/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Jpeg;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.CCITTG4Encoder;
import com.lowagie.text.pdf.codec.TIFFDirectory;
import com.lowagie.text.pdf.codec.TIFFFaxDecoder;
import com.lowagie.text.pdf.codec.TIFFField;
import com.lowagie.text.pdf.codec.TIFFLZWDecoder;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class TiffImage {
    public static int getNumberOfPages(RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            return TIFFDirectory.getNumDirectories(randomAccessFileOrArray);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    static int getDpi(TIFFField tIFFField, int n) {
        if (tIFFField == null) {
            return 0;
        }
        long[] lArray = tIFFField.getAsRational(0);
        float f = (float)lArray[0] / (float)lArray[1];
        int n2 = 0;
        switch (n) {
            case 1: 
            case 2: {
                n2 = (int)f;
                break;
            }
            case 3: {
                n2 = (int)((double)f * 2.54);
            }
        }
        return n2;
    }

    public static Image getTiffImage(RandomAccessFileOrArray randomAccessFileOrArray, int n) {
        return TiffImage.getTiffImage(randomAccessFileOrArray, n, false);
    }

    public static Image getTiffImage(RandomAccessFileOrArray randomAccessFileOrArray, int n, boolean bl) {
        if (n < 1) {
            throw new IllegalArgumentException("The page number must be >= 1.");
        }
        try {
            Object object;
            Object object2;
            long l;
            TIFFDirectory tIFFDirectory = new TIFFDirectory(randomAccessFileOrArray, n - 1);
            if (tIFFDirectory.isTagPresent(322)) {
                throw new IllegalArgumentException("Tiles are not supported.");
            }
            int n2 = (int)tIFFDirectory.getFieldAsLong(259);
            switch (n2) {
                case 2: 
                case 3: 
                case 4: 
                case 32771: {
                    break;
                }
                default: {
                    return TiffImage.getTiffImageColor(tIFFDirectory, randomAccessFileOrArray);
                }
            }
            float f = 0.0f;
            if (tIFFDirectory.isTagPresent(274)) {
                int n3 = (int)tIFFDirectory.getFieldAsLong(274);
                if (n3 == 3 || n3 == 4) {
                    f = (float)Math.PI;
                } else if (n3 == 5 || n3 == 8) {
                    f = 1.5707964f;
                } else if (n3 == 6 || n3 == 7) {
                    f = -1.5707964f;
                }
            }
            Image image = null;
            long l2 = 0L;
            long l3 = 0L;
            int n4 = 1;
            int n5 = (int)tIFFDirectory.getFieldAsLong(257);
            int n6 = (int)tIFFDirectory.getFieldAsLong(256);
            int n7 = 0;
            int n8 = 0;
            float f2 = 0.0f;
            int n9 = 2;
            if (tIFFDirectory.isTagPresent(296)) {
                n9 = (int)tIFFDirectory.getFieldAsLong(296);
            }
            n7 = TiffImage.getDpi(tIFFDirectory.getField(282), n9);
            n8 = TiffImage.getDpi(tIFFDirectory.getField(283), n9);
            if (n9 == 1) {
                if (n8 != 0) {
                    f2 = (float)n7 / (float)n8;
                }
                n7 = 0;
                n8 = 0;
            }
            long l4 = 0xFFFFFFFFL;
            if (tIFFDirectory.isTagPresent(278)) {
                l4 = tIFFDirectory.getFieldAsLong(278);
            }
            int n10 = (int)Math.min((long)n5, l4);
            long[] lArray = TiffImage.getArrayLongShort(tIFFDirectory, 273);
            long[] lArray2 = TiffImage.getArrayLongShort(tIFFDirectory, 279);
            if (lArray2 == null && n5 == n10) {
                lArray2 = new long[]{randomAccessFileOrArray.length() - (int)lArray[0]};
            }
            boolean bl2 = false;
            TIFFField tIFFField = tIFFDirectory.getField(266);
            if (tIFFField != null) {
                n4 = tIFFField.getAsInt(0);
            }
            bl2 = n4 == 2;
            int n11 = 0;
            if (tIFFDirectory.isTagPresent(262) && (l = tIFFDirectory.getFieldAsLong(262)) == 1L) {
                n11 |= 1;
            }
            int n12 = 0;
            switch (n2) {
                case 2: 
                case 32771: {
                    n12 = 257;
                    n11 |= 0xA;
                    break;
                }
                case 3: {
                    n12 = 257;
                    n11 |= 0xC;
                    object2 = tIFFDirectory.getField(292);
                    if (object2 == null) break;
                    l2 = ((TIFFField)object2).getAsLong(0);
                    if ((l2 & 1L) != 0L) {
                        n12 = 258;
                    }
                    if ((l2 & 4L) == 0L) break;
                    n11 |= 2;
                    break;
                }
                case 4: {
                    n12 = 256;
                    object = tIFFDirectory.getField(293);
                    if (object == null) break;
                    l3 = ((TIFFField)object).getAsLong(0);
                }
            }
            if (bl && n10 == n5) {
                object2 = new byte[(int)lArray2[0]];
                randomAccessFileOrArray.seek(lArray[0]);
                randomAccessFileOrArray.readFully((byte[])object2);
                image = Image.getInstance(n6, n5, bl2, n12, n11, (byte[])object2);
                image.setInverted(true);
            } else {
                int n13 = n5;
                object = new CCITTG4Encoder(n6);
                int n14 = 0;
                while (n14 < lArray.length) {
                    byte[] byArray = new byte[(int)lArray2[n14]];
                    randomAccessFileOrArray.seek(lArray[n14]);
                    randomAccessFileOrArray.readFully(byArray);
                    int n15 = Math.min(n10, n13);
                    TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(n4, n6, n15);
                    byte[] byArray2 = new byte[(n6 + 7) / 8 * n15];
                    switch (n2) {
                        case 2: 
                        case 32771: {
                            tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n15);
                            ((CCITTG4Encoder)object).fax4Encode(byArray2, n15);
                            break;
                        }
                        case 3: {
                            try {
                                tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n15, l2);
                            }
                            catch (RuntimeException runtimeException) {
                                l2 ^= 4L;
                                try {
                                    tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n15, l2);
                                }
                                catch (RuntimeException runtimeException2) {
                                    throw runtimeException;
                                }
                            }
                            ((CCITTG4Encoder)object).fax4Encode(byArray2, n15);
                            break;
                        }
                        case 4: {
                            tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n15, l3);
                            ((CCITTG4Encoder)object).fax4Encode(byArray2, n15);
                        }
                    }
                    n13 -= n10;
                    ++n14;
                }
                byte[] byArray = ((CCITTG4Encoder)object).close();
                image = Image.getInstance(n6, n5, false, 256, n11 & 1, byArray);
            }
            image.setDpi(n7, n8);
            image.setXYRatio(f2);
            if (tIFFDirectory.isTagPresent(34675)) {
                try {
                    TIFFField tIFFField2 = tIFFDirectory.getField(34675);
                    object = ICC_Profile.getInstance(tIFFField2.getAsBytes());
                    if (((ICC_Profile)object).getNumComponents() == 1) {
                        image.tagICC((ICC_Profile)object);
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
            image.setOriginalType(5);
            if (f != 0.0f) {
                image.setInitialRotation(f);
            }
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected static Image getTiffImageColor(TIFFDirectory tIFFDirectory, RandomAccessFileOrArray randomAccessFileOrArray) {
        try {
            byte[] byArray;
            int n;
            int n2 = (int)tIFFDirectory.getFieldAsLong(259);
            int n3 = 1;
            TIFFLZWDecoder tIFFLZWDecoder = null;
            switch (n2) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 32773: 
                case 32946: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The compression " + n2 + " is not supported.");
                }
            }
            int n4 = (int)tIFFDirectory.getFieldAsLong(262);
            switch (n4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    if (n2 == 6 || n2 == 7) break;
                    throw new IllegalArgumentException("The photometric " + n4 + " is not supported.");
                }
            }
            float f = 0.0f;
            if (tIFFDirectory.isTagPresent(274)) {
                n = (int)tIFFDirectory.getFieldAsLong(274);
                if (n == 3 || n == 4) {
                    f = (float)Math.PI;
                } else if (n == 5 || n == 8) {
                    f = 1.5707964f;
                } else if (n == 6 || n == 7) {
                    f = -1.5707964f;
                }
            }
            if (tIFFDirectory.isTagPresent(284) && tIFFDirectory.getFieldAsLong(284) == 2L) {
                throw new IllegalArgumentException("Planar images are not supported.");
            }
            if (tIFFDirectory.isTagPresent(338)) {
                throw new IllegalArgumentException("Extra samples are not supported.");
            }
            n = 1;
            if (tIFFDirectory.isTagPresent(277)) {
                n = (int)tIFFDirectory.getFieldAsLong(277);
            }
            int n5 = 1;
            if (tIFFDirectory.isTagPresent(258)) {
                n5 = (int)tIFFDirectory.getFieldAsLong(258);
            }
            switch (n5) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bits per sample " + n5 + " is not supported.");
                }
            }
            Image image = null;
            int n6 = (int)tIFFDirectory.getFieldAsLong(257);
            int n7 = (int)tIFFDirectory.getFieldAsLong(256);
            int n8 = 0;
            int n9 = 0;
            int n10 = 2;
            if (tIFFDirectory.isTagPresent(296)) {
                n10 = (int)tIFFDirectory.getFieldAsLong(296);
            }
            n8 = TiffImage.getDpi(tIFFDirectory.getField(282), n10);
            n9 = TiffImage.getDpi(tIFFDirectory.getField(283), n10);
            int n11 = n6;
            if (tIFFDirectory.isTagPresent(278)) {
                n11 = (int)tIFFDirectory.getFieldAsLong(278);
            }
            long[] lArray = TiffImage.getArrayLongShort(tIFFDirectory, 273);
            long[] lArray2 = TiffImage.getArrayLongShort(tIFFDirectory, 279);
            if (lArray2 == null && n6 == n11) {
                lArray2 = new long[]{randomAccessFileOrArray.length() - (int)lArray[0]};
            }
            if (n2 == 5) {
                TIFFField tIFFField = tIFFDirectory.getField(317);
                if (tIFFField != null) {
                    n3 = tIFFField.getAsInt(0);
                    if (n3 != 1 && n3 != 2) {
                        throw new RuntimeException("Illegal value for Predictor in TIFF file.");
                    }
                    if (n3 == 2 && n5 != 8) {
                        throw new RuntimeException(String.valueOf(n5) + "-bit samples are not supported for Horizontal differencing Predictor.");
                    }
                }
                tIFFLZWDecoder = new TIFFLZWDecoder(n7, n3, n);
            }
            int n12 = n6;
            ByteArrayOutputStream byteArrayOutputStream = null;
            DeflaterOutputStream deflaterOutputStream = null;
            CCITTG4Encoder cCITTG4Encoder = null;
            if (n5 == 1 && n == 1) {
                cCITTG4Encoder = new CCITTG4Encoder(n7);
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
                if (n2 != 6 && n2 != 7) {
                    deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                }
            }
            if (n2 == 6) {
                if (!tIFFDirectory.isTagPresent(513) || !tIFFDirectory.isTagPresent(514)) {
                    throw new RuntimeException("Missing tag(s) for OJPEG compression.");
                }
                int n13 = (int)tIFFDirectory.getFieldAsLong(513);
                int n14 = (int)tIFFDirectory.getFieldAsLong(514) + (int)lArray2[0];
                byArray = new byte[Math.min(n14, randomAccessFileOrArray.length() - n13)];
                int n15 = randomAccessFileOrArray.getFilePointer();
                randomAccessFileOrArray.seek(n15 += n13);
                randomAccessFileOrArray.readFully(byArray);
                image = new Jpeg(byArray);
            } else if (n2 == 7) {
                if (lArray2.length > 1) {
                    throw new IOException("Compression JPEG is only supported with a single strip. This image has " + lArray2.length + " strips.");
                }
                byte[] byArray2 = new byte[(int)lArray2[0]];
                randomAccessFileOrArray.seek(lArray[0]);
                randomAccessFileOrArray.readFully(byArray2);
                image = new Jpeg(byArray2);
            } else {
                int n16 = 0;
                while (n16 < lArray.length) {
                    byte[] byArray3 = new byte[(int)lArray2[n16]];
                    randomAccessFileOrArray.seek(lArray[n16]);
                    randomAccessFileOrArray.readFully(byArray3);
                    int n17 = Math.min(n11, n12);
                    byte[] byArray4 = null;
                    if (n2 != 1) {
                        byArray4 = new byte[(n7 * n5 * n + 7) / 8 * n17];
                    }
                    switch (n2) {
                        case 32946: {
                            TiffImage.inflate(byArray3, byArray4);
                            break;
                        }
                        case 1: {
                            byArray4 = byArray3;
                            break;
                        }
                        case 32773: {
                            TiffImage.decodePackbits(byArray3, byArray4);
                            break;
                        }
                        case 5: {
                            tIFFLZWDecoder.decode(byArray3, byArray4, n17);
                        }
                    }
                    if (n5 == 1 && n == 1) {
                        cCITTG4Encoder.fax4Encode(byArray4, n17);
                    } else {
                        deflaterOutputStream.write(byArray4);
                    }
                    n12 -= n11;
                    ++n16;
                }
                if (n5 == 1 && n == 1) {
                    image = Image.getInstance(n7, n6, false, 256, n4 == 1 ? 1 : 0, cCITTG4Encoder.close());
                } else {
                    deflaterOutputStream.close();
                    image = Image.getInstance(n7, n6, n, n5, byteArrayOutputStream.toByteArray());
                    image.setDeflated(true);
                }
            }
            image.setDpi(n8, n9);
            if (n2 != 6 && n2 != 7) {
                if (tIFFDirectory.isTagPresent(34675)) {
                    try {
                        TIFFField tIFFField = tIFFDirectory.getField(34675);
                        ICC_Profile iCC_Profile = ICC_Profile.getInstance(tIFFField.getAsBytes());
                        if (n == iCC_Profile.getNumComponents()) {
                            image.tagICC(iCC_Profile);
                        }
                    }
                    catch (RuntimeException runtimeException) {}
                }
                if (tIFFDirectory.isTagPresent(320)) {
                    TIFFField tIFFField = tIFFDirectory.getField(320);
                    char[] cArray = tIFFField.getAsChars();
                    byArray = new byte[cArray.length];
                    int n18 = cArray.length / 3;
                    int n19 = n18 * 2;
                    int n20 = 0;
                    while (n20 < n18) {
                        byArray[n20 * 3] = (byte)(cArray[n20] >>> 8);
                        byArray[n20 * 3 + 1] = (byte)(cArray[n20 + n18] >>> 8);
                        byArray[n20 * 3 + 2] = (byte)(cArray[n20 + n19] >>> 8);
                        ++n20;
                    }
                    PdfArray pdfArray = new PdfArray();
                    pdfArray.add(PdfName.INDEXED);
                    pdfArray.add(PdfName.DEVICERGB);
                    pdfArray.add(new PdfNumber(n18 - 1));
                    pdfArray.add(new PdfString(byArray));
                    PdfDictionary pdfDictionary = new PdfDictionary();
                    pdfDictionary.put(PdfName.COLORSPACE, pdfArray);
                    image.setAdditional(pdfDictionary);
                }
                image.setOriginalType(5);
            }
            if (n4 == 0) {
                image.setInverted(true);
            }
            if (f != 0.0f) {
                image.setInitialRotation(f);
            }
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    static long[] getArrayLongShort(TIFFDirectory tIFFDirectory, int n) {
        long[] lArray;
        TIFFField tIFFField = tIFFDirectory.getField(n);
        if (tIFFField == null) {
            return null;
        }
        if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            int n2 = 0;
            while (n2 < cArray.length) {
                lArray[n2] = cArray[n2];
                ++n2;
            }
        }
        return lArray;
    }

    public static void decodePackbits(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray2.length) {
            int n3;
            byte by;
            if ((by = byArray[n++]) >= 0 && by <= 127) {
                n3 = 0;
                while (n3 < by + 1) {
                    byArray2[n2++] = byArray[n++];
                    ++n3;
                }
                continue;
            }
            if (by <= -1 && by >= -127) {
                byte by2 = byArray[n++];
                n3 = 0;
                while (n3 < -by + 1) {
                    byArray2[n2++] = by2;
                    ++n3;
                }
                continue;
            }
            ++n;
        }
    }

    public static void inflate(byte[] byArray, byte[] byArray2) {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        try {
            inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new ExceptionConverter(dataFormatException);
        }
    }
}

