/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.workers;

import foxtrot.AbstractWorkerThread;
import foxtrot.Task;

public class DefaultWorkerThread
extends AbstractWorkerThread
implements Runnable {
    private static final boolean debug = false;
    private Thread thread;
    private Link current;

    public void start() {
        if (this.thread != null && this.thread.isAlive()) {
            this.stop();
        }
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected String getThreadName() {
        return "Foxtrot Default Worker Thread";
    }

    private void stop() {
        this.thread.interrupt();
    }

    public boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    public boolean isWorkerThread() {
        return Thread.currentThread() == this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTask(Task task) {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            if (this.hasTasks()) {
                Link link = this.current;
                while (link.next != null) {
                    link = link.next;
                }
                link.next = new Link(task);
            } else {
                this.current = new Link(task);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Task takeTask() throws InterruptedException {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            while (!this.hasTasks()) {
                this.wait();
            }
            Task task = this.current.task;
            this.current = this.current.next;
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTasks() {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            return this.current != null;
        }
    }

    protected boolean isThreadInterrupted() {
        return this.thread.isInterrupted();
    }

    public void run() {
        while (!this.isThreadInterrupted()) {
            try {
                Task task = this.takeTask();
                this.runTask(task);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    private static class Link {
        private Link next;
        private Task task;

        private Link(Task task) {
            this.task = task;
        }
    }
}

