/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRHyperlinkHelper {
    public static final String HYPERLINK_TYPE_NONE = "None";
    public static final String HYPERLINK_TYPE_REFERENCE = "Reference";
    public static final String HYPERLINK_TYPE_LOCAL_ANCHOR = "LocalAnchor";
    public static final String HYPERLINK_TYPE_LOCAL_PAGE = "LocalPage";
    public static final String HYPERLINK_TYPE_REMOTE_ANCHOR = "RemoteAnchor";
    public static final String HYPERLINK_TYPE_REMOTE_PAGE = "RemotePage";
    private static final Map builtinTypes = JRHyperlinkHelper.createBuiltinTypes();

    private static Map createBuiltinTypes() {
        HashMap<String, Byte> hashMap = new HashMap<String, Byte>();
        hashMap.put(HYPERLINK_TYPE_NONE, new Byte(1));
        hashMap.put(HYPERLINK_TYPE_REFERENCE, new Byte(2));
        hashMap.put(HYPERLINK_TYPE_LOCAL_ANCHOR, new Byte(3));
        hashMap.put(HYPERLINK_TYPE_LOCAL_PAGE, new Byte(4));
        hashMap.put(HYPERLINK_TYPE_REMOTE_ANCHOR, new Byte(5));
        hashMap.put(HYPERLINK_TYPE_REMOTE_PAGE, new Byte(6));
        return hashMap;
    }

    public static byte getHyperlinkType(JRHyperlink jRHyperlink) {
        return JRHyperlinkHelper.getHyperlinkType(jRHyperlink.getLinkType());
    }

    public static byte getHyperlinkType(String string) {
        Byte by;
        int n = string == null ? 1 : ((by = (Byte)builtinTypes.get(string)) == null ? 7 : (int)by.byteValue());
        return (byte)n;
    }

    public static String getLinkType(byte by) {
        String string;
        switch (by) {
            case 0: 
            case 1: {
                string = null;
                break;
            }
            case 2: {
                string = HYPERLINK_TYPE_REFERENCE;
                break;
            }
            case 3: {
                string = HYPERLINK_TYPE_LOCAL_ANCHOR;
                break;
            }
            case 4: {
                string = HYPERLINK_TYPE_LOCAL_PAGE;
                break;
            }
            case 5: {
                string = HYPERLINK_TYPE_REMOTE_ANCHOR;
                break;
            }
            case 6: {
                string = HYPERLINK_TYPE_REMOTE_PAGE;
                break;
            }
            case 7: {
                throw new JRRuntimeException("Custom hyperlink types cannot be specified using the byte constant");
            }
            default: {
                throw new JRRuntimeException("Unknown hyperlink type " + by);
            }
        }
        return string;
    }
}

