/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;

public abstract class JRFiller {
    public static JasperPrint fillReport(JasperReport jasperReport, Map map, Connection connection) throws JRException {
        JRBaseFiller jRBaseFiller = JRFiller.createFiller(jasperReport);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = jRBaseFiller.fill(map, connection);
        }
        catch (JRFillInterruptedException jRFillInterruptedException) {
            throw new JRException("The report filling thread was interrupted.");
        }
        return jasperPrint;
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map map, JRDataSource jRDataSource) throws JRException {
        JRBaseFiller jRBaseFiller = JRFiller.createFiller(jasperReport);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = jRBaseFiller.fill(map, jRDataSource);
        }
        catch (JRFillInterruptedException jRFillInterruptedException) {
            throw new JRException("The report filling thread was interrupted.");
        }
        return jasperPrint;
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map map) throws JRException {
        JRBaseFiller jRBaseFiller = JRFiller.createFiller(jasperReport);
        try {
            JasperPrint jasperPrint = jRBaseFiller.fill(map);
            return jasperPrint;
        }
        catch (JRFillInterruptedException jRFillInterruptedException) {
            throw new JRException("The report filling thread was interrupted.");
        }
    }

    public static JRBaseFiller createFiller(JasperReport jasperReport) throws JRException {
        JRBaseFiller jRBaseFiller = null;
        switch (jasperReport.getPrintOrder()) {
            case 2: {
                jRBaseFiller = new JRHorizontalFiller(jasperReport);
                break;
            }
            case 1: {
                jRBaseFiller = new JRVerticalFiller(jasperReport);
            }
        }
        return jRBaseFiller;
    }
}

