/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class X509CRLEntryObject
extends X509CRLEntry {
    private TBSCertList.CRLEntry c;
    private boolean isIndirect = false;
    private X500Principal previousCertificateIssuer = null;

    public X509CRLEntryObject(TBSCertList.CRLEntry cRLEntry) {
        this.c = cRLEntry;
    }

    public X509CRLEntryObject(TBSCertList.CRLEntry cRLEntry, boolean bl, X500Principal x500Principal) {
        this.c = cRLEntry;
        this.isIndirect = bl;
        this.previousCertificateIssuer = x500Principal;
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        return set != null && !set.isEmpty();
    }

    public X500Principal getCertificateIssuer() {
        if (!this.isIndirect) {
            return null;
        }
        byte[] byArray = this.getExtensionValue(X509Extensions.CertificateIssuer.getId());
        if (byArray == null) {
            return this.previousCertificateIssuer;
        }
        try {
            GeneralName[] generalNameArray = GeneralNames.getInstance(X509ExtensionUtil.fromExtensionValue(byArray)).getNames();
            int n = 0;
            while (n < generalNameArray.length) {
                if (generalNameArray[n].getTagNo() == 4) {
                    return new X500Principal(generalNameArray[n].getName().getDERObject().getDEREncoded());
                }
                ++n;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Set getExtensionOIDs(boolean bl) {
        X509Extensions x509Extensions = this.c.getExtensions();
        if (x509Extensions != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (bl != x509Extension.isCritical()) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String string) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.c.getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            try {
                return x509Extension.getValue().getEncoded();
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.c);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public BigInteger getSerialNumber() {
        return this.c.getUserCertificate().getValue();
    }

    public Date getRevocationDate() {
        return this.c.getRevocationDate().getDate();
    }

    public boolean hasExtensions() {
        return this.c.getExtensions() != null;
    }

    public String toString() {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("      userCertificate: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("       revocationDate: ").append(this.getRevocationDate()).append(string);
        X509Extensions x509Extensions = this.c.getExtensions();
        if (x509Extensions != null && (enumeration = x509Extensions.oids()).hasMoreElements()) {
            stringBuffer.append("   crlEntryExtensions:").append(string);
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                stringBuffer.append(x509Extension);
            }
        }
        return stringBuffer.toString();
    }
}

