/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class AnnotationBinding {
    ReferenceBinding type;
    ElementValuePair[] pairs;

    public static AnnotationBinding[] addStandardAnnotations(AnnotationBinding[] annotationBindingArray, long l, LookupEnvironment lookupEnvironment) {
        int n = 0;
        if ((l & 0x7FC00000000L) != 0L) {
            ++n;
        }
        if ((l & 0x180000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x200000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x400000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x800000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x1000000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x2000000000000L) != 0L) {
            ++n;
        }
        if (n == 0) {
            return annotationBindingArray;
        }
        int n2 = annotationBindingArray.length;
        AnnotationBinding[] annotationBindingArray2 = new AnnotationBinding[n2 + n];
        System.arraycopy(annotationBindingArray, 0, annotationBindingArray2, 0, n2);
        if ((l & 0x7FC00000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildTargetAnnotation(l, lookupEnvironment);
        }
        if ((l & 0x180000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildRetentionAnnotation(l, lookupEnvironment);
        }
        if ((l & 0x200000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_DEPRECATED, lookupEnvironment);
        }
        if ((l & 0x400000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED, lookupEnvironment);
        }
        if ((l & 0x800000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_INHERITED, lookupEnvironment);
        }
        if ((l & 0x1000000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_OVERRIDE, lookupEnvironment);
        }
        if ((l & 0x2000000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_SUPPRESSWARNINGS, lookupEnvironment);
        }
        return annotationBindingArray2;
    }

    private static AnnotationBinding buildMarkerAnnotation(char[][] cArray, LookupEnvironment lookupEnvironment) {
        ReferenceBinding referenceBinding = lookupEnvironment.getResolvedType(cArray, null);
        return new AnnotationBinding(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS);
    }

    private static AnnotationBinding buildRetentionAnnotation(long l, LookupEnvironment lookupEnvironment) {
        ReferenceBinding referenceBinding = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, null);
        FieldBinding fieldBinding = null;
        if ((l & 0x180000000000L) != 0L) {
            fieldBinding = referenceBinding.getField(TypeConstants.UPPER_RUNTIME, true);
        } else if ((l & 0x100000000000L) != 0L) {
            fieldBinding = referenceBinding.getField(TypeConstants.UPPER_CLASS, true);
        } else if ((l & 0x80000000000L) != 0L) {
            fieldBinding = referenceBinding.getField(TypeConstants.UPPER_SOURCE, true);
        }
        ReferenceBinding referenceBinding2 = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_ANNOTATION_RETENTION, null);
        ElementValuePair[] elementValuePairArray = new ElementValuePair[]{new ElementValuePair(TypeConstants.VALUE, fieldBinding, null)};
        return AnnotationBinding.createUnresolvedAnnotation(referenceBinding2, elementValuePairArray, lookupEnvironment);
    }

    private static AnnotationBinding buildTargetAnnotation(long l, LookupEnvironment lookupEnvironment) {
        ElementValuePair[] elementValuePairArray;
        ReferenceBinding referenceBinding = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_ANNOTATION_TARGET, null);
        if ((l & 0x400000000L) != 0L) {
            return new AnnotationBinding(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS);
        }
        int n = 0;
        if ((l & 0x20000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x8000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x1000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x10000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x2000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x40000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x4000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x800000000L) != 0L) {
            ++n;
        }
        Object[] objectArray = new Object[n];
        if (n > 0) {
            elementValuePairArray = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE, null);
            int n2 = 0;
            if ((l & 0x20000000000L) != 0L) {
                objectArray[n2++] = elementValuePairArray.getField(TypeConstants.UPPER_ANNOTATION_TYPE, true);
            }
            if ((l & 0x8000000000L) != 0L) {
                objectArray[n2++] = elementValuePairArray.getField(TypeConstants.UPPER_CONSTRUCTOR, true);
            }
            if ((l & 0x1000000000L) != 0L) {
                objectArray[n2++] = elementValuePairArray.getField(TypeConstants.UPPER_FIELD, true);
            }
            if ((l & 0x10000000000L) != 0L) {
                objectArray[n2++] = elementValuePairArray.getField(TypeConstants.UPPER_LOCAL_VARIABLE, true);
            }
            if ((l & 0x2000000000L) != 0L) {
                objectArray[n2++] = elementValuePairArray.getField(TypeConstants.UPPER_METHOD, true);
            }
            if ((l & 0x40000000000L) != 0L) {
                objectArray[n2++] = elementValuePairArray.getField(TypeConstants.UPPER_PACKAGE, true);
            }
            if ((l & 0x4000000000L) != 0L) {
                objectArray[n2++] = elementValuePairArray.getField(TypeConstants.UPPER_PARAMETER, true);
            }
            if ((l & 0x800000000L) != 0L) {
                objectArray[n2++] = elementValuePairArray.getField(TypeConstants.TYPE, true);
            }
        }
        elementValuePairArray = new ElementValuePair[]{new ElementValuePair(TypeConstants.VALUE, objectArray, null)};
        return AnnotationBinding.createUnresolvedAnnotation(referenceBinding, elementValuePairArray, lookupEnvironment);
    }

    public static AnnotationBinding createUnresolvedAnnotation(ReferenceBinding referenceBinding, ElementValuePair[] elementValuePairArray, LookupEnvironment lookupEnvironment) {
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            return new UnresolvedAnnotationBinding(referenceBinding, elementValuePairArray, lookupEnvironment);
        }
        AnnotationBinding annotationBinding = new AnnotationBinding(referenceBinding, elementValuePairArray);
        annotationBinding.setMethodBindings();
        return annotationBinding;
    }

    public AnnotationBinding(ReferenceBinding referenceBinding, ElementValuePair[] elementValuePairArray) {
        this.type = referenceBinding;
        this.pairs = elementValuePairArray;
    }

    public AnnotationBinding(Annotation annotation) {
        this((ReferenceBinding)annotation.resolvedType, annotation.computeElementValuePairs());
    }

    public ReferenceBinding getAnnotationType() {
        return this.type;
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.pairs;
    }

    protected void setMethodBindings() {
        if (this.type == null) {
            return;
        }
        int n = this.pairs.length;
        while (--n >= 0) {
            ElementValuePair elementValuePair = this.pairs[n];
            MethodBinding[] methodBindingArray = this.type.getMethods(elementValuePair.getName());
            if (methodBindingArray == null || methodBindingArray.length != 1) continue;
            elementValuePair.setMethodBinding(methodBindingArray[0]);
        }
    }
}

