/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.util.Iterator;
import serpro.ppgd.irpf.ItemQuadroAuxiliar;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroAuxiliar
extends Colecao {
    private Valor totais = new Valor(this, "Totais");
    public static final int MAX_TAMANHO_DESCRICAO = 60;

    public ColecaoItemQuadroAuxiliar() {
        super(ItemQuadroAuxiliar.class.getName());
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(Object object) {
        ((ItemQuadroAuxiliar)object).getValor().addObservador(this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object object) {
        ((ItemQuadroAuxiliar)object).getValor().removeObservador(this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator iterator = this.recuperarLista().iterator();
        this.totais.clear();
        while (iterator.hasNext()) {
            ItemQuadroAuxiliar itemQuadroAuxiliar = (ItemQuadroAuxiliar)iterator.next();
            this.totais.append('+', itemQuadroAuxiliar.getValor());
        }
    }

    public String getDescricoes() {
        String string = "";
        Iterator iterator = this.recuperarLista().iterator();
        this.totais.clear();
        while (iterator.hasNext()) {
            ItemQuadroAuxiliar itemQuadroAuxiliar = (ItemQuadroAuxiliar)iterator.next();
            if (!string.equals("")) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + itemQuadroAuxiliar.getEspecificacao().asString();
        }
        if (string.length() > 60) {
            string = string.substring(0, 60);
        }
        return string;
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.calculaTotal();
    }
}

