package serpro.ppgd.irpf;
import java.util.Iterator;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroOutrosRendimentos extends Colecao
{
  private transient DeclaracaoIRPF objDecl;
  private Valor totais;
  private Valor totaisTitular;
  private Valor totaisDependentes;

  public ColecaoItemQuadroOutrosRendimentos (final DeclaracaoIRPF objDecl,
					     final String ficha)
  {
    super (serpro.ppgd.irpf.ItemQuadroOutrosRendimentos.class.getName ());
    totais = new Valor (this, "Totais");
    getTotais ().setReadOnly (true);
    totaisTitular = new Valor (this, "Totais do titular");
    getTotaisTitular ().setReadOnly (true);
    totaisDependentes = new Valor (this, "Totais dos dependentes");
    getTotaisDependentes ().setReadOnly (true);
    this.objDecl = objDecl;
    setFicha (ficha);
  }

  public ObjetoNegocio instanciaNovoObjeto ()
  {
    return new ItemQuadroOutrosRendimentos (objDecl);
  }

  public Valor getTotais ()
  {
    return totais;
  }

  public Valor getTotaisTitular ()
  {
    return totaisTitular;
  }

  public Valor getTotaisDependentes ()
  {
    return totaisDependentes;
  }

  public void objetoInserido (Object o)
  {
    ((ObjetoNegocio) o).setFicha (getFicha ());

    ((ItemQuadroOutrosRendimentos) o).getValor ().addObservador (this);
    calculaTotal ();
  }

  public void objetoRemovido (Object o)
  {
    ((ItemQuadroOutrosRendimentos) o).getValor ().removeObservador (this);
    calculaTotal ();
  }

  private void calculaTotal ()
  {
    Iterator it = recuperarLista ().iterator ();
    totaisTitular.clear ();
    totaisDependentes.clear ();
    while (it.hasNext ())
      {
	ItemQuadroOutrosRendimentos or
	  = (ItemQuadroOutrosRendimentos) it.next ();
	Valor v;
	if (or.isTitular ())
	  v = totaisTitular;
	else
	  v = totaisDependentes;
	v.append ('+', or.getValor ());
      }
    totais.clear ();
    totais.append ('+', totaisTitular);
    totais.append ('+', totaisDependentes);
  }

  public void notifica (Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo)
  {
    calculaTotal ();
  }
}
