/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.Fonts;
import com.jgoodies.looks.LookUtils;
import java.awt.Font;
import javax.swing.UIDefaults;

public final class FontPolicies {
    private FontPolicies() {
    }

    public static FontPolicy createFixedPolicy(FontSet fontSet) {
        return new FixedPolicy(fontSet);
    }

    public static FontPolicy customSettingsPolicy(FontPolicy fontPolicy) {
        return new CustomSettingsPolicy(fontPolicy);
    }

    public static FontPolicy getDefaultPlasticOnWindowsPolicy() {
        return new DefaultPlasticOnWindowsPolicy();
    }

    public static FontPolicy getDefaultPlasticPolicy() {
        if (LookUtils.IS_OS_WINDOWS) {
            return FontPolicies.getDefaultPlasticOnWindowsPolicy();
        }
        return FontPolicies.getLogicalFontsPolicy();
    }

    public static FontPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    public static FontPolicy getLogicalFontsPolicy() {
        return FontPolicies.createFixedPolicy(FontSets.getLogicalFontSet());
    }

    public static FontPolicy getLooks1xPlasticPolicy() {
        Font font;
        Font font2 = font = Fonts.getDefaultGUIFontWesternModernWindowsNormal();
        Font font3 = font.deriveFont(1);
        FontSet fontSet = FontSets.createDefaultFontSet(font, font2, font3);
        return FontPolicies.createFixedPolicy(fontSet);
    }

    public static FontPolicy getLooks1xWindowsPolicy() {
        return new Looks1xWindowsPolicy();
    }

    public static FontPolicy getTransitionalPlasticPolicy() {
        return LookUtils.IS_OS_WINDOWS ? FontPolicies.getDefaultPlasticOnWindowsPolicy() : FontPolicies.getLooks1xPlasticPolicy();
    }

    private static FontSet getCustomFontSet(String string) {
        String string2 = string + ".controlFont";
        String string3 = string + ".menuFont";
        String string4 = LookUtils.getSystemProperty(string2);
        if (string4 == null) {
            return null;
        }
        Font font = Font.decode(string4);
        String string5 = LookUtils.getSystemProperty(string3);
        Font font2 = string5 != null ? Font.decode(string5) : null;
        Font font3 = "Plastic".equals(string) ? font.deriveFont(1) : font;
        return FontSets.createDefaultFontSet(font, font2, font3);
    }

    private static FontPolicy getCustomPolicy(String string) {
        return null;
    }

    private static final class Looks1xWindowsPolicy
    implements FontPolicy {
        private Looks1xWindowsPolicy() {
        }

        @Override
        public FontSet getFontSet(String string, UIDefaults uIDefaults) {
            Font font = Fonts.getLooks1xWindowsControlFont();
            Font font2 = font != null ? font : (uIDefaults != null ? uIDefaults.getFont("Button.font") : new Font("Dialog", 0, 12));
            return FontSets.createDefaultFontSet(font2);
        }
    }

    private static final class FixedPolicy
    implements FontPolicy {
        private final FontSet fontSet;

        FixedPolicy(FontSet fontSet) {
            this.fontSet = fontSet;
        }

        @Override
        public FontSet getFontSet(String string, UIDefaults uIDefaults) {
            return this.fontSet;
        }
    }

    private static final class DefaultWindowsPolicy
    implements FontPolicy {
        private DefaultWindowsPolicy() {
        }

        @Override
        public FontSet getFontSet(String string, UIDefaults uIDefaults) {
            Font font = Fonts.getWindowsControlFont();
            Font font2 = font != null ? font : (uIDefaults != null ? uIDefaults.getFont("Button.font") : new Font("Dialog", 0, 12));
            Font font3 = uIDefaults == null ? font2 : uIDefaults.getFont("Menu.font");
            Font font4 = font2;
            Font font5 = uIDefaults == null ? font2 : uIDefaults.getFont("OptionPane.font");
            Font font6 = uIDefaults == null ? font2.deriveFont(font2.getSize2D() - 2.0f) : uIDefaults.getFont("ToolTip.font");
            Font font7 = uIDefaults == null ? font2 : uIDefaults.getFont("InternalFrame.titleFont");
            return FontSets.createDefaultFontSet(font2, font3, font4, font5, font6, font7);
        }
    }

    private static final class DefaultPlasticOnWindowsPolicy
    implements FontPolicy {
        private DefaultPlasticOnWindowsPolicy() {
        }

        @Override
        public FontSet getFontSet(String string, UIDefaults uIDefaults) {
            Font font = Fonts.getWindowsControlFont();
            Font font2 = font != null ? font : (uIDefaults != null ? uIDefaults.getFont("Button.font") : new Font("Dialog", 0, 12));
            Font font3 = uIDefaults == null ? font2 : uIDefaults.getFont("Menu.font");
            Font font4 = font2.deriveFont(1);
            return FontSets.createDefaultFontSet(font2, font3, font4);
        }
    }

    private static final class CustomSettingsPolicy
    implements FontPolicy {
        private final FontPolicy wrappedPolicy;

        CustomSettingsPolicy(FontPolicy fontPolicy) {
            this.wrappedPolicy = fontPolicy;
        }

        @Override
        public FontSet getFontSet(String string, UIDefaults uIDefaults) {
            FontPolicy fontPolicy = FontPolicies.getCustomPolicy(string);
            if (fontPolicy != null) {
                return fontPolicy.getFontSet(null, uIDefaults);
            }
            FontSet fontSet = FontPolicies.getCustomFontSet(string);
            if (fontSet != null) {
                return fontSet;
            }
            return this.wrappedPolicy.getFontSet(string, uIDefaults);
        }
    }
}

