/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import foxtrot.Task;
import foxtrot.WorkerThread;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.swing.SwingUtilities;

public abstract class AbstractWorkerThread
implements WorkerThread {
    private static final Runnable EMPTY_EVENT = new Runnable(){

        @Override
        public final void run() {
        }
    };

    protected AbstractWorkerThread() {
    }

    @Override
    public void runTask(final Task task) {
        try {
            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return task.run();
                }
            }, task.getSecurityContext());
            task.setResult(t);
        }
        catch (PrivilegedActionException privilegedActionException) {
            task.setThrowable(privilegedActionException.getException());
        }
        catch (Throwable throwable) {
            task.setThrowable(throwable);
        }
        finally {
            task.setCompleted(true);
            SwingUtilities.invokeLater(EMPTY_EVENT);
        }
    }
}

