/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculator;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRCalculable;

public class JRPercentageCalculatorFactory {
    private static final Map builtInCalculators = new HashMap();
    private static final Map cachedCalculators;

    public static boolean hasBuiltInCalculator(Class clazz) {
        return builtInCalculators.containsKey(clazz.getName());
    }

    public static JRPercentageCalculator getPercentageCalculator(Class clazz, Class clazz2) {
        JRPercentageCalculator jRPercentageCalculator;
        if (clazz == null) {
            jRPercentageCalculator = (JRPercentageCalculator)builtInCalculators.get(clazz2.getName());
            if (jRPercentageCalculator == null) {
                throw new JRRuntimeException("Measure with type " + clazz2.getName() + " should specify a percentage calculator class.");
            }
        } else {
            jRPercentageCalculator = (JRPercentageCalculator)cachedCalculators.get(clazz.getName());
            if (jRPercentageCalculator == null) {
                try {
                    jRPercentageCalculator = (JRPercentageCalculator)clazz.newInstance();
                    cachedCalculators.put(clazz.getName(), jRPercentageCalculator);
                }
                catch (InstantiationException instantiationException) {
                    throw new JRRuntimeException("Error while creating percentage calculator instance of " + clazz + ".", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JRRuntimeException("Error while creating percentage calculator instance of " + clazz + ".", illegalAccessException);
                }
            }
        }
        return jRPercentageCalculator;
    }

    static {
        builtInCalculators.put(Float.class.getName(), new FloatPercentageCalculator());
        builtInCalculators.put(Double.class.getName(), new DoublePercentageCalculator());
        builtInCalculators.put(Integer.class.getName(), new IntegerPercentageCalculator());
        builtInCalculators.put(Long.class.getName(), new LongPercentageCalculator());
        builtInCalculators.put(Short.class.getName(), new ShortPercentageCalculator());
        builtInCalculators.put(Byte.class.getName(), new BytePercentageCalculator());
        builtInCalculators.put(BigDecimal.class.getName(), new BigDecimalPercentageCalculator());
        builtInCalculators.put(BigInteger.class.getName(), new BigIntegerPercentageCalculator());
        cachedCalculators = new HashMap();
    }

    public static class BigIntegerPercentageCalculator
    implements JRPercentageCalculator {
        @Override
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            BigInteger bigInteger = (BigInteger)jRCalculable2.getValue();
            BigInteger bigInteger2 = (BigInteger)jRCalculable.getValue();
            BigInteger bigInteger3 = bigInteger != null && bigInteger.doubleValue() != 0.0 ? bigInteger2.multiply(BigInteger.valueOf(100L)).divide(bigInteger) : BigInteger.valueOf(0L);
            return bigInteger3;
        }
    }

    public static class BigDecimalPercentageCalculator
    implements JRPercentageCalculator {
        @Override
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            BigDecimal bigDecimal = (BigDecimal)jRCalculable2.getValue();
            BigDecimal bigDecimal2 = (BigDecimal)jRCalculable.getValue();
            BigDecimal bigDecimal3 = bigDecimal != null && bigDecimal.doubleValue() != 0.0 ? bigDecimal2.multiply(BigDecimal.valueOf(100L)).divide(bigDecimal, 4) : BigDecimal.valueOf(0L);
            return bigDecimal3;
        }
    }

    public static class DoublePercentageCalculator
    implements JRPercentageCalculator {
        @Override
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Double d = (Double)jRCalculable2.getValue();
            Double d2 = (Double)jRCalculable.getValue();
            double d3 = 0.0;
            if (d != null && d != 0.0) {
                d3 = 100.0 * d2 / d;
            }
            return new Double(d3);
        }
    }

    public static class FloatPercentageCalculator
    implements JRPercentageCalculator {
        @Override
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Float f = (Float)jRCalculable2.getValue();
            Float f2 = (Float)jRCalculable.getValue();
            float f3 = 0.0f;
            if (f != null && f.floatValue() != 0.0f) {
                f3 = 100.0f * f2.floatValue() / f.floatValue();
            }
            return new Float(f3);
        }
    }

    public static class LongPercentageCalculator
    implements JRPercentageCalculator {
        @Override
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Long l = (Long)jRCalculable2.getValue();
            Long l2 = (Long)jRCalculable.getValue();
            long l3 = 0L;
            if (l != null && l != 0L) {
                l3 = 100L * l2 / l;
            }
            return new Long(l3);
        }
    }

    public static class IntegerPercentageCalculator
    implements JRPercentageCalculator {
        @Override
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Integer n = (Integer)jRCalculable2.getValue();
            Integer n2 = (Integer)jRCalculable.getValue();
            int n3 = 0;
            if (n != null && n != 0) {
                n3 = 100 * n2 / n;
            }
            return new Integer(n3);
        }
    }

    public static class ShortPercentageCalculator
    implements JRPercentageCalculator {
        @Override
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Short s = (Short)jRCalculable2.getValue();
            Short s2 = (Short)jRCalculable.getValue();
            short s3 = 0;
            if (s != null && s != 0) {
                s3 = (short)(100 * s2 / s);
            }
            return new Short(s3);
        }
    }

    public static class BytePercentageCalculator
    implements JRPercentageCalculator {
        @Override
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Byte by = (Byte)jRCalculable2.getValue();
            Byte by2 = (Byte)jRCalculable.getValue();
            byte by3 = 0;
            if (by != null && by != 0) {
                by3 = (byte)(100 * by2 / by);
            }
            return new Byte(by3);
        }
    }
}

