/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.Comparator;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.collections.comparators.ReverseComparator;

public class BucketDefinition {
    public static final byte ORDER_ASCENDING = 1;
    public static final byte ORDER_DESCENDING = 2;
    public static final byte TOTAL_POSITION_NONE = 0;
    public static final byte TOTAL_POSITION_START = 1;
    public static final byte TOTAL_POSITION_END = 2;
    protected static final byte VALUE_TYPE_VALUE = 0;
    protected static final byte VALUE_TYPE_NULL = 1;
    protected static final byte VALUE_TYPE_TOTAL = 2;
    protected final Bucket VALUE_TOTAL = new Bucket(2);
    protected final Bucket VALUE_NULL = new Bucket(1);
    protected final Comparator comparator;
    private final byte totalPosition;
    private boolean computeTotal;

    public BucketDefinition(Class clazz, Comparator comparator, byte by, byte by2) throws JRException {
        if (comparator == null && !Comparable.class.isAssignableFrom(clazz)) {
            throw new JRException("The bucket expression values are not comparable and no comparator specified.");
        }
        switch (by) {
            case 2: {
                if (comparator == null) {
                    this.comparator = new ReverseComparator();
                    break;
                }
                this.comparator = new ReverseComparator(comparator);
                break;
            }
            default: {
                this.comparator = comparator;
            }
        }
        this.totalPosition = by2;
        this.computeTotal = by2 != 0;
    }

    public boolean computeTotal() {
        return this.computeTotal;
    }

    public void setComputeTotal() {
        this.computeTotal = true;
    }

    public byte getTotalPosition() {
        return this.totalPosition;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Bucket create(Object object) {
        if (object == null) {
            return this.VALUE_NULL;
        }
        return new Bucket(object);
    }

    public class Bucket
    implements Comparable {
        private final Object value;
        private final byte type;

        protected Bucket(byte by) {
            this.value = null;
            this.type = by;
        }

        protected Bucket(Object object) {
            this.value = object;
            this.type = 0;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Bucket)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            Bucket bucket = (Bucket)object;
            if (this.type != 0) {
                return this.type == bucket.type;
            }
            return bucket.type == 0 && this.value.equals(bucket.value);
        }

        public int hashCode() {
            int n = this.type;
            if (this.type == 0) {
                n = 37 * n + this.value.hashCode();
            }
            return n;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "NULL";
                }
                case 2: {
                    return "TOTAL";
                }
            }
            return String.valueOf(this.value);
        }

        public int compareTo(Object object) {
            Bucket bucket = (Bucket)object;
            if (this.type != bucket.type) {
                return this.type - bucket.type;
            }
            if (this.type != 0) {
                return 0;
            }
            if (BucketDefinition.this.comparator != null) {
                return BucketDefinition.this.comparator.compare(this.value, bucket.value);
            }
            return ((Comparable)this.value).compareTo(bucket.value);
        }

        public boolean isTotal() {
            return this.type == 2;
        }
    }
}

