/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRTypeSniffer;

public class JRImageRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;
    private byte[] imageData = null;
    private String imageLocation = null;
    private byte onErrorType = 1;
    private byte imageType = 0;
    private transient SoftReference awtImageRef = null;

    private JRImageRenderer(byte[] byArray, byte by) {
        this.imageData = byArray;
        this.onErrorType = by;
        if (byArray != null) {
            this.imageType = JRTypeSniffer.getImageType(byArray);
        }
    }

    private JRImageRenderer(String string, byte by) {
        this.imageLocation = string;
        this.onErrorType = by;
    }

    public static ClassLoader getClassLoader() {
        return JRResourcesUtil.getThreadClassLoader();
    }

    public static void setClassLoader(ClassLoader classLoader) {
        JRResourcesUtil.setThreadClassLoader(classLoader);
    }

    public static JRImageRenderer getInstance(byte[] byArray) {
        return JRImageRenderer.getInstance(byArray, (byte)1);
    }

    public static JRImageRenderer getInstance(byte[] byArray, byte by) {
        return new JRImageRenderer(byArray, by);
    }

    public static JRRenderable getInstance(String string) throws JRException {
        return JRImageRenderer.getInstance(string, (byte)1, true);
    }

    public static JRRenderable getInstance(String string, byte by) throws JRException {
        return JRImageRenderer.getInstance(string, by, true);
    }

    public static JRRenderable getInstance(String string, byte by, boolean bl) throws JRException {
        return JRImageRenderer.getInstance(string, by, bl, null, null);
    }

    public static JRRenderable getInstance(String string, byte by, boolean bl, ClassLoader classLoader) throws JRException {
        return JRImageRenderer.getInstance(string, by, bl, classLoader);
    }

    public static JRRenderable getInstance(String string, byte by, boolean bl, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws JRException {
        if (string == null) {
            return null;
        }
        if (bl) {
            return new JRImageRenderer(string, by);
        }
        try {
            byte[] byArray = JRImageLoader.loadImageDataFromLocation(string, classLoader, uRLStreamHandlerFactory);
            return new JRImageRenderer(byArray, by);
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by, jRException);
        }
    }

    public static JRRenderable getInstance(Image image, byte by) throws JRException {
        try {
            return new JRImageRenderer(JRImageLoader.loadImageDataFromAWTImage(image), by);
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by, jRException);
        }
    }

    public static JRRenderable getInstance(InputStream inputStream, byte by) throws JRException {
        try {
            return new JRImageRenderer(JRImageLoader.loadImageDataFromInputStream(inputStream), by);
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by, jRException);
        }
    }

    public static JRRenderable getInstance(URL uRL, byte by) throws JRException {
        try {
            return new JRImageRenderer(JRImageLoader.loadImageDataFromURL(uRL), by);
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by, jRException);
        }
    }

    public static JRRenderable getInstance(File file, byte by) throws JRException {
        try {
            return new JRImageRenderer(JRImageLoader.loadImageDataFromFile(file), by);
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by, jRException);
        }
    }

    private static JRImageRenderer getOnErrorRenderer(byte by, JRException jRException) throws JRException {
        JRImageRenderer jRImageRenderer = null;
        switch (by) {
            case 3: {
                jRImageRenderer = new JRImageRenderer("net/sf/jasperreports/engine/images/noimage.GIF", 1);
                break;
            }
            case 2: {
                jRImageRenderer = new JRImageRenderer("net/sf/jasperreports/engine/images/pixel.GIF", 1);
                break;
            }
            default: {
                throw jRException;
            }
        }
        return jRImageRenderer;
    }

    public Image getImage() throws JRException {
        Image image = null;
        if (this.awtImageRef == null || this.awtImageRef.get() == null) {
            try {
                image = JRImageLoader.loadImage(this.getImageData());
                this.awtImageRef = new SoftReference<Image>(image);
            }
            catch (JRException jRException) {
                return JRImageRenderer.getOnErrorRenderer(this.onErrorType, jRException).getImage();
            }
        }
        return (Image)this.awtImageRef.get();
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    @Override
    public byte getType() {
        return 0;
    }

    @Override
    public byte getImageType() {
        return this.imageType;
    }

    @Override
    public Dimension2D getDimension() throws JRException {
        Image image = this.getImage();
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    @Override
    public byte[] getImageData() throws JRException {
        if (this.imageData == null) {
            try {
                this.imageData = JRImageLoader.loadImageDataFromLocation(this.imageLocation);
            }
            catch (JRException jRException) {
                this.imageData = JRImageRenderer.getOnErrorRenderer(this.onErrorType, jRException).getImageData();
            }
        }
        return this.imageData;
    }

    @Override
    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D) throws JRException {
        Image image = this.getImage();
        graphics2D.drawImage(image, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), null);
    }
}

