/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.FontKey;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.PdfFont;
import net.sf.jasperreports.engine.util.BreakIteratorSplitCharacter;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRPdfExporter
extends JRAbstractExporter {
    public static final String PDF_FORCE_SVG_SHAPES = "net.sf.jasperreports.export.pdf.force.svg.shapes";
    private static final String EMPTY_BOOKMARK_TITLE = "";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static boolean fontsRegistered = false;
    protected Document document = null;
    protected PdfContentByte pdfContentByte = null;
    protected Document imageTesterDocument = null;
    protected PdfContentByte imageTesterPdfContentByte = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected int reportIndex = 0;
    protected boolean isCreatingBatchModeBookmarks = false;
    protected boolean isCompressed = false;
    protected boolean isEncrypted = false;
    protected boolean is128BitKey = false;
    protected String userPassword = null;
    protected String ownerPassword = null;
    protected int permissions = 0;
    protected Character pdfVersion = null;
    protected Map loadedImagesMap = null;
    protected Image pxImage = null;
    private BookmarkStack bookmarkStack = null;
    private Map fontMap = null;
    private boolean forceSvgShapes = true;
    private SplitCharacter splitCharacter;
    protected JRHyperlinkProducerFactory hyperlinkProducerFactory;

    protected Image getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = Image.getInstance(JRImageLoader.loadImageDataFromLocation("net/sf/jasperreports/engine/images/pixel.GIF", null));
            }
            catch (Exception exception) {
                throw new JRRuntimeException(exception);
            }
        }
        return this.pxImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block23: {
            JRPdfExporter.registerFonts();
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                Boolean bl;
                Boolean bl2;
                Boolean bl3;
                Boolean bl4;
                this.setExportContext();
                this.setInput();
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                if ((bl4 = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_CREATING_BATCH_MODE_BOOKMARKS)) != null) {
                    this.isCreatingBatchModeBookmarks = bl4;
                }
                if ((bl3 = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_COMPRESSED)) != null) {
                    this.isCompressed = bl3;
                }
                if ((bl2 = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_ENCRYPTED)) != null) {
                    this.isEncrypted = bl2;
                }
                if ((bl = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_128_BIT_KEY)) != null) {
                    this.is128BitKey = bl;
                }
                this.userPassword = (String)this.parameters.get(JRPdfExporterParameter.USER_PASSWORD);
                this.ownerPassword = (String)this.parameters.get(JRPdfExporterParameter.OWNER_PASSWORD);
                Integer n = (Integer)this.parameters.get(JRPdfExporterParameter.PERMISSIONS);
                if (n != null) {
                    this.permissions = n;
                }
                this.pdfVersion = (Character)this.parameters.get(JRPdfExporterParameter.PDF_VERSION);
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setForceSvgShapes();
                this.setSplitCharacter();
                this.setHyperlinkProducerFactory();
                OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (outputStream != null) {
                    this.exportReportToStream(outputStream);
                    break block23;
                }
                File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (file == null) {
                    String string = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (string != null) {
                        file = new File(string);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    outputStream = new FileOutputStream(file);
                    this.exportReportToStream(outputStream);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    throw new JRException("Error trying to export to file : " + file, iOException);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setForceSvgShapes() {
        Boolean bl = (Boolean)this.parameters.get(JRPdfExporterParameter.FORCE_SVG_SHAPES);
        this.forceSvgShapes = bl == null ? JRProperties.getBooleanProperty(PDF_FORCE_SVG_SHAPES) : bl;
    }

    protected void setSplitCharacter() {
        Boolean bl = (Boolean)this.parameters.get(JRPdfExporterParameter.FORCE_LINEBREAK_POLICY);
        boolean bl2 = bl == null ? JRProperties.getBooleanProperty("net.sf.jasperreports.export.pdf.force.linebreak.policy") : bl;
        if (bl2) {
            this.splitCharacter = new BreakIteratorSplitCharacter();
        }
    }

    protected void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRPdfExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    protected void exportReportToStream(OutputStream outputStream) throws JRException {
        this.document = new Document(new Rectangle(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            PdfWriter pdfWriter = PdfWriter.getInstance(this.document, outputStream);
            pdfWriter.setCloseStream(false);
            if (this.pdfVersion != null) {
                pdfWriter.setPdfVersion(this.pdfVersion.charValue());
            }
            if (this.isCompressed) {
                pdfWriter.setFullCompression();
            }
            if (this.isEncrypted) {
                pdfWriter.setEncryption(this.is128BitKey, this.userPassword, this.ownerPassword, this.permissions);
            }
            if ((string5 = (String)this.parameters.get(JRPdfExporterParameter.METADATA_TITLE)) != null) {
                this.document.addTitle(string5);
            }
            if ((string4 = (String)this.parameters.get(JRPdfExporterParameter.METADATA_AUTHOR)) != null) {
                this.document.addAuthor(string4);
            }
            if ((string3 = (String)this.parameters.get(JRPdfExporterParameter.METADATA_SUBJECT)) != null) {
                this.document.addSubject(string3);
            }
            if ((string2 = (String)this.parameters.get(JRPdfExporterParameter.METADATA_KEYWORDS)) != null) {
                this.document.addKeywords(string2);
            }
            if ((string = (String)this.parameters.get(JRPdfExporterParameter.METADATA_CREATOR)) != null) {
                this.document.addCreator(string);
            } else {
                this.document.addCreator("JasperReports (" + this.jasperPrint.getName() + ")");
            }
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
            this.initBookmarks();
            PdfWriter pdfWriter2 = PdfWriter.getInstance(this.imageTesterDocument, new NullOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = pdfWriter2.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
                this.loadedImagesMap = new HashMap();
                this.document.setPageSize(new Rectangle(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
                List list = this.jasperPrint.getPages();
                if (list != null && list.size() > 0) {
                    if (this.isModeBatch) {
                        this.document.newPage();
                        if (this.isCreatingBatchModeBookmarks) {
                            this.addBookmark(0, this.jasperPrint.getName(), 0, 0);
                        }
                        this.startPageIndex = 0;
                        this.endPageIndex = list.size() - 1;
                    }
                    Chunk chunk = null;
                    ColumnText columnText = null;
                    JRPrintPage jRPrintPage = null;
                    for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        jRPrintPage = (JRPrintPage)list.get(i);
                        this.document.newPage();
                        this.pdfContentByte = pdfWriter.getDirectContent();
                        this.pdfContentByte.setLineCap(2);
                        chunk = new Chunk(" ");
                        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (i + 1));
                        columnText = new ColumnText(this.pdfContentByte);
                        columnText.setSimpleColumn(new Phrase(chunk), 0.0f, this.jasperPrint.getPageHeight(), 1.0f, 1.0f, 0.0f, 0);
                        columnText.go();
                        this.exportPage(jRPrintPage);
                    }
                } else {
                    this.document.newPage();
                    this.pdfContentByte = pdfWriter.getDirectContent();
                    this.pdfContentByte.setLiteral("\n");
                }
                ++this.reportIndex;
            }
        }
        catch (DocumentException documentException) {
            throw new JRException("PDF Document error : " + this.jasperPrint.getName(), documentException);
        }
        catch (IOException iOException) {
            throw new JRException("Error generating PDF report : " + this.jasperPrint.getName(), iOException);
        }
        finally {
            this.document.close();
            this.imageTesterDocument.close();
        }
    }

    protected void exportPage(JRPrintPage jRPrintPage) throws JRException, DocumentException, IOException {
        List list = jRPrintPage.getElements();
        this.exportElements(list);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection collection) throws DocumentException, IOException, JRException {
        if (collection != null && collection.size() > 0) {
            for (JRPrintElement jRPrintElement : collection) {
                if (jRPrintElement instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintText) {
                    this.exportText((JRPrintText)jRPrintElement);
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)jRPrintElement);
            }
        }
    }

    protected void exportLine(JRPrintLine jRPrintLine) {
        if (jRPrintLine.getPen() != 0) {
            this.pdfContentByte.setRGBColorStroke(jRPrintLine.getForecolor().getRed(), jRPrintLine.getForecolor().getGreen(), jRPrintLine.getForecolor().getBlue());
            switch (jRPrintLine.getPen()) {
                case 4: {
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                    break;
                }
                case 3: {
                    this.pdfContentByte.setLineWidth(4.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 2: {
                    this.pdfContentByte.setLineWidth(2.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 0: {
                    break;
                }
                case 5: {
                    this.pdfContentByte.setLineWidth(0.5f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                default: {
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                }
            }
            if (jRPrintLine.getDirection() == 1) {
                this.pdfContentByte.moveTo(jRPrintLine.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY());
                this.pdfContentByte.lineTo(jRPrintLine.getX() + this.getOffsetX() + jRPrintLine.getWidth() - 1, this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY() - jRPrintLine.getHeight() + 1);
            } else {
                this.pdfContentByte.moveTo(jRPrintLine.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY() - jRPrintLine.getHeight() + 1);
                this.pdfContentByte.lineTo(jRPrintLine.getX() + this.getOffsetX() + jRPrintLine.getWidth() - 1, this.jasperPrint.getPageHeight() - jRPrintLine.getY() - this.getOffsetY());
            }
            this.pdfContentByte.stroke();
            this.pdfContentByte.setLineDash(0.0f);
        }
    }

    protected void exportRectangle(JRPrintRectangle jRPrintRectangle) {
        this.pdfContentByte.setRGBColorStroke(jRPrintRectangle.getForecolor().getRed(), jRPrintRectangle.getForecolor().getGreen(), jRPrintRectangle.getForecolor().getBlue());
        this.pdfContentByte.setRGBColorFill(jRPrintRectangle.getBackcolor().getRed(), jRPrintRectangle.getBackcolor().getGreen(), jRPrintRectangle.getBackcolor().getBlue());
        float f = this.prepareGraphicElement(jRPrintRectangle);
        if (jRPrintRectangle.getMode() == 1) {
            this.pdfContentByte.roundRectangle((float)(jRPrintRectangle.getX() + this.getOffsetX()) - f, (float)(this.jasperPrint.getPageHeight() - jRPrintRectangle.getY() - this.getOffsetY() - jRPrintRectangle.getHeight()) - f + 1.0f, (float)jRPrintRectangle.getWidth() + 2.0f * f - 1.0f, (float)jRPrintRectangle.getHeight() + 2.0f * f - 1.0f, jRPrintRectangle.getRadius());
            if (jRPrintRectangle.getPen() == 4) {
                this.pdfContentByte.fill();
                this.pdfContentByte.roundRectangle(jRPrintRectangle.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - jRPrintRectangle.getY() - this.getOffsetY() - jRPrintRectangle.getHeight() + 1, jRPrintRectangle.getWidth() - 1, jRPrintRectangle.getHeight() - 1, jRPrintRectangle.getRadius());
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.fillStroke();
            }
        } else if (jRPrintRectangle.getPen() != 0) {
            this.pdfContentByte.roundRectangle((float)(jRPrintRectangle.getX() + this.getOffsetX()) - f, (float)(this.jasperPrint.getPageHeight() - jRPrintRectangle.getY() - this.getOffsetY() - jRPrintRectangle.getHeight()) - f + 1.0f, (float)jRPrintRectangle.getWidth() + 2.0f * f - 1.0f, (float)jRPrintRectangle.getHeight() + 2.0f * f - 1.0f, jRPrintRectangle.getRadius());
            this.pdfContentByte.stroke();
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    protected float prepareGraphicElement(JRPrintGraphicElement jRPrintGraphicElement) {
        float f = 0.0f;
        switch (jRPrintGraphicElement.getPen()) {
            case 4: {
                f = jRPrintGraphicElement.getMode() == 1 ? 0.5f : 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                f = 0.5f;
                this.pdfContentByte.setLineWidth(4.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                f = 0.5f;
                this.pdfContentByte.setLineWidth(2.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                f = 0.25f;
                this.pdfContentByte.setLineWidth(0.5f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                f = 0.5f;
                this.pdfContentByte.setLineWidth(0.0f);
                this.pdfContentByte.setLineDash(0.0f);
                this.pdfContentByte.setRGBColorStroke(jRPrintGraphicElement.getBackcolor().getRed(), jRPrintGraphicElement.getBackcolor().getGreen(), jRPrintGraphicElement.getBackcolor().getBlue());
                break;
            }
            default: {
                f = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(0.0f);
            }
        }
        return f;
    }

    protected void exportEllipse(JRPrintEllipse jRPrintEllipse) {
        this.pdfContentByte.setRGBColorStroke(jRPrintEllipse.getForecolor().getRed(), jRPrintEllipse.getForecolor().getGreen(), jRPrintEllipse.getForecolor().getBlue());
        this.pdfContentByte.setRGBColorFill(jRPrintEllipse.getBackcolor().getRed(), jRPrintEllipse.getBackcolor().getGreen(), jRPrintEllipse.getBackcolor().getBlue());
        float f = this.prepareGraphicElement(jRPrintEllipse);
        if (jRPrintEllipse.getMode() == 1) {
            this.pdfContentByte.ellipse((float)(jRPrintEllipse.getX() + this.getOffsetX()) - f, (float)(this.jasperPrint.getPageHeight() - jRPrintEllipse.getY() - this.getOffsetY() - jRPrintEllipse.getHeight()) - f + 1.0f, (float)(jRPrintEllipse.getX() + this.getOffsetX() + jRPrintEllipse.getWidth()) + f - 1.0f, (float)(this.jasperPrint.getPageHeight() - jRPrintEllipse.getY() - this.getOffsetY()) + f);
            if (jRPrintEllipse.getPen() == 4) {
                this.pdfContentByte.fill();
                this.pdfContentByte.ellipse(jRPrintEllipse.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - jRPrintEllipse.getY() - this.getOffsetY() - jRPrintEllipse.getHeight() + 1, jRPrintEllipse.getX() + this.getOffsetX() + jRPrintEllipse.getWidth() - 1, this.jasperPrint.getPageHeight() - jRPrintEllipse.getY() - this.getOffsetY());
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.fillStroke();
            }
        } else if (jRPrintEllipse.getPen() != 0) {
            this.pdfContentByte.ellipse((float)(jRPrintEllipse.getX() + this.getOffsetX()) - f, (float)(this.jasperPrint.getPageHeight() - jRPrintEllipse.getY() - this.getOffsetY() - jRPrintEllipse.getHeight()) - f + 1.0f, (float)(jRPrintEllipse.getX() + this.getOffsetX() + jRPrintEllipse.getWidth()) + f - 1.0f, (float)(this.jasperPrint.getPageHeight() - jRPrintEllipse.getY() - this.getOffsetY()) + f);
            this.pdfContentByte.stroke();
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    protected void exportImage(JRPrintImage jRPrintImage) throws DocumentException, IOException, JRException {
        this.pdfContentByte.setRGBColorFill(jRPrintImage.getBackcolor().getRed(), jRPrintImage.getBackcolor().getGreen(), jRPrintImage.getBackcolor().getBlue());
        if (jRPrintImage.getMode() == 1) {
            float f = 0.5f;
            this.pdfContentByte.setRGBColorStroke(jRPrintImage.getBackcolor().getRed(), jRPrintImage.getBackcolor().getGreen(), jRPrintImage.getBackcolor().getBlue());
            this.pdfContentByte.setLineWidth(0.1f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle((float)(jRPrintImage.getX() + this.getOffsetX()) - f, (float)(this.jasperPrint.getPageHeight() - jRPrintImage.getY() - this.getOffsetY()) + f, (float)jRPrintImage.getWidth() + 2.0f * f - 1.0f, (float)(-jRPrintImage.getHeight()) - 2.0f * f + 1.0f);
            this.pdfContentByte.fillStroke();
        }
        int n = jRPrintImage.getTopPadding();
        int n2 = jRPrintImage.getLeftPadding();
        int n3 = jRPrintImage.getBottomPadding();
        int n4 = jRPrintImage.getRightPadding();
        int n5 = jRPrintImage.getWidth() - n2 - n4;
        n5 = n5 < 0 ? 0 : n5;
        int n6 = jRPrintImage.getHeight() - n - n3;
        n6 = n6 < 0 ? 0 : n6;
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (jRRenderable != null && n5 > 0 && n6 > 0) {
            int n7 = 0;
            int n8 = 0;
            Chunk chunk = null;
            float f = n5;
            float f2 = n6;
            if (jRRenderable.getType() == 0) {
                Image image = null;
                float f3 = this.getXAlignFactor(jRPrintImage);
                float f4 = this.getYAlignFactor(jRPrintImage);
                switch (jRPrintImage.getScaleImage()) {
                    case 1: {
                        int n9 = n5;
                        int n10 = n6;
                        Dimension2D dimension2D = jRRenderable.getDimension();
                        if (dimension2D != null) {
                            n9 = (int)dimension2D.getWidth();
                            n10 = (int)dimension2D.getHeight();
                        }
                        n7 = (int)(f3 * (float)(n5 - n9));
                        n8 = (int)(f4 * (float)(n6 - n10));
                        int n11 = Math.min(n9, n5);
                        int n12 = Math.min(n10, n6);
                        BufferedImage bufferedImage = new BufferedImage(n11, n12, 2);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        if (jRPrintImage.getMode() == 1) {
                            graphics2D.setColor(jRPrintImage.getBackcolor());
                            graphics2D.fillRect(0, 0, n11, n12);
                        }
                        jRRenderable.render(graphics2D, new java.awt.Rectangle(n7 > 0 ? 0 : n7, n8 > 0 ? 0 : n8, n9, n10));
                        graphics2D.dispose();
                        n7 = n7 < 0 ? 0 : n7;
                        n8 = n8 < 0 ? 0 : n8;
                        image = Image.getInstance(bufferedImage, null);
                        break;
                    }
                    case 2: {
                        if (this.loadedImagesMap.containsKey(jRRenderable)) {
                            image = (Image)this.loadedImagesMap.get(jRRenderable);
                        } else {
                            try {
                                image = Image.getInstance(jRRenderable.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception exception) {
                                java.awt.Image image2 = JRImageRenderer.getInstance(jRRenderable.getImageData(), jRPrintImage.getOnErrorType()).getImage();
                                image = Image.getInstance(image2, null);
                            }
                            this.loadedImagesMap.put(jRRenderable, image);
                        }
                        image.scaleAbsolute(n5, n6);
                        break;
                    }
                    default: {
                        if (this.loadedImagesMap.containsKey(jRRenderable)) {
                            image = (Image)this.loadedImagesMap.get(jRRenderable);
                        } else {
                            try {
                                image = Image.getInstance(jRRenderable.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception exception) {
                                java.awt.Image image3 = JRImageRenderer.getInstance(jRRenderable.getImageData(), jRPrintImage.getOnErrorType()).getImage();
                                image = Image.getInstance(image3, null);
                            }
                            this.loadedImagesMap.put(jRRenderable, image);
                        }
                        image.scaleToFit(n5, n6);
                        n7 = (int)(f3 * ((float)n5 - image.plainWidth()));
                        n8 = (int)(f4 * ((float)n6 - image.plainHeight()));
                        n7 = n7 < 0 ? 0 : n7;
                        n8 = n8 < 0 ? 0 : n8;
                    }
                }
                chunk = new Chunk(image, -0.5f, 0.5f);
                f = image.scaledWidth();
                f2 = image.scaledHeight();
            } else {
                Graphics2D graphics2D;
                double d = n5;
                double d2 = n6;
                Dimension2D dimension2D = jRRenderable.getDimension();
                if (dimension2D != null) {
                    float f5 = this.getXAlignFactor(jRPrintImage);
                    float f6 = this.getYAlignFactor(jRPrintImage);
                    switch (jRPrintImage.getScaleImage()) {
                        case 1: {
                            d = dimension2D.getWidth();
                            d2 = dimension2D.getHeight();
                            n7 = (int)((double)f5 * ((double)n5 - d));
                            n8 = (int)((double)f6 * ((double)n6 - d2));
                            break;
                        }
                        case 2: {
                            n7 = 0;
                            n8 = 0;
                            break;
                        }
                        default: {
                            d = dimension2D.getWidth();
                            d2 = dimension2D.getHeight();
                            double d3 = (double)n5 / d;
                            double d4 = (double)n6 / d2;
                            double d5 = d3 < d4 ? d3 : d4;
                            n7 = (int)((double)f5 * ((double)n5 - (d *= d5)));
                            n8 = (int)((double)f6 * ((double)n6 - (d2 *= d5)));
                            break;
                        }
                    }
                }
                PdfTemplate pdfTemplate = this.pdfContentByte.createTemplate(n5, n6);
                Graphics2D graphics2D2 = graphics2D = this.forceSvgShapes ? pdfTemplate.createGraphicsShapes(n5, n6) : pdfTemplate.createGraphics(n5, n6, new LocalFontMapper());
                if (jRPrintImage.getMode() == 1) {
                    graphics2D.setColor(jRPrintImage.getBackcolor());
                    graphics2D.fillRect(0, 0, d <= (double)n5 ? (int)d : n5, d2 <= (double)n6 ? (int)d2 : n6);
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(n7 > 0 ? 0 : n7, n8 > 0 ? 0 : n8, d, d2);
                jRRenderable.render(graphics2D, double_);
                graphics2D.dispose();
                n7 = n7 < 0 ? 0 : n7;
                n8 = n8 < 0 ? 0 : n8;
                this.pdfContentByte.saveState();
                this.pdfContentByte.addTemplate(pdfTemplate, jRPrintImage.getX() + this.getOffsetX() + n7, this.jasperPrint.getPageHeight() - jRPrintImage.getY() - this.getOffsetY() - n6 - n8);
                this.pdfContentByte.restoreState();
                Image image = this.getPxImage();
                image.scaleAbsolute(n5, n6);
                chunk = new Chunk(image, 0.0f, 0.0f);
            }
            this.setAnchor(chunk, jRPrintImage, jRPrintImage);
            this.setHyperlinkInfo(chunk, jRPrintImage);
            ColumnText columnText = new ColumnText(this.pdfContentByte);
            int n13 = this.jasperPrint.getPageHeight() - jRPrintImage.getY() - n - this.getOffsetY() - n8;
            int n14 = jRPrintImage.getX() + n2 + this.getOffsetX() + n7;
            columnText.setSimpleColumn(new Phrase(chunk), n14, (float)n13 - f2, (float)n14 + f, n13, f2, 0);
            columnText.go();
        }
        if (jRPrintImage.getTopBorder() == 0 && jRPrintImage.getLeftBorder() == 0 && jRPrintImage.getBottomBorder() == 0 && jRPrintImage.getRightBorder() == 0) {
            if (jRPrintImage.getPen() != 0) {
                this.exportBox(this.getBox(jRPrintImage), jRPrintImage);
            }
        } else {
            this.exportBox(jRPrintImage, jRPrintImage);
        }
    }

    private float getXAlignFactor(JRPrintImage jRPrintImage) {
        float f = 0.0f;
        switch (jRPrintImage.getHorizontalAlignment()) {
            case 3: {
                f = 1.0f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    private float getYAlignFactor(JRPrintImage jRPrintImage) {
        float f = 0.0f;
        switch (jRPrintImage.getVerticalAlignment()) {
            case 3: {
                f = 1.0f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    protected void setHyperlinkInfo(Chunk chunk, JRPrintHyperlink jRPrintHyperlink) {
        switch (jRPrintHyperlink.getHyperlinkType()) {
            case 2: {
                if (jRPrintHyperlink.getHyperlinkReference() == null) break;
                chunk.setAnchor(jRPrintHyperlink.getHyperlinkReference());
                break;
            }
            case 3: {
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                chunk.setLocalGoto(jRPrintHyperlink.getHyperlinkAnchor());
                break;
            }
            case 4: {
                if (jRPrintHyperlink.getHyperlinkPage() == null) break;
                chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + jRPrintHyperlink.getHyperlinkPage().toString());
                break;
            }
            case 5: {
                if (jRPrintHyperlink.getHyperlinkReference() == null || jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                chunk.setRemoteGoto(jRPrintHyperlink.getHyperlinkReference(), jRPrintHyperlink.getHyperlinkAnchor());
                break;
            }
            case 6: {
                if (jRPrintHyperlink.getHyperlinkReference() == null || jRPrintHyperlink.getHyperlinkPage() == null) break;
                chunk.setRemoteGoto(jRPrintHyperlink.getHyperlinkReference(), jRPrintHyperlink.getHyperlinkPage());
                break;
            }
            case 7: {
                String string;
                if (this.hyperlinkProducerFactory == null || (string = this.hyperlinkProducerFactory.produceHyperlink(jRPrintHyperlink)) == null) break;
                chunk.setAnchor(string);
            }
        }
    }

    protected Phrase getPhrase(JRStyledText jRStyledText, JRPrintText jRPrintText) {
        Phrase phrase = new Phrase();
        String string = jRStyledText.getText();
        int n = 0;
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        while (n < jRStyledText.length() && (n = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
            Chunk chunk = this.getChunk(attributedCharacterIterator.getAttributes(), string.substring(attributedCharacterIterator.getIndex(), n));
            this.setAnchor(chunk, jRPrintText, jRPrintText);
            this.setHyperlinkInfo(chunk, jRPrintText);
            phrase.add(chunk);
            attributedCharacterIterator.setIndex(n);
        }
        return phrase;
    }

    protected Chunk getChunk(Map map, String string) {
        Object v;
        com.lowagie.text.Font font = this.getFont(map);
        Chunk chunk = new Chunk(string, font);
        Color color = (Color)map.get(TextAttribute.BACKGROUND);
        if (color != null) {
            chunk.setBackground(color);
        }
        if ((v = map.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(v)) {
                chunk.setTextRise(font.leading(1.0f) / 2.0f);
            } else if (v != null && TextAttribute.SUPERSCRIPT_SUB.equals(v)) {
                chunk.setTextRise(-font.leading(1.0f) / 2.0f);
            }
        }
        if (this.splitCharacter != null) {
            chunk.setSplitCharacter(this.splitCharacter);
        }
        return chunk;
    }

    protected com.lowagie.text.Font getFont(Map map) {
        JRBaseFont jRBaseFont = new JRBaseFont(map);
        Exception exception = null;
        Color color = (Color)map.get(TextAttribute.FOREGROUND);
        com.lowagie.text.Font font = null;
        PdfFont pdfFont = null;
        FontKey fontKey = new FontKey(jRBaseFont.getFontName(), jRBaseFont.isBold(), jRBaseFont.isItalic());
        pdfFont = this.fontMap != null && this.fontMap.containsKey(fontKey) ? (PdfFont)this.fontMap.get(fontKey) : new PdfFont(jRBaseFont.getPdfFontName(), jRBaseFont.getPdfEncoding(), jRBaseFont.isPdfEmbedded());
        try {
            font = FontFactory.getFont(pdfFont.getPdfFontName(), pdfFont.getPdfEncoding(), pdfFont.isPdfEmbedded(), jRBaseFont.getFontSize(), (pdfFont.isPdfSimulatedBold() ? 1 : 0) | (pdfFont.isPdfSimulatedItalic() ? 2 : 0) | (jRBaseFont.isUnderline() ? 4 : 0) | (jRBaseFont.isStrikeThrough() ? 8 : 0), color);
            if (font.getBaseFont() == null && font.family() == -1) {
                font = null;
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (font == null) {
            byte[] byArray = null;
            try {
                byArray = JRLoader.loadBytesFromLocation(pdfFont.getPdfFontName(), this.classLoader, this.urlHandlerFactory);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException("Could not load the following font : \npdfFontName   : " + pdfFont.getPdfFontName() + "\npdfEncoding   : " + pdfFont.getPdfEncoding() + "\nisPdfEmbedded : " + pdfFont.isPdfEmbedded(), exception);
            }
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont(pdfFont.getPdfFontName(), pdfFont.getPdfEncoding(), pdfFont.isPdfEmbedded(), true, byArray, null);
            }
            catch (DocumentException documentException) {
                throw new JRRuntimeException(documentException);
            }
            catch (IOException iOException) {
                throw new JRRuntimeException(iOException);
            }
            font = new com.lowagie.text.Font(baseFont, (float)jRBaseFont.getFontSize(), (pdfFont.isPdfSimulatedBold() ? 1 : 0) | (pdfFont.isPdfSimulatedItalic() ? 2 : 0) | (jRBaseFont.isUnderline() ? 4 : 0) | (jRBaseFont.isStrikeThrough() ? 8 : 0), color);
        }
        return font;
    }

    protected void exportText(JRPrintText jRPrintText) throws DocumentException {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText, false);
        if (jRStyledText == null) {
            return;
        }
        int n = jRStyledText.length();
        int n2 = jRPrintText.getX() + this.getOffsetX();
        int n3 = jRPrintText.getY() + this.getOffsetY();
        int n4 = jRPrintText.getWidth();
        int n5 = jRPrintText.getHeight();
        int n6 = jRPrintText.getTopPadding();
        int n7 = jRPrintText.getLeftPadding();
        int n8 = jRPrintText.getBottomPadding();
        int n9 = jRPrintText.getRightPadding();
        int n10 = 0;
        int n11 = 0;
        double d = 0.0;
        switch (jRPrintText.getRotation()) {
            case 1: {
                n3 = jRPrintText.getY() + this.getOffsetY() + jRPrintText.getHeight();
                n10 = 1;
                n4 = jRPrintText.getHeight();
                n5 = jRPrintText.getWidth();
                int n12 = n6;
                n6 = n7;
                n7 = n8;
                n8 = n9;
                n9 = n12;
                d = 1.5707963267948966;
                break;
            }
            case 2: {
                n2 = jRPrintText.getX() + this.getOffsetX() + jRPrintText.getWidth();
                n11 = -1;
                n4 = jRPrintText.getHeight();
                n5 = jRPrintText.getWidth();
                int n12 = n6;
                n6 = n9;
                n9 = n8;
                n8 = n7;
                n7 = n12;
                d = -1.5707963267948966;
                break;
            }
            case 3: {
                n2 = jRPrintText.getX() + this.getOffsetX() + jRPrintText.getWidth();
                n3 = jRPrintText.getY() + this.getOffsetY() + jRPrintText.getHeight();
                int n12 = n6;
                n6 = n8;
                n8 = n12;
                n12 = n7;
                n7 = n9;
                n9 = n12;
                d = Math.PI;
                break;
            }
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d, n2, this.jasperPrint.getPageHeight() - n3);
        this.pdfContentByte.transform(affineTransform);
        if (jRPrintText.getMode() == 1) {
            Color color = jRPrintText.getBackcolor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.setLineWidth(1.0f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle(n2 + n10, this.jasperPrint.getPageHeight() - n3 + n11, n4 - 1, -n5 + 1);
            this.pdfContentByte.fillStroke();
        }
        if (n > 0) {
            int n13 = 0;
            switch (jRPrintText.getHorizontalAlignment()) {
                case 1: {
                    if (jRPrintText.getRunDirection() == 0) {
                        n13 = 0;
                        break;
                    }
                    n13 = 2;
                    break;
                }
                case 2: {
                    n13 = 1;
                    break;
                }
                case 3: {
                    if (jRPrintText.getRunDirection() == 0) {
                        n13 = 2;
                        break;
                    }
                    n13 = 0;
                    break;
                }
                case 4: {
                    n13 = 3;
                    break;
                }
                default: {
                    n13 = 0;
                }
            }
            float f = 0.0f;
            switch (jRPrintText.getVerticalAlignment()) {
                case 1: {
                    f = 0.0f;
                    break;
                }
                case 2: {
                    f = ((float)(n5 - n6 - n8) - jRPrintText.getTextHeight()) / 2.0f;
                    break;
                }
                case 3: {
                    f = (float)(n5 - n6 - n8) - jRPrintText.getTextHeight();
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            ColumnText columnText = new ColumnText(this.pdfContentByte);
            columnText.setSimpleColumn(this.getPhrase(jRStyledText, jRPrintText), n2 + n7, (float)(this.jasperPrint.getPageHeight() - n3 - n6) - f - jRPrintText.getLeadingOffset(), n2 + n4 - n9, this.jasperPrint.getPageHeight() - n3 - n5 + n8, 0.0f, n13);
            columnText.setLeading(0.0f, jRPrintText.getLineSpacingFactor());
            columnText.setRunDirection(jRPrintText.getRunDirection() == 0 ? 2 : 3);
            columnText.go();
        }
        affineTransform = new AffineTransform();
        affineTransform.rotate(-d, n2, this.jasperPrint.getPageHeight() - n3);
        this.pdfContentByte.transform(affineTransform);
        this.exportBox(jRPrintText, jRPrintText);
    }

    protected void exportBox(JRBox jRBox, JRPrintElement jRPrintElement) {
        Color color;
        float f;
        if (jRBox.getTopBorder() != 0) {
            f = JRPdfExporter.prepareBorder(this.pdfContentByte, jRBox.getTopBorder());
            color = jRBox.getTopBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getTopBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(jRPrintElement.getX() + this.getOffsetX()) - f, (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY()) + f);
            this.pdfContentByte.lineTo((float)(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth() - 1) + f, (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY()) + f);
            this.pdfContentByte.stroke();
        }
        if (jRBox.getLeftBorder() != 0) {
            f = JRPdfExporter.prepareBorder(this.pdfContentByte, jRBox.getLeftBorder());
            color = jRBox.getLeftBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getLeftBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(jRPrintElement.getX() + this.getOffsetX()) - f, (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY()) + f);
            this.pdfContentByte.lineTo((float)(jRPrintElement.getX() + this.getOffsetX()) - f, (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY() - jRPrintElement.getHeight() + 1) - f);
            this.pdfContentByte.stroke();
        }
        if (jRBox.getBottomBorder() != 0) {
            f = JRPdfExporter.prepareBorder(this.pdfContentByte, jRBox.getBottomBorder());
            color = jRBox.getBottomBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getBottomBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(jRPrintElement.getX() + this.getOffsetX()) - f, (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY() - jRPrintElement.getHeight() + 1) - f);
            this.pdfContentByte.lineTo((float)(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth() - 1) + f, (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY() - jRPrintElement.getHeight() + 1) - f);
            this.pdfContentByte.stroke();
        }
        if (jRBox.getRightBorder() != 0) {
            f = JRPdfExporter.prepareBorder(this.pdfContentByte, jRBox.getRightBorder());
            color = jRBox.getRightBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getRightBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth() - 1) + f, (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY()) + f);
            this.pdfContentByte.lineTo((float)(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth() - 1) + f, (float)(this.jasperPrint.getPageHeight() - jRPrintElement.getY() - this.getOffsetY() - jRPrintElement.getHeight() + 1) - f);
            this.pdfContentByte.stroke();
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    private static float prepareBorder(PdfContentByte pdfContentByte, byte by) {
        float f = 0.0f;
        switch (by) {
            case 4: {
                f = 0.0f;
                pdfContentByte.setLineWidth(1.0f);
                pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                f = 0.5f;
                pdfContentByte.setLineWidth(4.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                f = 0.5f;
                pdfContentByte.setLineWidth(2.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                f = 0.25f;
                pdfContentByte.setLineWidth(0.5f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                f = 0.5f;
                pdfContentByte.setLineWidth(1.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            default: {
                f = 0.0f;
                pdfContentByte.setLineWidth(1.0f);
                pdfContentByte.setLineDash(0.0f);
            }
        }
        return f;
    }

    protected static synchronized void registerFonts() {
        if (!fontsRegistered) {
            Object object;
            Object object2;
            Object object3;
            List list = JRProperties.getProperties("net.sf.jasperreports.export.pdf.font.");
            if (!list.isEmpty()) {
                object3 = list.iterator();
                while (object3.hasNext()) {
                    object2 = (JRProperties.PropertySuffix)object3.next();
                    object = ((JRProperties.PropertySuffix)object2).getValue();
                    if (((String)object).toLowerCase().endsWith(".ttc")) {
                        FontFactory.register((String)object);
                        continue;
                    }
                    String string = ((JRProperties.PropertySuffix)object2).getSuffix();
                    FontFactory.register((String)object, string);
                }
            }
            if (!(object3 = JRProperties.getProperties("net.sf.jasperreports.export.pdf.fontdir.")).isEmpty()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (JRProperties.PropertySuffix)object2.next();
                    FontFactory.registerDirectory(((JRProperties.PropertySuffix)object).getValue());
                }
            }
            fontsRegistered = true;
        }
    }

    protected void initBookmarks() {
        this.bookmarkStack = new BookmarkStack();
        int n = this.isModeBatch && this.isCreatingBatchModeBookmarks ? -1 : 0;
        Bookmark bookmark = new Bookmark(this.pdfContentByte.getRootOutline(), n);
        this.bookmarkStack.push(bookmark);
    }

    protected void addBookmark(int n, String string, int n2, int n3) {
        Bookmark bookmark = this.bookmarkStack.peek();
        while (bookmark.level > n - 1) {
            this.bookmarkStack.pop();
            bookmark = this.bookmarkStack.peek();
        }
        for (int i = bookmark.level + 1; i < n; ++i) {
            Bookmark bookmark2 = new Bookmark(bookmark, bookmark.pdfOutline.getPdfDestination(), EMPTY_BOOKMARK_TITLE);
            this.bookmarkStack.push(bookmark2);
            bookmark = bookmark2;
        }
        Bookmark bookmark3 = new Bookmark(bookmark, n2, this.jasperPrint.getPageHeight() - n3, string);
        this.bookmarkStack.push(bookmark3);
    }

    protected void setAnchor(Chunk chunk, JRPrintAnchor jRPrintAnchor, JRPrintElement jRPrintElement) {
        String string = jRPrintAnchor.getAnchorName();
        if (string != null) {
            chunk.setLocalDestination(string);
            if (jRPrintAnchor.getBookmarkLevel() != 0) {
                this.addBookmark(jRPrintAnchor.getBookmarkLevel(), jRPrintAnchor.getAnchorName(), jRPrintElement.getX(), jRPrintElement.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame jRPrintFrame) throws DocumentException, IOException, JRException {
        if (jRPrintFrame.getMode() == 1) {
            int n = jRPrintFrame.getX() + this.getOffsetX();
            int n2 = jRPrintFrame.getY() + this.getOffsetY();
            Color color = jRPrintFrame.getBackcolor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.setLineWidth(1.0f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle(n, this.jasperPrint.getPageHeight() - n2, jRPrintFrame.getWidth() - 1, -jRPrintFrame.getHeight() + 1);
            this.pdfContentByte.fillStroke();
        }
        this.setFrameElementsOffset(jRPrintFrame, false);
        try {
            this.exportElements(jRPrintFrame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(jRPrintFrame, jRPrintFrame);
    }

    class LocalFontMapper
    implements FontMapper {
        @Override
        public BaseFont awtToPdf(Font font) {
            return JRPdfExporter.this.getFont(font.getAttributes()).getBaseFont();
        }

        @Override
        public Font pdfToAwt(BaseFont baseFont, int n) {
            return null;
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(int n) {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
        }

        @Override
        public void write(byte[] byArray) {
        }
    }

    protected static class BookmarkStack {
        LinkedList stack = new LinkedList();

        BookmarkStack() {
        }

        void push(Bookmark bookmark) {
            this.stack.add(bookmark);
        }

        Bookmark pop() {
            return (Bookmark)this.stack.removeLast();
        }

        Bookmark peek() {
            return (Bookmark)this.stack.getLast();
        }
    }

    protected static class Bookmark {
        final PdfOutline pdfOutline;
        final int level;

        Bookmark(Bookmark bookmark, int n, int n2, String string) {
            this(bookmark, new PdfDestination(0, n, n2, 0.0f), string);
        }

        Bookmark(Bookmark bookmark, PdfDestination pdfDestination, String string) {
            this.pdfOutline = new PdfOutline(bookmark.pdfOutline, pdfDestination, string, false);
            this.level = bookmark.level + 1;
        }

        Bookmark(PdfOutline pdfOutline, int n) {
            this.pdfOutline = pdfOutline;
            this.level = n;
        }
    }
}

