/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRCrosstabExpressionEvaluator;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabCell;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabMeasure;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabParameter;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabCell;
import net.sf.jasperreports.crosstabs.fill.calculation.HeaderCell;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillCellContents;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplateRectangle;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.jfree.data.general.Dataset;

public class JRFillCrosstab
extends JRFillElement
implements JRCrosstab {
    protected final JRCrosstab parentCrosstab;
    protected JRFillCrosstabDataset dataset;
    protected JRFillCrosstabRowGroup[] rowGroups;
    protected Map rowGroupsMap;
    protected JRFillCrosstabColumnGroup[] columnGroups;
    protected Map columnGroupsMap;
    protected JRFillCrosstabMeasure[] measures;
    protected BucketingService bucketingService;
    protected JRFillVariable[] variables;
    protected Map variablesMap;
    protected JRFillVariable[][][] totalVariables;
    protected boolean[][] retrieveTotal;
    protected JRFillCrosstabParameter[] parameters;
    protected Map parametersMap;
    protected JRCrosstabExpressionEvaluator crosstabEvaluator;
    protected JRFillCrosstabCell[][] crossCells;
    protected JRFillCellContents headerCell;
    protected JRFillCellContents whenNoDataCell;
    protected boolean hasData;
    protected HeaderCell[][] columnHeadersData;
    protected HeaderCell[][] rowHeadersData;
    protected CrosstabCell[][] cellData;
    protected MeasureDefinition.MeasureValue[] grandTotals;
    private boolean percentage;
    private CrosstabFiller crosstabFiller;

    public JRFillCrosstab(JRBaseFiller jRBaseFiller, JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRCrosstab, jRFillObjectFactory);
        this.parentCrosstab = jRCrosstab;
        this.loadEvaluator(jRBaseFiller.getJasperReport());
        JRFillObjectFactory jRFillObjectFactory2 = new JRFillObjectFactory(jRBaseFiller, this.crosstabEvaluator);
        this.headerCell = jRFillObjectFactory2.getCell(jRCrosstab.getHeaderCell());
        this.copyRowGroups(jRCrosstab, jRFillObjectFactory2);
        this.copyColumnGroups(jRCrosstab, jRFillObjectFactory2);
        this.copyMeasures(jRCrosstab, jRFillObjectFactory2);
        this.copyCells(jRCrosstab, jRFillObjectFactory2);
        this.whenNoDataCell = jRFillObjectFactory2.getCell(jRCrosstab.getWhenNoDataCell());
        this.dataset = jRFillObjectFactory.getCrosstabDataset(jRCrosstab.getDataset(), this);
        this.copyParameters(jRCrosstab, jRFillObjectFactory);
        this.copyVariables(jRCrosstab, jRFillObjectFactory2);
        this.crosstabFiller = new CrosstabFiller();
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    private void copyRowGroups(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        this.rowGroups = new JRFillCrosstabRowGroup[jRCrosstabRowGroupArray.length];
        this.rowGroupsMap = new HashMap();
        for (int i = 0; i < jRCrosstabRowGroupArray.length; ++i) {
            JRFillCrosstabRowGroup jRFillCrosstabRowGroup = jRFillObjectFactory.getCrosstabRowGroup(jRCrosstabRowGroupArray[i]);
            jRFillCrosstabRowGroup.getFillHeader().setVerticalPositionType(jRCrosstabRowGroupArray[i].getPosition());
            this.rowGroups[i] = jRFillCrosstabRowGroup;
            this.rowGroupsMap.put(jRFillCrosstabRowGroup.getName(), new Integer(i));
        }
    }

    private void copyColumnGroups(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        this.columnGroups = new JRFillCrosstabColumnGroup[jRCrosstabColumnGroupArray.length];
        this.columnGroupsMap = new HashMap();
        for (int i = 0; i < jRCrosstabColumnGroupArray.length; ++i) {
            JRFillCrosstabColumnGroup jRFillCrosstabColumnGroup;
            this.columnGroups[i] = jRFillCrosstabColumnGroup = jRFillObjectFactory.getCrosstabColumnGroup(jRCrosstabColumnGroupArray[i]);
            this.columnGroupsMap.put(jRFillCrosstabColumnGroup.getName(), new Integer(i));
        }
    }

    private void copyMeasures(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jRCrosstab.getMeasures();
        this.measures = new JRFillCrosstabMeasure[jRCrosstabMeasureArray.length];
        for (int i = 0; i < jRCrosstabMeasureArray.length; ++i) {
            this.measures[i] = jRFillObjectFactory.getCrosstabMeasure(jRCrosstabMeasureArray[i]);
        }
    }

    private void copyParameters(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        this.parameters = new JRFillCrosstabParameter[jRCrosstabParameterArray.length];
        this.parametersMap = new HashMap();
        for (int i = 0; i < jRCrosstabParameterArray.length; ++i) {
            this.parameters[i] = jRFillObjectFactory.getCrosstabParameter(jRCrosstabParameterArray[i]);
            this.parametersMap.put(this.parameters[i].getName(), this.parameters[i]);
        }
    }

    private void copyCells(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
        this.crossCells = new JRFillCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
        for (int i = 0; i <= this.rowGroups.length; ++i) {
            for (int j = 0; j <= this.columnGroups.length; ++j) {
                if (jRCrosstabCellArray[i][j] == null) continue;
                this.crossCells[i][j] = jRFillObjectFactory.getCrosstabCell(jRCrosstabCellArray[i][j]);
            }
        }
    }

    private void copyVariables(JRCrosstab jRCrosstab, JRFillObjectFactory jRFillObjectFactory) {
        Object object;
        int n;
        JRExpressionChunk[] jRExpressionChunkArray;
        JRVariable[] jRVariableArray = jRCrosstab.getVariables();
        this.variables = new JRFillVariable[jRVariableArray.length];
        this.variablesMap = new HashMap();
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = jRFillObjectFactory.getVariable(jRVariableArray[i]);
            this.variablesMap.put(this.variables[i].getName(), this.variables[i]);
        }
        HashMap<Object, int[]> hashMap = new HashMap<Object, int[]>();
        this.totalVariables = new JRFillVariable[this.rowGroups.length + 1][this.columnGroups.length + 1][this.measures.length];
        for (int i = 0; i <= this.rowGroups.length; ++i) {
            JRFillCrosstabRowGroup jRFillCrosstabRowGroup = i == this.rowGroups.length ? null : this.rowGroups[i];
            for (int j = 0; j <= this.columnGroups.length; ++j) {
                JRExpressionChunk[] jRExpressionChunkArray2 = jRExpressionChunkArray = j == this.columnGroups.length ? null : this.columnGroups[j];
                if (i >= this.rowGroups.length && j >= this.columnGroups.length) continue;
                for (n = 0; n < this.measures.length; ++n) {
                    object = JRDesignCrosstab.getTotalVariableName(this.measures[n], jRFillCrosstabRowGroup, (JRCrosstabColumnGroup)jRExpressionChunkArray);
                    this.totalVariables[i][j][n] = (JRFillVariable)this.variablesMap.get(object);
                    hashMap.put(object, new int[]{i, j});
                }
            }
        }
        this.retrieveTotal = new boolean[this.rowGroups.length + 1][this.columnGroups.length + 1];
        List list = JRExpressionCollector.collectExpressions(this.filler.getJasperReport(), jRCrosstab);
        for (JRExpression jRExpression : list) {
            jRExpressionChunkArray = jRExpression.getChunks();
            if (jRExpressionChunkArray == null) continue;
            for (n = 0; n < jRExpressionChunkArray.length; ++n) {
                String string;
                int[] nArray;
                object = jRExpressionChunkArray[n];
                if (object.getType() != 4 || (nArray = (int[])hashMap.get(string = object.getText())) == null) continue;
                this.retrieveTotal[nArray[0]][nArray[1]] = true;
            }
        }
    }

    protected void loadEvaluator(JasperReport jasperReport) {
        try {
            JREvaluator jREvaluator = JRDefaultCompiler.getInstance().loadEvaluator(jasperReport, this.parentCrosstab);
            this.crosstabEvaluator = new JRCrosstabExpressionEvaluator(jREvaluator);
        }
        catch (JRException jRException) {
            throw new JRRuntimeException("Could not load evaluator for crosstab.", jRException);
        }
    }

    private BucketingService createService(byte by) throws JRException {
        ArrayList<BucketDefinition> arrayList = new ArrayList<BucketDefinition>(this.rowGroups.length);
        for (int i = 0; i < this.rowGroups.length; ++i) {
            arrayList.add(this.createServiceBucket(this.rowGroups[i], by));
        }
        ArrayList<BucketDefinition> arrayList2 = new ArrayList<BucketDefinition>(this.columnGroups.length);
        for (int i = 0; i < this.columnGroups.length; ++i) {
            arrayList2.add(this.createServiceBucket(this.columnGroups[i], by));
        }
        this.percentage = false;
        ArrayList<MeasureDefinition> arrayList3 = new ArrayList<MeasureDefinition>(this.measures.length);
        for (int i = 0; i < this.measures.length; ++i) {
            arrayList3.add(this.createServiceMeasure(this.measures[i]));
            this.percentage |= this.measures[i].getPercentageOfType() == 1;
        }
        if (this.percentage) {
            ((BucketDefinition)arrayList.get(0)).setComputeTotal();
            ((BucketDefinition)arrayList2.get(0)).setComputeTotal();
        }
        return new BucketingService(arrayList, arrayList2, arrayList3, this.dataset.isDataPreSorted(), this.retrieveTotal);
    }

    private BucketDefinition createServiceBucket(JRCrosstabGroup jRCrosstabGroup, byte by) throws JRException {
        JRCrosstabBucket jRCrosstabBucket = jRCrosstabGroup.getBucket();
        Comparator comparator = null;
        JRExpression jRExpression = jRCrosstabBucket.getComparatorExpression();
        if (jRExpression != null) {
            comparator = (Comparator)this.evaluateExpression(jRExpression, by);
        }
        byte by2 = jRCrosstabGroup.getTotalPosition();
        return new BucketDefinition(jRCrosstabBucket.getExpression().getValueClass(), comparator, jRCrosstabBucket.getOrder(), by2);
    }

    private MeasureDefinition createServiceMeasure(JRFillCrosstabMeasure jRFillCrosstabMeasure) {
        return new MeasureDefinition(jRFillCrosstabMeasure.getValueClass(), jRFillCrosstabMeasure.getCalculation(), jRFillCrosstabMeasure.getIncrementerFactory());
    }

    @Override
    protected void reset() {
        super.reset();
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i].setValue(null);
            this.variables[i].setInitialized(true);
        }
    }

    @Override
    protected void evaluate(byte by) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(by);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.dataset.evaluateDatasetRun(by);
            this.initEvaluator(by);
            this.bucketingService.processData();
            this.hasData = this.bucketingService.hasData();
            if (this.hasData) {
                this.columnHeadersData = this.bucketingService.getColumnHeaders();
                this.rowHeadersData = this.bucketingService.getRowHeaders();
                this.cellData = this.bucketingService.getCrosstabCells();
                if (this.percentage) {
                    this.grandTotals = this.bucketingService.getGrandTotals();
                }
                this.crosstabFiller.initCrosstab();
            }
        }
    }

    protected void initEvaluator(byte by) throws JRException {
        Map map = JRFillSubreport.getParameterValues(this.filler, this.getParametersMapExpression(), this.getParameters(), by, true, false, false);
        ResourceBundle resourceBundle = (ResourceBundle)map.get("REPORT_RESOURCE_BUNDLE");
        if (resourceBundle == null) {
            JRFillParameter jRFillParameter = (JRFillParameter)this.filler.getParametersMap().get("REPORT_RESOURCE_BUNDLE");
            map.put("REPORT_RESOURCE_BUNDLE", jRFillParameter.getValue());
        }
        map.put("REPORT_PARAMETERS_MAP", map);
        for (int i = 0; i < this.parameters.length; ++i) {
            Object v = map.get(this.parameters[i].getName());
            this.parameters[i].setValue(v);
        }
        this.crosstabEvaluator.init(this.parametersMap, this.variablesMap, this.filler.getWhenResourceMissingType());
    }

    protected void initBucketingService() {
        if (this.bucketingService == null) {
            try {
                this.bucketingService = this.createService((byte)1);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException("Could not create bucketing service", jRException);
            }
        } else {
            this.bucketingService.clear();
        }
    }

    @Override
    protected boolean prepare(int n, boolean bl) throws JRException {
        super.prepare(n, bl);
        if (!this.isToPrint()) {
            return false;
        }
        if (n < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            this.setToPrint(false);
            return true;
        }
        if (bl && this.crosstabFiller.ended() && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setStretchHeight(this.getHeight());
                this.setToPrint(false);
                return false;
            }
        }
        if (bl && this.isPrintWhenDetailOverflows()) {
            this.setReprinted(true);
        }
        int n2 = this.getHeight() + n - this.getRelativeY() + this.getY() + this.getBandBottomY();
        this.crosstabFiller.fill(n2);
        boolean bl2 = this.crosstabFiller.willOverflow();
        this.setStretchHeight(bl2 ? n2 : this.crosstabFiller.getUsedHeight());
        return bl2;
    }

    @Override
    protected JRPrintElement fill() {
        JRTemplatePrintRectangle jRTemplatePrintRectangle = null;
        jRTemplatePrintRectangle = new JRTemplatePrintRectangle(this.getJRTemplateRectangle());
        jRTemplatePrintRectangle.setX(this.getX());
        jRTemplatePrintRectangle.setY(this.getRelativeY());
        jRTemplatePrintRectangle.setWidth(this.getWidth());
        jRTemplatePrintRectangle.setHeight(this.getStretchHeight());
        return jRTemplatePrintRectangle;
    }

    protected JRTemplateRectangle getJRTemplateRectangle() {
        JRStyle jRStyle = this.getStyle();
        JRTemplateRectangle jRTemplateRectangle = (JRTemplateRectangle)this.getTemplate(jRStyle);
        if (jRTemplateRectangle == null) {
            JRDesignRectangle jRDesignRectangle = new JRDesignRectangle();
            jRDesignRectangle.setKey(this.getKey());
            jRDesignRectangle.setPositionType(this.getPositionType());
            jRDesignRectangle.setMode(this.getMode());
            jRDesignRectangle.setX(this.getX());
            jRDesignRectangle.setY(this.getY());
            jRDesignRectangle.setWidth(this.getWidth());
            jRDesignRectangle.setHeight(this.getHeight());
            jRDesignRectangle.setRemoveLineWhenBlank(this.isRemoveLineWhenBlank());
            jRDesignRectangle.setPrintInFirstWholeBand(this.isPrintInFirstWholeBand());
            jRDesignRectangle.setPrintWhenDetailOverflows(this.isPrintWhenDetailOverflows());
            jRDesignRectangle.setPrintWhenGroupChanges(this.getPrintWhenGroupChanges());
            jRDesignRectangle.setForecolor(this.getForecolor());
            jRDesignRectangle.setBackcolor(this.getBackcolor());
            jRDesignRectangle.setPen((byte)0);
            jRTemplateRectangle = new JRTemplateRectangle(this.filler.getJasperPrint().getDefaultStyleProvider(), jRDesignRectangle);
            this.registerTemplate(jRStyle, jRTemplateRectangle);
        }
        return jRTemplateRectangle;
    }

    @Override
    protected void rewind() {
        this.crosstabFiller.initCrosstab();
    }

    protected List getPrintElements() {
        return this.crosstabFiller.getPrintElements();
    }

    @Override
    protected void resolveElement(JRPrintElement jRPrintElement, byte by) {
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getCrosstab(this);
    }

    @Override
    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeCrosstab(this);
    }

    @Override
    public int getId() {
        return this.parentCrosstab.getId();
    }

    @Override
    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    @Override
    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    @Override
    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    @Override
    public int getColumnBreakOffset() {
        return this.parentCrosstab.getColumnBreakOffset();
    }

    @Override
    public boolean isRepeatColumnHeaders() {
        return this.parentCrosstab.isRepeatColumnHeaders();
    }

    @Override
    public boolean isRepeatRowHeaders() {
        return this.parentCrosstab.isRepeatRowHeaders();
    }

    @Override
    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    @Override
    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    @Override
    public JRCrosstabParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parentCrosstab.getParametersMapExpression();
    }

    @Override
    public JRElement getElementByKey(String string) {
        return JRBaseCrosstab.getElementByKey(this, string);
    }

    @Override
    public JRCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return null;
    }

    @Override
    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    @Override
    public JRVariable[] getVariables() {
        return this.variables;
    }

    protected class CrosstabFiller {
        private int yOffset;
        private boolean willOverflow;
        private int[] rowHeadersXOffsets;
        private boolean[] columnBreakable;
        private boolean[] rowBreakable;
        private int[] columnCount;
        private int[] rowCount;
        private int[] columnXOffsets;
        private boolean noDataCellPrinted;
        private int startRowIndex;
        private int startColumnIndex;
        private int lastColumnIndex;
        private List columnHeaders;
        private List printRows;
        private HeaderCell[] spanHeaders;
        private int[] spanHeadersStart;
        private List rowYs = new ArrayList();
        private int rowIdx;
        private List preparedRow = new ArrayList();
        private int preparedRowHeight;
        private boolean printRowHeaders;
        private boolean printColumnHeaders;
        private JRFillVariable rowCountVar;
        private JRFillVariable colCountVar;

        protected CrosstabFiller() {
            this.setRowHeadersXOffsets();
            this.printRows = new ArrayList();
            this.rowCountVar = (JRFillVariable)JRFillCrosstab.this.variablesMap.get("ROW_COUNT");
            this.colCountVar = (JRFillVariable)JRFillCrosstab.this.variablesMap.get("COLUMN_COUNT");
        }

        protected void initCrosstab() {
            this.columnXOffsets = this.computeOffsets(JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups, true);
            this.columnBreakable = this.computeBreakableHeaders(JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups, this.columnXOffsets, true, true);
            this.columnCount = this.computeCounts(JRFillCrosstab.this.columnHeadersData);
            int[] nArray = this.computeOffsets(JRFillCrosstab.this.rowHeadersData, JRFillCrosstab.this.rowGroups, false);
            this.rowBreakable = this.computeBreakableHeaders(JRFillCrosstab.this.rowHeadersData, JRFillCrosstab.this.rowGroups, nArray, false, false);
            this.rowCount = this.computeCounts(JRFillCrosstab.this.rowHeadersData);
            this.spanHeaders = new HeaderCell[JRFillCrosstab.this.rowGroups.length - 1];
            this.spanHeadersStart = new int[JRFillCrosstab.this.rowGroups.length - 1];
            this.startRowIndex = 0;
            this.startColumnIndex = 0;
            this.lastColumnIndex = 0;
            this.noDataCellPrinted = false;
        }

        protected void setRowHeadersXOffsets() {
            this.rowHeadersXOffsets = new int[JRFillCrosstab.this.rowGroups.length + 1];
            this.rowHeadersXOffsets[0] = 0;
            for (int i = 0; i < JRFillCrosstab.this.rowGroups.length; ++i) {
                this.rowHeadersXOffsets[i + 1] = this.rowHeadersXOffsets[i] + JRFillCrosstab.this.rowGroups[i].getWidth();
            }
        }

        protected int[] computeOffsets(HeaderCell[][] headerCellArray, JRFillCrosstabGroup[] jRFillCrosstabGroupArray, boolean bl) {
            int[] nArray = new int[headerCellArray[0].length + 1];
            nArray[0] = 0;
            for (int i = 0; i < headerCellArray[0].length; ++i) {
                int n = 0;
                for (int j = jRFillCrosstabGroupArray.length - 1; j >= 0; --j) {
                    JRFillCellContents jRFillCellContents;
                    if (headerCellArray[j][i] == null) continue;
                    JRFillCellContents jRFillCellContents2 = jRFillCellContents = headerCellArray[j][i].isTotal() ? jRFillCrosstabGroupArray[j].getFillTotalHeader() : jRFillCrosstabGroupArray[j].getFillHeader();
                    n = jRFillCellContents == null ? 0 : (bl ? jRFillCellContents.getWidth() : jRFillCellContents.getHeight());
                    break;
                }
                nArray[i + 1] = nArray[i] + n;
            }
            return nArray;
        }

        protected boolean[] computeBreakableHeaders(HeaderCell[][] headerCellArray, JRFillCrosstabGroup[] jRFillCrosstabGroupArray, int[] nArray, boolean bl, boolean bl2) {
            int n;
            boolean[] blArray = new boolean[headerCellArray[0].length];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = true;
            }
            for (n = 0; n < jRFillCrosstabGroupArray.length; ++n) {
                JRFillCellContents jRFillCellContents = jRFillCrosstabGroupArray[n].getFillHeader();
                if (jRFillCellContents == null) continue;
                int n2 = bl ? jRFillCellContents.getWidth() : jRFillCellContents.getHeight();
                for (int i = 0; i < headerCellArray[0].length; ++i) {
                    int n3;
                    HeaderCell headerCell = headerCellArray[n][i];
                    if (headerCell == null || headerCell.isTotal() || headerCell.getLevelSpan() <= 1) continue;
                    int n4 = headerCell.getLevelSpan();
                    if (bl2) {
                        for (n3 = i + 1; n3 < i + n4 && nArray[n3] - nArray[i] < n2; ++n3) {
                            blArray[n3] = false;
                        }
                    }
                    for (n3 = i + n4 - 1; n3 > i && nArray[i + n4] - nArray[n3] < n2; --n3) {
                        blArray[n3] = false;
                    }
                }
            }
            return blArray;
        }

        private int[] computeCounts(HeaderCell[][] headerCellArray) {
            int[] nArray = new int[headerCellArray[0].length];
            HeaderCell[] headerCellArray2 = headerCellArray[headerCellArray.length - 1];
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                HeaderCell headerCell = headerCellArray2[i];
                if (headerCell == null || !headerCell.isTotal()) {
                    // empty if block
                }
                nArray[i] = ++n;
            }
            return nArray;
        }

        protected void fill(int n) throws JRException {
            this.printRows.clear();
            this.yOffset = 0;
            this.willOverflow = false;
            this.fillVerticalCrosstab(n);
        }

        protected boolean willOverflow() {
            return this.willOverflow;
        }

        protected int getUsedHeight() {
            return this.yOffset;
        }

        protected boolean ended() {
            return JRFillCrosstab.this.hasData ? this.startRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length && this.startColumnIndex >= JRFillCrosstab.this.columnHeadersData[0].length : this.noDataCellPrinted;
        }

        protected void fillVerticalCrosstab(int n) throws JRException {
            boolean bl;
            int n2;
            int n3;
            if (!JRFillCrosstab.this.hasData) {
                this.fillNoDataCell(n);
                return;
            }
            this.printRowHeaders = this.startColumnIndex == 0 || JRFillCrosstab.this.isRepeatRowHeaders();
            int n4 = n3 = this.printRowHeaders ? this.rowHeadersXOffsets[JRFillCrosstab.this.rowGroups.length] : 0;
            if (this.startColumnIndex == this.lastColumnIndex) {
                int n5 = JRFillCrosstab.this.getWidth();
                this.columnHeaders = this.getGroupHeaders(n5 - n3, this.columnXOffsets, this.columnBreakable, this.startColumnIndex, JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups);
                this.lastColumnIndex = this.startColumnIndex + this.columnHeaders.size();
                if (this.startColumnIndex == this.lastColumnIndex) {
                    throw new JRRuntimeException("Not enough space to render the crosstab.");
                }
            }
            this.printColumnHeaders = this.startRowIndex == 0 || JRFillCrosstab.this.isRepeatColumnHeaders();
            List list = null;
            if (this.printColumnHeaders) {
                list = this.fillColumnHeaders(n3, n - this.yOffset);
                if (this.willOverflow) {
                    return;
                }
            }
            if ((n2 = this.fillRows(n3, n - this.yOffset)) == this.startRowIndex) {
                this.willOverflow = true;
                return;
            }
            if (list != null) {
                this.printRows.addAll(list);
            }
            if (n2 >= JRFillCrosstab.this.rowHeadersData[0].length) {
                this.startColumnIndex = this.lastColumnIndex;
                if (this.startColumnIndex < JRFillCrosstab.this.columnHeadersData[0].length) {
                    n2 = 0;
                    this.startRowIndex = 0;
                    this.yOffset += JRFillCrosstab.this.getColumnBreakOffset();
                    this.fillVerticalCrosstab(n);
                    return;
                }
            }
            boolean bl2 = bl = n2 >= JRFillCrosstab.this.rowHeadersData[0].length && this.lastColumnIndex >= JRFillCrosstab.this.columnHeadersData[0].length;
            if (bl) {
                JRFillCrosstab.this.setStretchHeight(this.yOffset);
            } else {
                JRFillCrosstab.this.setStretchHeight(n);
            }
            this.startRowIndex = n2;
            this.willOverflow = !bl;
        }

        protected List getGroupHeaders(int n, int[] nArray, boolean[] blArray, int n2, HeaderCell[][] headerCellArray, JRFillCrosstabGroup[] jRFillCrosstabGroupArray) {
            int n3;
            HeaderCell[] headerCellArray2;
            int n4;
            ArrayList<HeaderCell[]> arrayList = new ArrayList<HeaderCell[]>();
            int n5 = n + nArray[n2];
            for (n4 = n2; n4 < headerCellArray[0].length && nArray[n4 + 1] <= n5; ++n4) {
                headerCellArray2 = new HeaderCell[jRFillCrosstabGroupArray.length];
                for (n3 = 0; n3 < jRFillCrosstabGroupArray.length; ++n3) {
                    headerCellArray2[n3] = headerCellArray[n3][n4];
                }
                arrayList.add(headerCellArray2);
            }
            if (n4 < headerCellArray[0].length) {
                while (n4 > n2 && !blArray[n4]) {
                    --n4;
                    arrayList.remove(arrayList.size() - 1);
                }
            }
            if (n4 > n2) {
                HeaderCell[] headerCellArray3;
                if (n2 > 0) {
                    headerCellArray2 = (HeaderCell[])arrayList.get(0);
                    for (n3 = 0; n3 < jRFillCrosstabGroupArray.length; ++n3) {
                        int n6;
                        HeaderCell headerCell = headerCellArray[n3][n2];
                        if (headerCell != null || (n6 = this.getSpanIndex(n2, n3, headerCellArray)) < 0) continue;
                        headerCellArray3 = headerCellArray[n3][n6];
                        int n7 = headerCellArray3.getLevelSpan() + n6;
                        if (n7 > n4) {
                            n7 = n4;
                        }
                        headerCellArray2[n3] = HeaderCell.createLevelSpanCopy((HeaderCell)headerCellArray3, n7 - n2);
                    }
                }
                if (n4 < headerCellArray[0].length) {
                    for (int i = 0; i < jRFillCrosstabGroupArray.length; ++i) {
                        int n8;
                        HeaderCell headerCell = headerCellArray[i][n4];
                        if (headerCell != null || (n8 = this.getSpanIndex(n4, i, headerCellArray)) < n2) continue;
                        HeaderCell headerCell2 = headerCellArray[i][n8];
                        headerCellArray3 = (HeaderCell[])arrayList.get(n8 - n2);
                        headerCellArray3[i] = HeaderCell.createLevelSpanCopy(headerCell2, n4 - n8);
                    }
                }
            }
            return arrayList;
        }

        protected int getSpanIndex(int n, int n2, HeaderCell[][] headerCellArray) {
            HeaderCell headerCell;
            int n3;
            int n4;
            for (n4 = n - 1; n4 >= 0 && headerCellArray[n2][n4] == null; --n4) {
            }
            if (n4 >= 0 && (n3 = (headerCell = headerCellArray[n2][n4]).getLevelSpan()) > n - n4) {
                return n4;
            }
            return -1;
        }

        protected void fillNoDataCell(int n) throws JRException {
            if (JRFillCrosstab.this.whenNoDataCell == null) {
                this.noDataCellPrinted = true;
            } else if (n < JRFillCrosstab.this.whenNoDataCell.getHeight()) {
                this.willOverflow = true;
            } else {
                JRFillCrosstab.this.whenNoDataCell.evaluate((byte)3);
                JRFillCrosstab.this.whenNoDataCell.prepare(n - JRFillCrosstab.this.whenNoDataCell.getHeight());
                this.willOverflow = JRFillCrosstab.this.whenNoDataCell.willOverflow();
                if (!this.willOverflow) {
                    JRFillCrosstab.this.whenNoDataCell.setX(0);
                    JRFillCrosstab.this.whenNoDataCell.setY(0);
                    JRPrintFrame jRPrintFrame = JRFillCrosstab.this.whenNoDataCell.fill();
                    ArrayList<JRPrintFrame> arrayList = new ArrayList<JRPrintFrame>(1);
                    arrayList.add(jRPrintFrame);
                    this.addPrintRow(arrayList);
                    this.yOffset += JRFillCrosstab.this.whenNoDataCell.getPrintHeight();
                    this.noDataCellPrinted = true;
                }
            }
        }

        protected List fillColumnHeaders(int n, int n2) throws JRException {
            Object object;
            JRFillCellContents[][] jRFillCellContentsArray = new JRFillCellContents[JRFillCrosstab.this.columnGroups.length][this.lastColumnIndex - this.startColumnIndex + 1];
            this.rowYs.clear();
            this.rowYs.add(new Integer(0));
            if (this.printRowHeaders && JRFillCrosstab.this.headerCell != null) {
                object = this.fillHeader(n2);
                if (this.willOverflow) {
                    return null;
                }
                jRFillCellContentsArray[JRFillCrosstab.this.columnGroups.length - 1][0] = object;
            }
            this.rowIdx = 0;
            block0: while (this.rowIdx < JRFillCrosstab.this.columnGroups.length) {
                int n3;
                for (n3 = this.startColumnIndex; n3 < this.lastColumnIndex; ++n3) {
                    JRFillCellContents jRFillCellContents;
                    HeaderCell[] headerCellArray = (HeaderCell[])this.columnHeaders.get(n3 - this.startColumnIndex);
                    HeaderCell headerCell = headerCellArray[this.rowIdx];
                    if (headerCell == null) continue;
                    jRFillCellContentsArray[this.rowIdx + headerCell.getDepthSpan() - 1][n3 - this.startColumnIndex + 1] = jRFillCellContents = this.prepareColumnHeader(headerCell, n3, n, n2);
                    if (this.willOverflow) break block0;
                }
                n3 = this.stretchColumnHeadersRow(jRFillCellContentsArray[this.rowIdx]);
                this.rowYs.add(new Integer((Integer)this.rowYs.get(this.rowIdx) + n3));
                ++this.rowIdx;
            }
            if (this.willOverflow) {
                object = null;
                this.releaseColumnHeaderCells(jRFillCellContentsArray);
            } else {
                object = this.fillColumnHeaders(jRFillCellContentsArray);
                this.yOffset += ((Integer)this.rowYs.get(JRFillCrosstab.this.columnGroups.length)).intValue();
            }
            this.resetVariables();
            return object;
        }

        private void setCountVars(int n, int n2) {
            if (n == -1) {
                this.rowCountVar.setValue(null);
            } else {
                this.rowCountVar.setValue(new Integer(this.rowCount[n]));
            }
            if (n2 == -1) {
                this.colCountVar.setValue(null);
            } else {
                this.colCountVar.setValue(new Integer(this.columnCount[n2]));
            }
        }

        private JRFillCellContents fillHeader(int n) throws JRException {
            this.setCountVars(-1, -1);
            JRFillCellContents jRFillCellContents = JRFillCrosstab.this.headerCell.getWorkingClone();
            jRFillCellContents.evaluate((byte)3);
            jRFillCellContents.prepare(n - JRFillCrosstab.this.headerCell.getHeight());
            this.willOverflow = jRFillCellContents.willOverflow();
            if (!this.willOverflow) {
                jRFillCellContents.setX(0);
                jRFillCellContents.setY(this.yOffset);
                jRFillCellContents.setVerticalSpan(JRFillCrosstab.this.columnGroups.length);
            }
            return jRFillCellContents;
        }

        private JRFillCellContents prepareColumnHeader(HeaderCell headerCell, int n, int n2, int n3) throws JRException {
            JRFillCrosstabColumnGroup jRFillCrosstabColumnGroup = JRFillCrosstab.this.columnGroups[this.rowIdx];
            JRFillCellContents jRFillCellContents = headerCell.isTotal() ? jRFillCrosstabColumnGroup.getFillTotalHeader() : jRFillCrosstabColumnGroup.getFillHeader();
            int n4 = this.columnXOffsets[n + headerCell.getLevelSpan()] - this.columnXOffsets[n];
            int n5 = jRFillCellContents.getHeight();
            if (n4 <= 0 || n5 <= 0) {
                return null;
            }
            JRFillCellContents jRFillCellContents2 = null;
            int n6 = (Integer)this.rowYs.get(this.rowIdx);
            int n7 = n3 - n6 - n5;
            if (n7 >= 0) {
                this.setCountVars(-1, n);
                this.setGroupVariables(JRFillCrosstab.this.columnGroups, headerCell.getBucketValues());
                jRFillCellContents = jRFillCellContents.getTransformedContents(n4, n5, jRFillCrosstabColumnGroup.getPosition(), (byte)1);
                jRFillCellContents = jRFillCellContents.getBoxContents(n == this.startColumnIndex && (!this.printRowHeaders || JRFillCrosstab.this.headerCell == null), false);
                jRFillCellContents = jRFillCellContents.getWorkingClone();
                jRFillCellContents.evaluate((byte)3);
                jRFillCellContents.prepare(n7);
                if (jRFillCellContents.willOverflow()) {
                    this.willOverflow = true;
                } else {
                    jRFillCellContents.setX(this.columnXOffsets[n] - this.columnXOffsets[this.startColumnIndex] + n2);
                    jRFillCellContents.setY(n6 + this.yOffset);
                    jRFillCellContents.setVerticalSpan(headerCell.getDepthSpan());
                    jRFillCellContents2 = jRFillCellContents;
                }
            } else {
                this.willOverflow = true;
            }
            return jRFillCellContents2;
        }

        private int stretchColumnHeadersRow(JRFillCellContents[] jRFillCellContentsArray) {
            int n;
            JRFillCellContents jRFillCellContents;
            int n2;
            int n3 = (Integer)this.rowYs.get(this.rowIdx);
            int n4 = 0;
            for (n2 = 0; n2 < jRFillCellContentsArray.length; ++n2) {
                int n5;
                jRFillCellContents = jRFillCellContentsArray[n2];
                if (jRFillCellContents == null) continue;
                n = n3;
                if (jRFillCellContents.getVerticalSpan() > 1) {
                    n = (Integer)this.rowYs.get(this.rowIdx - jRFillCellContents.getVerticalSpan() + 1);
                }
                if ((n5 = jRFillCellContents.getPrintHeight() - n3 + n) <= n4) continue;
                n4 = n5;
            }
            for (n2 = 0; n2 < jRFillCellContentsArray.length; ++n2) {
                jRFillCellContents = jRFillCellContentsArray[n2];
                if (jRFillCellContents == null) continue;
                n = n3;
                if (jRFillCellContents.getVerticalSpan() > 1) {
                    n = (Integer)this.rowYs.get(this.rowIdx - jRFillCellContents.getVerticalSpan() + 1);
                }
                jRFillCellContents.stretchTo(n4 + n3 - n);
            }
            return n4;
        }

        private List fillColumnHeaders(JRFillCellContents[][] jRFillCellContentsArray) throws JRException {
            ArrayList arrayList = new ArrayList(JRFillCrosstab.this.columnGroups.length);
            for (int i = 0; i < jRFillCellContentsArray.length; ++i) {
                ArrayList<JRPrintFrame> arrayList2 = new ArrayList<JRPrintFrame>(this.lastColumnIndex - this.startColumnIndex);
                arrayList.add(arrayList2);
                for (int j = 0; j < jRFillCellContentsArray[i].length; ++j) {
                    JRFillCellContents jRFillCellContents = jRFillCellContentsArray[i][j];
                    if (jRFillCellContents == null) continue;
                    arrayList2.add(jRFillCellContents.fill());
                    jRFillCellContents.releaseWorkingClone();
                }
            }
            return arrayList;
        }

        private void releaseColumnHeaderCells(JRFillCellContents[][] jRFillCellContentsArray) throws JRException {
            for (int i = 0; i < jRFillCellContentsArray.length; ++i) {
                for (int j = 0; j < jRFillCellContentsArray[i].length; ++j) {
                    JRFillCellContents jRFillCellContents = jRFillCellContentsArray[i][j];
                    if (jRFillCellContents == null) continue;
                    jRFillCellContents.rewind();
                    jRFillCellContents.releaseWorkingClone();
                }
            }
        }

        protected int fillRows(int n, int n2) throws JRException {
            this.rowYs.clear();
            this.rowYs.add(new Integer(0));
            this.rowIdx = 0;
            while (this.rowIdx < JRFillCrosstab.this.cellData.length - this.startRowIndex) {
                this.initPreparedRow();
                this.prepareRow(n, n2);
                if (this.willOverflow) break;
                this.fillRow();
                this.rowYs.add(new Integer((Integer)this.rowYs.get(this.rowIdx) + this.preparedRowHeight));
                ++this.rowIdx;
            }
            if (this.rowIdx < JRFillCrosstab.this.cellData.length - this.startRowIndex) {
                this.releasePreparedRow();
                if (this.printRowHeaders) {
                    this.fillContinuingRowHeaders(n, n2);
                }
            }
            this.yOffset += ((Integer)this.rowYs.get(this.rowIdx)).intValue();
            return this.rowIdx + this.startRowIndex;
        }

        private void initPreparedRow() {
            this.preparedRow.clear();
            this.preparedRowHeight = 0;
        }

        private void removeFilledRows(int n) {
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.printRows.remove(this.printRows.size() - 1);
                    this.rowYs.remove(this.rowYs.size() - 1);
                }
                this.rowIdx -= n;
            }
        }

        private void releasePreparedRow() throws JRException {
            for (JRFillCellContents jRFillCellContents : this.preparedRow) {
                jRFillCellContents.rewind();
                jRFillCellContents.releaseWorkingClone();
            }
            this.preparedRow.clear();
        }

        private void fillRow() throws JRException {
            int n = (Integer)this.rowYs.get(this.rowIdx);
            ArrayList<JRPrintFrame> arrayList = new ArrayList<JRPrintFrame>(this.preparedRow.size());
            for (JRFillCellContents jRFillCellContents : this.preparedRow) {
                int n2 = 0;
                if (jRFillCellContents.getVerticalSpan() > 1) {
                    n2 = n - (Integer)this.rowYs.get(this.rowIdx - jRFillCellContents.getVerticalSpan() + 1);
                }
                jRFillCellContents.stretchTo(this.preparedRowHeight + n2);
                arrayList.add(jRFillCellContents.fill());
                jRFillCellContents.releaseWorkingClone();
            }
            this.addPrintRow(arrayList);
        }

        private void prepareRow(int n, int n2) throws JRException {
            boolean bl;
            Object object;
            int n3;
            for (n3 = this.startColumnIndex; n3 < this.lastColumnIndex; ++n3) {
                object = JRFillCrosstab.this.cellData[this.rowIdx + this.startRowIndex][n3];
                bl = this.prepareDataCell((CrosstabCell)object, n3, n2, n);
                if (!bl) continue;
                this.willOverflow = true;
                return;
            }
            this.resetVariables();
            if (this.printRowHeaders) {
                for (n3 = 0; n3 < JRFillCrosstab.this.rowGroups.length; ++n3) {
                    object = JRFillCrosstab.this.rowHeadersData[n3][this.rowIdx + this.startRowIndex];
                    bl = false;
                    if (object == null) {
                        bl = this.prepareClosingRowHeader(n3, n2);
                    } else {
                        if (((HeaderCell)object).getLevelSpan() > 1) {
                            this.spanHeaders[n3] = object;
                            this.spanHeadersStart[n3] = this.rowIdx + this.startRowIndex;
                            continue;
                        }
                        bl = this.prepareRowHeader(n3, (HeaderCell)object, 1, n2);
                    }
                    if (!bl) continue;
                    this.willOverflow = true;
                    return;
                }
                this.resetVariables();
            }
        }

        private boolean prepareDataCell(CrosstabCell crosstabCell, int n, int n2, int n3) throws JRException {
            boolean bl;
            JRFillCellContents jRFillCellContents;
            int n4 = (Integer)this.rowYs.get(this.rowIdx);
            JRFillCrosstabCell jRFillCrosstabCell = JRFillCrosstab.this.crossCells[crosstabCell.getRowTotalGroupIndex()][crosstabCell.getColumnTotalGroupIndex()];
            JRFillCellContents jRFillCellContents2 = jRFillCellContents = jRFillCrosstabCell == null ? null : jRFillCrosstabCell.getFillContents();
            if (jRFillCellContents == null || jRFillCellContents.getWidth() <= 0 || jRFillCellContents.getHeight() <= 0) {
                return false;
            }
            int n5 = n2 - n4 - jRFillCellContents.getHeight();
            boolean bl2 = bl = n5 < 0;
            if (!bl) {
                boolean bl3 = this.startColumnIndex != 0 && !JRFillCrosstab.this.isRepeatRowHeaders();
                boolean bl4 = this.startRowIndex != 0 && !JRFillCrosstab.this.isRepeatColumnHeaders();
                this.setCountVars(this.rowIdx + this.startRowIndex, n);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, crosstabCell.getRowBucketValues());
                this.setGroupVariables(JRFillCrosstab.this.columnGroups, crosstabCell.getColumnBucketValues());
                this.setMeasureVariables(crosstabCell);
                jRFillCellContents = jRFillCellContents.getBoxContents(bl3 && n == this.startColumnIndex, bl4 && this.rowIdx == 0);
                jRFillCellContents = jRFillCellContents.getWorkingClone();
                jRFillCellContents.evaluate((byte)3);
                jRFillCellContents.prepare(n5);
                this.preparedRow.add(jRFillCellContents);
                bl = jRFillCellContents.willOverflow();
                if (!bl) {
                    jRFillCellContents.setX(this.columnXOffsets[n] - this.columnXOffsets[this.startColumnIndex] + n3);
                    jRFillCellContents.setY(n4 + this.yOffset);
                    int n6 = jRFillCellContents.getPrintHeight();
                    if (n6 > this.preparedRowHeight) {
                        this.preparedRowHeight = n6;
                    }
                }
            }
            return bl;
        }

        private boolean prepareRowHeader(int n, HeaderCell headerCell, int n2, int n3) throws JRException {
            boolean bl;
            JRFillCellContents jRFillCellContents;
            JRFillCrosstabRowGroup jRFillCrosstabRowGroup = JRFillCrosstab.this.rowGroups[n];
            JRFillCellContents jRFillCellContents2 = jRFillCellContents = headerCell.isTotal() ? jRFillCrosstabRowGroup.getFillTotalHeader() : jRFillCrosstabRowGroup.getFillHeader();
            if (jRFillCellContents.getWidth() <= 0 || jRFillCellContents.getHeight() <= 0) {
                return false;
            }
            int n4 = 0;
            int n5 = (Integer)this.rowYs.get(this.rowIdx - n2 + 1);
            if (n2 > 1) {
                n4 += (Integer)this.rowYs.get(this.rowIdx) - n5;
            }
            int n6 = n4 + this.preparedRowHeight;
            boolean bl2 = jRFillCrosstabRowGroup.getPosition() == 4;
            int n7 = bl2 ? n6 : jRFillCellContents.getHeight();
            int n8 = n3 - n5 - n7;
            boolean bl3 = bl = n8 < 0 || n6 < jRFillCellContents.getHeight();
            if (!bl) {
                this.setCountVars(this.rowIdx + this.startRowIndex - n2 + 1, -1);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, headerCell.getBucketValues());
                if (bl2) {
                    jRFillCellContents = jRFillCellContents.getTransformedContents(jRFillCellContents.getWidth(), n6, (byte)1, (byte)4);
                }
                jRFillCellContents = jRFillCellContents.getBoxContents(false, this.rowIdx + 1 == n2 && (!this.printColumnHeaders || JRFillCrosstab.this.headerCell == null));
                jRFillCellContents.getWorkingClone();
                jRFillCellContents.evaluate((byte)3);
                jRFillCellContents.prepare(n8);
                this.preparedRow.add(jRFillCellContents);
                bl = jRFillCellContents.willOverflow();
                if (!bl) {
                    jRFillCellContents.setX(this.rowHeadersXOffsets[n]);
                    jRFillCellContents.setY(n5 + this.yOffset);
                    jRFillCellContents.setVerticalSpan(n2);
                    int n9 = jRFillCellContents.getPrintHeight() - n4;
                    if (n9 > this.preparedRowHeight) {
                        this.preparedRowHeight = n9;
                    }
                }
            }
            if (bl) {
                this.removeFilledRows(n2 - 1);
            }
            return bl;
        }

        private boolean prepareClosingRowHeader(int n, int n2) throws JRException {
            if (n < JRFillCrosstab.this.rowGroups.length - 1 && this.spanHeaders[n] != null && this.spanHeaders[n].getLevelSpan() + this.spanHeadersStart[n] == this.rowIdx + this.startRowIndex + 1) {
                HeaderCell headerCell = this.spanHeaders[n];
                int n3 = headerCell.getLevelSpan();
                if (this.spanHeadersStart[n] < this.startRowIndex) {
                    n3 += this.spanHeadersStart[n] - this.startRowIndex;
                }
                this.spanHeaders[n] = null;
                return this.prepareRowHeader(n, headerCell, n3, n2);
            }
            return false;
        }

        private void removeExceedingSpanHeaders() {
            for (int i = JRFillCrosstab.this.rowGroups.length - 2; i >= 0; --i) {
                if (this.spanHeaders[i] == null || this.spanHeadersStart[i] < this.rowIdx + this.startRowIndex) continue;
                this.spanHeaders[i] = null;
            }
        }

        private void setBackSpanHeaders() {
            for (int i = JRFillCrosstab.this.rowGroups.length - 2; i >= 0 && this.spanHeaders[i] == null; --i) {
                int n = this.getSpanIndex(this.rowIdx + this.startRowIndex, i, JRFillCrosstab.this.rowHeadersData);
                if (n < 0) continue;
                this.spanHeaders[i] = JRFillCrosstab.this.rowHeadersData[i][n];
                this.spanHeadersStart[i] = n;
            }
        }

        private void fillContinuingRowHeaders(int n, int n2) throws JRException {
            boolean bl = false;
            block0: do {
                int n3;
                this.removeExceedingSpanHeaders();
                if (!this.rowBreakable[this.rowIdx + this.startRowIndex]) {
                    this.removeFilledRows(1);
                    this.setBackSpanHeaders();
                    continue;
                }
                this.initPreparedRow();
                for (n3 = 0; n3 < JRFillCrosstab.this.rowGroups.length - 1; ++n3) {
                    boolean bl2;
                    if (this.spanHeaders[n3] == null || !(bl2 = this.prepareContinuingRowHeader(n3, n2))) continue;
                    this.releasePreparedRow();
                    continue block0;
                }
                if (!this.preparedRow.isEmpty()) {
                    n3 = (Integer)this.rowYs.get(this.rowIdx) - (Integer)this.rowYs.get(this.rowIdx - 1);
                    if (this.preparedRowHeight > n3) {
                        this.refillLastRow(n, n2);
                    } else {
                        this.fillContinuingHeaders(n3);
                    }
                }
                bl = true;
            } while (!bl && this.rowIdx > 0);
        }

        private void fillContinuingHeaders(int n) throws JRException {
            int n2 = (Integer)this.rowYs.get(this.rowIdx - 1);
            List list = this.getLastPrintRow();
            for (int i = 0; i < this.preparedRow.size(); ++i) {
                JRFillCellContents jRFillCellContents = (JRFillCellContents)this.preparedRow.get(i);
                int n3 = (Integer)this.rowYs.get(this.rowIdx - jRFillCellContents.getVerticalSpan());
                jRFillCellContents.stretchTo(n2 - n3 + n);
                list.add(jRFillCellContents.fill());
                jRFillCellContents.releaseWorkingClone();
            }
        }

        private void refillLastRow(int n, int n2) throws JRException {
            this.removeFilledRows(1);
            this.setBackSpanHeaders();
            this.prepareRow(n, n2);
            this.fillRow();
            this.rowYs.add(new Integer((Integer)this.rowYs.get(this.rowIdx) + this.preparedRowHeight));
            ++this.rowIdx;
        }

        private boolean prepareContinuingRowHeader(int n, int n2) throws JRException {
            boolean bl;
            HeaderCell headerCell = this.spanHeaders[n];
            int n3 = this.rowIdx + this.startRowIndex - this.spanHeadersStart[n];
            if (this.spanHeadersStart[n] < this.startRowIndex) {
                n3 += this.spanHeadersStart[n] - this.startRowIndex;
            }
            int n4 = (Integer)this.rowYs.get(this.rowIdx - n3);
            int n5 = (Integer)this.rowYs.get(this.rowIdx);
            int n6 = n5 - n4;
            int n7 = (Integer)this.rowYs.get(this.rowIdx - 1);
            int n8 = n7 - n4;
            JRFillCrosstabRowGroup jRFillCrosstabRowGroup = JRFillCrosstab.this.rowGroups[n];
            JRFillCellContents jRFillCellContents = headerCell.isTotal() ? jRFillCrosstabRowGroup.getFillTotalHeader() : jRFillCrosstabRowGroup.getFillHeader();
            boolean bl2 = jRFillCrosstabRowGroup.getPosition() == 4;
            int n9 = bl2 ? n6 : jRFillCellContents.getHeight();
            int n10 = n2 - n4 - n9;
            boolean bl3 = bl = n10 < 0 || n6 < jRFillCellContents.getHeight();
            if (!bl) {
                this.setCountVars(this.rowIdx + this.startRowIndex - n3, -1);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, headerCell.getBucketValues());
                if (bl2) {
                    jRFillCellContents = jRFillCellContents.getTransformedContents(jRFillCellContents.getWidth(), n6, (byte)1, (byte)4);
                }
                jRFillCellContents = jRFillCellContents.getBoxContents(false, this.rowIdx == n3 && (!this.printColumnHeaders || JRFillCrosstab.this.headerCell == null));
                jRFillCellContents.getWorkingClone();
                jRFillCellContents.evaluate((byte)3);
                jRFillCellContents.prepare(n10);
                this.preparedRow.add(jRFillCellContents);
                bl = jRFillCellContents.willOverflow();
                if (!bl) {
                    jRFillCellContents.setX(this.rowHeadersXOffsets[n]);
                    jRFillCellContents.setY(n4 + this.yOffset);
                    jRFillCellContents.setVerticalSpan(n3);
                    int n11 = jRFillCellContents.getPrintHeight() - n8;
                    if (n11 > this.preparedRowHeight) {
                        this.preparedRowHeight = n11;
                    }
                }
            }
            if (bl) {
                this.removeFilledRows(n3);
            }
            return bl;
        }

        protected void addPrintRow(List list) {
            this.printRows.add(list);
        }

        protected List getLastPrintRow() {
            return (List)this.printRows.get(this.printRows.size() - 1);
        }

        protected List getPrintElements() {
            ArrayList arrayList = new ArrayList();
            for (List list : this.printRows) {
                arrayList.addAll(list);
            }
            return arrayList;
        }

        protected void setGroupVariables(JRFillCrosstabGroup[] jRFillCrosstabGroupArray, BucketDefinition.Bucket[] bucketArray) {
            for (int i = 0; i < jRFillCrosstabGroupArray.length; ++i) {
                Object object = null;
                if (bucketArray[i] != null && !bucketArray[i].isTotal()) {
                    object = bucketArray[i].getValue();
                }
                jRFillCrosstabGroupArray[i].getFillVariable().setValue(object);
            }
        }

        protected void setMeasureVariables(CrosstabCell crosstabCell) {
            MeasureDefinition.MeasureValue[] measureValueArray = crosstabCell.getMesureValues();
            for (int i = 0; i < JRFillCrosstab.this.measures.length; ++i) {
                Object object = this.measureValue(measureValueArray, i);
                JRFillCrosstab.this.measures[i].getFillVariable().setValue(object);
            }
            MeasureDefinition.MeasureValue[][][] measureValueArray2 = crosstabCell.getTotals();
            for (int i = 0; i <= JRFillCrosstab.this.rowGroups.length; ++i) {
                for (int j = 0; j <= JRFillCrosstab.this.columnGroups.length; ++j) {
                    MeasureDefinition.MeasureValue[] measureValueArray3 = measureValueArray2[i][j];
                    if (!JRFillCrosstab.this.retrieveTotal[i][j]) continue;
                    for (int k = 0; k < JRFillCrosstab.this.measures.length; ++k) {
                        JRFillVariable jRFillVariable = JRFillCrosstab.this.totalVariables[i][j][k];
                        Object object = this.measureValue(measureValueArray3, k);
                        jRFillVariable.setValue(object);
                    }
                }
            }
        }

        protected Object measureValue(MeasureDefinition.MeasureValue[] measureValueArray, int n) {
            Object object = JRFillCrosstab.this.measures[n].getPercentageOfType() == 1 ? (measureValueArray[n].isInitialized() ? measureValueArray[n].getValue() : JRFillCrosstab.this.measures[n].getPercentageCalculator().calculatePercentage(measureValueArray[n], JRFillCrosstab.this.grandTotals[n])) : measureValueArray[n].getValue();
            return object;
        }

        protected void resetVariables() {
            int n;
            for (n = 0; n < JRFillCrosstab.this.rowGroups.length; ++n) {
                JRFillCrosstab.this.rowGroups[n].getFillVariable().setValue(null);
            }
            for (n = 0; n < JRFillCrosstab.this.columnGroups.length; ++n) {
                JRFillCrosstab.this.columnGroups[n].getFillVariable().setValue(null);
            }
            for (n = 0; n < JRFillCrosstab.this.measures.length; ++n) {
                JRFillCrosstab.this.measures[n].getFillVariable().setValue(null);
            }
            for (n = 0; n <= JRFillCrosstab.this.rowGroups.length; ++n) {
                for (int i = 0; i <= JRFillCrosstab.this.columnGroups.length; ++i) {
                    if (!JRFillCrosstab.this.retrieveTotal[n][i]) continue;
                    for (int j = 0; j < JRFillCrosstab.this.measures.length; ++j) {
                        JRFillCrosstab.this.totalVariables[n][i][j].setValue(null);
                    }
                }
            }
        }
    }

    public class JRFillCrosstabDataset
    extends JRFillElementDataset
    implements JRCrosstabDataset {
        private Object[] bucketValues;
        private Object[] measureValues;

        public JRFillCrosstabDataset(JRCrosstabDataset jRCrosstabDataset, JRFillObjectFactory jRFillObjectFactory) {
            super(jRCrosstabDataset, jRFillObjectFactory);
            this.bucketValues = new Object[JRFillCrosstab.this.rowGroups.length + JRFillCrosstab.this.columnGroups.length];
            this.measureValues = new Object[JRFillCrosstab.this.measures.length];
        }

        @Override
        protected void customInitialize() {
            JRFillCrosstab.this.initBucketingService();
        }

        @Override
        protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
            int n;
            for (n = 0; n < JRFillCrosstab.this.rowGroups.length; ++n) {
                this.bucketValues[n] = jRCalculator.evaluate(JRFillCrosstab.this.rowGroups[n].getBucket().getExpression());
            }
            for (n = 0; n < JRFillCrosstab.this.columnGroups.length; ++n) {
                this.bucketValues[n + JRFillCrosstab.this.rowGroups.length] = jRCalculator.evaluate(JRFillCrosstab.this.columnGroups[n].getBucket().getExpression());
            }
            for (n = 0; n < JRFillCrosstab.this.measures.length; ++n) {
                this.measureValues[n] = jRCalculator.evaluate(JRFillCrosstab.this.measures[n].getValueExpression());
            }
        }

        @Override
        protected void customIncrement() {
            try {
                JRFillCrosstab.this.bucketingService.addData(this.bucketValues, this.measureValues);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException("Error incrementing crosstab dataset", jRException);
            }
        }

        protected Dataset getCustomDataset() {
            return null;
        }

        @Override
        public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        }

        @Override
        public boolean isDataPreSorted() {
            return ((JRCrosstabDataset)this.parent).isDataPreSorted();
        }
    }
}

