/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRSortableDataSource;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRDistinctCountIncrementerFactory;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;

public class JRFillDataset
implements JRDataset {
    private final JRBaseFiller filler;
    private final JRDataset parent;
    private final boolean isMain;
    protected JRQuery query = null;
    private boolean useDatasourceParamValue = false;
    private boolean useConnectionParamValue = false;
    protected JRFillParameter[] parameters = null;
    protected Map parametersMap = null;
    protected JRFillField[] fields = null;
    protected Map fieldsMap = null;
    protected JRFillVariable[] variables = null;
    protected Map variablesMap = null;
    protected Set variableCalculationReqs;
    protected JRFillElementDataset[] elementDatasets;
    protected JRFillElementDataset[] origElementDatasets;
    protected JRFillGroup[] groups = null;
    protected String resourceBundleBaseName = null;
    protected byte whenResourceMissingType;
    protected String scriptletClassName = null;
    protected JRDataSource dataSource = null;
    protected Locale locale = null;
    protected ResourceBundle resourceBundle = null;
    protected TimeZone timeZone = null;
    protected int reportCount = 0;
    protected JRCalculator calculator = null;
    protected JRAbstractScriptlet scriptlet = null;
    protected Integer reportMaxCount = null;
    private JRQueryExecuter queryExecuter;

    protected JRFillDataset(JRBaseFiller jRBaseFiller, JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        jRFillObjectFactory.put(jRDataset, this);
        this.filler = jRBaseFiller;
        this.parent = jRDataset;
        this.isMain = jRDataset.isMainDataset();
        this.scriptletClassName = jRDataset.getScriptletClass();
        this.resourceBundleBaseName = jRDataset.getResourceBundle();
        this.whenResourceMissingType = jRDataset.getWhenResourceMissingType();
        this.query = jRDataset.getQuery();
        this.setParameters(jRDataset, jRFillObjectFactory);
        this.setFields(jRDataset, jRFillObjectFactory);
        this.setVariables(jRDataset, jRFillObjectFactory);
        this.setGroups(jRDataset, jRFillObjectFactory);
    }

    private void setParameters(JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        JRParameter[] jRParameterArray = jRDataset.getParameters();
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            this.parameters = new JRFillParameter[jRParameterArray.length];
            this.parametersMap = new HashMap();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = jRFillObjectFactory.getParameter(jRParameterArray[i]);
                this.parametersMap.put(this.parameters[i].getName(), this.parameters[i]);
            }
        }
    }

    private void setGroups(JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        JRGroup[] jRGroupArray = jRDataset.getGroups();
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            this.groups = new JRFillGroup[jRGroupArray.length];
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = jRFillObjectFactory.getGroup(jRGroupArray[i]);
            }
        }
    }

    private void setVariables(JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        JRVariable[] jRVariableArray = jRDataset.getVariables();
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            ArrayList arrayList = new ArrayList(jRVariableArray.length * 3);
            this.variablesMap = new HashMap();
            for (int i = 0; i < jRVariableArray.length; ++i) {
                this.addVariable(jRVariableArray[i], arrayList, jRFillObjectFactory);
            }
            this.setVariables(arrayList);
        }
    }

    private JRFillVariable addVariable(JRVariable jRVariable, List list, JRFillObjectFactory jRFillObjectFactory) {
        JRFillVariable jRFillVariable = jRFillObjectFactory.getVariable(jRVariable);
        byte by = jRFillVariable.getCalculation();
        switch (by) {
            case 3: 
            case 7: {
                JRVariable jRVariable2 = this.createHelperVariable(jRVariable, "_COUNT", (byte)1);
                JRFillVariable jRFillVariable2 = this.addVariable(jRVariable2, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable2, (byte)0);
                JRVariable jRVariable3 = this.createHelperVariable(jRVariable, "_SUM", (byte)2);
                JRFillVariable jRFillVariable3 = this.addVariable(jRVariable3, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable3, (byte)1);
                break;
            }
            case 6: {
                JRVariable jRVariable4 = this.createHelperVariable(jRVariable, "_VARIANCE", (byte)7);
                JRFillVariable jRFillVariable4 = this.addVariable(jRVariable4, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable4, (byte)2);
                break;
            }
            case 10: {
                JRVariable jRVariable5 = this.createDistinctCountHelperVariable(jRVariable);
                JRFillVariable jRFillVariable5 = this.addVariable(jRVariable5, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable5, (byte)0);
                break;
            }
        }
        list.add(jRFillVariable);
        return jRFillVariable;
    }

    private JRVariable createHelperVariable(JRVariable jRVariable, String string, byte by) {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName(jRVariable.getName() + string);
        jRDesignVariable.setValueClassName(jRVariable.getValueClassName());
        jRDesignVariable.setIncrementerFactoryClassName(jRVariable.getIncrementerFactoryClassName());
        jRDesignVariable.setResetType(jRVariable.getResetType());
        jRDesignVariable.setResetGroup(jRVariable.getResetGroup());
        jRDesignVariable.setIncrementType(jRVariable.getIncrementType());
        jRDesignVariable.setIncrementGroup(jRVariable.getIncrementGroup());
        jRDesignVariable.setCalculation(by);
        jRDesignVariable.setSystemDefined(true);
        jRDesignVariable.setExpression(jRVariable.getExpression());
        return jRDesignVariable;
    }

    private JRVariable createDistinctCountHelperVariable(JRVariable jRVariable) {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName(jRVariable.getName() + "_DISTINCT_COUNT");
        jRDesignVariable.setValueClassName(jRVariable.getValueClassName());
        jRDesignVariable.setIncrementerFactoryClassName(JRDistinctCountIncrementerFactory.class.getName());
        jRDesignVariable.setResetType((byte)1);
        if (jRVariable.getIncrementType() != 5) {
            jRDesignVariable.setResetType(jRVariable.getIncrementType());
        }
        jRDesignVariable.setResetGroup(jRVariable.getIncrementGroup());
        jRDesignVariable.setCalculation((byte)0);
        jRDesignVariable.setSystemDefined(true);
        jRDesignVariable.setExpression(jRVariable.getExpression());
        return jRDesignVariable;
    }

    private void setVariables(List list) {
        this.variables = new JRFillVariable[list.size()];
        this.variables = list.toArray(this.variables);
        for (int i = 0; i < this.variables.length; ++i) {
            this.variablesMap.put(this.variables[i].getName(), this.variables[i]);
        }
    }

    private void setFields(JRDataset jRDataset, JRFillObjectFactory jRFillObjectFactory) {
        JRField[] jRFieldArray = jRDataset.getFields();
        if (jRFieldArray != null && jRFieldArray.length > 0) {
            this.fields = new JRFillField[jRFieldArray.length];
            this.fieldsMap = new HashMap();
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = jRFillObjectFactory.getField(jRFieldArray[i]);
                this.fieldsMap.put(this.fields[i].getName(), this.fields[i]);
            }
        }
    }

    protected void createCalculator(JasperReport jasperReport) throws JRException {
        this.setCalculator(JRFillDataset.createCalculator(jasperReport, this));
    }

    protected void setCalculator(JRCalculator jRCalculator) {
        this.calculator = jRCalculator;
    }

    protected static JRCalculator createCalculator(JasperReport jasperReport, JRDataset jRDataset) throws JRException {
        JREvaluator jREvaluator = JRDefaultCompiler.getInstance().loadEvaluator(jasperReport, jRDataset);
        return new JRCalculator(jREvaluator);
    }

    protected void initCalculator() throws JRException {
        this.calculator.init(this);
    }

    protected void inheritFromMain() {
        if (this.resourceBundleBaseName == null && !this.isMain) {
            this.resourceBundleBaseName = this.filler.mainDataset.resourceBundleBaseName;
            this.whenResourceMissingType = this.filler.mainDataset.whenResourceMissingType;
        }
    }

    protected JRAbstractScriptlet createScriptlet() throws JRException {
        JRAbstractScriptlet jRAbstractScriptlet = null;
        if (this.scriptletClassName != null) {
            try {
                Class clazz = JRClassLoader.loadClassForName(this.scriptletClassName);
                jRAbstractScriptlet = (JRAbstractScriptlet)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRException("Error loading scriptlet class : " + this.scriptletClassName, classNotFoundException);
            }
            catch (Exception exception) {
                throw new JRException("Error creating scriptlet class instance : " + this.scriptletClassName, exception);
            }
        } else {
            jRAbstractScriptlet = new JRDefaultScriptlet();
        }
        return jRAbstractScriptlet;
    }

    protected void initElementDatasets(JRFillObjectFactory jRFillObjectFactory) {
        this.elementDatasets = jRFillObjectFactory.getElementDatasets(this);
    }

    protected void filterElementDatasets(JRFillElementDataset jRFillElementDataset) {
        this.origElementDatasets = this.elementDatasets;
        this.elementDatasets = new JRFillElementDataset[]{jRFillElementDataset};
    }

    protected void restoreElementDatasets() {
        if (this.origElementDatasets != null) {
            this.elementDatasets = this.origElementDatasets;
            this.origElementDatasets = null;
        }
    }

    protected ResourceBundle loadResourceBundle() {
        ResourceBundle resourceBundle = null;
        if (this.resourceBundleBaseName != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale, classLoader);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (resourceBundle == null) {
                classLoader = JRClassLoader.class.getClassLoader();
                resourceBundle = classLoader == null ? ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale) : ResourceBundle.getBundle(this.resourceBundleBaseName, this.locale, classLoader);
            }
        }
        return resourceBundle;
    }

    protected void setParameterValues(Map map) throws JRException {
        map.put("REPORT_PARAMETERS_MAP", map);
        this.reportMaxCount = (Integer)map.get("REPORT_MAX_COUNT");
        this.locale = (Locale)map.get("REPORT_LOCALE");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
            map.put("REPORT_LOCALE", this.locale);
        }
        this.resourceBundle = (ResourceBundle)map.get("REPORT_RESOURCE_BUNDLE");
        if (this.resourceBundle == null) {
            this.resourceBundle = this.loadResourceBundle();
            if (this.resourceBundle != null) {
                map.put("REPORT_RESOURCE_BUNDLE", this.resourceBundle);
            }
        }
        this.timeZone = (TimeZone)map.get("REPORT_TIME_ZONE");
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
            map.put("REPORT_TIME_ZONE", this.timeZone);
        }
        this.scriptlet = (JRAbstractScriptlet)map.get("REPORT_SCRIPTLET");
        if (this.scriptlet == null) {
            this.scriptlet = this.createScriptlet();
            map.put("REPORT_SCRIPTLET", this.scriptlet);
        }
        this.scriptlet.setData(this.parametersMap, this.fieldsMap, this.variablesMap, this.groups);
        this.setFillParameterValues(map);
        this.setDatasource();
    }

    private void setDatasource() throws JRException {
        JRSortField[] jRSortFieldArray;
        this.queryExecuter = null;
        this.dataSource = (JRDataSource)this.getParameterValue("REPORT_DATA_SOURCE");
        if (!this.useDatasourceParamValue && (this.useConnectionParamValue || this.dataSource == null)) {
            this.dataSource = this.createQueryDatasource();
            this.setParameter("REPORT_DATA_SOURCE", (Object)this.dataSource);
        }
        if ((jRSortFieldArray = this.getSortFields()) != null && jRSortFieldArray.length > 0) {
            this.dataSource = new JRSortableDataSource(this.dataSource, this.fields, jRSortFieldArray, this.locale);
            this.setParameter("REPORT_DATA_SOURCE", (Object)this.dataSource);
        }
    }

    private void setFillParameterValues(Map map) throws JRException {
        if (this.parameters != null && this.parameters.length > 0) {
            for (int i = 0; i < this.parameters.length; ++i) {
                Object object = null;
                if (map.containsKey(this.parameters[i].getName())) {
                    object = map.get(this.parameters[i].getName());
                } else if (!this.parameters[i].isSystemDefined() && (object = this.calculator.evaluate(this.parameters[i].getDefaultValueExpression(), (byte)3)) != null) {
                    map.put(this.parameters[i].getName(), object);
                }
                this.setParameter(this.parameters[i], object);
            }
        }
    }

    private JRDataSource createQueryDatasource() throws JRException {
        if (this.query == null) {
            return null;
        }
        try {
            JRQueryExecuterFactory jRQueryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(this.query.getLanguage());
            this.queryExecuter = jRQueryExecuterFactory.createQueryExecuter(this.parent, this.parametersMap);
            this.filler.fillContext.setRunningQueryExecuter(this.queryExecuter);
            JRDataSource jRDataSource = this.queryExecuter.createDatasource();
            return jRDataSource;
        }
        finally {
            this.filler.fillContext.clearRunningQueryExecuter();
        }
    }

    protected void reset() {
        this.useDatasourceParamValue = false;
        this.useConnectionParamValue = false;
    }

    protected void setDatasourceParameterValue(Map map, JRDataSource jRDataSource) {
        this.useDatasourceParamValue = true;
        if (jRDataSource != null) {
            map.put("REPORT_DATA_SOURCE", jRDataSource);
        }
    }

    protected void setConnectionParameterValue(Map map, Connection connection) {
        this.useConnectionParamValue = true;
        if (connection != null) {
            map.put("REPORT_CONNECTION", connection);
        }
    }

    protected void closeDatasource() {
        if (this.queryExecuter != null) {
            this.queryExecuter.close();
            this.queryExecuter = null;
        }
        this.reset();
    }

    protected void start() {
        this.reportCount = 0;
    }

    protected boolean next() throws JRException {
        boolean bl = false;
        if (this.dataSource != null) {
            boolean bl2 = true;
            JRExpression jRExpression = this.getFilterExpression();
            do {
                if (!(bl = this.advanceDataSource())) continue;
                this.setOldValues();
                this.calculator.estimateVariables();
                if (jRExpression != null) {
                    Boolean bl3 = (Boolean)this.calculator.evaluate(jRExpression, (byte)2);
                    boolean bl4 = bl2 = bl3 != null && bl3 != false;
                }
                if (bl2) continue;
                this.revertToOldValues();
            } while (bl && !bl2);
            if (bl) {
                ++this.reportCount;
            }
        }
        return bl;
    }

    protected void setOldValues() throws JRException {
        Object object;
        int n;
        if (this.fields != null && this.fields.length > 0) {
            for (n = 0; n < this.fields.length; ++n) {
                object = this.fields[n];
                ((JRFillField)object).setPreviousOldValue(((JRFillField)object).getOldValue());
                ((JRFillField)object).setOldValue(((JRFillField)object).getValue());
                ((JRFillField)object).setValue(this.dataSource.getFieldValue((JRField)object));
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (n = 0; n < this.variables.length; ++n) {
                object = this.variables[n];
                ((JRFillVariable)object).setPreviousOldValue(((JRFillVariable)object).getOldValue());
                ((JRFillVariable)object).setOldValue(((JRFillVariable)object).getValue());
            }
        }
    }

    protected void revertToOldValues() {
        Object object;
        int n;
        if (this.fields != null && this.fields.length > 0) {
            for (n = 0; n < this.fields.length; ++n) {
                object = this.fields[n];
                ((JRFillField)object).setValue(((JRFillField)object).getOldValue());
                ((JRFillField)object).setOldValue(((JRFillField)object).getPreviousOldValue());
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (n = 0; n < this.variables.length; ++n) {
                object = this.variables[n];
                ((JRFillVariable)object).setValue(((JRFillVariable)object).getOldValue());
                ((JRFillVariable)object).setOldValue(((JRFillVariable)object).getPreviousOldValue());
            }
        }
    }

    protected boolean advanceDataSource() throws JRException {
        boolean bl = (this.reportMaxCount == null || this.reportMaxCount > this.reportCount) && this.dataSource.next();
        return bl;
    }

    protected void setParameter(String string, Object object) throws JRException {
        JRFillParameter jRFillParameter = (JRFillParameter)this.parametersMap.get(string);
        if (jRFillParameter != null) {
            this.setParameter(jRFillParameter, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setParameter(JRFillParameter jRFillParameter, Object object) throws JRException {
        if (object != null) {
            if (!jRFillParameter.getValueClass().isInstance(object)) throw new JRException("Incompatible " + object.getClass().getName() + " value assigned to parameter " + jRFillParameter.getName() + " in the " + this.getName() + " dataset.");
            jRFillParameter.setValue(object);
            return;
        } else {
            jRFillParameter.setValue(object);
        }
    }

    public Object getVariableValue(String string) {
        JRFillVariable jRFillVariable = (JRFillVariable)this.variablesMap.get(string);
        if (jRFillVariable == null) {
            throw new JRRuntimeException("No such variable " + string);
        }
        return jRFillVariable.getValue();
    }

    public Object getParameterValue(String string) {
        JRFillParameter jRFillParameter = (JRFillParameter)this.parametersMap.get(string);
        if (jRFillParameter == null) {
            throw new JRRuntimeException("No such parameter " + string);
        }
        return jRFillParameter.getValue();
    }

    public Object getFieldValue(String string) {
        JRFillField jRFillField = (JRFillField)this.fieldsMap.get(string);
        if (jRFillField == null) {
            throw new JRRuntimeException("No such field " + string);
        }
        return jRFillField.getValue();
    }

    protected void addVariableCalculationReq(String string, byte by) {
        if (this.variableCalculationReqs == null) {
            this.variableCalculationReqs = new HashSet();
        }
        this.variableCalculationReqs.add(new VariableCalculationReq(string, by));
    }

    protected void checkVariableCalculationReqs(JRFillObjectFactory jRFillObjectFactory) {
        if (this.variableCalculationReqs != null && !this.variableCalculationReqs.isEmpty()) {
            ArrayList arrayList = new ArrayList(this.variables.length * 2);
            for (int i = 0; i < this.variables.length; ++i) {
                JRFillVariable jRFillVariable = this.variables[i];
                this.checkVariableCalculationReq(jRFillVariable, arrayList, jRFillObjectFactory);
            }
            this.setVariables(arrayList);
        }
    }

    private void checkVariableCalculationReq(JRFillVariable jRFillVariable, List list, JRFillObjectFactory jRFillObjectFactory) {
        JRFillVariable jRFillVariable2;
        JRVariable jRVariable;
        if (this.hasVariableCalculationReq(jRFillVariable, (byte)3) || this.hasVariableCalculationReq(jRFillVariable, (byte)7)) {
            if (jRFillVariable.getHelperVariable((byte)0) == null) {
                jRVariable = this.createHelperVariable(jRFillVariable, "_COUNT", (byte)1);
                jRFillVariable2 = jRFillObjectFactory.getVariable(jRVariable);
                this.checkVariableCalculationReq(jRFillVariable2, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable2, (byte)0);
            }
            if (jRFillVariable.getHelperVariable((byte)1) == null) {
                jRVariable = this.createHelperVariable(jRFillVariable, "_SUM", (byte)2);
                jRFillVariable2 = jRFillObjectFactory.getVariable(jRVariable);
                this.checkVariableCalculationReq(jRFillVariable2, list, jRFillObjectFactory);
                jRFillVariable.setHelperVariable(jRFillVariable2, (byte)1);
            }
        }
        if (this.hasVariableCalculationReq(jRFillVariable, (byte)6) && jRFillVariable.getHelperVariable((byte)2) == null) {
            jRVariable = this.createHelperVariable(jRFillVariable, "_VARIANCE", (byte)7);
            jRFillVariable2 = jRFillObjectFactory.getVariable(jRVariable);
            this.checkVariableCalculationReq(jRFillVariable2, list, jRFillObjectFactory);
            jRFillVariable.setHelperVariable(jRFillVariable2, (byte)2);
        }
        if (this.hasVariableCalculationReq(jRFillVariable, (byte)10) && jRFillVariable.getHelperVariable((byte)0) == null) {
            jRVariable = this.createDistinctCountHelperVariable(jRFillVariable);
            jRFillVariable2 = jRFillObjectFactory.getVariable(jRVariable);
            this.checkVariableCalculationReq(jRFillVariable2, list, jRFillObjectFactory);
            jRFillVariable.setHelperVariable(jRFillVariable2, (byte)0);
        }
        list.add(jRFillVariable);
    }

    private boolean hasVariableCalculationReq(JRVariable jRVariable, byte by) {
        return this.variableCalculationReqs.contains(new VariableCalculationReq(jRVariable.getName(), by));
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public String getScriptletClass() {
        return this.parent.getScriptletClass();
    }

    @Override
    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    @Override
    public JRQuery getQuery() {
        return this.query;
    }

    @Override
    public JRField[] getFields() {
        return this.fields;
    }

    @Override
    public JRSortField[] getSortFields() {
        return this.parent.getSortFields();
    }

    @Override
    public JRVariable[] getVariables() {
        return this.variables;
    }

    @Override
    public JRGroup[] getGroups() {
        return this.groups;
    }

    @Override
    public boolean isMainDataset() {
        return this.isMain;
    }

    @Override
    public String getResourceBundle() {
        return this.parent.getResourceBundle();
    }

    @Override
    public byte getWhenResourceMissingType() {
        return this.whenResourceMissingType;
    }

    @Override
    public void setWhenResourceMissingType(byte by) {
        this.whenResourceMissingType = by;
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.parent.getPropertiesMap();
    }

    @Override
    public JRExpression getFilterExpression() {
        return this.parent.getFilterExpression();
    }

    protected static class VariableCalculationReq {
        String variableName;
        byte calculation;

        VariableCalculationReq(String string, byte by) {
            this.variableName = string;
            this.calculation = by;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof VariableCalculationReq)) {
                return false;
            }
            VariableCalculationReq variableCalculationReq = (VariableCalculationReq)object;
            return this.variableName.equals(variableCalculationReq.variableName) && this.calculation == variableCalculationReq.calculation;
        }

        public int hashCode() {
            return 31 * this.calculation + this.variableName.hashCode();
        }
    }
}

