/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRXmlWriteHelper {
    private final Writer writer;
    private final List indents;
    private int indent;
    private final List elementStack;
    private StringBuffer buffer;
    private StackElement lastElement;
    protected static final int COLOR_MASK = Integer.parseInt("FFFFFF", 16);

    public JRXmlWriteHelper(Writer writer) {
        this.writer = writer;
        this.indents = new ArrayList();
        this.indent = 0;
        this.elementStack = new ArrayList();
        this.lastElement = null;
        this.clearBuffer();
    }

    public void writeProlog(String string) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + string + "\"?>\n");
    }

    public void writePublicDoctype(String string, String string2, String string3) throws IOException {
        this.writer.write("<!DOCTYPE " + string + " PUBLIC \"" + string2 + "\" \"" + string3 + "\">\n\n");
    }

    public void startElement(String string) {
        ++this.indent;
        this.lastElement = new StackElement(string);
        this.elementStack.add(this.lastElement);
    }

    protected void writeParents(boolean bl) throws IOException {
        int n = this.elementStack.size();
        for (int i = n - 1; i >= 0; --i) {
            StackElement stackElement = (StackElement)this.elementStack.get(i);
            if (stackElement.hasChildren) break;
            if (i < n - 1) {
                stackElement.hasChildren = true;
                continue;
            }
            stackElement.hasChildren |= bl;
        }
        for (int i = i + 1; i < n; ++i) {
            StackElement stackElement = (StackElement)this.elementStack.get(i);
            this.writeElementAttributes(stackElement, i);
        }
    }

    public void writeCDATA(String string) throws IOException {
        if (string != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append("<![CDATA[");
            this.buffer.append(string);
            this.buffer.append("]]>\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String string, String string2) throws IOException {
        if (string2 != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append('<');
            this.buffer.append(string);
            this.buffer.append("><![CDATA[");
            this.buffer.append(string2);
            this.buffer.append("]]></");
            this.buffer.append(string);
            this.buffer.append(">\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String string, String string2, String string3, String string4) throws IOException {
        if (string2 != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append('<');
            this.buffer.append(string);
            this.buffer.append(' ');
            this.buffer.append(string3);
            this.buffer.append("=\"");
            this.buffer.append(string4);
            this.buffer.append("\"><![CDATA[");
            this.buffer.append(string2);
            this.buffer.append("]]></");
            this.buffer.append(string);
            this.buffer.append(">\n");
            this.flushBuffer();
        }
    }

    protected void writeElementAttributes(StackElement stackElement, int n) throws IOException {
        this.buffer.append(this.getIndent(n));
        this.buffer.append('<');
        this.buffer.append(stackElement.name);
        for (Attribute attribute : stackElement.atts) {
            this.buffer.append(' ');
            this.buffer.append(attribute.name);
            this.buffer.append("=\"");
            this.buffer.append(attribute.value);
            this.buffer.append('\"');
        }
        if (stackElement.hasChildren) {
            this.buffer.append(">\n");
        } else {
            this.buffer.append("/>\n");
        }
        this.flushBuffer();
    }

    public void closeElement() throws IOException {
        this.closeElement(false);
    }

    public void closeElement(boolean bl) throws IOException {
        --this.indent;
        if (bl && this.lastElement.atts.size() == 0 && !this.lastElement.hasChildren) {
            this.clearBuffer();
        } else {
            this.writeParents(false);
            if (this.lastElement.hasChildren) {
                this.buffer.append(this.getIndent(this.indent));
                this.buffer.append("</");
                this.buffer.append(this.lastElement.name);
                this.buffer.append(">\n");
                this.flushBuffer();
            }
        }
        this.elementStack.remove(this.indent);
        this.lastElement = this.indent > 0 ? (StackElement)this.elementStack.get(this.indent - 1) : null;
    }

    protected char[] getIndent(int n) {
        if (n >= this.indents.size()) {
            for (int i = this.indents.size(); i <= n; ++i) {
                char[] cArray = new char[i];
                Arrays.fill(cArray, '\t');
                this.indents.add(cArray);
            }
        }
        return (char[])this.indents.get(n);
    }

    protected void flushBuffer() throws IOException {
        this.writer.write(this.buffer.toString());
        this.clearBuffer();
    }

    protected void clearBuffer() {
        this.buffer = new StringBuffer();
    }

    public void writeExpression(String string, JRExpression jRExpression, boolean bl) throws IOException {
        this.writeExpression(string, jRExpression, bl, null);
    }

    public void writeExpression(String string, JRExpression jRExpression, boolean bl, String string2) throws IOException {
        if (jRExpression != null) {
            if (bl && (string2 == null || !string2.equals(jRExpression.getValueClassName()))) {
                this.writeCDATAElement(string, jRExpression.getText(), "class", jRExpression.getValueClassName());
            } else {
                this.writeCDATAElement(string, jRExpression.getText());
            }
        }
    }

    protected void writeAttribute(String string, String string2) {
        this.lastElement.addAttribute(string, string2);
    }

    public void addAttribute(String string, String string2) {
        if (string2 != null) {
            this.writeAttribute(string, string2);
        }
    }

    public void addEncodedAttribute(String string, String string2) {
        if (string2 != null) {
            this.writeAttribute(string, JRStringUtil.xmlEncode(string2));
        }
    }

    public void addAttribute(String string, String string2, String string3) {
        if (string2 != null && !string2.equals(string3)) {
            this.writeAttribute(string, string2);
        }
    }

    public void addAttribute(String string, Object object) {
        if (object != null) {
            this.writeAttribute(string, String.valueOf(object));
        }
    }

    public void addAttribute(String string, int n) {
        this.writeAttribute(string, String.valueOf(n));
    }

    public void addAttributePositive(String string, int n) {
        if (n > 0) {
            this.writeAttribute(string, String.valueOf(n));
        }
    }

    public void addAttribute(String string, float f) {
        this.writeAttribute(string, String.valueOf(f));
    }

    public void addAttribute(String string, float f, float f2) {
        if (f != f2) {
            this.writeAttribute(string, String.valueOf(f));
        }
    }

    public void addAttribute(String string, double d) {
        this.writeAttribute(string, String.valueOf(d));
    }

    public void addAttribute(String string, double d, double d2) {
        if (d != d2) {
            this.writeAttribute(string, String.valueOf(d));
        }
    }

    public void addAttribute(String string, int n, int n2) {
        if (n != n2) {
            this.addAttribute(string, n);
        }
    }

    public void addAttribute(String string, boolean bl) {
        this.writeAttribute(string, String.valueOf(bl));
    }

    public void addAttribute(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.addAttribute(string, bl);
        }
    }

    public void addAttribute(String string, Color color) {
        if (color != null) {
            this.writeAttribute(string, "#" + JRXmlWriteHelper.getHexaColor(color));
        }
    }

    public void addAttribute(String string, Color color, Color color2) {
        if (color != null && color.getRGB() != color2.getRGB()) {
            this.addAttribute(string, color);
        }
    }

    public void addAttribute(String string, byte by, Map map) {
        String string2 = (String)map.get(new Byte(by));
        this.writeAttribute(string, string2);
    }

    public void addAttribute(String string, int n, Map map) {
        String string2 = (String)map.get(new Integer(n));
        this.writeAttribute(string, string2);
    }

    public void addAttribute(String string, byte by, Map map, byte by2) {
        if (by != by2) {
            this.addAttribute(string, by, map);
        }
    }

    public void addAttribute(String string, Object object, Map map) {
        if (object != null) {
            String string2 = (String)map.get(object);
            this.writeAttribute(string, string2);
        }
    }

    public void addAttribute(String string, Object object, Map map, Object object2) {
        if (!object.equals(object2)) {
            this.addAttribute(string, object, map);
        }
    }

    protected static String getHexaColor(Color color) {
        String string = Integer.toHexString(color.getRGB() & COLOR_MASK).toUpperCase();
        return ("000000" + string).substring(string.length());
    }

    protected static class StackElement {
        String name;
        List atts;
        boolean hasChildren;

        StackElement(String string) {
            this.name = string;
            this.atts = new ArrayList();
            this.hasChildren = false;
        }

        void addAttribute(String string, String string2) {
            this.atts.add(new Attribute(string, string2));
        }
    }

    protected static class Attribute {
        String name;
        String value;

        Attribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

