/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class IntegerArrayConverter
extends AbstractArrayConverter {
    private static int[] model = new int[0];

    public IntegerArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public IntegerArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                int[] nArray = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    nArray[i] = Integer.parseInt(stringArray[i]);
                }
                return nArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            int[] nArray = new int[list.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Integer.parseInt((String)list.get(i));
            }
            return nArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

