/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.Arrays;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class ClassFilePool {
    public static final int POOL_SIZE = 7;
    ClassFile[] classFiles = new ClassFile[7];

    private ClassFilePool() {
    }

    public static ClassFilePool newInstance() {
        return new ClassFilePool();
    }

    public void release(ClassFile classFile) {
        for (int i = 0; i < 7; ++i) {
            ClassFile classFile2 = this.classFiles[i];
            if (classFile2 != classFile) continue;
            classFile.isShared = false;
            return;
        }
    }

    public ClassFile acquire(SourceTypeBinding sourceTypeBinding) {
        for (int i = 0; i < 7; ++i) {
            ClassFile classFile = this.classFiles[i];
            if (classFile == null) {
                ClassFile classFile2;
                this.classFiles[i] = classFile2 = new ClassFile(sourceTypeBinding);
                classFile2.isShared = true;
                return classFile2;
            }
            if (classFile.isShared) continue;
            classFile.reset(sourceTypeBinding);
            classFile.isShared = true;
            return classFile;
        }
        return new ClassFile(sourceTypeBinding);
    }

    public void reset() {
        Arrays.fill(this.classFiles, null);
    }
}

