/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayAllocationExpression
extends Expression {
    public TypeReference type;
    public Expression[] dimensions;
    public ArrayInitializer initializer;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        for (Expression expression : this.dimensions) {
            if (expression == null) continue;
            flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo);
        }
        if (this.initializer != null) {
            return this.initializer.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.initializer != null) {
            this.initializer.generateCode(blockScope, codeStream, bl);
            return;
        }
        int n2 = 0;
        int n3 = this.dimensions.length;
        for (int i = 0; i < n3; ++i) {
            if (this.dimensions[i] == null) continue;
            this.dimensions[i].generateCode(blockScope, codeStream, true);
            ++n2;
        }
        if (this.resolvedType.dimensions() == 1) {
            codeStream.newArray((ArrayBinding)this.resolvedType);
        } else {
            codeStream.multianewarray(this.resolvedType, n2);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append("new ");
        this.type.print(0, stringBuffer);
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (this.dimensions[i] == null) {
                stringBuffer.append("[]");
                continue;
            }
            stringBuffer.append('[');
            this.dimensions[i].printExpression(0, stringBuffer);
            stringBuffer.append(']');
        }
        if (this.initializer != null) {
            this.initializer.printExpression(0, stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        this.constant = Constant.NotAConstant;
        if (typeBinding == TypeBinding.VOID) {
            blockScope.problemReporter().cannotAllocateVoidArray(this);
            typeBinding = null;
        }
        int n = -1;
        int n2 = this.dimensions.length;
        while (--n2 >= 0) {
            if (this.dimensions[n2] != null) {
                if (n >= 0) continue;
                n = n2;
                continue;
            }
            if (n <= 0) continue;
            blockScope.problemReporter().incorrectLocationForNonEmptyDimension(this, n);
            break;
        }
        if (this.initializer == null) {
            if (n < 0) {
                blockScope.problemReporter().mustDefineDimensionsOrInitializer(this);
            }
            if (typeBinding != null && !typeBinding.isReifiable()) {
                blockScope.problemReporter().illegalGenericArray(typeBinding, this);
            }
        } else if (n >= 0) {
            blockScope.problemReporter().cannotDefineDimensionsAndInitializer(this);
        }
        for (n2 = 0; n2 <= n; ++n2) {
            TypeBinding typeBinding2;
            if (this.dimensions[n2] == null || (typeBinding2 = this.dimensions[n2].resolveTypeExpecting(blockScope, TypeBinding.INT)) == null) continue;
            this.dimensions[n2].computeConversion(blockScope, TypeBinding.INT, typeBinding2);
        }
        if (typeBinding != null) {
            if (this.dimensions.length > 255) {
                blockScope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = blockScope.createArrayType(typeBinding, this.dimensions.length);
            if (this.initializer != null && this.initializer.resolveTypeExpecting(blockScope, this.resolvedType) != null) {
                this.initializer.binding = (ArrayBinding)this.resolvedType;
            }
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.dimensions.length;
            this.type.traverse(aSTVisitor, blockScope);
            for (int i = 0; i < n; ++i) {
                if (this.dimensions[i] == null) continue;
                this.dimensions[i].traverse(aSTVisitor, blockScope);
            }
            if (this.initializer != null) {
                this.initializer.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

