/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayTypeReference
extends SingleTypeReference {
    public int dimensions;
    public int originalSourceEnd;

    public ArrayTypeReference(char[] cArray, int n, long l) {
        super(cArray, l);
        this.originalSourceEnd = this.sourceEnd;
        this.dimensions = n;
    }

    @Override
    public int dimensions() {
        return this.dimensions;
    }

    @Override
    public char[][] getParameterizedTypeName() {
        int n = this.dimensions;
        char[] cArray = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            cArray[n2] = 91;
            cArray[n2 + 1] = 93;
        }
        return new char[][]{CharOperation.concat(this.token, cArray)};
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        TypeBinding typeBinding = scope.getType(this.token);
        return scope.createArrayType(typeBinding, this.dimensions);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        super.printExpression(n, stringBuffer);
        if ((this.bits & 0x4000) != 0) {
            for (int i = 0; i < this.dimensions - 1; ++i) {
                stringBuffer.append("[]");
            }
            stringBuffer.append("...");
        } else {
            for (int i = 0; i < this.dimensions; ++i) {
                stringBuffer.append("[]");
            }
        }
        return stringBuffer;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

