/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ClassLiteralAccess
extends Expression {
    public TypeReference type;
    public TypeBinding targetType;
    FieldBinding syntheticField;

    public ClassLiteralAccess(int n, TypeReference typeReference) {
        this.type = typeReference;
        typeReference.bits |= 0x40000000;
        this.sourceStart = typeReference.sourceStart;
        this.sourceEnd = n;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        SourceTypeBinding sourceTypeBinding = blockScope.outerMostClassScope().enclosingSourceType();
        if (!sourceTypeBinding.isInterface() && !sourceTypeBinding.isBaseType() && blockScope.compilerOptions().sourceLevel < 0x310000L) {
            this.syntheticField = sourceTypeBinding.addSyntheticFieldForClassLiteral(this.targetType, blockScope);
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateClassLiteralAccessForType(this.type.resolvedType, this.syntheticField);
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.type.print(0, stringBuffer).append(".class");
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        ReferenceBinding referenceBinding;
        this.constant = Constant.NotAConstant;
        this.targetType = this.type.resolveType(blockScope, true);
        if (this.targetType == null) {
            return null;
        }
        if (this.targetType.isArrayType() && ((ArrayBinding)this.targetType).leafComponentType == TypeBinding.VOID) {
            blockScope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (this.targetType.isTypeVariable()) {
            blockScope.problemReporter().illegalClassLiteralForTypeVariable((TypeVariableBinding)this.targetType, this);
        }
        if ((referenceBinding = blockScope.getJavaLangClass()).isGenericType()) {
            TypeBinding typeBinding = null;
            if (this.targetType.id == 6) {
                typeBinding = blockScope.environment().getType(JAVA_LANG_VOID);
                if (typeBinding == null) {
                    typeBinding = new ProblemReferenceBinding(JAVA_LANG_VOID, null, 1);
                }
            } else {
                typeBinding = blockScope.boxing(this.targetType);
            }
            this.resolvedType = blockScope.environment().createParameterizedType(referenceBinding, new TypeBinding[]{typeBinding}, null);
        } else {
            this.resolvedType = referenceBinding;
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.type.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

