/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ForeachStatement
extends Statement {
    public LocalDeclaration elementVariable;
    public int elementVariableImplicitWidening = -1;
    public Expression collection;
    public Statement action;
    private int kind;
    private static final int ARRAY = 0;
    private static final int RAW_ITERABLE = 1;
    private static final int GENERIC_ITERABLE = 2;
    private TypeBinding iteratorReceiverType;
    private TypeBinding collectionElementType;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    public BlockScope scope;
    public LocalVariableBinding indexVariable;
    public LocalVariableBinding collectionVariable;
    public LocalVariableBinding maxVariable;
    private static final char[] SecretIndexVariableName = " index".toCharArray();
    private static final char[] SecretCollectionVariableName = " collection".toCharArray();
    private static final char[] SecretMaxVariableName = " max".toCharArray();
    int postCollectionInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForeachStatement(LocalDeclaration localDeclaration, int n) {
        this.elementVariable = localDeclaration;
        this.sourceStart = n;
        this.kind = -1;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        this.collection.checkNPE(blockScope, flowContext, flowInfo);
        flowInfo = this.elementVariable.analyseCode(this.scope, flowContext, flowInfo);
        FlowInfo flowInfo3 = this.collection.analyseCode(this.scope, flowContext, flowInfo.copy());
        flowInfo3.markAsDefinitelyAssigned(this.elementVariable.binding);
        this.postCollectionInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
        LoopingFlowContext loopingFlowContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, this.scope);
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo3.nullInfoLessUnconditionalCopy();
        if (!(this.action == null || this.action.isEmptyBlock() && blockScope.compilerOptions().complianceLevel <= 0x2F0000L)) {
            if (!this.action.complainIfUnreachable(unconditionalFlowInfo, this.scope, false)) {
                unconditionalFlowInfo = this.action.analyseCode(this.scope, loopingFlowContext, unconditionalFlowInfo).unconditionalCopy();
            }
            flowInfo2 = flowInfo.unconditionalCopy().addInitializationsFrom(flowInfo3.initsWhenFalse());
            if ((unconditionalFlowInfo.tagBits & loopingFlowContext.initsOnContinue.tagBits & 1) != 0) {
                this.continueLabel = null;
            } else {
                unconditionalFlowInfo = unconditionalFlowInfo.mergedWith(loopingFlowContext.initsOnContinue);
                loopingFlowContext.complainOnDeferredFinalChecks(this.scope, unconditionalFlowInfo);
                flowInfo2.addPotentialInitializationsFrom(unconditionalFlowInfo);
            }
        } else {
            flowInfo2 = flowInfo3.initsWhenFalse();
        }
        boolean bl = this.action == null || this.action.isEmptyBlock() || (this.action.bits & 1) != 0;
        switch (this.kind) {
            case 0: {
                if (bl && this.elementVariable.binding.resolvedPosition == -1) break;
                this.collectionVariable.useFlag = 1;
                this.indexVariable.useFlag = 1;
                this.maxVariable.useFlag = 1;
                break;
            }
            case 1: 
            case 2: {
                this.indexVariable.useFlag = 1;
            }
        }
        loopingFlowContext.complainOnDeferredNullChecks(blockScope, unconditionalFlowInfo);
        UnconditionalFlowInfo unconditionalFlowInfo2 = FlowInfo.mergedOptimizedBranches((loopingFlowContext.initsOnBreak.tagBits & 1) != 0 ? loopingFlowContext.initsOnBreak : flowInfo.addInitializationsFrom(loopingFlowContext.initsOnBreak), false, flowInfo2, false, true);
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo2);
        return unconditionalFlowInfo2;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        int n;
        Object object;
        boolean bl;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        boolean bl2 = bl = this.action == null || this.action.isEmptyBlock() || (this.action.bits & 1) != 0;
        if (bl && this.elementVariable.binding.resolvedPosition == -1 && this.kind == 0) {
            this.collection.generateCode(this.scope, codeStream, false);
            codeStream.exitUserScope(this.scope);
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        switch (this.kind) {
            case 0: {
                this.collection.generateCode(this.scope, codeStream, true);
                codeStream.store(this.collectionVariable, false);
                codeStream.iconst_0();
                codeStream.store(this.indexVariable, false);
                codeStream.load(this.collectionVariable);
                codeStream.arraylength();
                codeStream.store(this.maxVariable, false);
                break;
            }
            case 1: 
            case 2: {
                this.collection.generateCode(this.scope, codeStream, true);
                object = new MethodBinding(1, "iterator".toCharArray(), this.scope.getJavaUtilIterator(), Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, (ReferenceBinding)this.iteratorReceiverType.erasure());
                if (this.iteratorReceiverType.isInterface()) {
                    codeStream.invokeinterface((MethodBinding)object);
                } else {
                    codeStream.invokevirtual((MethodBinding)object);
                }
                codeStream.store(this.indexVariable, false);
            }
        }
        object = new BranchLabel(codeStream);
        ((BranchLabel)object).tagBits |= 2;
        BranchLabel branchLabel = new BranchLabel(codeStream);
        branchLabel.tagBits |= 2;
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.initialize(codeStream);
            this.continueLabel.tagBits |= 2;
        }
        codeStream.goto_(branchLabel);
        ((BranchLabel)object).place();
        switch (this.kind) {
            case 0: {
                if (this.elementVariable.binding.resolvedPosition == -1) break;
                codeStream.load(this.collectionVariable);
                codeStream.load(this.indexVariable);
                codeStream.arrayAt(this.collectionElementType.id);
                if (this.elementVariableImplicitWidening != -1) {
                    codeStream.generateImplicitConversion(this.elementVariableImplicitWidening);
                }
                codeStream.store(this.elementVariable.binding, false);
                codeStream.addVisibleLocalVariable(this.elementVariable.binding);
                if (this.postCollectionInitStateIndex == -1) break;
                codeStream.addDefinitelyAssignedVariables(blockScope, this.postCollectionInitStateIndex);
                break;
            }
            case 1: 
            case 2: {
                codeStream.load(this.indexVariable);
                codeStream.invokeJavaUtilIteratorNext();
                if (this.elementVariable.binding.type.id != 1) {
                    if (this.elementVariableImplicitWidening != -1) {
                        codeStream.checkcast(this.collectionElementType);
                        codeStream.generateImplicitConversion(this.elementVariableImplicitWidening);
                    } else {
                        codeStream.checkcast(this.elementVariable.binding.type);
                    }
                }
                if (this.elementVariable.binding.resolvedPosition == -1) {
                    codeStream.pop();
                    break;
                }
                codeStream.store(this.elementVariable.binding, false);
                codeStream.addVisibleLocalVariable(this.elementVariable.binding);
                if (this.postCollectionInitStateIndex == -1) break;
                codeStream.addDefinitelyAssignedVariables(blockScope, this.postCollectionInitStateIndex);
            }
        }
        if (!bl) {
            this.action.generateCode(this.scope, codeStream);
        }
        codeStream.removeVariable(this.elementVariable.binding);
        if (this.postCollectionInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.postCollectionInitStateIndex);
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            n = codeStream.position;
            switch (this.kind) {
                case 0: {
                    if (bl && this.elementVariable.binding.resolvedPosition == -1) break;
                    codeStream.iinc(this.indexVariable.resolvedPosition, 1);
                    break;
                }
            }
            codeStream.recordPositionsFrom(n, this.elementVariable.sourceStart);
        }
        branchLabel.place();
        n = codeStream.position;
        switch (this.kind) {
            case 0: {
                codeStream.load(this.indexVariable);
                codeStream.load(this.maxVariable);
                codeStream.if_icmplt((BranchLabel)object);
                break;
            }
            case 1: 
            case 2: {
                codeStream.load(this.indexVariable);
                codeStream.invokeJavaUtilIteratorHasNext();
                codeStream.ifne((BranchLabel)object);
            }
        }
        codeStream.recordPositionsFrom(n, this.elementVariable.sourceStart);
        codeStream.exitUserScope(this.scope);
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        this.breakLabel.place();
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        ForeachStatement.printIndent(n, stringBuffer).append("for (");
        this.elementVariable.printAsExpression(0, stringBuffer);
        stringBuffer.append(" : ");
        this.collection.print(0, stringBuffer).append(") ");
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            stringBuffer.append('\n');
            this.action.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding;
        this.scope = new BlockScope(blockScope);
        this.elementVariable.resolve(this.scope);
        TypeBinding typeBinding2 = this.elementVariable.type.resolvedType;
        TypeBinding typeBinding3 = typeBinding = this.collection == null ? null : this.collection.resolveType(this.scope);
        if (typeBinding2 != null && typeBinding != null) {
            block32: {
                ReferenceBinding referenceBinding;
                if (typeBinding.isArrayType()) {
                    this.kind = 0;
                    this.collection.computeConversion(this.scope, typeBinding, typeBinding);
                    this.collectionElementType = ((ArrayBinding)typeBinding).elementsType();
                    if (!this.collectionElementType.isCompatibleWith(typeBinding2) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, typeBinding2)) {
                        this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, typeBinding2);
                    }
                    int n = this.collectionElementType.id;
                    if (typeBinding2.isBaseType()) {
                        if (!this.collectionElementType.isBaseType()) {
                            n = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                            this.elementVariableImplicitWidening = 1024;
                            if (typeBinding2.isBaseType()) {
                                this.elementVariableImplicitWidening |= (typeBinding2.id << 4) + n;
                                this.scope.problemReporter().autoboxing(this.collection, this.collectionElementType, typeBinding2);
                            }
                        } else {
                            this.elementVariableImplicitWidening = (typeBinding2.id << 4) + n;
                        }
                    } else if (this.collectionElementType.isBaseType()) {
                        int n2 = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                        this.elementVariableImplicitWidening = 0x200 | n << 4 | n;
                        n = n2;
                        this.scope.problemReporter().autoboxing(this.collection, this.collectionElementType, typeBinding2);
                    }
                } else if (typeBinding instanceof ReferenceBinding && (referenceBinding = ((ReferenceBinding)typeBinding).findSuperTypeErasingTo(38, false)) != null) {
                    this.iteratorReceiverType = typeBinding.erasure();
                    if (((ReferenceBinding)this.iteratorReceiverType).findSuperTypeErasingTo(38, false) == null) {
                        this.iteratorReceiverType = referenceBinding;
                        this.collection.computeConversion(this.scope, referenceBinding, typeBinding);
                    } else {
                        this.collection.computeConversion(this.scope, typeBinding, typeBinding);
                    }
                    TypeBinding[] typeBindingArray = null;
                    switch (referenceBinding.kind()) {
                        case 1028: {
                            this.kind = 1;
                            this.collectionElementType = this.scope.getJavaLangObject();
                            if (!this.collectionElementType.isCompatibleWith(typeBinding2) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, typeBinding2)) {
                                this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, typeBinding2);
                            }
                            break block32;
                        }
                        case 2052: {
                            typeBindingArray = referenceBinding.typeVariables();
                            break;
                        }
                        case 260: {
                            typeBindingArray = ((ParameterizedTypeBinding)referenceBinding).arguments;
                            break;
                        }
                        default: {
                            break block32;
                        }
                    }
                    if (typeBindingArray.length == 1) {
                        this.kind = 2;
                        this.collectionElementType = typeBindingArray[0];
                        if (!this.collectionElementType.isCompatibleWith(typeBinding2) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, typeBinding2)) {
                            this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, typeBinding2);
                        }
                        int n = this.collectionElementType.id;
                        if (typeBinding2.isBaseType()) {
                            if (!this.collectionElementType.isBaseType()) {
                                n = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                                this.elementVariableImplicitWidening = 1024;
                                if (typeBinding2.isBaseType()) {
                                    this.elementVariableImplicitWidening |= (typeBinding2.id << 4) + n;
                                }
                            } else {
                                this.elementVariableImplicitWidening = (typeBinding2.id << 4) + n;
                            }
                        } else if (this.collectionElementType.isBaseType()) {
                            int n3 = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                            this.elementVariableImplicitWidening = 0x200 | n << 4 | n;
                            n = n3;
                        }
                    }
                }
            }
            switch (this.kind) {
                case 0: {
                    this.indexVariable = new LocalVariableBinding(SecretIndexVariableName, (TypeBinding)TypeBinding.INT, 0, false);
                    this.scope.addLocalVariable(this.indexVariable);
                    this.indexVariable.setConstant(Constant.NotAConstant);
                    this.maxVariable = new LocalVariableBinding(SecretMaxVariableName, (TypeBinding)TypeBinding.INT, 0, false);
                    this.scope.addLocalVariable(this.maxVariable);
                    this.maxVariable.setConstant(Constant.NotAConstant);
                    this.collectionVariable = new LocalVariableBinding(SecretCollectionVariableName, typeBinding, 0, false);
                    this.scope.addLocalVariable(this.collectionVariable);
                    this.collectionVariable.setConstant(Constant.NotAConstant);
                    break;
                }
                case 1: 
                case 2: {
                    this.indexVariable = new LocalVariableBinding(SecretIndexVariableName, (TypeBinding)this.scope.getJavaUtilIterator(), 0, false);
                    this.scope.addLocalVariable(this.indexVariable);
                    this.indexVariable.setConstant(Constant.NotAConstant);
                    break;
                }
                default: {
                    this.scope.problemReporter().invalidTypeForCollection(this.collection);
                }
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.elementVariable.traverse(aSTVisitor, this.scope);
            this.collection.traverse(aSTVisitor, this.scope);
            if (this.action != null) {
                this.action.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

