/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocFieldReference
extends FieldReference {
    public int tagSourceStart;
    public int tagSourceEnd;
    public int tagValue;
    public MethodBinding methodBinding;
    public boolean superAccess = false;

    public JavadocFieldReference(char[] cArray, long l) {
        super(cArray, l);
        this.bits |= 0x8000;
    }

    protected TypeBinding internalResolveType(Scope scope) {
        Binding binding;
        FieldBinding fieldBinding;
        this.constant = Constant.NotAConstant;
        this.receiverType = this.receiver == null ? scope.enclosingSourceType() : (scope.kind == 3 ? this.receiver.resolveType((ClassScope)scope) : this.receiver.resolveType((BlockScope)scope));
        if (this.receiverType == null) {
            return null;
        }
        Binding binding2 = fieldBinding = this.receiver != null && this.receiver.isThis() ? scope.classScope().getBinding(this.token, this.bits & 7, this, true) : scope.getField(this.receiverType, this.token, this);
        if (!fieldBinding.isValidBinding()) {
            switch (fieldBinding.problemId()) {
                case 5: 
                case 6: 
                case 7: {
                    binding = ((ProblemFieldBinding)fieldBinding).closestMatch;
                    if (binding == null) break;
                    fieldBinding = binding;
                }
            }
        }
        if (!fieldBinding.isValidBinding() || !(fieldBinding instanceof FieldBinding)) {
            if (this.receiverType instanceof ReferenceBinding) {
                binding = (ReferenceBinding)this.receiverType;
                MethodBinding[] methodBindingArray = ((ReferenceBinding)binding).getMethods(this.token);
                if (methodBindingArray == null) {
                    scope.problemReporter().javadocInvalidField(this.sourceStart, this.sourceEnd, fieldBinding, this.receiverType, scope.getDeclarationModifiers());
                } else {
                    switch (methodBindingArray.length) {
                        case 0: {
                            scope.problemReporter().javadocInvalidField(this.sourceStart, this.sourceEnd, fieldBinding, this.receiverType, scope.getDeclarationModifiers());
                            break;
                        }
                        case 1: {
                            this.methodBinding = methodBindingArray[0];
                            break;
                        }
                        default: {
                            this.methodBinding = methodBindingArray[0];
                            scope.problemReporter().javadocAmbiguousMethodReference(this.sourceStart, this.sourceEnd, fieldBinding, scope.getDeclarationModifiers());
                        }
                    }
                }
            }
            return null;
        }
        this.binding = fieldBinding;
        if (this.isFieldUseDeprecated(this.binding, scope, (this.bits & 0x2000) != 0)) {
            scope.problemReporter().javadocDeprecatedField(this.binding, this, scope.getDeclarationModifiers());
        }
        this.resolvedType = this.binding.type;
        return this.resolvedType;
    }

    @Override
    public boolean isSuperAccess() {
        return this.superAccess;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.receiver != null) {
            this.receiver.printExpression(0, stringBuffer);
        }
        stringBuffer.append('#').append(this.token);
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        return this.internalResolveType(blockScope);
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.receiver != null) {
            this.receiver.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

