/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;

public class NormalAnnotation
extends Annotation {
    public MemberValuePair[] memberValuePairs;

    public NormalAnnotation(TypeReference typeReference, int n) {
        this.type = typeReference;
        this.sourceStart = n;
        this.sourceEnd = typeReference.sourceEnd;
    }

    @Override
    public ElementValuePair[] computeElementValuePairs() {
        int n;
        int n2 = n = this.memberValuePairs == null ? 0 : this.memberValuePairs.length;
        if (n == 0) {
            return Binding.NO_ELEMENT_VALUE_PAIRS;
        }
        ElementValuePair[] elementValuePairArray = new ElementValuePair[n];
        for (int i = 0; i < n; ++i) {
            elementValuePairArray[i] = this.memberValuePairs[i].compilerElementPair;
        }
        return elementValuePairArray;
    }

    @Override
    public MemberValuePair[] memberValuePairs() {
        return this.memberValuePairs == null ? NoValuePairs : this.memberValuePairs;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        super.printExpression(n, stringBuffer);
        stringBuffer.append('(');
        if (this.memberValuePairs != null) {
            int n2 = this.memberValuePairs.length;
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                this.memberValuePairs[i].print(n, stringBuffer);
            }
        }
        stringBuffer.append(')');
        return stringBuffer;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.memberValuePairs != null) {
            int n = this.memberValuePairs.length;
            for (int i = 0; i < n; ++i) {
                this.memberValuePairs[i].traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (aSTVisitor.visit(this, compilationUnitScope) && this.memberValuePairs != null) {
            int n = this.memberValuePairs.length;
            for (int i = 0; i < n; ++i) {
                this.memberValuePairs[i].traverse(aSTVisitor, compilationUnitScope);
            }
        }
        aSTVisitor.endVisit(this, compilationUnitScope);
    }
}

