/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedQualifiedTypeReference
extends ArrayQualifiedTypeReference {
    public TypeReference[][] typeArguments;
    private boolean didResolve = false;

    public ParameterizedQualifiedTypeReference(char[][] cArray, TypeReference[][] typeReferenceArray, int n, long[] lArray) {
        super(cArray, n, lArray);
        this.typeArguments = typeReferenceArray;
    }

    @Override
    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        this.checkBounds((ReferenceBinding)this.resolvedType.leafComponentType(), scope, this.typeArguments.length - 1);
    }

    public void checkBounds(ReferenceBinding referenceBinding, Scope scope, int n) {
        if (n > 0 && referenceBinding.enclosingType() != null) {
            this.checkBounds(referenceBinding.enclosingType(), scope, n - 1);
        }
        if (referenceBinding.isParameterizedType()) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding;
            ReferenceBinding referenceBinding2 = parameterizedTypeBinding.type;
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding2.typeVariables();
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null && typeVariableBindingArray != null) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments[n]);
            }
        }
    }

    @Override
    public TypeReference copyDims(int n) {
        return new ParameterizedQualifiedTypeReference(this.tokens, this.typeArguments, n, this.sourcePositions);
    }

    @Override
    public char[][] getParameterizedTypeName() {
        int n;
        Object[] objectArray;
        int n2;
        int n3 = this.tokens.length;
        char[][] cArrayArray = new char[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray = this.typeArguments[n2];
            if (objectArray == null) {
                cArrayArray[n2] = this.tokens[n2];
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(5);
            stringBuffer.append(this.tokens[n2]);
            stringBuffer.append('<');
            int n4 = objectArray.length;
            for (n = 0; n < n4; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(CharOperation.concatWith(objectArray[n].getParameterizedTypeName(), '.'));
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArrayArray[n2] = new char[n];
            stringBuffer.getChars(0, n, cArrayArray[n2], 0);
        }
        n2 = this.dimensions;
        if (n2 > 0) {
            objectArray = new char[n2 * 2];
            for (int i = 0; i < n2; ++i) {
                n = i * 2;
                objectArray[n] = (TypeReference)91;
                objectArray[n + 1] = (TypeReference)93;
            }
            cArrayArray[n3 - 1] = CharOperation.concat(cArrayArray[n3 - 1], (char[])objectArray);
        }
        return cArrayArray;
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, boolean bl) {
        this.constant = Constant.NotAConstant;
        if (this.didResolve) {
            if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
                return null;
            }
            return this.resolvedType;
        }
        this.didResolve = true;
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            this.resolvedType = (ReferenceBinding)binding;
            this.reportInvalidType(scope);
            return null;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        boolean bl2 = scope.kind == 3;
        boolean bl3 = true;
        Object object = null;
        int n = this.tokens.length;
        for (int i = packageBinding == null ? 0 : packageBinding.compoundName.length; i < n; ++i) {
            Object object2;
            TypeReference[] typeReferenceArray;
            this.findNextTypeBinding(i, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                return null;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            if (object == null && (object = referenceBinding.enclosingType()) != null && (((TypeBinding)object).isGenericType() || ((TypeBinding)object).isParameterizedType())) {
                Object object3 = object = referenceBinding.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType((TypeBinding)object) : scope.environment().convertToParameterizedType((ReferenceBinding)object);
            }
            if (bl3 && referenceBinding.isStatic() && object != null && (((TypeBinding)object).isParameterizedType() || ((TypeBinding)object).isGenericType())) {
                scope.problemReporter().staticMemberOfParameterizedType(this, scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)object));
                bl3 = false;
            }
            if ((typeReferenceArray = this.typeArguments[i]) != null) {
                TypeVariableBinding[] typeVariableBindingArray;
                Object object4;
                object2 = null;
                if (bl2) {
                    object2 = ((ClassScope)scope).superTypeReference;
                    ((ClassScope)scope).superTypeReference = null;
                }
                int n2 = typeReferenceArray.length;
                TypeBinding[] typeBindingArray = new TypeBinding[n2];
                boolean bl4 = false;
                for (int j = 0; j < n2; ++j) {
                    TypeBinding typeBinding;
                    object4 = typeReferenceArray[j];
                    TypeBinding typeBinding2 = typeBinding = bl2 ? ((TypeReference)object4).resolveTypeArgument((ClassScope)scope, referenceBinding, j) : ((TypeReference)object4).resolveTypeArgument((BlockScope)scope, referenceBinding, j);
                    if (typeBinding == null) {
                        bl4 = true;
                        continue;
                    }
                    typeBindingArray[j] = typeBinding;
                }
                if (bl4) {
                    return null;
                }
                if (bl2) {
                    ((ClassScope)scope).superTypeReference = object2;
                    if (((ClassScope)scope).detectHierarchyCycle(referenceBinding, this, typeBindingArray)) {
                        return null;
                    }
                }
                if ((typeVariableBindingArray = referenceBinding.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
                    scope.problemReporter().nonGenericTypeCannotBeParameterized(i, this, referenceBinding, typeBindingArray);
                    return null;
                }
                if (n2 != typeVariableBindingArray.length) {
                    scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding, typeBindingArray);
                    return null;
                }
                if (bl3 && !referenceBinding.isStatic() && object != null && ((TypeBinding)object).isRawType()) {
                    scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType((ReferenceBinding)referenceBinding.erasure(), (ReferenceBinding)object), typeBindingArray);
                    bl3 = false;
                }
                object4 = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), typeBindingArray, (ReferenceBinding)object);
                if (bl) {
                    ((ParameterizedTypeBinding)object4).boundCheck(scope, typeReferenceArray);
                }
                object = object4;
                continue;
            }
            if (bl2 && ((ClassScope)scope).detectHierarchyCycle(referenceBinding, this, null)) {
                return null;
            }
            object2 = (ReferenceBinding)referenceBinding.erasure();
            if (((TypeBinding)object2).isGenericType()) {
                if (bl3 && object != null && ((TypeBinding)object).isParameterizedType()) {
                    scope.problemReporter().parameterizedMemberTypeMissingArguments(this, scope.environment().createParameterizedType((ReferenceBinding)object2, null, (ReferenceBinding)object));
                    bl3 = false;
                }
                object = scope.environment().createRawType((ReferenceBinding)object2, (ReferenceBinding)object);
                continue;
            }
            object = object != null && ((TypeBinding)object).isParameterizedType() ? scope.environment().createParameterizedType((ReferenceBinding)object2, null, (ReferenceBinding)object) : referenceBinding;
        }
        this.resolvedType = object;
        if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
            this.reportDeprecatedType(scope);
        }
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
        return this.resolvedType;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        int n3 = this.tokens.length;
        for (int i = 0; i < n3 - 1; ++i) {
            stringBuffer.append(this.tokens[i]);
            TypeReference[] typeReferenceArray = this.typeArguments[i];
            if (typeReferenceArray != null) {
                stringBuffer.append('<');
                n2 = typeReferenceArray.length - 1;
                for (int j = 0; j < n2; ++j) {
                    typeReferenceArray[j].print(0, stringBuffer);
                    stringBuffer.append(", ");
                }
                typeReferenceArray[n2].print(0, stringBuffer);
                stringBuffer.append('>');
            }
            stringBuffer.append('.');
        }
        stringBuffer.append(this.tokens[n3 - 1]);
        TypeReference[] typeReferenceArray = this.typeArguments[n3 - 1];
        if (typeReferenceArray != null) {
            stringBuffer.append('<');
            int n4 = typeReferenceArray.length - 1;
            for (n2 = 0; n2 < n4; ++n2) {
                typeReferenceArray[n2].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            typeReferenceArray[n4].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if ((this.bits & 0x4000) != 0) {
            for (int i = 0; i < this.dimensions - 1; ++i) {
                stringBuffer.append("[]");
            }
            stringBuffer.append("...");
        } else {
            for (int i = 0; i < this.dimensions; ++i) {
                stringBuffer.append("[]");
            }
        }
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        return this.internalResolveType(blockScope, bl);
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope, false);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.typeArguments.length;
            for (int i = 0; i < n; ++i) {
                if (this.typeArguments[i] == null) continue;
                int n2 = this.typeArguments[i].length;
                for (int j = 0; j < n2; ++j) {
                    this.typeArguments[i][j].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n = this.typeArguments.length;
            for (int i = 0; i < n; ++i) {
                if (this.typeArguments[i] == null) continue;
                int n2 = this.typeArguments[i].length;
                for (int j = 0; j < n2; ++j) {
                    this.typeArguments[i][j].traverse(aSTVisitor, classScope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

