/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedSingleTypeReference
extends ArrayTypeReference {
    public TypeReference[] typeArguments;
    private boolean didResolve = false;

    public ParameterizedSingleTypeReference(char[] cArray, TypeReference[] typeReferenceArray, int n, long l) {
        super(cArray, n, l);
        this.originalSourceEnd = this.sourceEnd;
        this.typeArguments = typeReferenceArray;
    }

    @Override
    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        if (this.resolvedType.leafComponentType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.resolvedType.leafComponentType();
            ReferenceBinding referenceBinding = parameterizedTypeBinding.type;
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null && typeVariableBindingArray != null) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            }
        }
    }

    @Override
    public TypeReference copyDims(int n) {
        return new ParameterizedSingleTypeReference(this.token, this.typeArguments, n, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    @Override
    public char[][] getParameterizedTypeName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.token).append('<');
        int n2 = this.typeArguments.length;
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(CharOperation.concatWith(this.typeArguments[n].getParameterizedTypeName(), '.'));
        }
        stringBuffer.append('>');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        int n3 = this.dimensions;
        if (n3 > 0) {
            char[] cArray2 = new char[n3 * 2];
            for (int i = 0; i < n3; ++i) {
                int n4 = i * 2;
                cArray2[n4] = 91;
                cArray2[n4 + 1] = 93;
            }
            cArray = CharOperation.concat(cArray, cArray2);
        }
        return new char[][]{cArray};
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding referenceBinding, boolean bl) {
        TypeVariableBinding[] typeVariableBindingArray;
        Object object;
        this.constant = Constant.NotAConstant;
        if (this.didResolve) {
            if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
                return null;
            }
            return this.resolvedType;
        }
        this.didResolve = true;
        if (referenceBinding == null) {
            this.resolvedType = scope.getType(this.token);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                return null;
            }
            referenceBinding = this.resolvedType.enclosingType();
            if (referenceBinding != null && (referenceBinding.isGenericType() || referenceBinding.isParameterizedType())) {
                ReferenceBinding referenceBinding2 = (ReferenceBinding)this.resolvedType;
                referenceBinding = referenceBinding2.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType(referenceBinding) : scope.environment().convertToParameterizedType(referenceBinding);
            }
        } else {
            this.resolvedType = scope.getMemberType(this.token, (ReferenceBinding)referenceBinding.erasure());
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().invalidEnclosingType(this, this.resolvedType, referenceBinding);
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                scope.problemReporter().deprecatedType(this.resolvedType, this);
            }
        }
        boolean bl2 = scope.kind == 3;
        TypeReference typeReference = null;
        if (bl2) {
            typeReference = ((ClassScope)scope).superTypeReference;
            ((ClassScope)scope).superTypeReference = null;
        }
        ReferenceBinding referenceBinding3 = (ReferenceBinding)this.resolvedType;
        int n = this.typeArguments.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        boolean bl3 = false;
        for (int i = 0; i < n; ++i) {
            TypeBinding typeBinding;
            object = this.typeArguments[i];
            TypeBinding typeBinding2 = typeBinding = bl2 ? ((TypeReference)object).resolveTypeArgument((ClassScope)scope, referenceBinding3, i) : ((TypeReference)object).resolveTypeArgument((BlockScope)scope, referenceBinding3, i);
            if (typeBinding == null) {
                bl3 = true;
                continue;
            }
            typeBindingArray[i] = typeBinding;
        }
        if (bl3) {
            return null;
        }
        if (bl2) {
            ((ClassScope)scope).superTypeReference = typeReference;
            if (((ClassScope)scope).detectHierarchyCycle(referenceBinding3, this, typeBindingArray)) {
                return null;
            }
        }
        if ((typeVariableBindingArray = referenceBinding3.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
            scope.problemReporter().nonGenericTypeCannotBeParameterized(this, referenceBinding3, typeBindingArray);
            return null;
        }
        if (n != typeVariableBindingArray.length) {
            scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding3, typeBindingArray);
            return null;
        }
        if (!referenceBinding3.isStatic() && referenceBinding != null && referenceBinding.isRawType()) {
            scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType((ReferenceBinding)referenceBinding3.erasure(), referenceBinding), typeBindingArray);
            return null;
        }
        object = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding3.erasure(), typeBindingArray, referenceBinding);
        if (bl) {
            ((ParameterizedTypeBinding)object).boundCheck(scope, this.typeArguments);
        }
        this.resolvedType = object;
        if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
            this.reportDeprecatedType(scope);
        }
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
        return this.resolvedType;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        stringBuffer.append(this.token);
        stringBuffer.append("<");
        int n3 = this.typeArguments.length - 1;
        for (n2 = 0; n2 < n3; ++n2) {
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append(", ");
        }
        this.typeArguments[n3].print(0, stringBuffer);
        stringBuffer.append(">");
        if ((this.bits & 0x4000) != 0) {
            for (n2 = 0; n2 < this.dimensions - 1; ++n2) {
                stringBuffer.append("[]");
            }
            stringBuffer.append("...");
        } else {
            for (n2 = 0; n2 < this.dimensions; ++n2) {
                stringBuffer.append("[]");
            }
        }
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        return this.internalResolveType(blockScope, null, bl);
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope, null, false);
    }

    @Override
    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        return this.internalResolveType(blockScope, referenceBinding, true);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.typeArguments.length;
            for (int i = 0; i < n; ++i) {
                this.typeArguments[i].traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n = this.typeArguments.length;
            for (int i = 0; i < n; ++i) {
                this.typeArguments[i].traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

