/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class WhileStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    int preCondInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public WhileStatement(Expression expression, Statement statement, int n, int n2) {
        this.condition = expression;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        Constant constant = this.condition.constant;
        boolean bl = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl2 = constant != Constant.NotAConstant && !constant.booleanValue();
        constant = this.condition.optimizedBooleanConstant();
        boolean bl3 = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl4 = constant != Constant.NotAConstant && !constant.booleanValue();
        this.preCondInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        FlowInfo flowInfo3 = flowInfo.nullInfoLessUnconditionalCopy();
        LoopingFlowContext loopingFlowContext = new LoopingFlowContext(flowContext, flowInfo, this, null, null, blockScope);
        flowInfo3 = this.condition.analyseCode(blockScope, loopingFlowContext, flowInfo3);
        if (this.action == null || this.action.isEmptyBlock() && blockScope.compilerOptions().complianceLevel <= 0x2F0000L) {
            loopingFlowContext.complainOnDeferredFinalChecks(blockScope, flowInfo3);
            loopingFlowContext.complainOnDeferredNullChecks(blockScope, flowInfo3.unconditionalInits());
            if (bl) {
                return FlowInfo.DEAD_END;
            }
            FlowInfo flowInfo4 = flowInfo.copy().addInitializationsFrom(flowInfo3.initsWhenFalse());
            if (bl3) {
                flowInfo4.setReachMode(1);
            }
            this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo4);
            return flowInfo4;
        }
        LoopingFlowContext loopingFlowContext2 = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, blockScope);
        if (bl2) {
            flowInfo2 = FlowInfo.DEAD_END;
        } else {
            flowInfo2 = flowInfo3.initsWhenTrue().copy();
            if (bl4) {
                flowInfo2.setReachMode(1);
            }
        }
        this.condIfTrueInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3.initsWhenTrue());
        if (!this.action.complainIfUnreachable(flowInfo2, blockScope, false)) {
            flowInfo2 = this.action.analyseCode(blockScope, loopingFlowContext2, flowInfo2);
        }
        FlowInfo flowInfo5 = flowInfo.copy();
        if ((flowInfo2.tagBits & loopingFlowContext2.initsOnContinue.tagBits & 1) != 0) {
            this.continueLabel = null;
            flowInfo5.addInitializationsFrom(flowInfo3.initsWhenFalse());
        } else {
            loopingFlowContext.complainOnDeferredFinalChecks(blockScope, flowInfo3);
            flowInfo2 = flowInfo2.mergedWith(loopingFlowContext2.initsOnContinue.unconditionalInits());
            loopingFlowContext.complainOnDeferredNullChecks(blockScope, flowInfo2);
            loopingFlowContext2.complainOnDeferredFinalChecks(blockScope, flowInfo2);
            loopingFlowContext2.complainOnDeferredNullChecks(blockScope, flowInfo2);
            flowInfo5.addPotentialInitializationsFrom(flowInfo2.unconditionalInits()).addInitializationsFrom(flowInfo3.initsWhenFalse());
        }
        UnconditionalFlowInfo unconditionalFlowInfo = FlowInfo.mergedOptimizedBranches((loopingFlowContext2.initsOnBreak.tagBits & 1) != 0 ? loopingFlowContext2.initsOnBreak : flowInfo.addInitializationsFrom(loopingFlowContext2.initsOnBreak), bl3, flowInfo5, bl4, !bl);
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
        return unconditionalFlowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        boolean bl;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        Constant constant = this.condition.optimizedBooleanConstant();
        boolean bl2 = bl = constant != Constant.NotAConstant && !constant.booleanValue();
        if (bl) {
            this.condition.generateCode(blockScope, codeStream, false);
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel == null) {
            if (this.condition.constant == Constant.NotAConstant) {
                this.condition.generateOptimizedBoolean(blockScope, codeStream, null, this.breakLabel, true);
            }
        } else {
            this.continueLabel.initialize(codeStream);
            if (!(this.condition.constant != Constant.NotAConstant && this.condition.constant.booleanValue() || this.action == null || this.action.isEmptyBlock())) {
                int n2 = codeStream.position;
                codeStream.goto_(this.continueLabel);
                codeStream.recordPositionsFrom(n2, this.condition.sourceStart);
            }
        }
        BranchLabel branchLabel = new BranchLabel(codeStream);
        if (this.action != null) {
            branchLabel.tagBits |= 2;
            if (this.condIfTrueInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(blockScope, this.condIfTrueInitStateIndex);
            }
            branchLabel.place();
            this.action.generateCode(blockScope, codeStream);
            if (this.preCondInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preCondInitStateIndex);
            }
        } else {
            branchLabel.place();
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            this.condition.generateOptimizedBoolean(blockScope, codeStream, branchLabel, null, true);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        this.breakLabel.place();
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, TypeBinding.BOOLEAN);
        this.condition.computeConversion(blockScope, typeBinding, typeBinding);
        if (this.action != null) {
            this.action.resolve(blockScope);
        }
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        WhileStatement.printIndent(n, stringBuffer).append("while (");
        this.condition.printExpression(0, stringBuffer).append(')');
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            this.action.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.condition.traverse(aSTVisitor, blockScope);
            if (this.action != null) {
                this.action.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

