/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class ClasspathJar
extends ClasspathLocation {
    protected File file;
    protected ZipFile zipFile;
    protected boolean closeZipFileAtEnd;
    protected Hashtable packageCache;
    protected char[] normalizedPath;

    public ClasspathJar(File file, boolean bl, AccessRuleSet accessRuleSet) {
        super(accessRuleSet);
        this.file = file;
        this.closeZipFileAtEnd = bl;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        if (!this.isPackage(string)) {
            return null;
        }
        try {
            ClassFileReader classFileReader = ClassFileReader.read(this.zipFile, string2);
            if (classFileReader != null) {
                return new NameEnvironmentAnswer(classFileReader, this.fetchAccessRestriction(string2));
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void initialize() throws IOException {
        this.zipFile = new ZipFile(this.file);
    }

    @Override
    public boolean isPackage(String string) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(string);
        }
        this.packageCache = new Hashtable(41);
        this.packageCache.put("", "");
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement().getName();
            int n = string3.lastIndexOf(47);
            while (n > 0 && !this.packageCache.containsKey(string2 = string3.substring(0, n))) {
                this.packageCache.put(string2, string2);
                n = string2.lastIndexOf(47);
            }
        }
        return this.packageCache.containsKey(string);
    }

    @Override
    public void reset() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipFile = null;
        }
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            char[] cArray = this.file.getPath().toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(cArray, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(cArray, 0, CharOperation.lastIndexOf('.', cArray));
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }
}

