/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.GenericXMLWriter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    public static final int DEFAULT_SIZE_CLASSPATH = 4;
    public static final String NONE = "none";
    Compiler batchCompiler;
    public ResourceBundle bundle;
    protected FileSystem.Classpath[] checkedClasspaths;
    public Locale compilerLocale;
    public CompilerOptions compilerOptions;
    public String destinationPath;
    public String[] destinationPaths;
    public boolean generatePackagesStructure;
    private boolean didSpecifySource;
    private boolean didSpecifyTarget;
    public String[] encodings;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public int globalErrorsCount;
    public int globalProblemsCount;
    public int globalTasksCount;
    public int globalWarningsCount;
    private File javaHomeCache;
    private boolean javaHomeChecked = false;
    public long lineCount;
    public String log;
    public Logger logger;
    public int maxProblems;
    public boolean noWarn = false;
    public Map options;
    PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int repetitions;
    public boolean showProgress = false;
    public long startTime;
    public boolean systemExitWhenFinished = true;
    public long[] times;
    public int timesCounter;
    public boolean timing = false;
    public boolean verbose = false;

    public static boolean compile(String string) {
        return Main.compile(string, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public static boolean compile(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        return new Main(printWriter, printWriter2, false).compile(Main.tokenize(string));
    }

    public static File[][] getLibrariesFiles(File[] fileArray) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".jar") || string2.endsWith(".zip");
            }
        };
        int n = fileArray.length;
        File[][] fileArray2 = new File[n][];
        for (int i = 0; i < n; ++i) {
            File file = fileArray[i];
            if (!file.exists() || !file.isDirectory()) continue;
            fileArray2[i] = file.listFiles(filenameFilter);
        }
        return fileArray2;
    }

    public static void main(String[] stringArray) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true).compile(stringArray);
    }

    public static String[] tokenize(String string) {
        int n = 0;
        String[] stringArray = new String[10];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        String string2 = "";
        boolean bl = false;
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                if (bl) {
                    int n2 = n - 1;
                    stringArray[n2] = stringArray[n2] + string2;
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (string2.equals("\"")) {
                if (!bl && bl2) {
                    if (n == stringArray.length) {
                        String[] stringArray2 = stringArray;
                        stringArray = new String[n * 2];
                        System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    }
                    stringArray[n++] = "";
                }
                bl = !bl;
                bl2 = false;
                continue;
            }
            if (bl) {
                int n3 = n - 1;
                stringArray[n3] = stringArray[n3] + string2;
            } else if (string2.length() > 0 && !bl2) {
                int n4 = n - 1;
                stringArray[n4] = stringArray[n4] + string2;
            } else {
                String string3;
                if (n == stringArray.length) {
                    String[] stringArray3 = stringArray;
                    stringArray = new String[n * 2];
                    System.arraycopy(stringArray3, 0, stringArray, 0, n);
                }
                if ((string3 = string2.trim()).length() != 0) {
                    stringArray[n++] = string3;
                }
            }
            bl2 = false;
        }
        String[] stringArray4 = stringArray;
        stringArray = new String[n];
        System.arraycopy(stringArray4, 0, stringArray, 0, n);
        return stringArray;
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this(printWriter, printWriter2, bl, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.initialize(printWriter, printWriter2, bl, map);
        this.relocalize();
    }

    protected void addNewEntry(ArrayList arrayList, String string, ArrayList arrayList2, String string2, boolean bl) throws InvalidInputException {
        AccessRule[] accessRuleArray;
        int n = arrayList2.size();
        AccessRuleSet accessRuleSet = null;
        if (n != 0) {
            String[] stringArray;
            accessRuleArray = new AccessRule[arrayList2.size()];
            boolean bl2 = true;
            Iterator iterator = arrayList2.iterator();
            int n2 = 0;
            block6: while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                char c = stringArray.charAt(0);
                String string3 = stringArray.substring(1);
                if (string3.length() > 0) {
                    switch (c) {
                        case '+': {
                            accessRuleArray[n2++] = new AccessRule(string3.toCharArray(), 0);
                            continue block6;
                        }
                        case '~': {
                            accessRuleArray[n2++] = new AccessRule(string3.toCharArray(), 0x1000118);
                            continue block6;
                        }
                        case '-': {
                            accessRuleArray[n2++] = new AccessRule(string3.toCharArray(), 0x1000133);
                            continue block6;
                        }
                        case '?': {
                            accessRuleArray[n2++] = new AccessRule(string3.toCharArray(), 0x1000133, true);
                            continue block6;
                        }
                    }
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            }
            if (bl2) {
                stringArray = new String[]{this.bind("template.restrictedAccess.type", new String[]{"{0}", string}), this.bind("template.restrictedAccess.constructor", new String[]{"{0}", string}), this.bind("template.restrictedAccess.method", new String[]{"{0}", "{1}", string}), this.bind("template.restrictedAccess.field", new String[]{"{0}", "{1}", string})};
                accessRuleSet = new AccessRuleSet(accessRuleArray, stringArray);
            } else {
                this.logger.logIncorrectClasspath(string);
                return;
            }
        }
        if ((accessRuleArray = FileSystem.getClasspath(string, string2, bl, accessRuleSet)) != null) {
            arrayList.add(accessRuleArray);
        } else {
            this.logger.logIncorrectClasspath(string);
        }
    }

    public String bind(String string) {
        return this.bind(string, (String[])null);
    }

    public String bind(String string, String string2) {
        return this.bind(string, new String[]{string2});
    }

    public String bind(String string, String string2, String string3) {
        return this.bind(string, new String[]{string2, string3});
    }

    public String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + bundleName;
        }
        return MessageFormat.format(string2, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(String[] stringArray) {
        try {
            this.configure(stringArray);
            if (this.proceed) {
                if (this.showProgress) {
                    this.logger.compiling();
                }
                for (int i = 0; i < this.repetitions; ++i) {
                    this.globalProblemsCount = 0;
                    this.globalErrorsCount = 0;
                    this.globalWarningsCount = 0;
                    this.globalTasksCount = 0;
                    this.lineCount = 0L;
                    this.exportedClassFilesCounter = 0;
                    if (this.repetitions > 1) {
                        this.logger.flush();
                        this.logger.logRepetition(i, this.repetitions);
                    }
                    this.performCompilation();
                }
                if (this.times != null) {
                    this.logger.logAverage(this.times, this.lineCount);
                }
                if (this.showProgress) {
                    this.logger.printNewLine();
                }
            }
            if (this.systemExitWhenFinished) {
                this.logger.flush();
                this.logger.close();
                System.exit(this.globalErrorsCount > 0 ? -1 : 0);
            }
        }
        catch (InvalidInputException invalidInputException) {
            this.logger.logException(invalidInputException);
            if (this.systemExitWhenFinished) {
                this.logger.flush();
                this.logger.close();
                System.exit(-1);
            }
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException runtimeException) {
            this.logger.logException(runtimeException);
            if (this.systemExitWhenFinished) {
                this.logger.flush();
                this.logger.close();
                System.exit(-1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.logger.flush();
            this.logger.close();
        }
        return this.globalErrorsCount == 0;
    }

    protected void handleWarningToken(String string, boolean bl, boolean bl2) throws InvalidInputException {
        if (string.equals("constructorName")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", bl ? "warning" : "ignore");
        } else if (string.equals("pkgDefaultMethod") || string.equals("packageDefaultMethod")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", bl ? "warning" : "ignore");
        } else if (string.equals("maskedCatchBlock") || string.equals("maskedCatchBlocks")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", bl ? "warning" : "ignore");
        } else if (string.equals("deprecation")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
        } else if (string.equals("allDeprecation")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", bl ? "enabled" : "disabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", bl ? "enabled" : "disabled");
        } else if (string.equals("unusedLocal") || string.equals("unusedLocals")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", bl ? "warning" : "ignore");
        } else if (string.equals("unusedArgument") || string.equals("unusedArguments")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", bl ? "warning" : "ignore");
        } else if (string.equals("unusedImport") || string.equals("unusedImports")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", bl ? "warning" : "ignore");
        } else if (string.equals("unusedPrivate")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", bl ? "warning" : "ignore");
        } else if (string.equals("unusedLabel")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", bl ? "warning" : "ignore");
        } else if (string.equals("localHiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", bl ? "warning" : "ignore");
        } else if (string.equals("fieldHiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", bl ? "warning" : "ignore");
        } else if (string.equals("specialParamHiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", bl ? "enabled" : "disabled");
        } else if (string.equals("conditionAssign")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", bl ? "warning" : "ignore");
        } else if (string.equals("syntheticAccess") || string.equals("synthetic-access")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", bl ? "warning" : "ignore");
        } else if (string.equals("nls")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", bl ? "warning" : "ignore");
        } else if (string.equals("staticReceiver")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", bl ? "warning" : "ignore");
        } else if (string.equals("indirectStatic")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", bl ? "warning" : "ignore");
        } else if (string.equals("noEffectAssign")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", bl ? "warning" : "ignore");
        } else if (string.equals("intfNonInherited") || string.equals("interfaceNonInherited")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", bl ? "warning" : "ignore");
        } else if (string.equals("charConcat") || string.equals("noImplicitStringConversion")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", bl ? "warning" : "ignore");
        } else if (string.equals("semicolon")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", bl ? "warning" : "ignore");
        } else if (string.equals("serial")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", bl ? "warning" : "ignore");
        } else if (string.equals("emptyBlock")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", bl ? "warning" : "ignore");
        } else if (string.equals("uselessTypeCheck")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", bl ? "warning" : "ignore");
        } else if (string.equals("unchecked") || string.equals("unsafe")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", bl ? "warning" : "ignore");
        } else if (string.equals("raw")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", bl ? "warning" : "ignore");
        } else if (string.equals("finalBound")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.finalParameterBound", bl ? "warning" : "ignore");
        } else if (string.equals("suppress")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
        } else if (string.equals("warningToken")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", bl ? "warning" : "ignore");
        } else if (string.equals("unnecessaryElse")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", bl ? "warning" : "ignore");
        } else if (string.equals("javadoc")) {
            if (!bl2) {
                this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", bl ? "enabled" : "disabled");
            }
            if (bl) {
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "disabled");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
            }
        } else if (string.equals("allJavadoc")) {
            if (!bl2) {
                this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", bl ? "enabled" : "disabled");
            }
            if (bl) {
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "warning");
            }
        } else if (string.startsWith("tasks")) {
            String string2 = "";
            int n = string.indexOf(40);
            int n2 = string.indexOf(41);
            if (n >= 0 && n2 >= 0 && n < n2) {
                string2 = string.substring(n + 1, n2).trim();
                string2 = string2.replace('|', ',');
            }
            if (string2.length() == 0) {
                throw new InvalidInputException(this.bind("configure.invalidTaskTag", string));
            }
            this.options.put("org.eclipse.jdt.core.compiler.taskTags", bl ? string2 : "");
        } else if (string.equals("assertIdentifier")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", bl ? "warning" : "ignore");
        } else if (string.equals("enumIdentifier")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", bl ? "warning" : "ignore");
        } else if (string.equals("finally")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", bl ? "warning" : "ignore");
        } else if (string.equals("unusedThrown")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", bl ? "warning" : "ignore");
        } else if (string.equals("unqualifiedField") || string.equals("unqualified-field-access")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", bl ? "warning" : "ignore");
        } else if (string.equals("typeHiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", bl ? "warning" : "ignore");
        } else if (string.equals("varargsCast")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", bl ? "warning" : "ignore");
        } else if (string.equals("null")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.nullReference", bl ? "warning" : "ignore");
        } else if (string.equals("boxing")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.autoboxing", bl ? "warning" : "ignore");
        } else if (string.equals("over-ann")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", bl ? "warning" : "ignore");
        } else if (string.equals("dep-ann")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", bl ? "warning" : "ignore");
        } else if (string.equals("intfAnnotation")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", bl ? "warning" : "ignore");
        } else if (string.equals("enumSwitch") || string.equals("incomplete-switch")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", bl ? "warning" : "ignore");
        } else if (string.equals("hiding")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", bl ? "warning" : "ignore");
        } else if (string.equals("static-access")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", bl ? "warning" : "ignore");
        } else if (string.equals("unused")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", bl ? "warning" : "ignore");
        } else if (string.equals("paramAssign")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", bl ? "warning" : "ignore");
        } else if (string.equals("discouraged")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.discouragedReference", bl ? "warning" : "ignore");
        } else if (string.equals("forbidden")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", bl ? "warning" : "ignore");
        } else if (string.equals("fallthrough")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", bl ? "warning" : "ignore");
        } else {
            throw new InvalidInputException(this.bind("configure.invalidWarning", string));
        }
    }

    protected ArrayList handleExtdirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.ext.dirs");
            if (object == null) {
                arrayList.add(file.getAbsolutePath() + "/lib/ext");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            for (int i = 0; i < ((File[])object).length; ++i) {
                object[i] = new File((String)arrayList.get(i));
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File[] fileArray2 = fileArray[i];
                    if (fileArray2 != null) {
                        int n2 = fileArray2.length;
                        for (int j = 0; j < n2; ++j) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[j].getAbsolutePath(), null, null);
                            if (classpath == null) continue;
                            arrayList.add(classpath);
                        }
                        continue;
                    }
                    if (!object[i].isFile()) continue;
                    this.logger.logIncorrectExtDirsEntry(object[i].getAbsolutePath());
                }
            }
        }
        return arrayList;
    }

    protected ArrayList handleEndorseddirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.endorsed.dirs");
            if (object == null) {
                if (file != null) {
                    arrayList.add(file.getAbsolutePath() + "/lib/endorsed");
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            for (int i = 0; i < ((File[])object).length; ++i) {
                object[i] = new File((String)arrayList.get(i));
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File[] fileArray2 = fileArray[i];
                    if (fileArray2 != null) {
                        int n2 = fileArray2.length;
                        for (int j = 0; j < n2; ++j) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[j].getAbsolutePath(), null, null);
                            if (classpath == null) continue;
                            arrayList.add(classpath);
                        }
                        continue;
                    }
                    if (!object[i].isFile()) continue;
                    this.logger.logIncorrectEndorsedDirsEntry(object[i].getAbsolutePath());
                }
            }
        }
        return arrayList;
    }

    public void configure(String[] stringArray) throws InvalidInputException {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            this.printUsage();
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(4);
        String string = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(4);
        ArrayList<String> arrayList3 = new ArrayList<String>(4);
        ArrayList<String> arrayList4 = null;
        ArrayList<String> arrayList5 = null;
        int n2 = -1;
        int n3 = 0;
        int n4 = stringArray.length;
        int n5 = 0;
        this.repetitions = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        boolean bl8 = false;
        for (int i = 0; i < n4; ++i) {
            if (!stringArray[i].startsWith("@")) continue;
            bl8 = true;
            break;
        }
        String[] stringArray2 = null;
        if (bl8) {
            stringArray2 = new String[n4];
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                String[] stringArray3 = null;
                String string5 = stringArray[n].trim();
                if (string5.startsWith("@")) {
                    try {
                        String string6;
                        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(string5.substring(1)), null))));
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((string6 = lineNumberReader.readLine()) != null) {
                            if ((string6 = string6.trim()).startsWith("#")) continue;
                            stringBuffer.append(string6).append(" ");
                        }
                        stringArray3 = Main.tokenize(stringBuffer.toString());
                    }
                    catch (IOException iOException) {
                        throw new InvalidInputException(this.bind("configure.invalidexpansionargumentname", string5));
                    }
                }
                if (stringArray3 != null) {
                    int n6 = stringArray2.length;
                    int n7 = stringArray3.length;
                    String[] stringArray4 = stringArray2;
                    stringArray2 = new String[n6 + n7 - 1];
                    System.arraycopy(stringArray4, 0, stringArray2, 0, n2);
                    System.arraycopy(stringArray3, 0, stringArray2, n2, n7);
                    n2 += n7;
                    continue;
                }
                stringArray2[n2++] = string5;
            }
            n2 = -1;
        } else {
            stringArray2 = stringArray;
            for (n = 0; n < n4; ++n) {
                stringArray2[n] = stringArray2[n].trim();
            }
        }
        n4 = stringArray2.length;
        block33: while (++n2 < n4) {
            int n8;
            int n9;
            if (string2 != null) {
                throw new InvalidInputException(this.bind("configure.unexpectedCustomEncoding", string4, string2));
            }
            string4 = stringArray2[n2];
            switch (n5) {
                case 0: {
                    string2 = null;
                    if (string4.endsWith("]")) {
                        n = string4.indexOf(91) + 1;
                        int n10 = string4.length() - 1;
                        if (n >= 1) {
                            if (n < n10) {
                                string2 = string4.substring(n, n10);
                                try {
                                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string2);
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    throw new InvalidInputException(this.bind("configure.unsupportedEncoding", string2));
                                }
                            }
                            string4 = string4.substring(0, n - 1);
                        }
                    }
                    if (string4.endsWith(".java")) {
                        if (this.filenames == null) {
                            this.filenames = new String[n4 - n2];
                            this.encodings = new String[n4 - n2];
                        } else if (n3 == this.filenames.length) {
                            n = this.filenames.length;
                            this.filenames = new String[n + n4 - n2];
                            System.arraycopy(this.filenames, 0, this.filenames, 0, n);
                            this.encodings = new String[n + n4 - n2];
                            System.arraycopy(this.encodings, 0, this.encodings, 0, n);
                        }
                        this.filenames[n3] = string4;
                        this.encodings[n3++] = string2;
                        string2 = null;
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-log")) {
                        if (this.log != null) {
                            throw new InvalidInputException(this.bind("configure.duplicateLog", string4));
                        }
                        n5 = 5;
                        continue block33;
                    }
                    if (string4.equals("-repeat")) {
                        if (this.repetitions > 0) {
                            throw new InvalidInputException(this.bind("configure.duplicateRepeat", string4));
                        }
                        n5 = 6;
                        continue block33;
                    }
                    if (string4.equals("-maxProblems")) {
                        if (this.maxProblems > 0) {
                            throw new InvalidInputException(this.bind("configure.duplicateMaxProblems", string4));
                        }
                        n5 = 11;
                        continue block33;
                    }
                    if (string4.equals("-source")) {
                        n5 = 7;
                        continue block33;
                    }
                    if (string4.equals("-encoding")) {
                        n5 = 8;
                        continue block33;
                    }
                    if (string4.equals("-1.3")) {
                        if (bl7) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", string4));
                        }
                        bl7 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-1.4")) {
                        if (bl7) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", string4));
                        }
                        bl7 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-1.5") || string4.equals("-5") || string4.equals("-5.0")) {
                        if (bl7) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", string4));
                        }
                        bl7 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-1.6") || string4.equals("-6") || string4.equals("-6.0")) {
                        if (bl7) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", string4));
                        }
                        bl7 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-d")) {
                        if (this.destinationPath != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string4);
                            if (n2 + 1 < n4) {
                                stringBuffer.append(' ');
                                stringBuffer.append(stringArray2[n2 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateOutputPath", stringBuffer.toString()));
                        }
                        n5 = 3;
                        continue block33;
                    }
                    if (string4.equals("-classpath") || string4.equals("-cp")) {
                        n5 = 1;
                        continue block33;
                    }
                    if (string4.equals("-bootclasspath")) {
                        if (arrayList.size() > 0) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string4);
                            if (n2 + 1 < n4) {
                                stringBuffer.append(' ');
                                stringBuffer.append(stringArray2[n2 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateBootClasspath", stringBuffer.toString()));
                        }
                        n5 = 9;
                        continue block33;
                    }
                    if (string4.equals("-sourcepath")) {
                        if (arrayList2.size() > 0) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string4);
                            if (n2 + 1 < n4) {
                                stringBuffer.append(' ');
                                stringBuffer.append(stringArray2[n2 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateSourcepath", stringBuffer.toString()));
                        }
                        n5 = 13;
                        continue block33;
                    }
                    if (string4.equals("-extdirs")) {
                        if (arrayList4 != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string4);
                            if (n2 + 1 < n4) {
                                stringBuffer.append(' ');
                                stringBuffer.append(stringArray2[n2 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateExtDirs", stringBuffer.toString()));
                        }
                        n5 = 12;
                        continue block33;
                    }
                    if (string4.equals("-endorseddirs")) {
                        if (arrayList5 != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string4);
                            if (n2 + 1 < n4) {
                                stringBuffer.append(' ');
                                stringBuffer.append(stringArray2[n2 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateEndorsedDirs", stringBuffer.toString()));
                        }
                        n5 = 15;
                        continue block33;
                    }
                    if (string4.equals("-progress")) {
                        n5 = 0;
                        this.showProgress = true;
                        continue block33;
                    }
                    if (string4.equals("-proceedOnError")) {
                        n5 = 0;
                        this.proceedOnError = true;
                        continue block33;
                    }
                    if (string4.equals("-time")) {
                        n5 = 0;
                        this.timing = true;
                        continue block33;
                    }
                    if (string4.equals("-version") || string4.equals("-v")) {
                        this.logger.logVersion(true);
                        this.proceed = false;
                        return;
                    }
                    if (string4.equals("-showversion")) {
                        bl2 = true;
                        n5 = 0;
                        continue block33;
                    }
                    if ("-deprecation".equals(string4)) {
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-help") || string4.equals("-?")) {
                        bl = true;
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-noExit")) {
                        this.systemExitWhenFinished = false;
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-verbose")) {
                        this.verbose = true;
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-referenceInfo")) {
                        this.produceRefInfo = true;
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-inlineJSR")) {
                        n5 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                        continue block33;
                    }
                    if (string4.startsWith("-g")) {
                        n5 = 0;
                        String string7 = string4;
                        int n11 = string4.length();
                        if (n11 == 2) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            continue block33;
                        }
                        if (n11 > 3) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                            if (n11 == 7 && string7.equals("-g:none")) continue block33;
                            StringTokenizer stringTokenizer = new StringTokenizer(string7.substring(3, string7.length()), ",");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string8 = stringTokenizer.nextToken();
                                if (string8.equals("vars")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                                    continue;
                                }
                                if (string8.equals("lines")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                                    continue;
                                }
                                if (string8.equals("source")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                                    continue;
                                }
                                throw new InvalidInputException(this.bind("configure.invalidDebugOption", string7));
                            }
                            continue block33;
                        }
                        throw new InvalidInputException(this.bind("configure.invalidDebugOption", string7));
                    }
                    if (string4.startsWith("-nowarn")) {
                        this.disableWarnings();
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.startsWith("-warn")) {
                        int n12;
                        n5 = 0;
                        String string9 = string4;
                        int n13 = string4.length();
                        if (n13 == 10 && string9.equals("-warn:none")) {
                            this.disableWarnings();
                            continue block33;
                        }
                        if (n13 <= 6) {
                            throw new InvalidInputException(this.bind("configure.invalidWarningConfiguration", string9));
                        }
                        switch (string9.charAt(6)) {
                            case '+': {
                                n12 = 7;
                                n9 = 1;
                                break;
                            }
                            case '-': {
                                n12 = 7;
                                n9 = 0;
                                break;
                            }
                            default: {
                                n12 = 6;
                                if (!bl5) {
                                    this.disableWarnings();
                                }
                                n9 = 1;
                            }
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string9.substring(n12, string9.length()), ",");
                        int n14 = 0;
                        if (bl4) {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        }
                        while (stringTokenizer.hasMoreTokens()) {
                            String string10 = stringTokenizer.nextToken();
                            ++n14;
                            this.handleWarningToken(string10, n9 != 0, bl6);
                        }
                        if (n14 == 0) {
                            throw new InvalidInputException(this.bind("configure.invalidWarningOption", string4));
                        }
                        bl5 = true;
                        continue block33;
                    }
                    if (string4.equals("-target")) {
                        n5 = 4;
                        continue block33;
                    }
                    if (string4.equals("-preserveAllLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.equals("-enableJavadoc")) {
                        n5 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                        bl6 = true;
                        continue block33;
                    }
                    if (string4.equals("-Xemacs")) {
                        n5 = 0;
                        this.logger.setEmacs();
                        continue block33;
                    }
                    if (string4.startsWith("-X")) {
                        n5 = 0;
                        continue block33;
                    }
                    if (string4.startsWith("-J")) {
                        n5 = 0;
                        continue block33;
                    }
                    if (!string4.equals("-O")) break;
                    n5 = 0;
                    continue block33;
                }
                case 4: {
                    if (this.didSpecifyTarget) {
                        throw new InvalidInputException(this.bind("configure.duplicateTarget", string4));
                    }
                    this.didSpecifyTarget = true;
                    if (string4.equals("1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (string4.equals("1.2")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (string4.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (string4.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (string4.equals("1.5") || string4.equals("5") || string4.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (string4.equals("1.6") || string4.equals("6") || string4.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else if (string4.equals("jsr14")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "jsr14");
                    } else {
                        throw new InvalidInputException(this.bind("configure.targetJDK", string4));
                    }
                    n5 = 0;
                    continue block33;
                }
                case 5: {
                    this.log = string4;
                    n5 = 0;
                    continue block33;
                }
                case 6: {
                    try {
                        this.repetitions = Integer.parseInt(string4);
                        if (this.repetitions <= 0) {
                            throw new InvalidInputException(this.bind("configure.repetition", string4));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidInputException(this.bind("configure.repetition", string4));
                    }
                    n5 = 0;
                    continue block33;
                }
                case 11: {
                    try {
                        this.maxProblems = Integer.parseInt(string4);
                        if (this.maxProblems <= 0) {
                            throw new InvalidInputException(this.bind("configure.maxProblems", string4));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidInputException(this.bind("configure.maxProblems", string4));
                    }
                    n5 = 0;
                    continue block33;
                }
                case 7: {
                    if (this.didSpecifySource) {
                        throw new InvalidInputException(this.bind("configure.duplicateSource", string4));
                    }
                    this.didSpecifySource = true;
                    if (string4.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    } else if (string4.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                    } else if (string4.equals("1.5") || string4.equals("5") || string4.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    } else if (string4.equals("1.6") || string4.equals("6") || string4.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    } else {
                        throw new InvalidInputException(this.bind("configure.source", string4));
                    }
                    n5 = 0;
                    continue block33;
                }
                case 8: {
                    if (bl3) {
                        throw new InvalidInputException(this.bind("configure.duplicateDefaultEncoding", string4));
                    }
                    try {
                        new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string4);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new InvalidInputException(this.bind("configure.unsupportedEncoding", string4));
                    }
                    this.options.put("org.eclipse.jdt.core.encoding", string4);
                    bl3 = true;
                    n5 = 0;
                    continue block33;
                }
                case 3: {
                    if (!string4.equals(NONE)) {
                        this.setDestinationPath(string4);
                    }
                    n5 = 0;
                    continue block33;
                }
                case 1: {
                    arrayList3.add(string4);
                    n5 = 0;
                    continue block33;
                }
                case 9: {
                    arrayList.add(string4);
                    n5 = 0;
                    continue block33;
                }
                case 13: {
                    arrayList2.add(string4);
                    n5 = 0;
                    continue block33;
                }
                case 12: {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator, false);
                    arrayList4 = new ArrayList<String>(4);
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList4.add(stringTokenizer.nextToken());
                    }
                    n5 = 0;
                    continue block33;
                }
                case 15: {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator, false);
                    arrayList5 = new ArrayList<String>(4);
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList5.add(stringTokenizer.nextToken());
                    }
                    n5 = 0;
                    continue block33;
                }
            }
            string3 = File.separatorChar == '/' ? string4 : string4.replace('/', File.separatorChar);
            File file = new File(string3);
            if (!file.isDirectory()) {
                throw new InvalidInputException(this.bind("configure.directoryNotExist", string3));
            }
            String[] stringArray5 = FileFinder.find(file, ".JAVA");
            if (this.filenames != null) {
                n8 = stringArray5.length;
                this.filenames = new String[n8 + n3];
                System.arraycopy(this.filenames, 0, this.filenames, 0, n3);
                this.encodings = new String[n8 + n3];
                System.arraycopy(this.encodings, 0, this.encodings, 0, n3);
                System.arraycopy(stringArray5, 0, this.filenames, n3, n8);
                for (n9 = 0; n9 < n8; ++n9) {
                    this.encodings[n3 + n9] = string2;
                }
                n3 += n8;
                string2 = null;
                string3 = null;
            } else {
                this.filenames = stringArray5;
                n3 = this.filenames.length;
                this.encodings = new String[n3];
                for (n8 = 0; n8 < n3; ++n8) {
                    this.encodings[n8] = string2;
                }
                string2 = null;
                string3 = null;
            }
            n5 = 0;
        }
        if (bl || n3 == 0) {
            this.printUsage();
            this.proceed = false;
            return;
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        this.logger.logVersion(bl2);
        this.validateOptions(bl7);
        this.logger.logCommandLineArguments(stringArray2);
        this.logger.logOptions(this.options);
        if (this.repetitions == 0) {
            this.repetitions = 1;
        }
        if (this.repetitions >= 3 && this.timing) {
            this.times = new long[this.repetitions];
            this.timesCounter = 0;
        }
        if (n3 != 0) {
            this.filenames = new String[n3];
            System.arraycopy(this.filenames, 0, this.filenames, 0, n3);
        }
        this.setPaths(arrayList, string, arrayList2, arrayList3, arrayList4, arrayList5, string2);
    }

    protected void disableWarnings() {
        Object[] objectArray = this.options.entrySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)objectArray[i];
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !((String)entry.getValue()).equals("warning")) continue;
            this.options.put(entry.getKey(), "ignore");
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", "");
    }

    public String extractDestinationPathFromSourceFile(CompilationResult compilationResult) {
        String string;
        File file;
        char[] cArray;
        int n;
        ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
        if (iCompilationUnit != null && (n = CharOperation.lastIndexOf(File.separatorChar, cArray = iCompilationUnit.getFileName())) != -1 && (file = new File(string = new String(cArray, 0, n))).exists() && file.isDirectory()) {
            return string;
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            @Override
            public void acceptResult(CompilationResult compilationResult) {
                int n;
                if (compilationResult.lineSeparatorPositions != null) {
                    n = compilationResult.lineSeparatorPositions.length;
                    Main.this.lineCount += (long)n;
                    this.lineDelta += n;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.logger.logProgress();
                        this.lineDelta = 0;
                    }
                }
                Main.this.logger.startLoggingSource(compilationResult);
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    n = Main.this.logger.logProblems(compilationResult.getAllProblems(), compilationResult.compilationUnit.getContents(), Main.this);
                    if (Main.this.systemExitWhenFinished && !Main.this.proceedOnError && n > 0) {
                        CompilationUnitDeclaration[] compilationUnitDeclarationArray = Main.this.batchCompiler.unitsToProcess;
                        int n2 = Main.this.batchCompiler.totalUnits;
                        for (int i = 0; i < n2; ++i) {
                            CompilationResult compilationResult2;
                            CompilationUnitDeclaration compilationUnitDeclaration = compilationUnitDeclarationArray[i];
                            if (compilationUnitDeclaration == null || !(compilationResult2 = compilationUnitDeclaration.compilationResult).hasProblems() || compilationResult2.hasBeenAccepted) continue;
                            Main.this.logger.logProblems(compilationResult2.getAllProblems(), compilationResult2.compilationUnit.getContents(), Main.this);
                        }
                        Main.this.logger.endLoggingSource();
                        Main.this.logger.endLoggingSources();
                        Main.this.logger.printStats();
                        Main.this.logger.flush();
                        Main.this.logger.close();
                        System.exit(-1);
                    }
                }
                Main.this.outputClassFiles(compilationResult);
                Main.this.logger.endLoggingSource();
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() throws InvalidInputException {
        int n = this.filenames.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n);
        String string = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(string)) {
            string = null;
        }
        for (int i = 0; i < n; ++i) {
            char[] cArray = this.filenames[i].toCharArray();
            if (hashtableOfObject.get(cArray) != null) {
                throw new InvalidInputException(this.bind("unit.more", this.filenames[i]));
            }
            hashtableOfObject.put(cArray, cArray);
            File file = new File(this.filenames[i]);
            if (!file.exists()) {
                throw new InvalidInputException(this.bind("unit.missing", this.filenames[i]));
            }
            String string2 = this.encodings[i];
            if (string2 == null) {
                string2 = string;
            }
            compilationUnitArray[i] = new CompilationUnit(null, this.filenames[i], string2);
        }
        return compilationUnitArray;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            @Override
            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            @Override
            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    public File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            String string = System.getProperty("java.home");
            if (string != null) {
                this.javaHomeCache = new File(string);
                if (!this.javaHomeCache.exists()) {
                    this.javaHomeCache = null;
                }
            }
        }
        return this.javaHomeCache;
    }

    public FileSystem getLibraryAccess() {
        return new FileSystem(this.checkedClasspaths, this.filenames);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(this.compilerLocale);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this.initialize(printWriter, printWriter2, bl, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.logger = new Logger(this, printWriter, printWriter2);
        this.out = printWriter;
        this.systemExitWhenFinished = bl;
        this.options = new CompilerOptions().getMap();
        if (map != null) {
            this.didSpecifySource = map.get("org.eclipse.jdt.core.compiler.source") != null;
            this.didSpecifyTarget = map.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform") != null;
            for (Object k : map.keySet()) {
                this.options.put(k, map.get(k));
            }
        } else {
            this.didSpecifySource = false;
            this.didSpecifyTarget = false;
        }
    }

    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            if (!this.generatePackagesStructure) {
                this.destinationPath = this.extractDestinationPathFromSourceFile(compilationResult);
            }
            if (this.destinationPath != null) {
                for (ClassFile classFile : classFileArray) {
                    char[] cArray = classFile.fileName();
                    int n = cArray.length;
                    char[] cArray2 = new char[n + 6];
                    System.arraycopy(cArray, 0, cArray2, 0, n);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n, 6);
                    CharOperation.replace(cArray2, '/', File.separatorChar);
                    String string = new String(cArray2);
                    try {
                        if (this.compilerOptions.verbose) {
                            this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string}));
                        }
                        ClassFile.writeToDisk(this.generatePackagesStructure, this.destinationPath, string, classFile);
                        LookupEnvironment lookupEnvironment = this.batchCompiler.lookupEnvironment;
                        if (classFile.isShared) {
                            lookupEnvironment.classFilePool.release(classFile);
                        }
                        this.logger.logClassFile(this.generatePackagesStructure, this.destinationPath, string);
                        ++this.exportedClassFilesCounter;
                    }
                    catch (IOException iOException) {
                        this.logger.logNoClassFileCreated(this.destinationPath, string, iOException);
                    }
                }
            }
        }
    }

    public void performCompilation() throws InvalidInputException {
        this.startTime = System.currentTimeMillis();
        FileSystem fileSystem = this.getLibraryAccess();
        this.compilerOptions = new CompilerOptions(this.options);
        this.compilerOptions.performStatementsRecovery = false;
        this.batchCompiler = new Compiler((INameEnvironment)fileSystem, this.getHandlingPolicy(), this.compilerOptions, this.getBatchRequestor(), this.getProblemFactory(), this.out);
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            this.batchCompiler.compile(this.getCompilationUnits());
        }
        finally {
            this.logger.endLoggingSources();
        }
        this.logger.printStats();
        fileSystem.cleanup();
    }

    public void printUsage() {
        this.logger.logUsage(this.bind("misc.usage", new String[]{System.getProperty("path.separator"), this.bind("compiler.name"), this.bind("compiler.version"), this.bind("compiler.copyright")}));
    }

    public void processPathEntries(int n, ArrayList arrayList, String string, String string2, boolean bl, boolean bl2) throws InvalidInputException {
        String string3 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator + "[]", true);
        int n2 = 0;
        String string4 = null;
        block18: while (stringTokenizer.hasMoreTokens() && n2 != 99) {
            string4 = stringTokenizer.nextToken();
            if (string4.equals(File.pathSeparator)) {
                switch (n2) {
                    case 0: {
                        continue block18;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 3;
                        this.addNewEntry(arrayList, string3, arrayList2, string2, bl);
                        arrayList2.clear();
                        continue block18;
                    }
                    case 6: {
                        n2 = 4;
                        continue block18;
                    }
                }
                n2 = 99;
                continue;
            }
            if (string4.equals("[")) {
                switch (n2) {
                    case 1: {
                        n2 = 5;
                        continue block18;
                    }
                }
                n2 = 99;
                continue;
            }
            if (string4.equals("]")) {
                switch (n2) {
                    case 6: {
                        n2 = 2;
                        continue block18;
                    }
                }
                n2 = 99;
                continue;
            }
            switch (n2) {
                case 0: 
                case 3: {
                    n2 = 1;
                    string3 = string4;
                    continue block18;
                }
                case 4: 
                case 5: {
                    n2 = 6;
                    arrayList2.add(string4);
                    continue block18;
                }
            }
            n2 = 99;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                this.addNewEntry(arrayList, string3, arrayList2, string2, bl);
                break;
            }
            default: {
                this.logger.logIncorrectClasspath(string);
            }
        }
    }

    public void relocalize() {
        this.relocalize(Locale.getDefault());
    }

    public void relocalize(Locale locale) {
        this.compilerLocale = locale;
        try {
            this.bundle = ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw missingResourceException;
        }
    }

    public void setLocale(Locale locale) {
        this.relocalize(locale);
    }

    protected void setDestinationPath(String string) {
        this.destinationPath = string;
        this.generatePackagesStructure = true;
    }

    protected void setPaths(ArrayList arrayList, String string, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, String string2) throws InvalidInputException {
        Object object;
        int n;
        File[][] fileArray;
        Object object2;
        File file = this.getJavaHome();
        int n2 = arrayList.size();
        if (n2 != 0) {
            object2 = new String[n2];
            arrayList.toArray((T[])object2);
            arrayList.clear();
            for (int i = 0; i < n2; ++i) {
                this.processPathEntries(4, arrayList, (String)object2[i], string2, false, false);
            }
        } else {
            object2 = System.getProperty("java.version");
            if (object2 != null && ((String)object2).equalsIgnoreCase("1.1.8")) {
                this.logger.logWrongJDK();
                this.proceed = false;
                return;
            }
            if (file != null) {
                File[] fileArray2 = null;
                fileArray2 = System.getProperty("os.name").startsWith("Mac") ? new File[]{new File(file, "../Classes")} : new File[]{new File(file, "lib")};
                fileArray = Main.getLibrariesFiles(fileArray2);
                if (fileArray != null) {
                    int n3 = fileArray.length;
                    for (n = 0; n < n3; ++n) {
                        File[] fileArray3 = fileArray[n];
                        if (fileArray3 == null) continue;
                        int n4 = fileArray3.length;
                        for (int i = 0; i < n4; ++i) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray3[i].getAbsolutePath(), null, false, null);
                            if (classpath == null) continue;
                            arrayList.add(classpath);
                        }
                    }
                }
            }
        }
        int n5 = arrayList3.size();
        if (arrayList3.size() != 0) {
            object = new String[n5];
            arrayList3.toArray((T[])object);
            arrayList3.clear();
            for (int i = 0; i < n5; ++i) {
                this.processPathEntries(4, arrayList3, (String)object[i], string2, false, false);
            }
        } else {
            object = System.getProperty("java.class.path");
            if (object == null || ((String)object).length() == 0) {
                this.logger.logNoClasspath();
                arrayList3.add(FileSystem.getClasspath(System.getProperty("user.dir"), string2, null));
            } else {
                fileArray = new StringTokenizer((String)object, File.pathSeparator);
                while (fileArray.hasMoreTokens()) {
                    String string3 = fileArray.nextToken();
                    FileSystem.Classpath classpath = FileSystem.getClasspath(string3, string2, null);
                    if (classpath != null) {
                        arrayList3.add(classpath);
                        continue;
                    }
                    this.logger.logIncorrectClasspath(string3);
                }
            }
        }
        int n6 = arrayList2.size();
        if (n6 != 0) {
            String[] stringArray = new String[n6];
            arrayList2.toArray(stringArray);
            arrayList2.clear();
            for (n = 0; n < n6; ++n) {
                this.processPathEntries(4, arrayList2, stringArray[n], string2, true, false);
            }
        }
        arrayList4 = this.handleExtdirs(arrayList4);
        arrayList5 = this.handleEndorseddirs(arrayList5);
        arrayList.addAll(arrayList5);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList3 = arrayList;
        this.checkedClasspaths = new FileSystem.Classpath[arrayList3.size()];
        arrayList3.toArray(this.checkedClasspaths);
        this.logger.logClasspath(this.checkedClasspaths);
    }

    protected void validateOptions(boolean bl) throws InvalidInputException {
        Object v;
        if (bl) {
            v = this.options.get("org.eclipse.jdt.core.compiler.compliance");
            if ("1.3".equals(v)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(v)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                }
            } else if ("1.5".equals(v)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(v)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            }
        }
        if (this.didSpecifySource) {
            v = this.options.get("org.eclipse.jdt.core.compiler.source");
            if ("1.4".equals(v)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(v)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(v)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            }
        }
        v = this.options.get("org.eclipse.jdt.core.compiler.source");
        Object v2 = this.options.get("org.eclipse.jdt.core.compiler.compliance");
        if (v.equals("1.6") && CompilerOptions.versionToJdkLevel(v2) < 0x320000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.6"));
        }
        if (v.equals("1.5") && CompilerOptions.versionToJdkLevel(v2) < 0x310000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
        }
        if (v.equals("1.4") && CompilerOptions.versionToJdkLevel(v2) < 0x300000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
        }
        if (this.didSpecifyTarget) {
            Object v3 = this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            if ("jsr14".equals(v3)) {
                if (CompilerOptions.versionToJdkLevel(v) < 0x310000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForGenericSource", (String)v3, (String)v));
                }
            } else {
                if (CompilerOptions.versionToJdkLevel(v) >= 0x320000L && CompilerOptions.versionToJdkLevel(v3) < 0x320000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.6"));
                }
                if (CompilerOptions.versionToJdkLevel(v) >= 0x310000L && CompilerOptions.versionToJdkLevel(v3) < 0x310000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.5"));
                }
                if (CompilerOptions.versionToJdkLevel(v) >= 0x300000L && CompilerOptions.versionToJdkLevel(v3) < 0x300000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.4"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) < CompilerOptions.versionToJdkLevel(v3)) {
                    throw new InvalidInputException(this.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), (String)v3));
                }
            }
        }
    }

    public static class Logger {
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_NAME = "name";
        private static final String COMPILER_VERSION = "version";
        public static final int EMACS = 2;
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String EXCEPTION = "exception";
        private static final HashMap FIELD_TABLE = new HashMap();
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_ID = "id";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        public static final int XML = 1;
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler PUBLIC \"-//Eclipse.org//DTD Eclipse JDT 3.2.002 Compiler//EN\" \"http://www.eclipse.org/jdt/core/compiler_32_002.dtd\">";
        private PrintWriter err;
        private PrintWriter log;
        private Main main;
        private PrintWriter out;
        private HashMap parameters;
        int tagBits;

        public Logger(Main main, PrintWriter printWriter, PrintWriter printWriter2) {
            this.out = printWriter;
            this.err = printWriter2;
            this.parameters = new HashMap();
            this.main = main;
        }

        public String buildFileName(String string, String string2) {
            char c = File.separatorChar;
            String string3 = File.separator;
            string = string.replace('/', c);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith(string3)) {
                stringBuffer.append(string3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string4).append(string3);
                string4 = stringTokenizer.nextToken();
            }
            return stringBuffer.append(string4).toString();
        }

        public void close() {
            if (this.log != null) {
                if ((this.tagBits & 1) != 0) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(this.main.bind("progress.compiling"));
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        public void endLoggingSource() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if ((this.tagBits & 1) != 0) {
                this.endTag("tasks");
            }
        }

        private void endTag(String string) {
            ((GenericXMLWriter)this.log).endTag(string, true, true);
        }

        private void extractContext(CategorizedProblem categorizedProblem, char[] cArray) {
            int n;
            char c;
            int n2;
            int n3;
            int n4 = categorizedProblem.getSourceStart();
            if (n4 > (n3 = categorizedProblem.getSourceEnd()) || n4 < 0 && n3 < 0) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                return;
            }
            int n5 = cArray.length;
            int n6 = n2 = n4 >= n5 ? n5 - 1 : n4;
            while (n2 > 0 && (c = cArray[n2 - 1]) != '\n' && c != '\r') {
                --n2;
            }
            int n7 = n = n3 >= n5 ? n5 - 1 : n3;
            while (n + 1 < n5 && (c = cArray[n + 1]) != '\r' && c != '\n') {
                ++n;
            }
            while ((c = cArray[n2]) == ' ' || c == '\t') {
                ++n2;
            }
            while ((c = cArray[n]) == ' ' || c == '\t') {
                --n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n2, n - n2 + 1);
            this.parameters.put("value", String.valueOf(stringBuffer));
            this.parameters.put(SOURCE_START, Integer.toString(n4 - n2));
            this.parameters.put(SOURCE_END, Integer.toString(n3 - n2));
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        private String getFieldName(int n) {
            return (String)FIELD_TABLE.get(new Integer(n));
        }

        public void logAverage(long[] lArray, long l) {
            Arrays.sort(lArray);
            int n = lArray.length;
            long l2 = 0L;
            int n2 = n - 1;
            for (int i = 1; i < n2; ++i) {
                l2 += lArray[i];
            }
            long l3 = l2 / (long)(n - 2);
            this.printlnOut(this.main.bind("compile.averageTime", new String[]{String.valueOf(l), String.valueOf(l3), String.valueOf((double)((int)((double)l * 10000.0 / (double)l3)) / 10.0)}));
        }

        public void logClassFile(boolean bl, String string, String string2) {
            if ((this.tagBits & 1) != 0) {
                String string3 = null;
                if (bl) {
                    string3 = this.buildFileName(string, string2);
                } else {
                    char c = File.separatorChar;
                    String string4 = File.separator;
                    string = string.replace('/', c);
                    int n = string2.lastIndexOf(c);
                    if (n == -1) {
                        string3 = string.endsWith(string4) ? string + string2 : string + string4 + string2;
                    } else {
                        int n2 = string2.length();
                        string3 = string.endsWith(string4) ? string + string2.substring(n + 1, n2) : string + string4 + string2.substring(n + 1, n2);
                    }
                }
                File file = new File(string3);
                try {
                    this.parameters.put(PATH, file.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException iOException) {
                    this.logNoClassFileCreated(string, string2, iOException);
                }
            }
        }

        public void logClasspath(FileSystem.Classpath[] classpathArray) {
            int n;
            if (classpathArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = classpathArray.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                for (int i = 0; i < n; ++i) {
                    String string = classpathArray[i].getPath();
                    this.parameters.put(PATH, string);
                    File file = new File(string);
                    String string2 = null;
                    if (file.isFile()) {
                        string2 = Util.isArchiveFileName(string) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (file.isDirectory()) {
                        string2 = CLASSPATH_FOLDER;
                    }
                    if (string2 == null) continue;
                    this.parameters.put("id", string2);
                    this.printTag(CLASSPATH, this.parameters, true, true);
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logCommandLineArguments(String[] stringArray) {
            int n;
            if (stringArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = stringArray.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                for (int i = 0; i < n; ++i) {
                    this.parameters.put("value", stringArray[i]);
                    this.printTag("argument", this.parameters, true, true);
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception exception) {
            Object object;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            String string = stringWriter.getBuffer().toString();
            if ((this.tagBits & 1) != 0) {
                object = new LineNumberReader(new StringReader(string));
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = exception.getMessage();
                if (string2 != null) {
                    stringBuffer.append(string2).append(Util.LINE_SEPARATOR);
                }
                try {
                    String string3;
                    while ((string3 = ((LineNumberReader)object).readLine()) != null && n < 4) {
                        stringBuffer.append(string3).append(Util.LINE_SEPARATOR);
                        ++n;
                    }
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string2 = stringBuffer.toString();
                this.parameters.put("message", string2);
                this.parameters.put(CLASS, exception.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            if ((object = exception.getMessage()) == null) {
                this.printlnErr(string);
            } else {
                this.printlnErr((String)object);
            }
        }

        public void logIncorrectClasspath(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectClasspath", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectClasspath", string));
        }

        public void logIncorrectEndorsedDirsEntry(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectEndorsedDirsEntry", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectEndorsedDirsEntry", string));
        }

        public void logIncorrectExtDirsEntry(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectExtDirsEntry", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectExtDirsEntry", string));
        }

        public void logNoClassFileCreated(String string, String string2, IOException iOException) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
        }

        public void logNoClasspath() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.noClasspath"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.noClasspath"));
        }

        public void logNumberOfClassFilesGenerated(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Integer(n));
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (n == 1) {
                this.printlnOut(this.main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(this.main.bind("compile.severalClassFilesGenerated", String.valueOf(n)));
            }
        }

        public void logOptions(Map map) {
            if ((this.tagBits & 1) != 0) {
                this.printTag(OPTIONS, null, true, false);
                Set set = map.keySet();
                Object[] objectArray = set.toArray();
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    this.parameters.put(KEY, object);
                    this.parameters.put("value", map.get(object));
                    this.printTag(OPTION, this.parameters, true, true);
                }
                this.endTag(OPTIONS);
            }
        }

        private void logProblem(CategorizedProblem categorizedProblem, int n, int n2, char[] cArray) {
            if ((this.tagBits & 2) != 0) {
                String string = new String(categorizedProblem.getOriginatingFileName()) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                this.printlnErr(string);
                String string2 = ((DefaultProblem)categorizedProblem).errorReportSource(cArray, this.tagBits);
                if (string2.length() != 0) {
                    this.printlnErr(string2);
                }
            } else {
                if (n == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())) : this.main.bind("requestor.warning", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())));
                try {
                    String string = ((DefaultProblem)categorizedProblem).errorReportSource(cArray);
                    this.printlnErr(string);
                    this.printlnErr(categorizedProblem.getMessage());
                }
                catch (Exception exception) {
                    this.printlnErr(this.main.bind("requestor.notRetrieveErrorMessage", categorizedProblem.toString()));
                }
                this.printlnErr("----------");
            }
        }

        public int logProblems(CategorizedProblem[] categorizedProblemArray, char[] cArray, Main main) {
            int n = categorizedProblemArray.length;
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                if ((this.tagBits & 1) != 0) {
                    CategorizedProblem categorizedProblem;
                    int n4;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    for (n4 = 0; n4 < n; ++n4) {
                        categorizedProblem = categorizedProblemArray[n4];
                        if (categorizedProblem == null) continue;
                        ++main.globalProblemsCount;
                        this.logProblem(categorizedProblem, n3, main.globalProblemsCount, cArray);
                        ++n3;
                        if (categorizedProblem.isError()) {
                            ++n2;
                            ++n5;
                            ++main.globalErrorsCount;
                            continue;
                        }
                        if (categorizedProblem.getID() == 536871362) {
                            ++main.globalTasksCount;
                            ++n7;
                            continue;
                        }
                        ++main.globalWarningsCount;
                        ++n6;
                    }
                    if (n5 + n6 != 0) {
                        this.startLoggingProblems(n5, n6);
                        for (n4 = 0; n4 < n; ++n4) {
                            categorizedProblem = categorizedProblemArray[n4];
                            if (categorizedProblem == null || categorizedProblem.getID() == 536871362) continue;
                            this.logXmlProblem(categorizedProblem, cArray);
                        }
                        this.endLoggingProblems();
                    }
                    if (n7 != 0) {
                        this.startLoggingTasks(n7);
                        for (n4 = 0; n4 < n; ++n4) {
                            categorizedProblem = categorizedProblemArray[n4];
                            if (categorizedProblem == null || categorizedProblem.getID() != 536871362) continue;
                            this.logXmlTask(categorizedProblem, cArray);
                        }
                        this.endLoggingTasks();
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (categorizedProblemArray[i] == null) continue;
                        ++main.globalProblemsCount;
                        this.logProblem(categorizedProblemArray[i], n3, main.globalProblemsCount, cArray);
                        ++n3;
                        if (categorizedProblemArray[i].isError()) {
                            ++n2;
                            ++main.globalErrorsCount;
                            continue;
                        }
                        ++main.globalWarningsCount;
                    }
                }
            }
            return n2;
        }

        public void logProblemsSummary(int n, int n2, int n3, int n4) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("problems", new Integer(n));
                this.parameters.put(NUMBER_OF_ERRORS, new Integer(n2));
                this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n3));
                this.parameters.put("tasks", new Integer(n4));
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (n == 1) {
                String string = null;
                string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.oneWarning");
                this.printErr(this.main.bind("compile.oneProblem", string));
            } else {
                int n5;
                String string = null;
                String string2 = null;
                if (n2 > 0) {
                    string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.severalErrors", String.valueOf(n2));
                }
                if ((n5 = n3 + n4) > 0) {
                    string2 = n5 == 1 ? this.main.bind("compile.oneWarning") : this.main.bind("compile.severalWarnings", String.valueOf(n5));
                }
                if (string == null || string2 == null) {
                    if (string == null) {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string2));
                    } else {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string));
                    }
                } else {
                    this.printErr(this.main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(n), string, string2}));
                }
            }
            if ((this.tagBits & 2) != 0) {
                this.printlnErr();
            }
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int n, int n2) {
            this.printlnOut(this.main.bind("compile.repetition", String.valueOf(n + 1), String.valueOf(n2)));
        }

        public void logTiming(long l, long l2) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Long(l));
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.put("value", new Long(l2));
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (l2 != 0L) {
                this.printlnOut(this.main.bind("compile.instantTime", new String[]{String.valueOf(l2), String.valueOf(l), String.valueOf((double)((int)((double)l2 * 10000.0 / (double)l)) / 10.0)}));
            } else {
                this.printlnOut(this.main.bind("compile.totalTime", String.valueOf(l)));
            }
        }

        public void logUsage(String string) {
            this.printlnOut(string);
        }

        public void logVersion(boolean bl) {
            if (this.log != null && (this.tagBits & 1) == 0) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.log.println("# " + string);
                if (bl) {
                    this.out.println(string);
                    this.out.flush();
                }
            } else if (bl) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.out.println(string);
                this.out.flush();
            }
        }

        public void logWrongJDK() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlProblem(CategorizedProblem categorizedProblem, char[] cArray) {
            int n = categorizedProblem.getSourceStart();
            int n2 = categorizedProblem.getSourceEnd();
            this.parameters.put("id", this.getFieldName(categorizedProblem.getID()));
            this.parameters.put(PROBLEM_SEVERITY, categorizedProblem.isError() ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n2));
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            String[] stringArray = categorizedProblem.getArguments();
            int n3 = stringArray.length;
            if (n3 != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                for (int i = 0; i < n3; ++i) {
                    this.parameters.put("value", stringArray[i]);
                    this.printTag("argument", this.parameters, true, true);
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(CategorizedProblem categorizedProblem, char[] cArray) {
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(categorizedProblem.getSourceStart()));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(categorizedProblem.getSourceEnd()));
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            this.endTag(TASK);
        }

        private void printErr(String string) {
            this.err.print(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.print(string);
            }
        }

        private void printlnErr() {
            this.err.println();
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println();
            }
        }

        private void printlnErr(String string) {
            this.err.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        private void printlnOut(String string) {
            this.out.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c) {
            this.out.print(c);
        }

        public void printStats() {
            boolean bl = this.main.timing;
            if ((this.tagBits & 1) != 0) {
                this.printTag(STATS, null, true, false);
            }
            if (bl) {
                long l = System.currentTimeMillis() - this.main.startTime;
                this.logTiming(l, this.main.lineCount);
                if (this.main.times != null) {
                    this.main.times[this.main.timesCounter++] = l;
                }
            }
            if (this.main.globalProblemsCount > 0) {
                this.logProblemsSummary(this.main.globalProblemsCount, this.main.globalErrorsCount, this.main.globalWarningsCount, this.main.globalTasksCount);
            }
            if (this.main.exportedClassFilesCounter != 0 && (this.main.showProgress || bl || this.main.verbose)) {
                this.logNumberOfClassFilesGenerated(this.main.exportedClassFilesCounter);
            }
            if ((this.tagBits & 1) != 0) {
                this.endTag(STATS);
            }
        }

        private void printTag(String string, HashMap hashMap, boolean bl, boolean bl2) {
            ((GenericXMLWriter)this.log).printTag(string, this.parameters, true, bl, bl2);
            this.parameters.clear();
        }

        public void setEmacs() {
            this.tagBits |= 2;
        }

        public void setLog(String string) throws InvalidInputException {
            block6: {
                Date date = new Date();
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
                try {
                    int n = string.lastIndexOf(46);
                    if (n != -1) {
                        if (string.substring(n).toLowerCase().equals(".xml")) {
                            this.log = new GenericXMLWriter((OutputStream)new FileOutputStream(string, false), Util.LINE_SEPARATOR, true);
                            this.tagBits |= 1;
                            try {
                                this.log.println("<!-- " + new String(dateFormat.format(date).getBytes(), "UTF-8") + " -->");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                unsupportedEncodingException.printStackTrace();
                            }
                            this.log.println(XML_DTD_DECLARATION);
                            this.parameters.put(COMPILER_NAME, this.main.bind("compiler.name"));
                            this.parameters.put(COMPILER_VERSION, this.main.bind("compiler.version"));
                            this.parameters.put(COMPILER_COPYRIGHT, this.main.bind("compiler.copyright"));
                            this.printTag(COMPILER, this.parameters, true, false);
                            break block6;
                        }
                        this.log = new PrintWriter(new FileOutputStream(string, false));
                        this.log.println("# " + dateFormat.format(date));
                        break block6;
                    }
                    this.log = new PrintWriter(new FileOutputStream(string, false));
                    this.log.println("# " + dateFormat.format(date));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new InvalidInputException(this.main.bind("configure.cannotOpenLog"));
                }
            }
        }

        private void startLoggingProblems(int n, int n2) {
            this.parameters.put("problems", new Integer(n + n2));
            this.parameters.put(NUMBER_OF_ERRORS, new Integer(n));
            this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n2));
            this.printTag("problems", this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if ((this.tagBits & 1) != 0) {
                ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
                char[] cArray = iCompilationUnit.getFileName();
                File file = new File(new String(cArray));
                if (cArray != null && iCompilationUnit != null) {
                    this.parameters.put(PATH, file.getAbsolutePath());
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("tasks", new Integer(n));
                this.printTag("tasks", this.parameters, true, false);
            }
        }

        static {
            try {
                Class<IProblem> clazz = IProblem.class;
                for (Field field : clazz.getFields()) {
                    FIELD_TABLE.put(field.get(null), field.getName());
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }
}

