/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.util.Arrays;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;

public class BranchLabel
extends Label {
    public int[] forwardReferences = new int[10];
    public int forwardReferenceCount = 0;
    public int tagBits;
    public static final int WIDE = 1;
    public static final int USED = 2;

    public BranchLabel() {
    }

    public BranchLabel(CodeStream codeStream) {
        super(codeStream);
    }

    void addForwardReference(int n) {
        int n2 = this.forwardReferenceCount;
        if (n2 >= 1) {
            int n3 = this.forwardReferences[n2 - 1];
            if (n3 < n) {
                int n4 = this.forwardReferences.length;
                if (n2 >= n4) {
                    this.forwardReferences = new int[2 * n4];
                    System.arraycopy(this.forwardReferences, 0, this.forwardReferences, 0, n4);
                }
                this.forwardReferences[this.forwardReferenceCount++] = n;
            } else if (n3 > n) {
                int n5;
                int[] nArray = this.forwardReferences;
                int n6 = this.forwardReferenceCount;
                for (n5 = 0; n5 < n6; ++n5) {
                    if (nArray[n5] != n) continue;
                    return;
                }
                n5 = nArray.length;
                if (n2 >= n5) {
                    this.forwardReferences = new int[2 * n5];
                    System.arraycopy(nArray, 0, this.forwardReferences, 0, n5);
                }
                this.forwardReferences[this.forwardReferenceCount++] = n;
                Arrays.sort(this.forwardReferences, 0, this.forwardReferenceCount);
            }
        } else {
            int n7 = this.forwardReferences.length;
            if (n2 >= n7) {
                this.forwardReferences = new int[2 * n7];
                System.arraycopy(this.forwardReferences, 0, this.forwardReferences, 0, n7);
            }
            this.forwardReferences[this.forwardReferenceCount++] = n;
        }
    }

    public void appendForwardReferencesFrom(BranchLabel branchLabel) {
        int n = branchLabel.forwardReferenceCount;
        if (n == 0) {
            return;
        }
        int[] nArray = new int[this.forwardReferenceCount + n];
        int n2 = 0;
        int n3 = 0;
        int n4 = this.forwardReferenceCount;
        int n5 = branchLabel.forwardReferenceCount;
        block0: for (int i = 0; i < n4; ++i) {
            int n6 = this.forwardReferences[i];
            while (n3 < n5) {
                int n7 = branchLabel.forwardReferences[n3];
                if (n6 < n7) {
                    nArray[n2++] = n6;
                    continue block0;
                }
                if (n6 == n7) {
                    nArray[n2++] = n6;
                    ++n3;
                    continue block0;
                }
                nArray[n2++] = n7;
                ++n3;
            }
            nArray[n2++] = n6;
        }
        while (n3 < n5) {
            nArray[n2++] = branchLabel.forwardReferences[n3];
            ++n3;
        }
        this.forwardReferences = nArray;
        this.forwardReferenceCount = n2;
    }

    void branch() {
        this.tagBits |= 2;
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.codeStream.position += 2;
            this.codeStream.classFileOffset += 2;
        } else {
            this.codeStream.writePosition(this);
        }
    }

    void branchWide() {
        this.tagBits |= 2;
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.tagBits |= 1;
            this.codeStream.position += 4;
            this.codeStream.classFileOffset += 4;
        } else {
            this.codeStream.writeWidePosition(this);
        }
    }

    public void initialize(CodeStream codeStream) {
        this.codeStream = codeStream;
        this.position = -1;
        this.forwardReferenceCount = 0;
    }

    public boolean isCaseLabel() {
        return false;
    }

    public boolean isStandardLabel() {
        return true;
    }

    @Override
    public void place() {
        if (this.position == -1) {
            int n;
            this.position = (this.tagBits & 2) != 0 || this.forwardReferenceCount != 0 ? this.codeStream.getPosition() : this.codeStream.position;
            this.codeStream.addLabel(this);
            int n2 = this.position;
            boolean bl = false;
            if (this.forwardReferenceCount != 0) {
                boolean bl2 = bl = this.forwardReferences[this.forwardReferenceCount - 1] + 2 == this.position && this.codeStream.bCodeStream[this.codeStream.classFileOffset - 3] == -89;
                if (bl) {
                    this.codeStream.position = this.position -= 3;
                    this.codeStream.classFileOffset -= 3;
                    --this.forwardReferenceCount;
                    n = this.codeStream.pcToSourceMapSize - 2;
                    if (this.codeStream.lastEntryPC == n2) {
                        this.codeStream.lastEntryPC = this.position;
                    }
                    if (n >= 0 && this.codeStream.pcToSourceMap[n] == this.position) {
                        this.codeStream.pcToSourceMapSize -= 2;
                    }
                    if ((this.codeStream.generateAttributes & 0xC) != 0) {
                        for (LocalVariableBinding localVariableBinding : this.codeStream.locals) {
                            if (localVariableBinding == null || localVariableBinding.initializationCount <= 0) continue;
                            if (localVariableBinding.initializationPCs[(localVariableBinding.initializationCount - 1 << 1) + 1] == n2) {
                                localVariableBinding.initializationPCs[(localVariableBinding.initializationCount - 1 << 1) + 1] = this.position;
                            }
                            if (localVariableBinding.initializationPCs[localVariableBinding.initializationCount - 1 << 1] != n2) continue;
                            localVariableBinding.initializationPCs[localVariableBinding.initializationCount - 1 << 1] = this.position;
                        }
                    }
                }
            }
            for (n = 0; n < this.forwardReferenceCount; ++n) {
                this.codeStream.writePosition(this, this.forwardReferences[n]);
            }
            if (bl) {
                this.codeStream.optimizeBranch(n2, this);
            }
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('@').append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("(position=").append(this.position);
        stringBuffer.append(", forwards = [");
        for (int i = 0; i < this.forwardReferenceCount - 1; ++i) {
            stringBuffer.append(this.forwardReferences[i] + ", ");
        }
        if (this.forwardReferenceCount >= 1) {
            stringBuffer.append(this.forwardReferences[this.forwardReferenceCount - 1]);
        }
        stringBuffer.append("] )");
        return stringBuffer.toString();
    }
}

