/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class CaptureBinding
extends TypeVariableBinding {
    public TypeBinding lowerBound;
    public WildcardBinding wildcard;
    public ReferenceBinding sourceType;
    public int position;

    public CaptureBinding(WildcardBinding wildcardBinding, ReferenceBinding referenceBinding, int n) {
        super(TypeConstants.WILDCARD_CAPTURE_NAME, null, 0);
        this.wildcard = wildcardBinding;
        this.modifiers = 0x40000001;
        this.fPackage = wildcardBinding.fPackage;
        this.sourceType = referenceBinding;
        this.position = n;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.sourceType.computeUniqueKey(false));
            stringBuffer.append('&');
        }
        stringBuffer.append(TypeConstants.WILDCARD_CAPTURE);
        stringBuffer.append(this.wildcard.computeUniqueKey(false));
        stringBuffer.append(this.position);
        stringBuffer.append(';');
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public String debugName() {
        if (this.wildcard != null) {
            return String.valueOf(TypeConstants.WILDCARD_CAPTURE_NAME) + this.wildcard.debugName();
        }
        return super.debugName();
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            this.genericTypeSignature = CharOperation.concat(TypeConstants.WILDCARD_CAPTURE, this.wildcard.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    public void initializeBounds(Scope scope, ParameterizedTypeBinding parameterizedTypeBinding) {
        ReferenceBinding[] referenceBindingArray;
        ReferenceBinding[] referenceBindingArray2;
        TypeVariableBinding typeVariableBinding = this.wildcard.typeVariable();
        ReferenceBinding referenceBinding = typeVariableBinding.superclass;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)Scope.substitute((Substitution)parameterizedTypeBinding, referenceBinding);
        if (referenceBinding2 == this) {
            referenceBinding2 = referenceBinding;
        }
        if ((referenceBindingArray2 = Scope.substitute((Substitution)parameterizedTypeBinding, referenceBindingArray = typeVariableBinding.superInterfaces())) != referenceBindingArray) {
            int n = referenceBindingArray2.length;
            for (int i = 0; i < n; ++i) {
                if (referenceBindingArray2[i] != this) continue;
                referenceBindingArray2[i] = referenceBindingArray[i];
            }
        }
        TypeBinding typeBinding = this.wildcard.bound;
        switch (this.wildcard.boundKind) {
            case 1: {
                TypeBinding typeBinding2 = typeBinding.capture(scope, this.position);
                if (this.wildcard.bound.isInterface()) {
                    this.superclass = referenceBinding2;
                    if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) {
                        this.superInterfaces = new ReferenceBinding[]{(ReferenceBinding)typeBinding2};
                    } else {
                        int n = referenceBindingArray2.length;
                        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n + 1];
                        System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 1, n);
                        referenceBindingArray2[0] = (ReferenceBinding)typeBinding2;
                        this.superInterfaces = Scope.greaterLowerBound(referenceBindingArray2);
                    }
                } else {
                    this.superclass = this.wildcard.bound.isArrayType() ? referenceBinding2 : (ReferenceBinding)typeBinding2;
                    this.superInterfaces = referenceBindingArray2;
                }
                this.firstBound = typeBinding2;
                if ((typeBinding2.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 0: {
                this.superclass = referenceBinding2;
                this.superInterfaces = referenceBindingArray2;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 2: {
                this.superclass = referenceBinding2;
                if (typeVariableBinding.firstBound == referenceBinding2 || typeBinding == referenceBinding2) {
                    this.firstBound = referenceBinding2;
                }
                this.superInterfaces = referenceBindingArray2;
                this.lowerBound = typeBinding;
                if ((typeBinding.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
            }
        }
    }

    @Override
    public boolean isCapture() {
        return true;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        if (this.firstBound != null && this.firstBound.isArrayType() && this.firstBound.isCompatibleWith(typeBinding)) {
            return true;
        }
        if (typeBinding.isWildcard()) {
            return ((WildcardBinding)typeBinding).boundCheck(this);
        }
        return false;
    }

    @Override
    public char[] readableName() {
        if (this.wildcard != null) {
            return CharOperation.concat(TypeConstants.WILDCARD_CAPTURE_NAME, this.wildcard.readableName());
        }
        return super.readableName();
    }

    @Override
    public char[] shortReadableName() {
        if (this.wildcard != null) {
            return CharOperation.concat(TypeConstants.WILDCARD_CAPTURE_NAME, this.wildcard.shortReadableName());
        }
        return super.shortReadableName();
    }

    @Override
    public String toString() {
        if (this.wildcard != null) {
            return String.valueOf(TypeConstants.WILDCARD_CAPTURE_NAME) + this.wildcard.toString();
        }
        return super.toString();
    }
}

