/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;

public class ElementValuePair {
    char[] name;
    Object value;
    MethodBinding binding;

    public static Object getValue(Expression expression) {
        if (expression == null) {
            return null;
        }
        Constant constant = expression.constant;
        if (constant != null && constant != Constant.NotAConstant) {
            return constant;
        }
        if (expression instanceof Annotation) {
            return ((Annotation)expression).getCompilerAnnotation();
        }
        if (expression instanceof ArrayInitializer) {
            Expression[] expressionArray = ((ArrayInitializer)expression).expressions;
            int n = expressionArray == null ? 0 : expressionArray.length;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ElementValuePair.getValue(expressionArray[i]);
            }
            return objectArray;
        }
        if (expression instanceof ClassLiteralAccess) {
            return ((ClassLiteralAccess)expression).targetType;
        }
        if (expression instanceof Reference) {
            Binding binding;
            FieldBinding fieldBinding = null;
            if (expression instanceof FieldReference) {
                fieldBinding = ((FieldReference)expression).fieldBinding();
            } else if (expression instanceof NameReference && (binding = ((NameReference)expression).binding) != null && binding.kind() == 1) {
                fieldBinding = (FieldBinding)binding;
            }
            if (fieldBinding != null && (fieldBinding.modifiers & 0x4000) > 0) {
                return fieldBinding;
            }
        }
        return null;
    }

    public ElementValuePair(char[] cArray, Expression expression, MethodBinding methodBinding) {
        this(cArray, ElementValuePair.getValue(expression), methodBinding);
    }

    public ElementValuePair(char[] cArray, Object object, MethodBinding methodBinding) {
        this.name = cArray;
        this.value = object;
        this.binding = methodBinding;
    }

    public char[] getName() {
        return this.name;
    }

    public MethodBinding getMethodBinding() {
        return this.binding;
    }

    public Object getValue() {
        return this.value;
    }

    void setMethodBinding(MethodBinding methodBinding) {
        this.binding = methodBinding;
    }

    void setValue(Object object) {
        this.value = object;
    }
}

