/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment lookupEnvironment) {
        super(lookupEnvironment);
    }

    @Override
    boolean areMethodsEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3 = this.computeSubstituteMethod(methodBinding2, methodBinding);
        return methodBinding3 != null && this.doesSubstituteMethodOverride(methodBinding, methodBinding3) && this.areReturnTypesEqual(methodBinding, methodBinding3);
    }

    @Override
    boolean areParametersEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        if (typeBindingArray == typeBindingArray2) {
            return true;
        }
        int n = typeBindingArray.length;
        if (n != typeBindingArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.areTypesEqual(typeBindingArray[i], typeBindingArray2[i]) || !methodBinding.declaringClass.isInterface() && typeBindingArray[i].leafComponentType().isRawType() && typeBindingArray[i].dimensions() == typeBindingArray2[i].dimensions() && typeBindingArray[i].leafComponentType().isEquivalentTo(typeBindingArray2[i].leafComponentType())) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean areReturnTypesEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return this.areReturnTypesCompatible(methodBinding, methodBinding2);
    }

    @Override
    boolean areTypesEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (typeBinding.isParameterizedType() && typeBinding2.isParameterizedType()) {
            return typeBinding.isEquivalentTo(typeBinding2) && typeBinding2.isEquivalentTo(typeBinding);
        }
        return false;
    }

    @Override
    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    @Override
    boolean canSkipInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding2 == null || methodBinding.declaringClass == methodBinding2.declaringClass && !methodBinding.declaringClass.isParameterizedType();
    }

    @Override
    void checkConcreteInheritedMethod(MethodBinding methodBinding, MethodBinding[] methodBindingArray) {
        super.checkConcreteInheritedMethod(methodBinding, methodBindingArray);
        for (MethodBinding methodBinding2 : methodBindingArray) {
            if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
                this.problemReporter().varargsConflict(methodBinding, methodBinding2, this.type);
            }
            MethodBinding methodBinding3 = methodBinding2.original();
            if (methodBinding3.returnType != methodBinding.returnType) {
                TypeBinding typeBinding;
                if (methodBinding2.returnType.leafComponentType().isParameterizedType()) {
                    if (methodBinding.returnType.leafComponentType().isRawType()) {
                        this.problemReporter().unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
                    }
                } else if (methodBinding2.hasSubstitutedReturnType() && methodBinding3.returnType.leafComponentType().isTypeVariable() && ((TypeVariableBinding)methodBinding3.returnType.leafComponentType()).declaringElement == methodBinding3 && (!(typeBinding = methodBinding.returnType.leafComponentType()).isTypeVariable() || ((TypeVariableBinding)typeBinding).declaringElement != methodBinding)) {
                    this.problemReporter().unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
                }
            }
            if (!methodBinding3.declaringClass.isInterface() || this.type.superclass.erasure().findSuperTypeWithSameErasure(methodBinding3.declaringClass) != null) continue;
            this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original());
        }
    }

    @Override
    void checkForBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2, MethodBinding[] methodBindingArray) {
        if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
            this.problemReporter(methodBinding).varargsConflict(methodBinding, methodBinding2, this.type);
        }
        MethodBinding methodBinding3 = methodBinding2.original();
        if (methodBinding3.returnType != methodBinding.returnType) {
            TypeBinding typeBinding;
            if (methodBinding2.returnType.leafComponentType().isParameterizedType()) {
                if (methodBinding.returnType.leafComponentType().isRawType()) {
                    this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
                }
            } else if (methodBinding2.hasSubstitutedReturnType() && methodBinding3.returnType.leafComponentType().isTypeVariable() && ((TypeVariableBinding)methodBinding3.returnType.leafComponentType()).declaringElement == methodBinding3 && (!(typeBinding = methodBinding.returnType.leafComponentType()).isTypeVariable() || ((TypeVariableBinding)typeBinding).declaringElement != methodBinding)) {
                this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
            }
        }
        if (this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original()) != null) {
            for (MethodBinding methodBinding4 : methodBindingArray) {
                MethodBinding methodBinding5;
                MethodBinding methodBinding6;
                MethodBinding methodBinding7 = methodBinding4.original();
                if (methodBinding7 == methodBinding3 || methodBinding7 == methodBinding4 || (methodBinding6 = this.computeSubstituteMethod(methodBinding4, methodBinding5 = methodBinding2 instanceof ParameterizedGenericMethodBinding ? ((ParameterizedGenericMethodBinding)methodBinding2).originalMethod : methodBinding2)) == null || this.doesSubstituteMethodOverride(methodBinding5, methodBinding6) || !this.detectInheritedNameClash(methodBinding3, methodBinding7)) continue;
                return;
            }
        }
    }

    void checkForInheritedNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.declaringClass.isInterface() || methodBinding.isStatic()) {
            return;
        }
        this.detectInheritedNameClash(methodBinding, methodBinding2);
    }

    void checkForNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.declaringClass.isInterface() || methodBinding.isStatic()) {
            return;
        }
        if (!this.detectNameClash(methodBinding, methodBinding2)) {
            int n;
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            int n2 = typeBindingArray.length;
            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
            if (n2 != typeBindingArray2.length) {
                return;
            }
            for (int i = 0; i < n2; ++i) {
                if (typeBindingArray[i] == typeBindingArray2[i] || typeBindingArray[i].isBaseType() == typeBindingArray2[i].isBaseType() && typeBindingArray2[i].isCompatibleWith(typeBindingArray[i])) continue;
                return;
            }
            ReferenceBinding[] referenceBindingArray = null;
            int n3 = 0;
            ReferenceBinding referenceBinding = methodBinding2.declaringClass;
            ReferenceBinding[] referenceBindingArray2 = referenceBinding.superInterfaces();
            if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                n3 = referenceBindingArray2.length;
                referenceBindingArray = referenceBindingArray2;
            }
            for (referenceBinding = referenceBinding.superclass(); referenceBinding != null && referenceBinding.isValidBinding(); referenceBinding = referenceBinding.superclass()) {
                Binding binding;
                int n4;
                MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                n = methodBindingArray.length;
                for (n4 = 0; n4 < n; ++n4) {
                    binding = this.computeSubstituteMethod(methodBindingArray[n4], methodBinding);
                    if (binding == null || this.doesSubstituteMethodOverride(methodBinding, (MethodBinding)binding) || !this.detectNameClash(methodBinding, (MethodBinding)binding)) continue;
                    return;
                }
                referenceBindingArray2 = referenceBinding.superInterfaces();
                if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
                if (referenceBindingArray == null) {
                    referenceBindingArray = referenceBindingArray2;
                    n3 = referenceBindingArray.length;
                    continue;
                }
                n4 = referenceBindingArray2.length;
                if (n3 + n4 >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n3 + n4 + 5];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n3);
                }
                block3: for (n = 0; n < n4; ++n) {
                    binding = referenceBindingArray2[n];
                    for (int i = 0; i < n3; ++i) {
                        if (binding == referenceBindingArray[i]) continue block3;
                    }
                    referenceBindingArray[n3++] = binding;
                }
            }
            for (int i = 0; i < n3; ++i) {
                Binding binding;
                referenceBinding = referenceBindingArray[i];
                if (!referenceBinding.isValidBinding()) continue;
                MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                int n5 = methodBindingArray.length;
                for (n = 0; n < n5; ++n) {
                    binding = this.computeSubstituteMethod(methodBindingArray[n], methodBinding);
                    if (binding == null || this.doesSubstituteMethodOverride(methodBinding, (MethodBinding)binding) || !this.detectNameClash(methodBinding, (MethodBinding)binding)) continue;
                    return;
                }
                referenceBindingArray2 = referenceBinding.superInterfaces();
                if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
                n = referenceBindingArray2.length;
                if (n3 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray4 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n3 + n + 5];
                    System.arraycopy(referenceBindingArray4, 0, referenceBindingArray, 0, n3);
                }
                block7: for (n5 = 0; n5 < n; ++n5) {
                    binding = referenceBindingArray2[n5];
                    for (int j = 0; j < n3; ++j) {
                        if (binding == referenceBindingArray[j]) continue block7;
                    }
                    referenceBindingArray[n3++] = binding;
                }
            }
        }
    }

    @Override
    void checkInheritedMethods(MethodBinding[] methodBindingArray, int n) {
        int n2 = n;
        int n3 = 0;
        int n4 = n - 1;
        block0: while (n3 < n4) {
            MethodBinding methodBinding = methodBindingArray[n3++];
            for (int i = n3; i <= n4; ++i) {
                if (methodBinding.declaringClass != methodBindingArray[i].declaringClass || !this.areMethodsEqual(methodBinding, methodBindingArray[i])) continue;
                this.problemReporter().duplicateInheritedMethods(this.type, methodBinding, methodBindingArray[i]);
                --n2;
                methodBindingArray[n3 - 1] = null;
                continue block0;
            }
        }
        if (n2 < n) {
            if (n2 == 1) {
                return;
            }
            MethodBinding[] methodBindingArray2 = new MethodBinding[n2];
            n4 = n;
            while (--n4 >= 0) {
                if (methodBindingArray[n4] == null) continue;
                methodBindingArray2[--n2] = methodBindingArray[n4];
            }
            methodBindingArray = methodBindingArray2;
            n = methodBindingArray2.length;
        }
        super.checkInheritedMethods(methodBindingArray, n);
    }

    @Override
    boolean checkInheritedReturnTypes(MethodBinding[] methodBindingArray, int n) {
        if (methodBindingArray[0].declaringClass.isClass()) {
            return super.checkInheritedReturnTypes(methodBindingArray, n);
        }
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < n3) {
            MethodBinding methodBinding = methodBindingArray[n2++];
            for (int i = n2; i <= n3; ++i) {
                if (this.areReturnTypesEqual(methodBinding, methodBindingArray[i])) continue;
                if (this.type.isInterface()) {
                    int n4 = n;
                    while (--n4 >= 0) {
                        if (methodBindingArray[n4].declaringClass.id != 1) continue;
                        return false;
                    }
                }
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methodBindingArray, n);
                return false;
            }
        }
        return true;
    }

    @Override
    void checkMethods() {
        boolean bl = this.mustImplementAbstractMethods();
        boolean bl2 = bl && this.canSkipInheritedMethods();
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        while (--n >= 0) {
            int n2;
            MethodBinding[] methodBindingArray;
            if (cArray[n] == null || (methodBindingArray = (MethodBinding[])this.currentMethods.get(cArray[n])) == null && bl2) continue;
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.inheritedMethods.valueTable[n];
            if (methodBindingArray2.length == 1 && methodBindingArray == null) {
                if (!bl || !methodBindingArray2[0].isAbstract()) continue;
                this.checkAbstractMethod(methodBindingArray2[0]);
                continue;
            }
            int n3 = -1;
            MethodBinding[] methodBindingArray3 = new MethodBinding[methodBindingArray2.length];
            byte[] byArray = new byte[methodBindingArray2.length];
            if (methodBindingArray != null) {
                for (MethodBinding methodBinding : methodBindingArray) {
                    int n4 = methodBindingArray2.length;
                    for (n2 = 0; n2 < n4; ++n2) {
                        MethodBinding methodBinding2 = this.computeSubstituteMethod(methodBindingArray2[n2], methodBinding);
                        if (methodBinding2 == null) continue;
                        if (byArray[n2] == 0 && this.doesSubstituteMethodOverride(methodBinding, methodBinding2)) {
                            methodBindingArray3[++n3] = methodBinding2;
                            byArray[n2] = 1;
                            continue;
                        }
                        this.checkForNameClash(methodBinding, methodBinding2);
                    }
                    if (n3 < 0) continue;
                    this.checkAgainstInheritedMethods(methodBinding, methodBindingArray3, n3 + 1, methodBindingArray2);
                    while (n3 >= 0) {
                        methodBindingArray3[n3--] = null;
                    }
                }
            }
            int n5 = methodBindingArray2.length;
            for (int i = 0; i < n5; ++i) {
                MethodBinding methodBinding;
                if (byArray[i] == 1) continue;
                methodBinding = methodBindingArray2[i];
                methodBindingArray3[++n3] = methodBinding;
                for (n2 = i + 1; n2 < n5; ++n2) {
                    MethodBinding methodBinding3 = methodBindingArray2[n2];
                    if (byArray[n2] == 1 || this.canSkipInheritedMethods(methodBinding, methodBinding3) || (methodBinding3 = this.computeSubstituteMethod(methodBinding3, methodBinding)) == null) continue;
                    if (this.doesSubstituteMethodOverride(methodBinding, methodBinding3)) {
                        methodBindingArray3[++n3] = methodBinding3;
                        byArray[n2] = 1;
                        continue;
                    }
                    this.checkForInheritedNameClash(methodBinding, methodBinding3);
                }
                if (n3 == -1) continue;
                if (n3 > 0) {
                    this.checkInheritedMethods(methodBindingArray3, n3 + 1);
                } else if (bl && n3 == 0 && methodBindingArray3[0].isAbstract()) {
                    this.checkAbstractMethod(methodBindingArray3[0]);
                }
                while (n3 >= 0) {
                    methodBindingArray3[n3--] = null;
                }
            }
        }
    }

    void checkTypeVariableMethods() {
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        block0: while (--n >= 0) {
            MethodBinding[] methodBindingArray;
            if (cArray[n] == null || (methodBindingArray = (MethodBinding[])this.inheritedMethods.valueTable[n]).length == 1) continue;
            int n2 = -1;
            MethodBinding[] methodBindingArray2 = new MethodBinding[methodBindingArray.length];
            int n3 = methodBindingArray.length;
            for (int i = 0; i < n3; ++i) {
                while (n2 >= 0) {
                    methodBindingArray2[n2--] = null;
                }
                MethodBinding methodBinding = methodBindingArray[i];
                if (methodBinding != null) {
                    methodBindingArray2[++n2] = methodBinding;
                    for (int j = i + 1; j < n3; ++j) {
                        MethodBinding methodBinding2 = methodBindingArray[j];
                        if (this.canSkipInheritedMethods(methodBinding, methodBinding2) || (methodBinding2 = this.computeSubstituteMethod(methodBinding2, methodBinding)) == null || !this.doesSubstituteMethodOverride(methodBinding, methodBinding2)) continue;
                        methodBindingArray2[++n2] = methodBinding2;
                        methodBindingArray[j] = null;
                    }
                }
                if (n2 <= 0) continue;
                MethodBinding methodBinding3 = methodBindingArray2[0];
                int n4 = n2 + 1;
                while (--n4 > 0 && this.areReturnTypesEqual(methodBinding3, methodBindingArray2[n4])) {
                }
                if (n4 <= 0) continue;
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methodBindingArray2, n2 + 1);
                continue block0;
            }
        }
    }

    @Override
    MethodBinding computeSubstituteMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeVariableBinding[] typeVariableBindingArray;
        if (methodBinding == null) {
            return null;
        }
        if (methodBinding2.parameters.length != methodBinding.parameters.length) {
            return null;
        }
        if (methodBinding2.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding2.declaringClass).resolveTypesFor(methodBinding2);
        }
        if (methodBinding.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding.declaringClass).resolveTypesFor(methodBinding);
        }
        if ((typeVariableBindingArray = methodBinding.typeVariables) == Binding.NO_TYPE_VARIABLES) {
            return methodBinding;
        }
        int n = typeVariableBindingArray.length;
        TypeVariableBinding[] typeVariableBindingArray2 = methodBinding2.typeVariables;
        int n2 = typeVariableBindingArray2.length;
        if (n2 > 0 && n != n2) {
            return methodBinding;
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        if (n <= n2) {
            System.arraycopy(typeVariableBindingArray2, 0, typeBindingArray, 0, n);
        } else {
            System.arraycopy(typeVariableBindingArray2, 0, typeBindingArray, 0, n2);
            for (int i = n2; i < n; ++i) {
                typeBindingArray[i] = typeVariableBindingArray[i].upperBound();
            }
        }
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = this.environment.createParameterizedGenericMethod(methodBinding, typeBindingArray);
        for (int i = 0; i < n; ++i) {
            TypeVariableBinding typeVariableBinding = typeVariableBindingArray[i];
            TypeBinding typeBinding = typeBindingArray[i];
            if (typeBinding instanceof TypeVariableBinding) {
                TypeVariableBinding typeVariableBinding2 = (TypeVariableBinding)typeBinding;
                if (typeVariableBinding2.firstBound == typeVariableBinding.firstBound) {
                    if (typeVariableBinding2.firstBound == null) {
                        continue;
                    }
                } else if (typeVariableBinding2.firstBound != null && typeVariableBinding.firstBound != null && typeVariableBinding2.firstBound.isClass() != typeVariableBinding.firstBound.isClass()) {
                    return methodBinding;
                }
                if (Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding.superclass) != typeVariableBinding2.superclass) {
                    return methodBinding;
                }
                int n3 = typeVariableBinding.superInterfaces.length;
                ReferenceBinding[] referenceBindingArray = typeVariableBinding2.superInterfaces;
                if (n3 != referenceBindingArray.length) {
                    return methodBinding;
                }
                block2: for (int j = 0; j < n3; ++j) {
                    TypeBinding typeBinding2 = Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding.superInterfaces[j]);
                    for (int k = 0; k < n3; ++k) {
                        if (typeBinding2 == referenceBindingArray[k]) continue block2;
                    }
                    return methodBinding;
                }
                continue;
            }
            if (typeVariableBinding.boundCheck(parameterizedGenericMethodBinding, typeBinding) == 0) continue;
            return methodBinding;
        }
        return parameterizedGenericMethodBinding;
    }

    boolean detectInheritedNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!methodBinding.areParameterErasuresEqual(methodBinding2) || methodBinding.returnType.erasure() != methodBinding2.returnType.erasure()) {
            return false;
        }
        this.problemReporter().inheritedMethodsHaveNameClash(this.type, methodBinding, methodBinding2);
        return true;
    }

    boolean detectNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3 = methodBinding2.original();
        if (!methodBinding.areParameterErasuresEqual(methodBinding3) || methodBinding.returnType.erasure() != methodBinding3.returnType.erasure()) {
            return false;
        }
        this.problemReporter(methodBinding).methodNameClash(methodBinding, methodBinding3);
        return true;
    }

    @Override
    public boolean doesMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3 = this.computeSubstituteMethod(methodBinding2, methodBinding);
        return methodBinding3 != null && this.doesSubstituteMethodOverride(methodBinding, methodBinding3);
    }

    boolean doesSubstituteMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.doTypeVariablesClash(methodBinding, methodBinding2)) {
            return false;
        }
        if (this.areParametersEqual(methodBinding, methodBinding2)) {
            return true;
        }
        if (methodBinding.declaringClass == methodBinding2.declaringClass) {
            return false;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        if (n != typeBindingArray2.length) {
            return false;
        }
        if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES || !methodBinding2.hasSubstitutedParameters()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (!(typeBindingArray2[i].kind() == 4100 ? typeBindingArray[i] != ((TypeVariableBinding)typeBindingArray2[i]).upperBound() : typeBindingArray[i] != typeBindingArray2[i])) continue;
            return false;
        }
        return true;
    }

    boolean doTypeVariablesClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES && !(methodBinding2 instanceof ParameterizedGenericMethodBinding);
    }

    @Override
    boolean isInterfaceMethodImplemented(MethodBinding methodBinding, MethodBinding methodBinding2, ReferenceBinding referenceBinding) {
        if (methodBinding.original() != methodBinding && methodBinding2.declaringClass.isInterface()) {
            return false;
        }
        return (methodBinding = this.computeSubstituteMethod(methodBinding, methodBinding2)) != null && methodBinding.returnType == methodBinding2.returnType && super.isInterfaceMethodImplemented(methodBinding, methodBinding2, referenceBinding);
    }

    @Override
    SimpleSet findSuperinterfaceCollisions(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        int n2;
        int n3;
        ReferenceBinding referenceBinding2;
        ReferenceBinding[] referenceBindingArray2 = null;
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
        if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
            n4 = referenceBindingArray3.length;
            referenceBindingArray2 = referenceBindingArray3;
        }
        boolean bl = this.type.isHierarchyInconsistent();
        for (referenceBinding2 = referenceBinding; referenceBinding2 != null && referenceBinding2.isValidBinding(); referenceBinding2 = referenceBinding2.superclass()) {
            bl |= referenceBinding2.isHierarchyInconsistent();
            referenceBindingArray3 = referenceBinding2.superInterfaces();
            if (referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray2 == null) {
                referenceBindingArray2 = referenceBindingArray3;
                n4 = referenceBindingArray2.length;
                continue;
            }
            n3 = referenceBindingArray3.length;
            if (n4 + n3 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n4 + n3 + 5];
                System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n4);
            }
            block1: for (n2 = 0; n2 < n3; ++n2) {
                ReferenceBinding referenceBinding3 = referenceBindingArray3[n2];
                for (int i = 0; i < n4; ++i) {
                    if (referenceBinding3 == referenceBindingArray2[i]) continue block1;
                }
                referenceBindingArray2[n4++] = referenceBinding3;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            referenceBinding2 = referenceBindingArray2[n3];
            if (!referenceBinding2.isValidBinding()) continue;
            bl |= referenceBinding2.isHierarchyInconsistent();
            referenceBindingArray3 = referenceBinding2.superInterfaces();
            if (referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            n2 = referenceBindingArray3.length;
            if (n4 + n2 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n4 + n2 + 5];
                System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n4);
            }
            block4: for (int i = 0; i < n2; ++i) {
                ReferenceBinding referenceBinding4 = referenceBindingArray3[i];
                for (n = 0; n < n4; ++n) {
                    if (referenceBinding4 == referenceBindingArray2[n]) continue block4;
                }
                referenceBindingArray2[n4++] = referenceBinding4;
            }
        }
        if (!bl) {
            return null;
        }
        SimpleSet simpleSet = null;
        for (n2 = 0; n2 < n4; ++n2) {
            ReferenceBinding referenceBinding5 = referenceBindingArray2[n2];
            if (!referenceBinding5.isValidBinding()) continue;
            TypeBinding typeBinding = referenceBinding5.erasure();
            for (n = n2 + 1; n < n4; ++n) {
                ReferenceBinding referenceBinding6 = referenceBindingArray2[n];
                if (!referenceBinding6.isValidBinding() || referenceBinding6.erasure() != typeBinding) continue;
                if (simpleSet == null) {
                    simpleSet = new SimpleSet(n4);
                }
                simpleSet.add(referenceBindingArray2[n2]);
                simpleSet.add(referenceBindingArray2[n]);
            }
        }
        return simpleSet;
    }

    @Override
    boolean reportIncompatibleReturnTypeError(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && methodBinding2.original().typeVariables != Binding.NO_TYPE_VARIABLES && methodBinding.returnType.erasure().findSuperTypeWithSameErasure(methodBinding2.returnType.erasure()) != null) {
            this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding2, this.type);
            return false;
        }
        return super.reportIncompatibleReturnTypeError(methodBinding, methodBinding2);
    }

    @Override
    void verify(SourceTypeBinding sourceTypeBinding) {
        if (sourceTypeBinding.isAnnotationType()) {
            sourceTypeBinding.detectAnnotationCycle();
        }
        super.verify(sourceTypeBinding);
        int n = sourceTypeBinding.typeVariables.length;
        while (--n >= 0) {
            TypeVariableBinding typeVariableBinding = sourceTypeBinding.typeVariables[n];
            if (typeVariableBinding.superInterfaces == Binding.NO_SUPERINTERFACES || typeVariableBinding.superInterfaces.length == 1 && typeVariableBinding.superclass.id == 1) continue;
            this.currentMethods = new HashtableOfObject(0);
            ReferenceBinding referenceBinding = typeVariableBinding.superclass();
            if (referenceBinding.kind() == 4100) {
                referenceBinding = (ReferenceBinding)referenceBinding.erasure();
            }
            ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
            ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[referenceBindingArray.length];
            int n2 = referenceBindingArray.length;
            while (--n2 >= 0) {
                referenceBindingArray2[n2] = referenceBindingArray[n2].kind() == 4100 ? (ReferenceBinding)referenceBindingArray[n2].erasure() : referenceBindingArray[n2];
            }
            this.computeInheritedMethods(referenceBinding, referenceBindingArray2);
            this.checkTypeVariableMethods();
        }
    }
}

