/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class WildcardBinding
extends ReferenceBinding {
    ReferenceBinding genericType;
    int rank;
    public TypeBinding bound;
    public TypeBinding[] otherBounds;
    char[] genericSignature;
    public int boundKind;
    ReferenceBinding superclass;
    ReferenceBinding[] superInterfaces;
    TypeVariableBinding typeVariable;
    LookupEnvironment environment;

    public WildcardBinding(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, LookupEnvironment lookupEnvironment) {
        this.genericType = referenceBinding;
        this.rank = n;
        this.boundKind = n2;
        this.modifiers = 0x40000001;
        this.environment = lookupEnvironment;
        this.initialize(referenceBinding, typeBinding, typeBindingArray);
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)referenceBinding).addWrapper(this);
        }
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)typeBinding).addWrapper(this);
        }
        this.tagBits |= 0x1000000L;
    }

    @Override
    public int kind() {
        return 516;
    }

    public boolean boundCheck(TypeBinding typeBinding) {
        switch (this.boundKind) {
            case 0: {
                return true;
            }
            case 1: {
                int n;
                if (typeBinding.isCompatibleWith(this.bound)) {
                    return true;
                }
                int n2 = n = this.otherBounds == null ? 0 : this.otherBounds.length;
                for (int i = 0; i < n; ++i) {
                    if (!typeBinding.isCompatibleWith(this.otherBounds[i])) continue;
                    return true;
                }
                return false;
            }
        }
        return typeBinding.isCompatibleWith(this.bound);
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, Map map, int n) {
        block61: {
            if ((this.tagBits & 0x20000000L) == 0L) {
                return;
            }
            if (typeBinding == TypeBinding.NULL) {
                return;
            }
            if (typeBinding.isCapture()) {
                CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                typeBinding = captureBinding.wildcard;
            }
            block0 : switch (n) {
                case 1: {
                    switch (this.boundKind) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            if (typeBinding.isWildcard()) {
                                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                switch (wildcardBinding.boundKind) {
                                    case 0: {
                                        return;
                                    }
                                    case 1: {
                                        int n2;
                                        this.bound.collectSubstitutes(scope, wildcardBinding.bound, map, 1);
                                        int n3 = n2 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                        for (int i = 0; i < n2; ++i) {
                                            this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], map, 1);
                                        }
                                        return;
                                    }
                                    default: {
                                        return;
                                    }
                                }
                            }
                            this.bound.collectSubstitutes(scope, typeBinding, map, 1);
                            return;
                        }
                        case 2: {
                            if (typeBinding.isWildcard()) {
                                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                switch (wildcardBinding.boundKind) {
                                    case 0: {
                                        return;
                                    }
                                    case 1: {
                                        return;
                                    }
                                    case 2: {
                                        int n4;
                                        this.bound.collectSubstitutes(scope, wildcardBinding.bound, map, 2);
                                        int n5 = n4 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                        for (int i = 0; i < n4; ++i) {
                                            this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], map, 2);
                                        }
                                        return;
                                    }
                                }
                                return;
                            }
                            this.bound.collectSubstitutes(scope, typeBinding, map, 2);
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 0: {
                    switch (this.boundKind) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            if (!typeBinding.isWildcard()) return;
                            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                            switch (wildcardBinding.boundKind) {
                                case 0: {
                                    return;
                                }
                                case 1: {
                                    int n6;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, map, 0);
                                    int n7 = n6 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n6; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], map, 0);
                                    }
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                        case 2: {
                            if (!typeBinding.isWildcard()) return;
                            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                            switch (wildcardBinding.boundKind) {
                                case 0: {
                                    return;
                                }
                                case 1: {
                                    return;
                                }
                                case 2: {
                                    int n8;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, map, 0);
                                    int n9 = n8 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n8; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], map, 0);
                                    }
                                    break;
                                }
                            }
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 2: {
                    switch (this.boundKind) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            if (!typeBinding.isWildcard()) return;
                            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                            switch (wildcardBinding.boundKind) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    int n10;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, map, 2);
                                    int n11 = n10 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n10; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], map, 2);
                                    }
                                    break block61;
                                }
                                default: {
                                    break;
                                }
                            }
                            break block61;
                        }
                        case 2: {
                            if (!typeBinding.isWildcard()) return;
                            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                            switch (wildcardBinding.boundKind) {
                                case 0: {
                                    break block0;
                                }
                                case 1: {
                                    break block0;
                                }
                                case 2: {
                                    int n12;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, map, 2);
                                    int n13 = n12 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n12; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], map, 2);
                                    }
                                    break block0;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        char[] cArray;
        char[] cArray2 = this.genericType.computeUniqueKey(false);
        switch (this.boundKind) {
            case 0: {
                cArray = TypeConstants.WILDCARD_STAR;
                break;
            }
            case 1: {
                cArray = CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.bound.computeUniqueKey(false));
                break;
            }
            default: {
                cArray = CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.bound.computeUniqueKey(false));
            }
        }
        return CharOperation.concat(cArray2, cArray);
    }

    @Override
    public char[] constantPoolName() {
        return this.erasure().constantPoolName();
    }

    @Override
    public String debugName() {
        return this.toString();
    }

    @Override
    public TypeBinding erasure() {
        if (this.otherBounds == null) {
            if (this.boundKind == 1) {
                return this.bound.erasure();
            }
            return this.typeVariable().erasure();
        }
        return this.bound.id == 1 ? this.otherBounds[0].erasure() : this.bound.erasure();
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericSignature == null) {
            switch (this.boundKind) {
                case 0: {
                    this.genericSignature = TypeConstants.WILDCARD_STAR;
                    break;
                }
                case 1: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.bound.genericTypeSignature());
                    break;
                }
                default: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.bound.genericTypeSignature());
                }
            }
        }
        return this.genericSignature;
    }

    @Override
    public int hashCode() {
        return this.genericType.hashCode();
    }

    void initialize(ReferenceBinding referenceBinding, TypeBinding typeBinding, TypeBinding[] typeBindingArray) {
        this.genericType = referenceBinding;
        this.bound = typeBinding;
        this.otherBounds = typeBindingArray;
        if (referenceBinding != null) {
            this.fPackage = referenceBinding.getPackage();
        }
        if (typeBinding != null) {
            this.tagBits |= typeBinding.tagBits & 0x20000000L;
        }
    }

    @Override
    public boolean isSuperclassOf(ReferenceBinding referenceBinding) {
        if (this.boundKind == 2) {
            if (this.bound instanceof ReferenceBinding) {
                return ((ReferenceBinding)this.bound).isSuperclassOf(referenceBinding);
            }
            return referenceBinding.id == 1;
        }
        return false;
    }

    @Override
    public boolean isIntersectionType() {
        return this.otherBounds != null;
    }

    @Override
    public boolean isUnboundWildcard() {
        return this.boundKind == 0;
    }

    @Override
    public boolean isWildcard() {
        return true;
    }

    @Override
    public char[] readableName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                int n;
                if (this.otherBounds == null) {
                    return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.readableName());
                }
                StringBuffer stringBuffer = new StringBuffer(10);
                stringBuffer.append(this.bound.readableName());
                int n2 = this.otherBounds.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('&').append(this.otherBounds[n].readableName());
                }
                n = stringBuffer.length();
                char[] cArray = new char[n];
                stringBuffer.getChars(0, n, cArray, 0);
                return cArray;
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.readableName());
    }

    ReferenceBinding resolve() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this;
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        BinaryTypeBinding.resolveType(this.genericType, this.environment, null, 0);
        switch (this.boundKind) {
            case 1: 
            case 2: {
                BinaryTypeBinding.resolveType(this.bound, this.environment, null, 0);
                break;
            }
        }
        return this;
    }

    @Override
    public char[] shortReadableName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                int n;
                if (this.otherBounds == null) {
                    return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.shortReadableName());
                }
                StringBuffer stringBuffer = new StringBuffer(10);
                stringBuffer.append(this.bound.shortReadableName());
                int n2 = this.otherBounds.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('&').append(this.otherBounds[n].shortReadableName());
                }
                n = stringBuffer.length();
                char[] cArray = new char[n];
                stringBuffer.getChars(0, n, cArray, 0);
                return cArray;
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.shortReadableName());
    }

    @Override
    public char[] signature() {
        if (this.signature == null) {
            switch (this.boundKind) {
                case 1: {
                    return this.bound.signature();
                }
            }
            return this.typeVariable().signature();
        }
        return this.signature;
    }

    @Override
    public char[] sourceName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.sourceName());
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.sourceName());
    }

    @Override
    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            TypeBinding typeBinding = null;
            if (this.boundKind == 1 && !this.bound.isInterface()) {
                typeBinding = this.bound;
            } else {
                TypeVariableBinding typeVariableBinding = this.typeVariable();
                if (typeVariableBinding != null) {
                    typeBinding = typeVariableBinding.firstBound;
                }
            }
            this.superclass = typeBinding instanceof ReferenceBinding && !typeBinding.isInterface() ? (ReferenceBinding)typeBinding : this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
        }
        return this.superclass;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            this.superInterfaces = this.typeVariable() != null ? this.typeVariable.superInterfaces() : Binding.NO_SUPERINTERFACES;
            if (this.boundKind == 1) {
                int n;
                if (this.bound.isInterface()) {
                    n = this.superInterfaces.length;
                    this.superInterfaces = new ReferenceBinding[n + 1];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 1, n);
                    this.superInterfaces[0] = (ReferenceBinding)this.bound;
                }
                if (this.otherBounds != null) {
                    n = this.superInterfaces.length;
                    int n2 = this.otherBounds.length;
                    this.superInterfaces = new ReferenceBinding[n + n2];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 0, n);
                    for (int i = 0; i < n2; ++i) {
                        this.superInterfaces[n + i] = (ReferenceBinding)this.otherBounds[i];
                    }
                }
            }
        }
        return this.superInterfaces;
    }

    public ReferenceBinding[] superInterfaces2() {
        if (this.superInterfaces == null) {
            if (this.boundKind == 1) {
                if (this.bound.isInterface()) {
                    if (this.otherBounds != null) {
                        int n = this.otherBounds.length;
                        this.superInterfaces = new ReferenceBinding[n + 1];
                        System.arraycopy(this.otherBounds, 0, this.superInterfaces, 1, n);
                        this.superInterfaces[0] = (ReferenceBinding)this.bound;
                    } else {
                        this.superInterfaces = new ReferenceBinding[]{(ReferenceBinding)this.bound};
                    }
                } else if (this.otherBounds != null) {
                    int n = this.otherBounds.length;
                    this.superInterfaces = new ReferenceBinding[n];
                    System.arraycopy(this.otherBounds, 0, this.superInterfaces, 0, n);
                } else {
                    this.superInterfaces = Binding.NO_SUPERINTERFACES;
                }
            } else {
                this.superInterfaces = Binding.NO_SUPERINTERFACES;
            }
        }
        return this.superInterfaces;
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        boolean bl = false;
        if (this.genericType == unresolvedReferenceBinding) {
            this.genericType = referenceBinding;
            bl = true;
        } else if (this.bound == unresolvedReferenceBinding) {
            this.bound = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
            bl = true;
        }
        if (bl) {
            this.initialize(this.genericType, this.bound, this.otherBounds);
        }
    }

    public String toString() {
        switch (this.boundKind) {
            case 0: {
                return new String(TypeConstants.WILDCARD_NAME);
            }
            case 1: {
                if (this.otherBounds == null) {
                    return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.debugName().toCharArray()));
                }
                StringBuffer stringBuffer = new StringBuffer(this.bound.debugName());
                int n = this.otherBounds.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append('&').append(this.otherBounds[i].debugName());
                }
                return stringBuffer.toString();
            }
        }
        return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.debugName().toCharArray()));
    }

    public TypeVariableBinding typeVariable() {
        TypeVariableBinding[] typeVariableBindingArray;
        if (this.typeVariable == null && this.rank < (typeVariableBindingArray = this.genericType.typeVariables()).length) {
            this.typeVariable = typeVariableBindingArray[this.rank];
        }
        return this.typeVariable;
    }
}

