/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class ObjectVector {
    static int INITIAL_SIZE = 10;
    public int size;
    int maxSize;
    Object[] elements;

    public ObjectVector() {
        this(INITIAL_SIZE);
    }

    public ObjectVector(int n) {
        this.maxSize = n > 0 ? n : INITIAL_SIZE;
        this.size = 0;
        this.elements = new Object[this.maxSize];
    }

    public void add(Object object) {
        if (this.size == this.maxSize) {
            this.elements = new Object[this.maxSize *= 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        this.elements[this.size++] = object;
    }

    public void addAll(Object[] objectArray) {
        if (this.size + objectArray.length >= this.maxSize) {
            this.maxSize = this.size + objectArray.length;
            this.elements = new Object[this.maxSize];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        System.arraycopy(objectArray, 0, this.elements, this.size, objectArray.length);
        this.size += objectArray.length;
    }

    public void addAll(ObjectVector objectVector) {
        if (this.size + objectVector.size >= this.maxSize) {
            this.maxSize = this.size + objectVector.size;
            this.elements = new Object[this.maxSize];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
        }
        System.arraycopy(objectVector.elements, 0, this.elements, this.size, objectVector.size);
        this.size += objectVector.size;
    }

    public boolean containsIdentical(Object object) {
        int n = this.size;
        while (--n >= 0) {
            if (object != this.elements[n]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object object) {
        int n = this.size;
        while (--n >= 0) {
            if (!object.equals(this.elements[n])) continue;
            return true;
        }
        return false;
    }

    public void copyInto(Object[] objectArray) {
        this.copyInto(objectArray, 0);
    }

    public void copyInto(Object[] objectArray, int n) {
        System.arraycopy(this.elements, 0, objectArray, n, this.size);
    }

    public Object elementAt(int n) {
        return this.elements[n];
    }

    public Object find(Object object) {
        int n = this.size;
        while (--n >= 0) {
            if (!object.equals(this.elements[n])) continue;
            return object;
        }
        return null;
    }

    public Object remove(Object object) {
        int n = this.size;
        while (--n >= 0) {
            if (!object.equals(this.elements[n])) continue;
            System.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
            this.elements[this.size] = null;
            return object;
        }
        return null;
    }

    public void removeAll() {
        int n = this.size;
        while (--n >= 0) {
            this.elements[n] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.size; ++i) {
            string = string + this.elements[i].toString() + "\n";
        }
        return string;
    }
}

