/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class SimpleLookupTable
implements Cloneable {
    public Object[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    public int threshold;

    public SimpleLookupTable() {
        this(13);
    }

    public SimpleLookupTable(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.5f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new Object[n2];
        this.valueTable = new Object[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleLookupTable simpleLookupTable = (SimpleLookupTable)super.clone();
        simpleLookupTable.elementSize = this.elementSize;
        simpleLookupTable.threshold = this.threshold;
        int n = this.keyTable.length;
        simpleLookupTable.keyTable = new Object[n];
        System.arraycopy(this.keyTable, 0, simpleLookupTable.keyTable, 0, n);
        n = this.valueTable.length;
        simpleLookupTable.valueTable = new Object[n];
        System.arraycopy(this.valueTable, 0, simpleLookupTable.valueTable, 0, n);
        return simpleLookupTable;
    }

    public boolean containsKey(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public Object get(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public Object keyForValue(Object object) {
        if (object != null) {
            int n = this.keyTable.length;
            for (int i = 0; i < n; ++i) {
                if (this.keyTable[i] == null || !object.equals(this.valueTable[i])) continue;
                return this.keyTable[i];
            }
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object3 = this.keyTable[n2]) != null) {
            if (object3.equals(object)) {
                this.valueTable[n2] = object2;
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = object;
        this.valueTable[n2] = object2;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object2;
    }

    public Object removeKey(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                --this.elementSize;
                Object object3 = this.valueTable[n2];
                this.keyTable[n2] = null;
                this.valueTable[n2] = null;
                if (this.keyTable[n2 + 1 == n ? 0 : n2 + 1] != null) {
                    this.rehash();
                }
                return object3;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public void removeValue(Object object) {
        boolean bl = false;
        int n = this.valueTable.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = this.valueTable[i];
            if (object2 == null || !object2.equals(object)) continue;
            --this.elementSize;
            this.keyTable[i] = null;
            this.valueTable[i] = null;
            if (bl || this.keyTable[i + 1 == n ? 0 : i + 1] == null) continue;
            bl = true;
        }
        if (bl) {
            this.rehash();
        }
    }

    private void rehash() {
        SimpleLookupTable simpleLookupTable = new SimpleLookupTable(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            Object object = this.keyTable[n];
            if (object == null) continue;
            simpleLookupTable.put(object, this.valueTable[n]);
        }
        this.keyTable = simpleLookupTable.keyTable;
        this.valueTable = simpleLookupTable.valueTable;
        this.elementSize = simpleLookupTable.elementSize;
        this.threshold = simpleLookupTable.threshold;
    }

    public String toString() {
        String string = "";
        int n = this.valueTable.length;
        for (int i = 0; i < n; ++i) {
            Object object = this.valueTable[i];
            if (object == null) continue;
            string = string + this.keyTable[i].toString() + " -> " + object.toString() + "\n";
        }
        return string;
    }
}

