/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.lang.reflect.Method;
import org.jdom.output.EscapeStrategy;

public class Format
implements Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Format.java,v $ $Revision: 1.10 $ $Date: 2004/09/07 06:37:20 $ $Name: jdom_1_0 $";
    private static final String STANDARD_INDENT = "  ";
    private static final String STANDARD_LINE_SEPARATOR = "\r\n";
    private static final String STANDARD_ENCODING = "UTF-8";
    String indent = null;
    String lineSeparator = "\r\n";
    String encoding = "UTF-8";
    boolean omitDeclaration = false;
    boolean omitEncoding = false;
    boolean expandEmptyElements = false;
    boolean ignoreTrAXEscapingPIs = false;
    TextMode mode = TextMode.PRESERVE;
    EscapeStrategy escapeStrategy = new DefaultEscapeStrategy(this.encoding);

    public static Format getRawFormat() {
        return new Format();
    }

    public static Format getPrettyFormat() {
        Format format = new Format();
        format.setIndent(STANDARD_INDENT);
        format.setTextMode(TextMode.TRIM);
        return format;
    }

    public static Format getCompactFormat() {
        Format format = new Format();
        format.setTextMode(TextMode.NORMALIZE);
        return format;
    }

    private Format() {
    }

    public Format setEscapeStrategy(EscapeStrategy escapeStrategy) {
        this.escapeStrategy = escapeStrategy;
        return this;
    }

    public EscapeStrategy getEscapeStrategy() {
        return this.escapeStrategy;
    }

    public Format setLineSeparator(String string) {
        this.lineSeparator = string;
        return this;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public Format setOmitEncoding(boolean bl) {
        this.omitEncoding = bl;
        return this;
    }

    public boolean getOmitEncoding() {
        return this.omitEncoding;
    }

    public Format setOmitDeclaration(boolean bl) {
        this.omitDeclaration = bl;
        return this;
    }

    public boolean getOmitDeclaration() {
        return this.omitDeclaration;
    }

    public Format setExpandEmptyElements(boolean bl) {
        this.expandEmptyElements = bl;
        return this;
    }

    public boolean getExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public void setIgnoreTrAXEscapingPIs(boolean bl) {
        this.ignoreTrAXEscapingPIs = bl;
    }

    public boolean getIgnoreTrAXEscapingPIs() {
        return this.ignoreTrAXEscapingPIs;
    }

    public Format setTextMode(TextMode textMode) {
        this.mode = textMode;
        return this;
    }

    public TextMode getTextMode() {
        return this.mode;
    }

    public Format setIndent(String string) {
        if ("".equals(string)) {
            string = null;
        }
        this.indent = string;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public Format setEncoding(String string) {
        this.encoding = string;
        this.escapeStrategy = new DefaultEscapeStrategy(string);
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected Object clone() {
        Format format = null;
        try {
            format = (Format)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return format;
    }

    public static class TextMode {
        public static final TextMode PRESERVE = new TextMode("PRESERVE");
        public static final TextMode TRIM = new TextMode("TRIM");
        public static final TextMode NORMALIZE = new TextMode("NORMALIZE");
        public static final TextMode TRIM_FULL_WHITE = new TextMode("TRIM_FULL_WHITE");
        private final String name;

        private TextMode(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    class DefaultEscapeStrategy
    implements EscapeStrategy {
        private int bits;
        Object encoder;
        Method canEncode;

        public DefaultEscapeStrategy(String string) {
            if (Format.STANDARD_ENCODING.equalsIgnoreCase(string) || "UTF-16".equalsIgnoreCase(string)) {
                this.bits = 16;
            } else if ("ISO-8859-1".equalsIgnoreCase(string) || "Latin1".equalsIgnoreCase(string)) {
                this.bits = 8;
            } else if ("US-ASCII".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
                this.bits = 7;
            } else {
                this.bits = 0;
                try {
                    Class<?> clazz = Class.forName("java.nio.charset.Charset");
                    Class<?> clazz2 = Class.forName("java.nio.charset.CharsetEncoder");
                    Method method = clazz.getMethod("forName", String.class);
                    Object object = method.invoke(null, string);
                    Method method2 = clazz.getMethod("newEncoder", null);
                    this.encoder = method2.invoke(object, null);
                    this.canEncode = clazz2.getMethod("canEncode", Character.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean shouldEscape(char c) {
            if (this.bits == 16) {
                return false;
            }
            if (this.bits == 8) {
                return c > '\u00ff';
            }
            if (this.bits == 7) {
                return c > '\u007f';
            }
            if (this.canEncode != null && this.encoder != null) {
                try {
                    Boolean bl = (Boolean)this.canEncode.invoke(this.encoder, new Character(c));
                    return bl == false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

