/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.net.URLEncoder;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.ObjectUtilities;

public class StandardCategoryURLGenerator
implements CategoryURLGenerator,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2276668053074881909L;
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String categoryParameterName = "category";

    public StandardCategoryURLGenerator() {
    }

    public StandardCategoryURLGenerator(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        this.prefix = string;
    }

    public StandardCategoryURLGenerator(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Null 'seriesParameterName' argument.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Null 'categoryParameterName' argument.");
        }
        this.prefix = string;
        this.seriesParameterName = string2;
        this.categoryParameterName = string3;
    }

    @Override
    public String generateURL(CategoryDataset categoryDataset, int n, int n2) {
        String string = this.prefix;
        Comparable comparable = categoryDataset.getRowKey(n);
        Comparable comparable2 = categoryDataset.getColumnKey(n2);
        boolean bl = string.indexOf("?") == -1;
        string = string + (bl ? "?" : "&amp;");
        string = string + this.seriesParameterName + "=" + URLEncoder.encode(comparable.toString());
        string = string + "&amp;" + this.categoryParameterName + "=" + URLEncoder.encode(comparable2.toString());
        return string;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardCategoryURLGenerator)) {
            return false;
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = (StandardCategoryURLGenerator)object;
        if (!ObjectUtilities.equal(this.prefix, standardCategoryURLGenerator.prefix)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesParameterName, standardCategoryURLGenerator.seriesParameterName)) {
            return false;
        }
        return ObjectUtilities.equal(this.categoryParameterName, standardCategoryURLGenerator.categoryParameterName);
    }

    public int hashCode() {
        int n = this.prefix != null ? this.prefix.hashCode() : 0;
        n = 29 * n + (this.seriesParameterName != null ? this.seriesParameterName.hashCode() : 0);
        n = 29 * n + (this.categoryParameterName != null ? this.categoryParameterName.hashCode() : 0);
        return n;
    }
}

