/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;

public class DefaultPieDataset
extends AbstractDataset
implements PieDataset,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 2904745139106540618L;
    private DefaultKeyedValues data;

    public DefaultPieDataset() {
        this.data = new DefaultKeyedValues();
    }

    public DefaultPieDataset(KeyedValues keyedValues) {
        if (keyedValues == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        this.data = new DefaultKeyedValues();
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            this.data.addValue(keyedValues.getKey(i), keyedValues.getValue(i));
        }
    }

    @Override
    public int getItemCount() {
        return this.data.getItemCount();
    }

    @Override
    public List getKeys() {
        return Collections.unmodifiableList(this.data.getKeys());
    }

    @Override
    public Comparable getKey(int n) {
        return this.data.getKey(n);
    }

    @Override
    public int getIndex(Comparable comparable) {
        return this.data.getIndex(comparable);
    }

    @Override
    public Number getValue(int n) {
        Number number = null;
        if (this.getItemCount() > n) {
            number = this.data.getValue(n);
        }
        return number;
    }

    @Override
    public Number getValue(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return this.data.getValue(comparable);
    }

    public void setValue(Comparable comparable, Number number) {
        this.data.setValue(comparable, number);
        this.fireDatasetChanged();
    }

    public void setValue(Comparable comparable, double d) {
        this.setValue(comparable, new Double(d));
    }

    public void remove(Comparable comparable) {
        this.data.removeValue(comparable);
        this.fireDatasetChanged();
    }

    public void clear() {
        if (this.getItemCount() > 0) {
            this.data.clear();
            this.fireDatasetChanged();
        }
    }

    public void sortByKeys(SortOrder sortOrder) {
        this.data.sortByKeys(sortOrder);
        this.fireDatasetChanged();
    }

    public void sortByValues(SortOrder sortOrder) {
        this.data.sortByValues(sortOrder);
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PieDataset)) {
            return false;
        }
        PieDataset pieDataset = (PieDataset)object;
        int n = this.getItemCount();
        if (pieDataset.getItemCount() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i);
            if (!comparable2.equals(comparable = pieDataset.getKey(i))) {
                return false;
            }
            Number number = this.getValue(i);
            Number number2 = pieDataset.getValue(i);
            if (!(number == null ? number2 != null : !number.equals(number2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultPieDataset defaultPieDataset = (DefaultPieDataset)super.clone();
        defaultPieDataset.data = (DefaultKeyedValues)this.data.clone();
        return defaultPieDataset;
    }
}

