/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.general.Series;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValue;
import org.jfree.util.ObjectUtilities;

public class TimePeriodValues
extends Series
implements Serializable {
    static final long serialVersionUID = -2210593619794989709L;
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    private List data;
    private int minStartIndex = -1;
    private int maxStartIndex = -1;
    private int minMiddleIndex = -1;
    private int maxMiddleIndex = -1;
    private int minEndIndex = -1;
    private int maxEndIndex = -1;

    public TimePeriodValues(String string) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION);
    }

    public TimePeriodValues(String string, String string2, String string3) {
        super((Comparable)((Object)string));
        this.domain = string2;
        this.range = string3;
        this.data = new ArrayList();
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string) {
        String string2 = this.domain;
        this.domain = string;
        this.firePropertyChange("Domain", string2, string);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string) {
        String string2 = this.range;
        this.range = string;
        this.firePropertyChange("Range", string2, string);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public TimePeriodValue getDataItem(int n) {
        return (TimePeriodValue)this.data.get(n);
    }

    public TimePeriod getTimePeriod(int n) {
        return this.getDataItem(n).getPeriod();
    }

    public Number getValue(int n) {
        return this.getDataItem(n).getValue();
    }

    public void add(TimePeriodValue timePeriodValue) {
        if (timePeriodValue == null) {
            throw new IllegalArgumentException("Null item not allowed.");
        }
        this.data.add(timePeriodValue);
        this.updateBounds(timePeriodValue.getPeriod(), this.data.size() - 1);
        this.fireSeriesChanged();
    }

    private void updateBounds(TimePeriod timePeriod, int n) {
        long l;
        long l2;
        long l3;
        long l4 = timePeriod.getStart().getTime();
        long l5 = timePeriod.getEnd().getTime();
        long l6 = l4 + (l5 - l4) / 2L;
        if (this.minStartIndex >= 0) {
            l3 = this.getDataItem(this.minStartIndex).getPeriod().getStart().getTime();
            if (l4 < l3) {
                this.minStartIndex = n;
            }
        } else {
            this.minStartIndex = n;
        }
        if (this.maxStartIndex >= 0) {
            l3 = this.getDataItem(this.maxStartIndex).getPeriod().getStart().getTime();
            if (l4 > l3) {
                this.maxStartIndex = n;
            }
        } else {
            this.maxStartIndex = n;
        }
        if (this.minMiddleIndex >= 0) {
            l3 = this.getDataItem(this.minMiddleIndex).getPeriod().getStart().getTime();
            l = l3 + ((l2 = this.getDataItem(this.minMiddleIndex).getPeriod().getEnd().getTime()) - l3) / 2L;
            if (l6 < l) {
                this.minMiddleIndex = n;
            }
        } else {
            this.minMiddleIndex = n;
        }
        if (this.maxMiddleIndex >= 0) {
            l3 = this.getDataItem(this.minMiddleIndex).getPeriod().getStart().getTime();
            l = l3 + ((l2 = this.getDataItem(this.minMiddleIndex).getPeriod().getEnd().getTime()) - l3) / 2L;
            if (l6 > l) {
                this.maxMiddleIndex = n;
            }
        } else {
            this.maxMiddleIndex = n;
        }
        if (this.minEndIndex >= 0) {
            l3 = this.getDataItem(this.minEndIndex).getPeriod().getEnd().getTime();
            if (l5 < l3) {
                this.minEndIndex = n;
            }
        } else {
            this.minEndIndex = n;
        }
        if (this.maxEndIndex >= 0) {
            l3 = this.getDataItem(this.maxEndIndex).getPeriod().getEnd().getTime();
            if (l5 > l3) {
                this.maxEndIndex = n;
            }
        } else {
            this.maxEndIndex = n;
        }
    }

    private void recalculateBounds() {
        this.minStartIndex = -1;
        this.minMiddleIndex = -1;
        this.minEndIndex = -1;
        this.maxStartIndex = -1;
        this.maxMiddleIndex = -1;
        this.maxEndIndex = -1;
        for (int i = 0; i < this.data.size(); ++i) {
            TimePeriodValue timePeriodValue = (TimePeriodValue)this.data.get(i);
            this.updateBounds(timePeriodValue.getPeriod(), i);
        }
    }

    public void add(TimePeriod timePeriod, double d) {
        TimePeriodValue timePeriodValue = new TimePeriodValue(timePeriod, d);
        this.add(timePeriodValue);
    }

    public void add(TimePeriod timePeriod, Number number) {
        TimePeriodValue timePeriodValue = new TimePeriodValue(timePeriod, number);
        this.add(timePeriodValue);
    }

    public void update(int n, Number number) {
        TimePeriodValue timePeriodValue = this.getDataItem(n);
        timePeriodValue.setValue(number);
        this.fireSeriesChanged();
    }

    public void delete(int n, int n2) {
        for (int i = 0; i <= n2 - n; ++i) {
            this.data.remove(n);
        }
        this.recalculateBounds();
        this.fireSeriesChanged();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimePeriodValues)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TimePeriodValues timePeriodValues = (TimePeriodValues)object;
        if (!ObjectUtilities.equal(this.getDomainDescription(), timePeriodValues.getDomainDescription())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getRangeDescription(), timePeriodValues.getRangeDescription())) {
            return false;
        }
        int n = this.getItemCount();
        if (n != timePeriodValues.getItemCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getDataItem(i).equals(timePeriodValues.getDataItem(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.domain != null ? this.domain.hashCode() : 0;
        n = 29 * n + (this.range != null ? this.range.hashCode() : 0);
        n = 29 * n + this.data.hashCode();
        n = 29 * n + this.minStartIndex;
        n = 29 * n + this.maxStartIndex;
        n = 29 * n + this.minMiddleIndex;
        n = 29 * n + this.maxMiddleIndex;
        n = 29 * n + this.minEndIndex;
        n = 29 * n + this.maxEndIndex;
        return n;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TimePeriodValues timePeriodValues = this.createCopy(0, this.getItemCount() - 1);
        return timePeriodValues;
    }

    public TimePeriodValues createCopy(int n, int n2) throws CloneNotSupportedException {
        TimePeriodValues timePeriodValues = (TimePeriodValues)super.clone();
        timePeriodValues.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i = n; i <= n2; ++i) {
                TimePeriodValue timePeriodValue = (TimePeriodValue)this.data.get(i);
                TimePeriodValue timePeriodValue2 = (TimePeriodValue)timePeriodValue.clone();
                try {
                    timePeriodValues.add(timePeriodValue2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    System.err.println("Failed to add cloned item.");
                }
            }
        }
        return timePeriodValues;
    }

    public int getMinStartIndex() {
        return this.minStartIndex;
    }

    public int getMaxStartIndex() {
        return this.maxStartIndex;
    }

    public int getMinMiddleIndex() {
        return this.minMiddleIndex;
    }

    public int getMaxMiddleIndex() {
        return this.maxMiddleIndex;
    }

    public int getMinEndIndex() {
        return this.minEndIndex;
    }

    public int getMaxEndIndex() {
        return this.maxEndIndex;
    }
}

