/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDSpinner;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;

public class EditInteiro
extends EditCampo {
    private static Inteiro vazio = new Inteiro("EditInteiro");
    private JSpinner componente;
    private SpinnerNumberModel model;
    int valorInicial;
    int valorMinimo;
    int valorMaximo;
    int valorStep;

    public EditInteiro() {
        super(vazio);
    }

    public EditInteiro(Informacao informacao) {
        super(informacao);
    }

    @Override
    public void setInformacao(Informacao informacao) {
        if (this.componente == null) {
            this.model = new SpinnerNumberModel(0, 0, 10000, 1);
            this.componente = new PPGDSpinner(this.model);
            this.model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    EditInteiro.this.setIdentificacaoFoco(false);
                    Integer n = (Integer)EditInteiro.this.componente.getValue();
                    EditInteiro.this.getInformacao().setConteudo(n.toString());
                }
            });
            ((JSpinner.DefaultEditor)this.componente.getEditor()).getTextField().addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    EditInteiro.this.setIdentificacaoFoco(false);
                    String string = ((JSpinner.DefaultEditor)EditInteiro.this.componente.getEditor()).getTextField().getText();
                    EditInteiro.this.getInformacao().setConteudo(string);
                }
            });
        }
        Inteiro inteiro = (Inteiro)this.getInformacao();
        int n = inteiro.asInteger();
        this.componente.setValue(new Integer(n));
        ((PPGDSpinner)this.componente).setInformacao(informacao);
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.getInformacao().setObservadoresAtivos(false);
        this.setObservadorAtivo(false);
        this.componente.setValue(new Integer(((Inteiro)this.getInformacao()).asInteger()));
        this.getInformacao().setObservadoresAtivos(true);
        this.setObservadorAtivo(true);
    }

    @Override
    protected void readOnlyPropertyChange(boolean bl) {
        if (bl) {
            this.componente.setEnabled(false);
        } else {
            this.componente.setEnabled(true);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean bl) {
        this.componente.setEnabled(bl);
        this.labelCampo.setEnabled(bl);
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.componente;
    }

    public void configurarLimites(int n, int n2, int n3) {
        this.model.setMaximum(new Integer(n2));
        this.model.setMinimum(new Integer(n));
        this.model.setStepSize(new Integer(n3));
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.componente;
    }

    @Override
    public void setPerdeFocoComEnter(boolean bl) {
        this.isPerdeFocoComEnter = bl;
        if (this.isPerdeFocoComEnter()) {
            this.aplicaTransfereFocoEnter();
        } else {
            this.removeTransfereFocoEnter();
        }
    }
}

