/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosBens
extends Observador {
    private Bens bens = null;

    public CalculosBens(Bens bens) {
        this.bens = bens;
    }

    @Override
    public void notifica(Object object, String string, Object object2, Object object3) {
        if (string != null) {
            if (string.equals("ObjetoInserido")) {
                ((Bem)object3).getValorExercicioAtual().addObservador(this);
                ((Bem)object3).getValorExercicioAnterior().addObservador(this);
            } else if (string.equals("ObjetoRemovido")) {
                ((Bem)object3).getValorExercicioAtual().removeObservador(this);
                ((Bem)object3).getValorExercicioAnterior().removeObservador(this);
            }
        }
        this.calculaTotalExercicioAtual();
        this.calculaTotalExercicioAnterior();
    }

    private void calculaTotalExercicioAtual() {
        Valor valor = new Valor();
        this.bens.getTotalExercicioAtual().clear();
        for (Bem bem : this.bens.recuperarLista()) {
            valor.append('+', bem.getValorExercicioAtual());
        }
        this.bens.getTotalExercicioAtual().setConteudo(valor);
    }

    private void calculaTotalExercicioAnterior() {
        Valor valor = new Valor();
        for (Bem bem : this.bens.recuperarLista()) {
            valor.append('+', bem.getValorExercicioAnterior());
        }
        this.bens.getTotalExercicioAnterior().setConteudo(valor);
    }
}

