/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dividas;

import java.util.List;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Divida
extends ObjetoNegocio {
    public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
    private Codigo codigo = new Codigo(this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoDividas());
    private Alfa discriminacao = new Alfa(this, "Discrimina\u00e7\u00e3o", 120);
    private Valor valorExercicioAnterior = new Valor(this, NOME_CAMPO_VALOR_ANTERIOR);
    private Valor valorExercicioAtual = new Valor(this, NOME_CAMPO_VALOR_ATUAL);
    private Valor valorPagamentoAnual = new Valor(this, "Valor de pagamento anual");

    public Divida() {
        this.getCodigo().setColunaFiltro(1);
        this.getCodigo().addValidador(new ValidadorNaoNulo(3, this.tab.msg("divida_codigo")));
        this.getDiscriminacao().addValidador(new ValidadorNaoNulo(3, this.tab.msg("divida_discriminacao")));
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public Valor getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public Valor getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    public Valor getPagamentoAnual() {
        return this.valorPagamentoAnual;
    }

    @Override
    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.discriminacao);
        list.add(this.valorExercicioAtual);
        list.add(this.valorExercicioAnterior);
        return list;
    }

    @Override
    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List verificarPendencias(int n) {
        List list = super.verificarPendencias(n);
        if (this.getValorExercicioAtual().isVazio() && this.getValorExercicioAnterior().isVazio()) {
            Pendencia pendencia = new Pendencia(2, this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), this.tab.msg("divida_valor_nao_informado"), n);
            list.add(pendencia);
        }
        return list;
    }
}

