/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class Operacoes
extends ObjetoNegocio {
    public static final String PROP_BASE_CALC = "BASE CALCULO";
    private Valor mercadoVistaAcoes = new Valor(this, "");
    private Valor mercadoVistaOuro = new Valor(this, "");
    private Valor mercadoVistaForaBolsa = new Valor(this, "");
    private Valor mercadoOpcoesAcoes = new Valor(this, "");
    private Valor mercadoOpcoesOuro = new Valor(this, "");
    private Valor mercadoOpcoesForaDeBolsa = new Valor(this, "");
    private Valor mercadoOpcoesOutros = new Valor(this, "");
    private Valor mercadoFuturoDolar = new Valor(this, "");
    private Valor mercadoFuturoIndices = new Valor(this, "");
    private Valor mercadoFuturoJuros = new Valor(this, "");
    private Valor mercadoFuturoOutros = new Valor(this, "");
    private Valor mercadoTermoAcoes = new Valor(this, "");
    private Valor mercadoTermoOutros = new Valor(this, "");
    private Valor resultadoLiquidoMes = new Valor(this, "");
    private Valor resultadoNegativoMesAnterior = new Valor(this, "");
    private Valor baseCalculoImposto = new Valor(this, "BASE CALCULO");
    private Valor prejuizoCompensar = new Valor(this, "");
    private Alfa aliquotaDoImposto = new Alfa(this, "");
    private Valor impostoDevido = new Valor(this, "");
    private String VALOR_ALIQUOTA;

    public Operacoes(String string) {
        this.VALOR_ALIQUOTA = string;
        this.adicionarObservadorValoresMercado(this);
    }

    @Override
    public void notifica(Object object, String string, Object object2, Object object3) {
        this.atualizaOperacoes(this);
    }

    private void adicionarObservadorValoresMercado(Observador observador) {
        this.adicionaObservador(this.mercadoVistaAcoes, observador);
        this.adicionaObservador(this.mercadoVistaOuro, observador);
        this.adicionaObservador(this.mercadoVistaForaBolsa, observador);
        this.adicionaObservador(this.mercadoOpcoesAcoes, observador);
        this.adicionaObservador(this.mercadoTermoOutros, observador);
        this.adicionaObservador(this.mercadoTermoAcoes, observador);
        this.adicionaObservador(this.mercadoFuturoOutros, observador);
        this.adicionaObservador(this.mercadoFuturoJuros, observador);
        this.adicionaObservador(this.mercadoFuturoIndices, observador);
        this.adicionaObservador(this.mercadoFuturoDolar, observador);
        this.adicionaObservador(this.mercadoOpcoesOutros, observador);
        this.adicionaObservador(this.mercadoOpcoesOuro, observador);
        this.adicionaObservador(this.mercadoOpcoesForaDeBolsa, observador);
        this.adicionaObservador(this.resultadoNegativoMesAnterior, observador);
    }

    private void atualizaOperacoes(Operacoes operacoes) {
        Object object;
        Valor valor = new Valor();
        valor.append('+', operacoes.getMercadoVistaAcoes());
        valor.append('+', operacoes.getMercadoVistaOuro());
        valor.append('+', operacoes.getMercadoVistaForaBolsa());
        valor.append('+', operacoes.getMercadoOpcoesAcoes());
        valor.append('+', operacoes.getMercadoOpcoesOuro());
        valor.append('+', operacoes.getMercadoOpcoesForaDeBolsa());
        valor.append('+', operacoes.getMercadoOpcoesOutros());
        valor.append('+', operacoes.getMercadoFuturoDolar());
        valor.append('+', operacoes.getMercadoFuturoIndices());
        valor.append('+', operacoes.getMercadoFuturoJuros());
        valor.append('+', operacoes.getMercadoFuturoOutros());
        valor.append('+', operacoes.getMercadoTermoAcoes());
        valor.append('+', operacoes.getMercadoTermoOutros());
        operacoes.getResultadoLiquidoMes().setConteudo(valor);
        if (operacoes.getResultadoLiquidoMes().comparacao(">", operacoes.getResultadoNegativoMesAnterior())) {
            object = new Valor();
            ((Valor)object).append('+', operacoes.getResultadoLiquidoMes());
            ((Valor)object).append('-', operacoes.getResultadoNegativoMesAnterior());
            operacoes.getBaseCalculoImposto().setConteudo((Valor)object);
            operacoes.getPrejuizoCompensar().clear();
        } else {
            object = new Valor();
            ((Valor)object).append('+', operacoes.getResultadoNegativoMesAnterior());
            ((Valor)object).append('-', operacoes.getResultadoLiquidoMes());
            operacoes.getPrejuizoCompensar().setConteudo((Valor)object);
            operacoes.getBaseCalculoImposto().clear();
        }
        if (operacoes.getBaseCalculoImposto().comparacao(">", "0,00")) {
            object = "0," + this.VALOR_ALIQUOTA;
            operacoes.getImpostoDevido().setConteudo(operacoes.getBaseCalculoImposto().operacao('*', (String)object));
        } else {
            operacoes.getImpostoDevido().clear();
        }
    }

    private void adicionaObservador(Informacao informacao, Observador observador) {
        informacao.addObservador(observador);
    }

    public Alfa getAliquotaDoImposto() {
        return this.aliquotaDoImposto;
    }

    public void setAliquotaDoImposto(Alfa alfa) {
        this.aliquotaDoImposto = alfa;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public Valor getMercadoTermoAcoes() {
        return this.mercadoTermoAcoes;
    }

    public Valor getMercadoTermoOutros() {
        return this.mercadoTermoOutros;
    }

    public Valor getPrejuizoCompensar() {
        return this.prejuizoCompensar;
    }

    public Valor getBaseCalculoImposto() {
        return this.baseCalculoImposto;
    }

    public Valor getMercadoFuturoDolar() {
        return this.mercadoFuturoDolar;
    }

    public Valor getMercadoFuturoIndices() {
        return this.mercadoFuturoIndices;
    }

    public Valor getMercadoFuturoJuros() {
        return this.mercadoFuturoJuros;
    }

    public Valor getMercadoFuturoOutros() {
        return this.mercadoFuturoOutros;
    }

    public Valor getMercadoOpcoesAcoes() {
        return this.mercadoOpcoesAcoes;
    }

    public Valor getMercadoOpcoesForaDeBolsa() {
        return this.mercadoOpcoesForaDeBolsa;
    }

    public Valor getMercadoOpcoesOuro() {
        return this.mercadoOpcoesOuro;
    }

    public Valor getMercadoOpcoesOutros() {
        return this.mercadoOpcoesOutros;
    }

    public Valor getMercadoVistaAcoes() {
        return this.mercadoVistaAcoes;
    }

    public Valor getMercadoVistaForaBolsa() {
        return this.mercadoVistaForaBolsa;
    }

    public Valor getMercadoVistaOuro() {
        return this.mercadoVistaOuro;
    }

    public Valor getResultadoLiquidoMes() {
        return this.resultadoLiquidoMes;
    }

    public Valor getResultadoNegativoMesAnterior() {
        return this.resultadoNegativoMesAnterior;
    }

    @Override
    protected List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    @Override
    public boolean isVazio() {
        boolean bl = true;
        bl = bl && this.mercadoVistaAcoes.isVazio();
        bl = bl && this.mercadoVistaOuro.isVazio();
        bl = bl && this.mercadoVistaForaBolsa.isVazio();
        bl = bl && this.mercadoOpcoesAcoes.isVazio();
        bl = bl && this.mercadoOpcoesOuro.isVazio();
        bl = bl && this.mercadoOpcoesForaDeBolsa.isVazio();
        bl = bl && this.mercadoOpcoesOutros.isVazio();
        bl = bl && this.mercadoFuturoDolar.isVazio();
        bl = bl && this.mercadoFuturoIndices.isVazio();
        bl = bl && this.mercadoFuturoJuros.isVazio();
        bl = bl && this.mercadoFuturoOutros.isVazio();
        bl = bl && this.mercadoTermoAcoes.isVazio();
        bl = bl && this.mercadoTermoOutros.isVazio();
        return bl;
    }
}

