/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ListaPPGD;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.LogPPGD;

public abstract class Colecao
extends ObjetoNegocio {
    private List lista;
    protected Class tipoItens = null;
    private int tamanho = 0;
    private PropertyChangeSupport observadoresLista = new PropertyChangeSupport(this);
    private boolean observadoresListaAtivos = true;
    public static final String OBJETO_INSERIDO = "ObjetoInserido";
    public static final String OBJETO_A_REMOVER = "ObjetoAremover";
    public static final String OBJETO_REMOVIDO = "ObjetoRemovido";

    public Colecao(IdDeclaracao idDeclaracao) {
        super(idDeclaracao);
        this.setTipoItens(null);
    }

    public Colecao() {
        this.setTipoItens(null);
    }

    public Colecao(IdDeclaracao idDeclaracao, String string) {
        this(idDeclaracao);
        this.setTipoItens(string);
    }

    public Colecao(String string) {
        this.setTipoItens(string);
    }

    public Colecao(IdDeclaracao idDeclaracao, String string, int n) {
        this(idDeclaracao, string);
        this.tamanho = n;
    }

    public Colecao(String string, int n) {
        this.tamanho = n;
    }

    @Override
    public void clear() {
        super.clear();
        this.recuperarLista().clear();
    }

    @Override
    public void setValidadoresAtivos(boolean bl) {
        super.setValidadoresAtivos(bl);
        for (ObjetoNegocio objetoNegocio : this.recuperarLista()) {
            objetoNegocio.setValidadoresAtivos(bl);
        }
    }

    public void setTipoItens(String string) {
        try {
            this.tipoItens = string != null ? Class.forName(string) : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico("A classe " + string + " especificada com item da cole\u00e7\u00e3o " + this.getClass().getName() + " n\u00e3o foi encontrada.");
        }
    }

    public List recuperarLista() {
        if (this.lista == null) {
            this.lista = new ListaPPGD(this);
        }
        return this.lista;
    }

    public void objetoInserido(Object object) {
    }

    public void objetoARemover(Object object) {
    }

    public void objetoRemovido(Object object) {
    }

    public int novoObjeto() {
        this.recuperarLista().add(this.instanciaNovoObjeto());
        return this.recuperarLista().size() - 1;
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        ObjetoNegocio objetoNegocio;
        Class clazz = this.getTipoItens();
        try {
            Object t = clazz.newInstance();
            objetoNegocio = (ObjetoNegocio)t;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return objetoNegocio;
    }

    public void removeObjeto(int n) {
        this.recuperarLista().remove(n);
    }

    public Class getTipoItens() {
        return this.tipoItens;
    }

    @Override
    public List verificarPendencias(int n) {
        Vector vector = new Vector();
        vector.addAll(super.verificarPendencias(-1));
        int n2 = 0;
        for (Object e : this.recuperarLista()) {
            Object object;
            ++n2;
            if (!(e instanceof ObjetoNegocio)) {
                object = "Par\u00e2metro " + e.getClass() + "da classe " + this.getClass() + " n\u00e3o \u00e9 ObjetoNegocio.";
                LogPPGD.erro((String)object);
                throw new IllegalArgumentException((String)object);
            }
            ObjetoNegocio objetoNegocio = (ObjetoNegocio)e;
            object = objetoNegocio.verificarPendencias(n2);
            vector.addAll(object);
        }
        return vector;
    }

    @Override
    public void setFicha(String string) {
        this.ficha = string;
        for (Object object : this.recuperarLista()) {
            if (!(object instanceof ObjetoNegocio)) {
                throw new IllegalArgumentException("Par\u00e2metro " + object.getClass() + " n\u00e3o \u00e9 Informacao.");
            }
            Object object2 = (ObjetoNegocio)object;
            ((ObjetoNegocio)object2).setFicha(string);
        }
        for (Object object2 : this.recuperarListaCamposPendencia()) {
            ((Informacao)object2).setFicha(string);
        }
    }

    public int getTamanho() {
        return this.tamanho;
    }

    public int recuperarNumeroObjetosNaoNulos() {
        Iterator iterator = this.recuperarLista().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ObjetoNegocio objetoNegocio = (ObjetoNegocio)iterator.next();
            if (objetoNegocio.isVazio()) continue;
            ++n;
        }
        return n;
    }

    public void excluirRegistrosEmBranco() {
        List list = this.recuperarLista();
        String string = "";
        for (int i = list.size() - 1; i >= 0; --i) {
            ObjetoNegocio objetoNegocio = (ObjetoNegocio)list.get(i);
            if (!objetoNegocio.isVazio()) continue;
            list.remove(i);
        }
    }

    @Override
    public boolean isVazio() {
        for (ObjetoNegocio objetoNegocio : this.recuperarLista()) {
            if (objetoNegocio.isVazio()) continue;
            return false;
        }
        boolean bl = super.isVazio();
        return bl;
    }

    @Override
    public void removeObservadoresAnonimosDesnecessarios(Class clazz) {
        super.removeObservadoresAnonimosDesnecessarios(clazz);
        for (ObjetoNegocio objetoNegocio : this.recuperarLista()) {
            objetoNegocio.removeObservadoresAnonimosDesnecessarios(clazz);
        }
    }

    @Override
    public void removeObservadores(Class[] classArray) {
        super.removeObservadores(classArray);
        for (ObjetoNegocio objetoNegocio : this.recuperarLista()) {
            objetoNegocio.removeObservadores(classArray);
        }
    }

    public PropertyChangeSupport getObservadoresLista() {
        return this.observadoresLista;
    }

    public void addObservador(Observador observador) {
        this.observadoresLista.addPropertyChangeListener(observador);
    }

    public void addObservador(String string, Observador observador) {
        this.observadoresLista.addPropertyChangeListener(string, observador);
    }

    public void removeObservador(Observador observador) {
        this.observadoresLista.removePropertyChangeListener(observador);
    }

    public void removeObservador(String string, Observador observador) {
        this.observadoresLista.removePropertyChangeListener(string, observador);
    }

    public boolean isObservadoresListaAtivos() {
        return this.observadoresListaAtivos;
    }

    public void setObservadoresAtivos(boolean bl) {
        this.observadoresListaAtivos = bl;
    }
}

