/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.repositorioXML;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.repositorio.RepositorioTabelasBasicasIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioTabelasBasicasXML
implements RepositorioTabelasBasicasIf {
    protected String getPathArquivo(String string) {
        String string2 = "/" + string;
        return string2;
    }

    private Document leArquivo(String string) {
        Document document = null;
        InputStream inputStream = UtilitariosArquivo.getResource(string, RepositorioTabelasBasicasXML.class);
        if (string != null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(inputStream);
                LogPPGD.debug(document.getImplementation().toString());
            }
            catch (SAXParseException sAXParseException) {
                LogPPGD.erro("Erro de parsing de " + sAXParseException.getSystemId() + ". linha " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException;
                if (sAXException.getException() != null) {
                    exception = sAXException.getException();
                }
                LogPPGD.erro("Erro de parsing: " + exception.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                LogPPGD.erro("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + parserConfigurationException.getMessage());
            }
            catch (IOException iOException) {
                LogPPGD.erro("Erro de I/O: " + iOException.getMessage());
            }
        }
        return document;
    }

    @Override
    public List recuperarObjetosTabela(String string, boolean bl) throws RepositorioXMLException {
        Element element;
        Vector<ElementoTabela> vector = new Vector<ElementoTabela>();
        Document document = this.leArquivo(this.getPathArquivo(string));
        if (document != null && (element = document.getDocumentElement()).hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            String string2 = "0";
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                Element element2 = (Element)nodeList.item(i);
                String string3 = element2.getAttribute("CRC");
                if (string3 == "") {
                    String string4;
                    int n = 0;
                    do {
                        if ((string4 = element2.getAttribute("COL" + ++n)) == "") continue;
                        string2 = UtilitariosString.GerarCRC(string2, string4);
                    } while (string4 != "");
                    ElementoTabela elementoTabela = new ElementoTabela();
                    for (int j = 1; j < n; ++j) {
                        elementoTabela.setConteudo(j - 1, element2.getAttribute("COL" + j));
                    }
                    vector.add(elementoTabela);
                    continue;
                }
                if (string3.compareTo(string2) == 0 || !bl) continue;
                throw new RepositorioXMLException("Checksum de tabela b\u00e1sica inv\u00e1lido");
            }
        }
        if (vector.size() == 0) {
            throw new RepositorioXMLException("Tabela b\u00e1sica inv\u00e1lida");
        }
        return vector;
    }

    @Override
    public void salvar(String string, List list) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            object6 = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object6).newDocument();
            object5 = document.createElement("TABELA");
            document.appendChild((Node)object5);
            object5.setAttribute("xmlns", ConstantesGlobais.XMLNS);
            object4 = "0";
            for (int i = 0; i < list.size(); ++i) {
                object3 = document.createElement("ITEM");
                object5.appendChild((Node)object3);
                object2 = (ElementoTabela)list.get(i);
                for (int j = 1; j < ((ElementoTabela)object2).size() + 1; ++j) {
                    object3.setAttribute("COL" + j, ((ElementoTabela)object2).getConteudo(j - 1));
                    object4 = UtilitariosString.GerarCRC((String)object4, ((ElementoTabela)object2).getConteudo(j - 1));
                }
            }
            object = document.createElement("ITEM");
            object5.appendChild((Node)object);
            object.setAttribute("CRC", (String)object4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        document.normalize();
        try {
            object6 = RepositorioTabelasBasicasXML.class.getResource(this.getPathArquivo(string));
            object5 = new File(((URL)object6).getPath());
            object4 = new FileOutputStream((File)object5);
            object = new StreamResult((OutputStream)object4);
            object3 = new DOMSource(document);
            object2 = TransformerFactory.newInstance();
            Transformer transformer = ((TransformerFactory)object2).newTransformer();
            transformer.transform((Source)object3, (Result)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

