/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.ChapterAutoNumber;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Header;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Meta;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Document
implements DocListener {
    private static final String ITEXT_VERSION = "iText 2.0.2 (by lowagie.com)";
    public static boolean compress = true;
    private ArrayList listeners = new ArrayList();
    protected boolean open;
    protected boolean close;
    protected Rectangle pageSize;
    protected float marginLeft = 0.0f;
    protected float marginRight = 0.0f;
    protected float marginTop = 0.0f;
    protected float marginBottom = 0.0f;
    protected boolean marginMirroring = false;
    protected String javaScript_onLoad = null;
    protected String javaScript_onUnLoad = null;
    protected String htmlStyleClass = null;
    protected int pageN = 0;
    protected HeaderFooter header = null;
    protected HeaderFooter footer = null;
    protected int chapternumber = 0;

    public Document() {
        this(PageSize.A4);
    }

    public Document(Rectangle rectangle) {
        this(rectangle, 36.0f, 36.0f, 36.0f, 36.0f);
    }

    public Document(Rectangle rectangle, float f, float f2, float f3, float f4) {
        this.pageSize = rectangle;
        this.marginLeft = f;
        this.marginRight = f2;
        this.marginTop = f3;
        this.marginBottom = f4;
    }

    public void addDocListener(DocListener docListener) {
        this.listeners.add(docListener);
    }

    public void removeDocListener(DocListener docListener) {
        this.listeners.remove(docListener);
    }

    public boolean add(Element element) throws DocumentException {
        if (this.close) {
            throw new DocumentException("The document has been closed. You can't add any Elements.");
        }
        int n = element.type();
        if (this.open) {
            if (n != 10 && n != 11 && n != 12 && n != 22 && n != 23 && n != 40 && n != 17 && n != 29 && n != 16 && n != 13 && n != 14 && n != 15 && n != 30 && n != 32 && n != 34 && n != 35 && n != 50) {
                throw new DocumentException("The document is open; you can only add Elements with content.");
            }
        } else if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 7 && n != 6 && n != 50) {
            throw new DocumentException("The document is not open yet; you can only add Meta information.");
        }
        boolean bl = false;
        if (element instanceof ChapterAutoNumber) {
            ++this.chapternumber;
            ((ChapterAutoNumber)element).setChapterNumber(this.chapternumber);
        }
        for (DocListener docListener : this.listeners) {
            bl |= docListener.add(element);
        }
        return bl;
    }

    public void open() {
        if (!this.close) {
            this.open = true;
        }
        for (DocListener docListener : this.listeners) {
            docListener.setPageSize(this.pageSize);
            docListener.setMargins(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
            docListener.open();
        }
    }

    public boolean setPageSize(Rectangle rectangle) {
        this.pageSize = rectangle;
        for (DocListener docListener : this.listeners) {
            docListener.setPageSize(rectangle);
        }
        return true;
    }

    public boolean setMargins(float f, float f2, float f3, float f4) {
        this.marginLeft = f;
        this.marginRight = f2;
        this.marginTop = f3;
        this.marginBottom = f4;
        for (DocListener docListener : this.listeners) {
            docListener.setMargins(f, f2, f3, f4);
        }
        return true;
    }

    public boolean newPage() {
        if (!this.open || this.close) {
            return false;
        }
        for (DocListener docListener : this.listeners) {
            docListener.newPage();
        }
        return true;
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
        for (DocListener docListener : this.listeners) {
            docListener.setHeader(headerFooter);
        }
    }

    public void resetHeader() {
        this.header = null;
        for (DocListener docListener : this.listeners) {
            docListener.resetHeader();
        }
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
        for (DocListener docListener : this.listeners) {
            docListener.setFooter(headerFooter);
        }
    }

    public void resetFooter() {
        this.footer = null;
        for (DocListener docListener : this.listeners) {
            docListener.resetFooter();
        }
    }

    public void resetPageCount() {
        this.pageN = 0;
        for (DocListener docListener : this.listeners) {
            docListener.resetPageCount();
        }
    }

    public void setPageCount(int n) {
        this.pageN = n;
        for (DocListener docListener : this.listeners) {
            docListener.setPageCount(n);
        }
    }

    public int getPageNumber() {
        return this.pageN;
    }

    public void close() {
        if (!this.close) {
            this.open = false;
            this.close = true;
        }
        for (DocListener docListener : this.listeners) {
            docListener.close();
        }
    }

    public boolean addHeader(String string, String string2) {
        try {
            return this.add(new Header(string, string2));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addTitle(String string) {
        try {
            return this.add(new Meta(1, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addSubject(String string) {
        try {
            return this.add(new Meta(2, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addKeywords(String string) {
        try {
            return this.add(new Meta(3, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addAuthor(String string) {
        try {
            return this.add(new Meta(4, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addCreator(String string) {
        try {
            return this.add(new Meta(7, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addProducer() {
        try {
            return this.add(new Meta(5, "iText by lowagie.com"));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addCreationDate() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            return this.add(new Meta(6, simpleDateFormat.format(new Date())));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public float leftMargin() {
        return this.marginLeft;
    }

    public float rightMargin() {
        return this.marginRight;
    }

    public float topMargin() {
        return this.marginTop;
    }

    public float bottomMargin() {
        return this.marginBottom;
    }

    public float left() {
        return this.pageSize.left(this.marginLeft);
    }

    public float right() {
        return this.pageSize.right(this.marginRight);
    }

    public float top() {
        return this.pageSize.top(this.marginTop);
    }

    public float bottom() {
        return this.pageSize.bottom(this.marginBottom);
    }

    public float left(float f) {
        return this.pageSize.left(this.marginLeft + f);
    }

    public float right(float f) {
        return this.pageSize.right(this.marginRight + f);
    }

    public float top(float f) {
        return this.pageSize.top(this.marginTop + f);
    }

    public float bottom(float f) {
        return this.pageSize.bottom(this.marginBottom + f);
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public boolean isOpen() {
        return this.open;
    }

    public static final String getVersion() {
        return ITEXT_VERSION;
    }

    public void setJavaScript_onLoad(String string) {
        this.javaScript_onLoad = string;
    }

    public String getJavaScript_onLoad() {
        return this.javaScript_onLoad;
    }

    public void setJavaScript_onUnLoad(String string) {
        this.javaScript_onUnLoad = string;
    }

    public String getJavaScript_onUnLoad() {
        return this.javaScript_onUnLoad;
    }

    public void setHtmlStyleClass(String string) {
        this.htmlStyleClass = string;
    }

    public String getHtmlStyleClass() {
        return this.htmlStyleClass;
    }

    public boolean setMarginMirroring(boolean bl) {
        this.marginMirroring = bl;
        for (DocListener docListener : this.listeners) {
            docListener.setMarginMirroring(bl);
        }
        return true;
    }

    public boolean isMarginMirroring() {
        return this.marginMirroring;
    }
}

