/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.pdf.BidiLine;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class ColumnText {
    public static final int AR_NOVOWEL = 1;
    public static final int AR_COMPOSEDTASHKEEL = 4;
    public static final int AR_LIG = 8;
    public static final int DIGITS_EN2AN = 32;
    public static final int DIGITS_AN2EN = 64;
    public static final int DIGITS_EN2AN_INIT_LR = 96;
    public static final int DIGITS_EN2AN_INIT_AL = 128;
    public static final int DIGIT_TYPE_AN = 0;
    public static final int DIGIT_TYPE_AN_EXTENDED = 256;
    protected int runDirection = 0;
    public static final float GLOBAL_SPACE_CHAR_RATIO = 0.0f;
    public static final int START_COLUMN = 0;
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected static final int LINE_STATUS_OK = 0;
    protected static final int LINE_STATUS_OFFLIMITS = 1;
    protected static final int LINE_STATUS_NOLINE = 2;
    protected float maxY;
    protected float minY;
    protected float leftX;
    protected float rightX;
    protected int alignment = 0;
    protected ArrayList leftWall;
    protected ArrayList rightWall;
    protected BidiLine bidiLine;
    protected float yLine;
    protected float currentLeading = 16.0f;
    protected float fixedLeading = 16.0f;
    protected float multipliedLeading = 0.0f;
    protected PdfContentByte canvas;
    protected PdfContentByte[] canvases;
    protected int lineStatus;
    protected float indent = 0.0f;
    protected float followingIndent = 0.0f;
    protected float rightIndent = 0.0f;
    protected float extraParagraphSpace = 0.0f;
    protected float rectangularWidth = -1.0f;
    protected boolean rectangularMode = false;
    private float spaceCharRatio = 0.0f;
    private boolean lastWasNewline = true;
    private int linesWritten;
    private float firstLineY;
    private boolean firstLineYDone = false;
    private int arabicOptions = 0;
    protected float descender;
    protected boolean composite = false;
    protected ColumnText compositeColumn;
    protected LinkedList compositeElements;
    protected int listIdx = 0;
    private boolean splittedRow;
    protected Phrase waitPhrase;
    private boolean useAscender = false;
    private float filledWidth;

    public ColumnText(PdfContentByte pdfContentByte) {
        this.canvas = pdfContentByte;
    }

    public static ColumnText duplicate(ColumnText columnText) {
        ColumnText columnText2 = new ColumnText(null);
        columnText2.setACopy(columnText);
        return columnText2;
    }

    public ColumnText setACopy(ColumnText columnText) {
        this.setSimpleVars(columnText);
        if (columnText.bidiLine != null) {
            this.bidiLine = new BidiLine(columnText.bidiLine);
        }
        return this;
    }

    protected void setSimpleVars(ColumnText columnText) {
        this.maxY = columnText.maxY;
        this.minY = columnText.minY;
        this.alignment = columnText.alignment;
        this.leftWall = null;
        if (columnText.leftWall != null) {
            this.leftWall = new ArrayList(columnText.leftWall);
        }
        this.rightWall = null;
        if (columnText.rightWall != null) {
            this.rightWall = new ArrayList(columnText.rightWall);
        }
        this.yLine = columnText.yLine;
        this.currentLeading = columnText.currentLeading;
        this.fixedLeading = columnText.fixedLeading;
        this.multipliedLeading = columnText.multipliedLeading;
        this.canvas = columnText.canvas;
        this.canvases = columnText.canvases;
        this.lineStatus = columnText.lineStatus;
        this.indent = columnText.indent;
        this.followingIndent = columnText.followingIndent;
        this.rightIndent = columnText.rightIndent;
        this.extraParagraphSpace = columnText.extraParagraphSpace;
        this.rectangularWidth = columnText.rectangularWidth;
        this.rectangularMode = columnText.rectangularMode;
        this.spaceCharRatio = columnText.spaceCharRatio;
        this.lastWasNewline = columnText.lastWasNewline;
        this.linesWritten = columnText.linesWritten;
        this.arabicOptions = columnText.arabicOptions;
        this.runDirection = columnText.runDirection;
        this.descender = columnText.descender;
        this.composite = columnText.composite;
        this.splittedRow = columnText.splittedRow;
        if (columnText.composite) {
            this.compositeElements = new LinkedList(columnText.compositeElements);
            if (this.splittedRow) {
                PdfPTable pdfPTable = (PdfPTable)this.compositeElements.getFirst();
                this.compositeElements.set(0, new PdfPTable(pdfPTable));
            }
            if (columnText.compositeColumn != null) {
                this.compositeColumn = ColumnText.duplicate(columnText.compositeColumn);
            }
        }
        this.listIdx = columnText.listIdx;
        this.firstLineY = columnText.firstLineY;
        this.leftX = columnText.leftX;
        this.rightX = columnText.rightX;
        this.firstLineYDone = columnText.firstLineYDone;
        this.waitPhrase = columnText.waitPhrase;
        this.useAscender = columnText.useAscender;
        this.filledWidth = columnText.filledWidth;
    }

    private void addWaitingPhrase() {
        if (this.bidiLine == null && this.waitPhrase != null) {
            this.bidiLine = new BidiLine();
            Iterator iterator = this.waitPhrase.getChunks().iterator();
            while (iterator.hasNext()) {
                this.bidiLine.addChunk(new PdfChunk((Chunk)iterator.next(), null));
            }
            this.waitPhrase = null;
        }
    }

    public void addText(Phrase phrase) {
        if (phrase == null || this.composite) {
            return;
        }
        this.addWaitingPhrase();
        if (this.bidiLine == null) {
            this.waitPhrase = phrase;
            return;
        }
        Iterator iterator = phrase.getChunks().iterator();
        while (iterator.hasNext()) {
            this.bidiLine.addChunk(new PdfChunk((Chunk)iterator.next(), null));
        }
    }

    public void setText(Phrase phrase) {
        this.bidiLine = null;
        this.composite = false;
        this.compositeColumn = null;
        this.compositeElements = null;
        this.listIdx = 0;
        this.splittedRow = false;
        this.waitPhrase = phrase;
    }

    public void addText(Chunk chunk) {
        if (chunk == null || this.composite) {
            return;
        }
        this.addText(new Phrase(chunk));
    }

    public void addElement(Element element) {
        if (element == null) {
            return;
        }
        if (element instanceof Image) {
            Image image = (Image)element;
            PdfPTable pdfPTable = new PdfPTable(1);
            float f = image.getWidthPercentage();
            if (f == 0.0f) {
                pdfPTable.setTotalWidth(image.scaledWidth());
                pdfPTable.setLockedWidth(true);
            } else {
                pdfPTable.setWidthPercentage(f);
            }
            pdfPTable.setSpacingAfter(image.spacingAfter());
            pdfPTable.setSpacingBefore(image.spacingBefore());
            switch (image.alignment()) {
                case 0: {
                    pdfPTable.setHorizontalAlignment(0);
                    break;
                }
                case 2: {
                    pdfPTable.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    pdfPTable.setHorizontalAlignment(1);
                }
            }
            PdfPCell pdfPCell = new PdfPCell(image, true);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setBorder(image.border());
            pdfPCell.setBorderColor(image.borderColor());
            pdfPCell.setBorderWidth(image.borderWidth());
            pdfPCell.setBackgroundColor(image.backgroundColor());
            pdfPTable.addCell(pdfPCell);
            element = pdfPTable;
        }
        if (element.type() == 10) {
            element = new Paragraph((Chunk)element);
        } else if (element.type() == 11) {
            element = new Paragraph((Phrase)element);
        }
        if (element instanceof SimpleTable) {
            try {
                element = ((SimpleTable)element).createPdfPTable();
            }
            catch (DocumentException documentException) {
                throw new IllegalArgumentException("Element not allowed.");
            }
        } else if (element.type() != 12 && element.type() != 14 && element.type() != 23) {
            throw new IllegalArgumentException("Element not allowed.");
        }
        if (!this.composite) {
            this.composite = true;
            this.compositeElements = new LinkedList();
            this.bidiLine = null;
            this.waitPhrase = null;
        }
        this.compositeElements.add(element);
    }

    protected ArrayList convertColumn(float[] fArray) {
        if (fArray.length < 4) {
            throw new RuntimeException("No valid column line found.");
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        int n = 0;
        while (n < fArray.length - 2) {
            float f = fArray[n];
            float f2 = fArray[n + 1];
            float f3 = fArray[n + 2];
            float f4 = fArray[n + 3];
            if (f2 != f4) {
                float f5 = (f - f3) / (f2 - f4);
                float f6 = f - f5 * f2;
                float[] fArray2 = new float[]{Math.min(f2, f4), Math.max(f2, f4), f5, f6};
                arrayList.add(fArray2);
                this.maxY = Math.max(this.maxY, fArray2[1]);
                this.minY = Math.min(this.minY, fArray2[0]);
            }
            n += 2;
        }
        if (arrayList.isEmpty()) {
            throw new RuntimeException("No valid column line found.");
        }
        return arrayList;
    }

    protected float findLimitsPoint(ArrayList arrayList) {
        this.lineStatus = 0;
        if (this.yLine < this.minY || this.yLine > this.maxY) {
            this.lineStatus = 1;
            return 0.0f;
        }
        int n = 0;
        while (n < arrayList.size()) {
            float[] fArray = (float[])arrayList.get(n);
            if (!(this.yLine < fArray[0]) && !(this.yLine > fArray[1])) {
                return fArray[2] * this.yLine + fArray[3];
            }
            ++n;
        }
        this.lineStatus = 2;
        return 0.0f;
    }

    protected float[] findLimitsOneLine() {
        float f = this.findLimitsPoint(this.leftWall);
        if (this.lineStatus == 1 || this.lineStatus == 2) {
            return null;
        }
        float f2 = this.findLimitsPoint(this.rightWall);
        if (this.lineStatus == 2) {
            return null;
        }
        return new float[]{f, f2};
    }

    protected float[] findLimitsTwoLines() {
        float[] fArray;
        float[] fArray2;
        boolean bl = false;
        while (true) {
            if (bl && this.currentLeading == 0.0f) {
                return null;
            }
            bl = true;
            fArray2 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            this.yLine -= this.currentLeading;
            if (this.lineStatus == 2) continue;
            fArray = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            if (this.lineStatus == 2) {
                this.yLine -= this.currentLeading;
                continue;
            }
            if (!(fArray2[0] >= fArray[1]) && !(fArray[0] >= fArray2[1])) break;
        }
        return new float[]{fArray2[0], fArray2[1], fArray[0], fArray[1]};
    }

    public void setColumns(float[] fArray, float[] fArray2) {
        this.maxY = -1.0E21f;
        this.minY = 1.0E21f;
        this.rightWall = this.convertColumn(fArray2);
        this.leftWall = this.convertColumn(fArray);
        this.rectangularWidth = -1.0f;
        this.rectangularMode = false;
    }

    public void setSimpleColumn(Phrase phrase, float f, float f2, float f3, float f4, float f5, int n) {
        this.addText(phrase);
        this.setSimpleColumn(f, f2, f3, f4, f5, n);
    }

    public void setSimpleColumn(float f, float f2, float f3, float f4, float f5, int n) {
        this.setLeading(f5);
        this.alignment = n;
        this.setSimpleColumn(f, f2, f3, f4);
    }

    public void setSimpleColumn(float f, float f2, float f3, float f4) {
        this.leftX = Math.min(f, f3);
        this.maxY = Math.max(f2, f4);
        this.minY = Math.min(f2, f4);
        this.rightX = Math.max(f, f3);
        this.yLine = this.maxY;
        this.rectangularWidth = this.rightX - this.leftX;
        if (this.rectangularWidth < 0.0f) {
            this.rectangularWidth = 0.0f;
        }
        this.rectangularMode = true;
    }

    public void setLeading(float f) {
        this.fixedLeading = f;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float f, float f2) {
        this.fixedLeading = f;
        this.multipliedLeading = f2;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setYLine(float f) {
        this.yLine = f;
    }

    public float getYLine() {
        return this.yLine;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setIndent(float f) {
        this.indent = f;
        this.lastWasNewline = true;
    }

    public float getIndent() {
        return this.indent;
    }

    public void setFollowingIndent(float f) {
        this.followingIndent = f;
        this.lastWasNewline = true;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float f) {
        this.rightIndent = f;
        this.lastWasNewline = true;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public int go() throws DocumentException {
        return this.go(false);
    }

    public int go(boolean bl) throws DocumentException {
        int n;
        PdfContentByte pdfContentByte;
        boolean bl2;
        block28: {
            if (this.composite) {
                return this.goComposite(bl);
            }
            this.addWaitingPhrase();
            if (this.bidiLine == null) {
                return 1;
            }
            this.descender = 0.0f;
            this.linesWritten = 0;
            bl2 = false;
            float f = this.spaceCharRatio;
            Object[] objectArray = new Object[2];
            PdfFont pdfFont = null;
            Float f2 = new Float(0.0f);
            objectArray[1] = f2;
            PdfDocument pdfDocument = null;
            PdfContentByte pdfContentByte2 = null;
            pdfContentByte = null;
            this.firstLineY = Float.NaN;
            int n2 = 1;
            if (this.runDirection != 0) {
                n2 = this.runDirection;
            }
            if (this.canvas != null) {
                pdfContentByte2 = this.canvas;
                pdfDocument = this.canvas.getPdfDocument();
                pdfContentByte = this.canvas.getDuplicate();
            } else if (!bl) {
                throw new NullPointerException("ColumnText.go with simulate==false and text==null.");
            }
            if (!bl) {
                if (f == 0.0f) {
                    f = pdfContentByte.getPdfWriter().getSpaceCharRatio();
                } else if (f < 0.001f) {
                    f = 0.001f;
                }
            }
            float f3 = 0.0f;
            n = 0;
            if (this.rectangularMode) {
                while (true) {
                    float f4 = f3 = this.lastWasNewline ? this.indent : this.followingIndent;
                    if (this.rectangularWidth <= f3 + this.rightIndent) {
                        n = 2;
                        if (this.bidiLine.isEmpty()) {
                            n |= 1;
                        }
                        break block28;
                    }
                    if (this.bidiLine.isEmpty()) {
                        n = 1;
                        break block28;
                    }
                    PdfLine pdfLine = this.bidiLine.processLine(this.rectangularWidth - f3 - this.rightIndent, this.alignment, n2, this.arabicOptions);
                    if (pdfLine == null) {
                        n = 1;
                        break block28;
                    }
                    float f5 = pdfLine.getMaxSizeSimple();
                    this.currentLeading = this.isUseAscender() && Float.isNaN(this.firstLineY) ? pdfLine.getAscender() : this.fixedLeading + f5 * this.multipliedLeading;
                    if (this.yLine > this.maxY || this.yLine - this.currentLeading < this.minY) {
                        n = 2;
                        this.bidiLine.restore();
                        break block28;
                    }
                    this.yLine -= this.currentLeading;
                    if (!bl && !bl2) {
                        pdfContentByte.beginText();
                        bl2 = true;
                    }
                    if (Float.isNaN(this.firstLineY)) {
                        this.firstLineY = this.yLine;
                    }
                    this.updateFilledWidth(this.rectangularWidth - pdfLine.widthLeft());
                    if (!bl) {
                        objectArray[0] = pdfFont;
                        pdfContentByte.setTextMatrix(this.leftX + (pdfLine.isRTL() ? this.rightIndent : f3) + pdfLine.indentLeft(), this.yLine);
                        pdfDocument.writeLineToContent(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f);
                        pdfFont = (PdfFont)objectArray[0];
                    }
                    this.lastWasNewline = pdfLine.isNewlineSplit();
                    this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                    ++this.linesWritten;
                    this.descender = pdfLine.getDescender();
                }
            }
            this.currentLeading = this.fixedLeading;
            while (true) {
                PdfLine pdfLine;
                f3 = this.lastWasNewline ? this.indent : this.followingIndent;
                float f6 = this.yLine;
                float[] fArray = this.findLimitsTwoLines();
                if (fArray == null) {
                    n = 2;
                    if (this.bidiLine.isEmpty()) {
                        n |= 1;
                    }
                    this.yLine = f6;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    n = 1;
                    this.yLine = f6;
                    break;
                }
                float f7 = Math.max(fArray[0], fArray[2]);
                float f8 = Math.min(fArray[1], fArray[3]);
                if (f8 - f7 <= f3 + this.rightIndent) continue;
                if (!bl && !bl2) {
                    pdfContentByte.beginText();
                    bl2 = true;
                }
                if ((pdfLine = this.bidiLine.processLine(f8 - f7 - f3 - this.rightIndent, this.alignment, n2, this.arabicOptions)) == null) {
                    n = 1;
                    this.yLine = f6;
                    break;
                }
                if (!bl) {
                    objectArray[0] = pdfFont;
                    pdfContentByte.setTextMatrix(f7 + (pdfLine.isRTL() ? this.rightIndent : f3) + pdfLine.indentLeft(), this.yLine);
                    pdfDocument.writeLineToContent(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f);
                    pdfFont = (PdfFont)objectArray[0];
                }
                this.lastWasNewline = pdfLine.isNewlineSplit();
                this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                ++this.linesWritten;
                this.descender = pdfLine.getDescender();
            }
        }
        if (bl2) {
            pdfContentByte.endText();
            this.canvas.add(pdfContentByte);
        }
        return n;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f) {
        this.extraParagraphSpace = f;
    }

    public void clearChunks() {
        if (this.bidiLine != null) {
            this.bidiLine.clearChunks();
        }
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f) {
        this.spaceCharRatio = f;
    }

    public void setRunDirection(int n) {
        if (n < 0 || n > 3) {
            throw new RuntimeException("Invalid run direction: " + n);
        }
        this.runDirection = n;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public int getLinesWritten() {
        return this.linesWritten;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int n) {
        this.arabicOptions = n;
    }

    public float getDescender() {
        return this.descender;
    }

    public static float getWidth(Phrase phrase, int n, int n2) {
        ColumnText columnText = new ColumnText(null);
        columnText.addText(phrase);
        columnText.addWaitingPhrase();
        PdfLine pdfLine = columnText.bidiLine.processLine(20000.0f, 0, n, n2);
        if (pdfLine == null) {
            return 0.0f;
        }
        return 20000.0f - pdfLine.widthLeft();
    }

    public static float getWidth(Phrase phrase) {
        return ColumnText.getWidth(phrase, 1, 0);
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n, Phrase phrase, float f, float f2, float f3, int n2, int n3) {
        if (n != 0 && n != 1 && n != 2) {
            n = 0;
        }
        pdfContentByte.saveState();
        ColumnText columnText = new ColumnText(pdfContentByte);
        if (f3 == 0.0f) {
            if (n == 0) {
                columnText.setSimpleColumn(phrase, f, f2 - 1.0f, 20000.0f + f, f2 + 2.0f, 2.0f, n);
            } else if (n == 2) {
                columnText.setSimpleColumn(phrase, f - 20000.0f, f2 - 1.0f, f, f2 + 2.0f, 2.0f, n);
            } else {
                columnText.setSimpleColumn(phrase, f - 20000.0f, f2 - 1.0f, f + 20000.0f, f2 + 2.0f, 2.0f, n);
            }
        } else {
            double d = (double)f3 * Math.PI / 180.0;
            float f4 = (float)Math.cos(d);
            float f5 = (float)Math.sin(d);
            pdfContentByte.concatCTM(f4, f5, -f5, f4, f, f2);
            if (n == 0) {
                columnText.setSimpleColumn(phrase, 0.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n);
            } else if (n == 2) {
                columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 0.0f, 2.0f, 2.0f, n);
            } else {
                columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n);
            }
        }
        if (n2 == 3) {
            if (n == 0) {
                n = 2;
            } else if (n == 2) {
                n = 0;
            }
        }
        columnText.setAlignment(n);
        columnText.setArabicOptions(n3);
        columnText.setRunDirection(n2);
        try {
            columnText.go();
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
        pdfContentByte.restoreState();
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n, Phrase phrase, float f, float f2, float f3) {
        ColumnText.showTextAligned(pdfContentByte, n, phrase, f, f2, f3, 1, 0);
    }

    /*
     * Unable to fully structure code
     */
    protected int goComposite(boolean var1_1) throws DocumentException {
        if (!this.rectangularMode) {
            throw new DocumentException("Irregular columns are not supported in composite mode.");
        }
        this.linesWritten = 0;
        this.descender = 0.0f;
        var2_2 = true;
        block4: while (true) {
            block65: {
                if (this.compositeElements.isEmpty()) {
                    return 1;
                }
                var3_3 = (Element)this.compositeElements.getFirst();
                if (var3_3.type() == 12) {
                    var4_4 = (Paragraph)var3_3;
                    var5_5 = 0;
                    var6_8 = 0;
                    while (var6_8 < 2) {
                        var7_11 = this.yLine;
                        var8_12 = false;
                        if (this.compositeColumn == null) {
                            this.compositeColumn = new ColumnText(this.canvas);
                            this.compositeColumn.setUseAscender(var2_2 != false ? this.useAscender : false);
                            this.compositeColumn.setAlignment(var4_4.alignment());
                            this.compositeColumn.setIndent(var4_4.indentationLeft() + var4_4.getFirstLineIndent());
                            this.compositeColumn.setExtraParagraphSpace(var4_4.getExtraParagraphSpace());
                            this.compositeColumn.setFollowingIndent(var4_4.indentationLeft());
                            this.compositeColumn.setRightIndent(var4_4.indentationRight());
                            this.compositeColumn.setLeading(var4_4.leading(), var4_4.getMultipliedLeading());
                            this.compositeColumn.setRunDirection(this.runDirection);
                            this.compositeColumn.setArabicOptions(this.arabicOptions);
                            this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                            this.compositeColumn.addText((Phrase)var4_4);
                            if (!var2_2) {
                                this.yLine -= var4_4.spacingBefore();
                            }
                            var8_12 = true;
                        }
                        this.compositeColumn.leftX = this.leftX;
                        this.compositeColumn.rightX = this.rightX;
                        this.compositeColumn.yLine = this.yLine;
                        this.compositeColumn.rectangularWidth = this.rectangularWidth;
                        this.compositeColumn.rectangularMode = this.rectangularMode;
                        this.compositeColumn.minY = this.minY;
                        this.compositeColumn.maxY = this.maxY;
                        var9_15 = var4_4.getKeepTogether() != false && var8_12 != false && var2_2 == false ? 1 : 0;
                        var5_5 = this.compositeColumn.go(var1_1 != false || var9_15 != 0 && var6_8 == 0);
                        this.updateFilledWidth(this.compositeColumn.filledWidth);
                        if ((var5_5 & 1) == 0 && var9_15 != 0) {
                            this.compositeColumn = null;
                            this.yLine = var7_11;
                            return 2;
                        }
                        if (var1_1 || var9_15 == 0) break;
                        if (var6_8 == 0) {
                            this.compositeColumn = null;
                            this.yLine = var7_11;
                        }
                        ++var6_8;
                    }
                    var2_2 = false;
                    this.yLine = this.compositeColumn.yLine;
                    this.linesWritten += this.compositeColumn.linesWritten;
                    this.descender = this.compositeColumn.descender;
                    if (var5_5 & true) {
                        this.compositeColumn = null;
                        this.compositeElements.removeFirst();
                        this.yLine -= var4_4.spacingAfter();
                    }
                    if ((var5_5 & 2) == 0) continue;
                    return 2;
                }
                if (var3_3.type() != 14) break block65;
                var4_4 = (List)var3_3;
                var5_6 = var4_4.getItems();
                var6_9 = null;
                var7_11 = var4_4.indentationLeft();
                var8_13 = 0;
                var9_16 = new Stack<Object[]>();
                var10_17 = 0;
                while (var10_17 < var5_6.size()) {
                    block66: {
                        var11_18 = var5_6.get(var10_17);
                        if (!(var11_18 instanceof ListItem)) break block66;
                        if (var8_13 == this.listIdx) {
                            var6_9 = (ListItem)var11_18;
                            break;
                        }
                        ++var8_13;
                        ** GOTO lbl-1000
                    }
                    if (var11_18 instanceof List) {
                        var9_16.push(new Object[]{var4_4, new Integer(var10_17), new Float(var7_11)});
                        var4_4 = (List)var11_18;
                        var5_6 = var4_4.getItems();
                        var7_11 += var4_4.indentationLeft();
                        var10_17 = -1;
                    } else if (var10_17 == var5_6.size() - 1 && !var9_16.isEmpty()) {
                        var12_25 = (Object[])var9_16.pop();
                        var4_4 = (List)var12_25[0];
                        var5_6 = var4_4.getItems();
                        var10_17 = (Integer)var12_25[1];
                        var7_11 = ((Float)var12_25[2]).floatValue();
                    }
                    ++var10_17;
                }
                var10_17 = 0;
                var11_19 = 0;
                while (var11_19 < 2) {
                    var12_26 = this.yLine;
                    var13_31 = false;
                    if (this.compositeColumn == null) {
                        if (var6_9 == null) {
                            this.listIdx = 0;
                            this.compositeElements.removeFirst();
                            continue block4;
                        }
                        this.compositeColumn = new ColumnText(this.canvas);
                        this.compositeColumn.setUseAscender(var2_2 != false ? this.useAscender : false);
                        this.compositeColumn.setAlignment(var6_9.alignment());
                        this.compositeColumn.setIndent(var6_9.indentationLeft() + var7_11 + var6_9.getFirstLineIndent());
                        this.compositeColumn.setExtraParagraphSpace(var6_9.getExtraParagraphSpace());
                        this.compositeColumn.setFollowingIndent(this.compositeColumn.getIndent());
                        this.compositeColumn.setRightIndent(var6_9.indentationRight() + var4_4.indentationRight());
                        this.compositeColumn.setLeading(var6_9.leading(), var6_9.getMultipliedLeading());
                        this.compositeColumn.setRunDirection(this.runDirection);
                        this.compositeColumn.setArabicOptions(this.arabicOptions);
                        this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                        this.compositeColumn.addText(var6_9);
                        if (!var2_2) {
                            this.yLine -= var6_9.spacingBefore();
                        }
                        var13_31 = true;
                    }
                    this.compositeColumn.leftX = this.leftX;
                    this.compositeColumn.rightX = this.rightX;
                    this.compositeColumn.yLine = this.yLine;
                    this.compositeColumn.rectangularWidth = this.rectangularWidth;
                    this.compositeColumn.rectangularMode = this.rectangularMode;
                    this.compositeColumn.minY = this.minY;
                    this.compositeColumn.maxY = this.maxY;
                    var14_33 = var6_9.getKeepTogether() != false && var13_31 != false && var2_2 == false;
                    var10_17 = this.compositeColumn.go(var1_1 != false || var14_33 != false && var11_19 == 0);
                    this.updateFilledWidth(this.compositeColumn.filledWidth);
                    if ((var10_17 & 1) == 0 && var14_33) {
                        this.compositeColumn = null;
                        this.yLine = var12_26;
                        return 2;
                    }
                    if (var1_1 || !var14_33) break;
                    if (var11_19 == 0) {
                        this.compositeColumn = null;
                        this.yLine = var12_26;
                    }
                    ++var11_19;
                }
                var2_2 = false;
                this.yLine = this.compositeColumn.yLine;
                this.linesWritten += this.compositeColumn.linesWritten;
                this.descender = this.compositeColumn.descender;
                if (!Float.isNaN(this.compositeColumn.firstLineY) && !this.compositeColumn.firstLineYDone) {
                    if (!var1_1) {
                        ColumnText.showTextAligned(this.canvas, 0, new Phrase(var6_9.listSymbol()), this.compositeColumn.leftX + var7_11, this.compositeColumn.firstLineY, 0.0f);
                    }
                    this.compositeColumn.firstLineYDone = true;
                }
                if ((var10_17 & 1) != 0) {
                    this.compositeColumn = null;
                    ++this.listIdx;
                    this.yLine -= var6_9.spacingAfter();
                }
                if ((var10_17 & 2) == 0) continue;
                return 2;
            }
            if (var3_3.type() == 23) {
                if (this.yLine < this.minY || this.yLine > this.maxY) {
                    return 2;
                }
                var4_4 = (PdfPTable)var3_3;
                if (var4_4.size() <= var4_4.getHeaderRows()) {
                    this.compositeElements.removeFirst();
                    continue;
                }
                var5_7 = this.yLine;
                var6_10 = this.yLine;
                if (!var2_2 && this.listIdx == 0) {
                    var6_10 = var5_7 -= var4_4.spacingBefore();
                }
                this.currentLeading = 0.0f;
                if (var5_7 < this.minY || var5_7 > this.maxY) {
                    return 2;
                }
                var7_11 = this.leftX;
                if (var4_4.isLockedWidth()) {
                    var8_14 = var4_4.getTotalWidth();
                    this.updateFilledWidth(var8_14);
                } else {
                    var8_14 = this.rectangularWidth * var4_4.getWidthPercentage() / 100.0f;
                    var4_4.setTotalWidth(var8_14);
                }
                v0 = var10_17 = var2_2 == false && var4_4.isSkipFirstHeader() != false && this.listIdx <= var4_4.getHeaderRows() ? 1 : 0;
                if (var10_17 == 0 && ((var5_7 -= var4_4.getHeaderHeight()) < this.minY || var5_7 > this.maxY)) {
                    if (var2_2) {
                        this.compositeElements.removeFirst();
                        continue;
                    }
                    return 2;
                }
                if (this.listIdx < var4_4.getHeaderRows()) {
                    this.listIdx = var4_4.getHeaderRows();
                }
                var9_15 = this.listIdx;
                while (var9_15 < var4_4.size()) {
                    var11_20 = var4_4.getRowHeight(var9_15);
                    if (var5_7 - var11_20 < this.minY) break;
                    var5_7 -= var11_20;
                    ++var9_15;
                }
                if (var9_15 < var4_4.size()) {
                    if (var4_4.isSplitRows() && (!var4_4.isSplitLate() || var9_15 == this.listIdx && var2_2)) {
                        if (!this.splittedRow) {
                            this.splittedRow = true;
                            var4_4 = new PdfPTable((PdfPTable)var4_4);
                            this.compositeElements.set(0, var4_4);
                            var11_21 = var4_4.getRows();
                            var12_27 = var4_4.getHeaderRows();
                            while (var12_27 < this.listIdx) {
                                var11_21.set(var12_27, null);
                                ++var12_27;
                            }
                        }
                        var11_22 = var5_7 - this.minY;
                        var12_28 = var4_4.getRow(var9_15).splitRow(var11_22);
                        if (var12_28 == null) {
                            if (var9_15 == this.listIdx) {
                                return 2;
                            }
                        } else {
                            var5_7 = this.minY;
                            var4_4.getRows().add(++var9_15, var12_28);
                        }
                    } else {
                        if (!var4_4.isSplitRows() && var9_15 == this.listIdx && var2_2) {
                            this.compositeElements.removeFirst();
                            this.splittedRow = false;
                            continue;
                        }
                        if (!(var9_15 != this.listIdx || var2_2 || var4_4.isSplitRows() && !var4_4.isSplitLate())) {
                            return 2;
                        }
                    }
                }
                var2_2 = false;
                if (!var1_1) {
                    switch (var4_4.getHorizontalAlignment()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            var7_11 += this.rectangularWidth - var8_14;
                            break;
                        }
                        default: {
                            var7_11 += (this.rectangularWidth - var8_14) / 2.0f;
                        }
                    }
                    var11_23 = var4_4.getHeaderRows();
                    var12_29 = var4_4.getFooterRows();
                    if (var12_29 > var11_23) {
                        var12_29 = var11_23;
                    }
                    var11_23 -= var12_29;
                    var13_32 = PdfPTable.shallowCopy((PdfPTable)var4_4);
                    var14_34 = var4_4.getRows();
                    var15_35 = var13_32.getRows();
                    if (var10_17 == 0) {
                        var16_37 = 0;
                        while (var16_37 < var11_23) {
                            var15_35.add(var14_34.get(var16_37));
                            ++var16_37;
                        }
                    } else {
                        var13_32.setHeaderRows(var12_29);
                    }
                    var16_37 = this.listIdx;
                    while (var16_37 < var9_15) {
                        var15_35.add(var14_34.get(var16_37));
                        ++var16_37;
                    }
                    var16_37 = 0;
                    while (var16_37 < var12_29) {
                        var15_35.add(var14_34.get(var16_37 + var11_23));
                        ++var16_37;
                    }
                    var16_36 = 0.0f;
                    if (var4_4.isExtendLastRow()) {
                        var17_38 = (PdfPRow)var15_35.get(var15_35.size() - 1 - var12_29);
                        var16_36 = var17_38.getMaxHeights();
                        var17_38.setMaxHeights(var5_7 - this.minY + var16_36);
                        var5_7 = this.minY;
                    }
                    if (this.canvases != null) {
                        var13_32.writeSelectedRows(0, -1, var7_11, var6_10, this.canvases);
                    } else {
                        var13_32.writeSelectedRows(0, -1, var7_11, var6_10, this.canvas);
                    }
                    if (var4_4.isExtendLastRow()) {
                        var17_38 = (PdfPRow)var15_35.get(var15_35.size() - 1 - var12_29);
                        var17_38.setMaxHeights(var16_36);
                    }
                } else if (var4_4.isExtendLastRow() && this.minY > -1.0737418E9f) {
                    var5_7 = this.minY;
                }
                this.yLine = var5_7;
                if (var9_15 >= var4_4.size()) {
                    this.yLine -= var4_4.spacingAfter();
                    this.compositeElements.removeFirst();
                    this.splittedRow = false;
                    this.listIdx = 0;
                    continue;
                }
                if (this.splittedRow) {
                    var11_24 = var4_4.getRows();
                    var12_30 = this.listIdx;
                    while (var12_30 < var9_15) {
                        var11_24.set(var12_30, null);
                        ++var12_30;
                    }
                }
                this.listIdx = var9_15;
                return 2;
            }
            this.compositeElements.removeFirst();
        }
    }

    public PdfContentByte getCanvas() {
        return this.canvas;
    }

    public void setCanvas(PdfContentByte pdfContentByte) {
        this.canvas = pdfContentByte;
        this.canvases = null;
        if (this.compositeColumn != null) {
            this.compositeColumn.setCanvas(pdfContentByte);
        }
    }

    public void setCanvases(PdfContentByte[] pdfContentByteArray) {
        this.canvases = pdfContentByteArray;
        this.canvas = pdfContentByteArray[3];
        if (this.compositeColumn != null) {
            this.compositeColumn.setCanvases(pdfContentByteArray);
        }
    }

    public PdfContentByte[] getCanvases() {
        return this.canvases;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public void setUseAscender(boolean bl) {
        this.useAscender = bl;
    }

    public static boolean hasMoreText(int n) {
        return (n & 1) == 0;
    }

    public float getFilledWidth() {
        return this.filledWidth;
    }

    public void setFilledWidth(float f) {
        this.filledWidth = f;
    }

    public void updateFilledWidth(float f) {
        if (f > this.filledWidth) {
            this.filledWidth = f;
        }
    }
}

