/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillVariable;

public class JRCalculator
implements JRFillExpressionEvaluator {
    protected Map parsm = null;
    protected Map fldsm = null;
    protected Map varsm = null;
    protected JRFillVariable[] variables = null;
    protected JRFillGroup[] groups = null;
    protected JRFillElementDataset[] datasets = null;
    private JRFillVariable pageNumber = null;
    private JRFillVariable columnNumber = null;
    private final JREvaluator evaluator;

    protected JRCalculator(JREvaluator jREvaluator) {
        this.evaluator = jREvaluator;
    }

    protected void init(JRFillDataset jRFillDataset) throws JRException {
        this.parsm = jRFillDataset.parametersMap;
        this.fldsm = jRFillDataset.fieldsMap;
        this.varsm = jRFillDataset.variablesMap;
        this.variables = jRFillDataset.variables;
        this.groups = jRFillDataset.groups;
        this.datasets = jRFillDataset.elementDatasets;
        this.pageNumber = (JRFillVariable)this.varsm.get("PAGE_NUMBER");
        this.columnNumber = (JRFillVariable)this.varsm.get("COLUMN_NUMBER");
        byte by = jRFillDataset.getWhenResourceMissingType();
        this.evaluator.init(this.parsm, this.fldsm, this.varsm, by);
    }

    public JRFillVariable getPageNumber() {
        return this.pageNumber;
    }

    public JRFillVariable getColumnNumber() {
        return this.columnNumber;
    }

    public void calculateVariables() throws JRException {
        Object object;
        int n;
        if (this.variables != null && this.variables.length > 0) {
            n = 0;
            while (n < this.variables.length) {
                object = this.variables[n];
                Object object2 = this.evaluate(((JRFillVariable)object).getExpression());
                Object object3 = ((JRFillVariable)object).getIncrementer().increment((JRFillVariable)object, object2, AbstractValueProvider.getCurrentValueProvider());
                ((JRFillVariable)object).setValue(object3);
                ((JRFillVariable)object).setInitialized(false);
                if (((JRFillVariable)object).getIncrementType() == 5) {
                    ((JRFillVariable)object).setIncrementedValue(((JRFillVariable)object).getValue());
                }
                ++n;
            }
        }
        if (this.datasets != null && this.datasets.length > 0) {
            n = 0;
            while (n < this.datasets.length) {
                object = this.datasets[n];
                ((JRFillElementDataset)object).evaluate(this);
                if (((JRFillElementDataset)object).getIncrementType() == 5) {
                    ((JRFillElementDataset)object).increment();
                }
                ++n;
            }
        }
    }

    public void estimateVariables() throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            JRFillVariable jRFillVariable = null;
            Object object = null;
            Object object2 = null;
            int n = 0;
            while (n < this.variables.length) {
                jRFillVariable = this.variables[n];
                object = this.evaluateEstimated(jRFillVariable.getExpression());
                object2 = jRFillVariable.getIncrementer().increment(jRFillVariable, object, AbstractValueProvider.getEstimatedValueProvider());
                jRFillVariable.setEstimatedValue(object2);
                ++n;
            }
        }
    }

    public void estimateGroupRuptures() throws JRException {
        JRFillGroup jRFillGroup = null;
        Object object = null;
        Object object2 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.groups != null && this.groups.length > 0) {
            int n = 0;
            while (n < this.groups.length) {
                jRFillGroup = this.groups[n];
                bl2 = false;
                if (!bl) {
                    object = this.evaluateOld(jRFillGroup.getExpression());
                    object2 = this.evaluateEstimated(jRFillGroup.getExpression());
                    if (object == null && object2 != null || object != null && !object.equals(object2)) {
                        bl = true;
                        bl2 = true;
                    }
                }
                jRFillGroup.setHasChanged(bl);
                jRFillGroup.setTopLevelChange(bl2);
                ++n;
            }
        }
    }

    public void initializeVariables(byte by) throws JRException {
        int n;
        if (this.variables != null && this.variables.length > 0) {
            n = 0;
            while (n < this.variables.length) {
                this.incrementVariable(this.variables[n], by);
                this.initializeVariable(this.variables[n], by);
                ++n;
            }
        }
        if (this.datasets != null && this.datasets.length > 0) {
            n = 0;
            while (n < this.datasets.length) {
                this.incrementDataset(this.datasets[n], by);
                this.initializeDataset(this.datasets[n], by);
                ++n;
            }
        }
    }

    private void incrementVariable(JRFillVariable jRFillVariable, byte by) {
        if (jRFillVariable.getIncrementType() != 5) {
            boolean bl = false;
            switch (by) {
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = jRFillVariable.getIncrementType() == 2 || jRFillVariable.getIncrementType() == 3;
                    break;
                }
                case 3: {
                    bl = jRFillVariable.getIncrementType() == 3;
                    break;
                }
                case 4: {
                    if (jRFillVariable.getIncrementType() != 4) break;
                    JRFillGroup jRFillGroup = (JRFillGroup)jRFillVariable.getIncrementGroup();
                    bl = jRFillGroup.hasChanged();
                }
            }
            if (bl) {
                jRFillVariable.setIncrementedValue(jRFillVariable.getValue());
            }
        } else {
            jRFillVariable.setIncrementedValue(jRFillVariable.getValue());
        }
    }

    private void incrementDataset(JRFillElementDataset jRFillElementDataset, byte by) {
        if (jRFillElementDataset.getIncrementType() != 5) {
            boolean bl = false;
            switch (by) {
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = jRFillElementDataset.getIncrementType() == 2 || jRFillElementDataset.getIncrementType() == 3;
                    break;
                }
                case 3: {
                    bl = jRFillElementDataset.getIncrementType() == 3;
                    break;
                }
                case 4: {
                    if (jRFillElementDataset.getIncrementType() != 4) break;
                    JRFillGroup jRFillGroup = (JRFillGroup)jRFillElementDataset.getIncrementGroup();
                    bl = jRFillGroup.hasChanged();
                }
            }
            if (bl) {
                jRFillElementDataset.increment();
            }
        }
    }

    private void initializeVariable(JRFillVariable jRFillVariable, byte by) throws JRException {
        if (jRFillVariable.getResetType() != 5) {
            boolean bl = false;
            switch (by) {
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = jRFillVariable.getResetType() == 2 || jRFillVariable.getResetType() == 3;
                    break;
                }
                case 3: {
                    bl = jRFillVariable.getResetType() == 3;
                    break;
                }
                case 4: {
                    if (jRFillVariable.getResetType() != 4) break;
                    JRFillGroup jRFillGroup = (JRFillGroup)jRFillVariable.getResetGroup();
                    bl = jRFillGroup.hasChanged();
                }
            }
            if (bl) {
                jRFillVariable.setValue(this.evaluate(jRFillVariable.getInitialValueExpression()));
                jRFillVariable.setInitialized(true);
                jRFillVariable.setIncrementedValue(null);
            }
        } else {
            jRFillVariable.setValue(this.evaluate(jRFillVariable.getExpression()));
            jRFillVariable.setIncrementedValue(jRFillVariable.getValue());
        }
    }

    private void initializeDataset(JRFillElementDataset jRFillElementDataset, byte by) {
        boolean bl = false;
        switch (by) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = jRFillElementDataset.getResetType() == 2 || jRFillElementDataset.getResetType() == 3;
                break;
            }
            case 3: {
                bl = jRFillElementDataset.getResetType() == 3;
                break;
            }
            case 4: {
                if (jRFillElementDataset.getResetType() != 4) break;
                JRFillGroup jRFillGroup = (JRFillGroup)jRFillElementDataset.getResetGroup();
                bl = jRFillGroup.hasChanged();
            }
        }
        if (bl) {
            jRFillElementDataset.initialize();
        }
    }

    public Object evaluate(JRExpression jRExpression, byte by) throws JRException {
        Object object = null;
        switch (by) {
            case 1: {
                object = this.evaluateOld(jRExpression);
                break;
            }
            case 2: {
                object = this.evaluateEstimated(jRExpression);
                break;
            }
            default: {
                object = this.evaluate(jRExpression);
            }
        }
        return object;
    }

    public Object evaluateOld(JRExpression jRExpression) throws JRExpressionEvalException {
        return this.evaluator.evaluateOld(jRExpression);
    }

    public Object evaluateEstimated(JRExpression jRExpression) throws JRExpressionEvalException {
        return this.evaluator.evaluateEstimated(jRExpression);
    }

    public Object evaluate(JRExpression jRExpression) throws JRExpressionEvalException {
        return this.evaluator.evaluate(jRExpression);
    }
}

